.TH "ZIP_SET_DEFAULT_PASSWORD" "3" "December 18, 2017" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_set_default_password\fR
\- set default password for encrypted files in zip
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIint\fR
.br
.PD 0
.HP 4n
\fBzip_set_default_password\fR(\fIzip_t\ *archive\fR, \fIconst\ char\ *password\fR);
.PD
.SH "DESCRIPTION"
The
\fBzip_set_default_password\fR()
function sets the default password used when accessing encrypted files.
If
\fIpassword\fR
is
\fRNULL\fR,
the default password is unset.
.PP
If you prefer a different password for single files, use
zip_fopen_encrypted(3)
instead of
zip_fopen(3).
Usually, however, the same password is used for every file in an
zip archive.
.SH "RETURN VALUES"
Upon successful completion 0 is returned.
Otherwise, \-1 is returned and the error information in
\fIarchive\fR
is set to indicate the error.
.SH "ERRORS"
\fBzip_set_default_password\fR()
fails if:
.TP 19n
[\fRZIP_ER_MEMORY\fR]
Required memory could not be allocated.
.SH "SEE ALSO"
libzip(3),
zip_fopen(3),
zip_fopen_encrypted(3)
.SH "HISTORY"
\fBzip_set_default_password\fR()
was added in libzip 0.10.
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fItk@giga.or.at\fR>
