# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
###

import glob
import os
import sys
import imp
from traceback import format_exception
import gobject

from config import config
from helper import SignalCollector
from logger import Logger

class Plugin(Logger):
    """
    Require field
    """
    PLUGIN_NAME = "No Name"
    PLUGIN_DESC = None
    PLUGIN_VERSION = None
    PLUGIN_AUTHOR = None
    PLUGIN_WEBSITE = None

    signal_collector_id = None

    def __init__(self):
        if not self.signal_collector_id: self.signal_collector_id = self.__class__.__name__
        #print "DEBUG : Plugin",self.PLUGIN_NAME,"(",self.__class__.__name__,") -> __init__()"
    
    def autoconnect(self,obj,signal_name,func,*args):
        if self.signal_collector_id:
            SignalCollector.connect(self.signal_collector_id,obj,signal_name,func,*args)

    def delete_thyself(self):
        if self.signal_collector_id:
            self.logdebug("disconnect monitored signal for %s"%self.signal_collector_id)
            SignalCollector.disconnect_all(self.signal_collector_id)

    """
    Require to enable configure button in preferences
    Need to be static
    @staticmethod
    def on_configure():
        pass
    """

class Manager(gobject.GObject):

    __gsignals__ = {
        "plugin-disabled" : (gobject.SIGNAL_RUN_LAST,
                gobject.TYPE_NONE,
                (gobject.TYPE_PYOBJECT,)),
        "plugin-enabled" : (gobject.SIGNAL_RUN_LAST,
                gobject.TYPE_NONE,
                (gobject.TYPE_PYOBJECT,)),
    }

    activable = True
    instances = {}
    Kinds = []

    def __init__(self, folders=[],name=None ):
        super(Manager,self).__init__()

        self.folders = folders
        self.__files = {}
        self._plugins = {}
        self.__failures = {}
        if name : 
            self.name = name
            self.instances[self.name] = self

    def scan(self):
        for scanfolder in self.folders:
            try: names = glob.glob(os.path.join(scanfolder, "[!_]*.py"))
            except OSError: continue
            for pathname in names:
                name = os.path.basename(pathname)
                name = name[:name.rfind(".")]
                try: modified = os.path.getmtime(pathname)
                except EnvironmentError: continue
                info = self.__files.setdefault(name, [None, None])
                try:
                    sys.path.insert(0, scanfolder)
                    if info[1] is None or info[1] != modified:
                        if info[0] is None:
                            try: modinfo = imp.find_module(name)
                            except ImportError: continue
                            try:
                                mod = imp.load_module(name, *modinfo)
                            except Exception:
                                self.__failures[name] = format_exception(*sys.exc_info())
                                try: del sys.modules[name]
                                except KeyError: pass
                            else:
                                info[0] = mod
                                self._load(name, mod)
                        else:
                            try: mod = reload(info[0])
                            except Exception:
                                self.__failures[name] = format_exception(*sys.exc_info())
                            else:
                                info[0] = mod
                                self._load(name, mod)

                finally:
                    del sys.path[0:1]
                info[1] = modified
        self.restore()

    def restore(self):
        key = "active_" + str(type(self).__name__)
        try: possible = config.get("plugins", key).splitlines()
        except : pass
        else:
            for plugin in self.list():
                self.enable(plugin, plugin.PLUGIN_ID in possible,emit=False)

    def save(self):
        key = "active_" + str(type(self).__name__)
        active = [plugin.PLUGIN_ID for plugin in self.list()
                  if self.enabled(plugin)]
        config.set("plugins", key, "\n".join(active))

    def _load(self, name, module):
        self.__failures.pop(name, None)
        try: objs = [getattr(module, attr) for attr in module.__all__]
        except AttributeError:
            objs = [getattr(module, attr) for attr in vars(module)
                    if not attr.startswith("_")]
        objs = filter(lambda x: isinstance(x, type), objs)
        self._plugins[name] = objs

    def find_subclasses(self, Kind, all=False):
        """Return all classes in all plugins that subclass 'Kind'."""
        kinds = []
        for plugin in self._plugins.values():
            for obj in plugin:
                try:
                    if issubclass(obj, Kind) and obj is not Kind:
                        kinds.append(obj)
                except TypeError: pass

        for Kind in kinds:
            try: Kind.PLUGIN_ID
            except AttributeError:
                try: Kind.PLUGIN_ID = Kind.PLUGIN_NAME
                except AttributeError:
                    Kind.PLUGIN_ID = Kind.__name__

            try: Kind.PLUGIN_NAME
            except AttributeError:
                Kind.PLUGIN_NAME = Kind.PLUGIN_ID
                
            try: Kind.PLUGIN_DESC
            except AttributeError:
                Kind.PLUGIN_DESC = ""
                
            try: Kind.PLUGIN_VERSION
            except AttributeError:
                Kind.PLUGIN_VERSION = "0.0"

        if not all:
            kinds = filter(self.enabled, kinds)

        return kinds



    def enable(self, plugin, enabled,emit=True):
        plugin.__enabled = bool(enabled)
        if emit:
            if plugin.__enabled:
                self.emit("plugin-enabled",plugin)
            else:
                self.emit("plugin-disabled",plugin)
   
    def enabled(self, plugin):
        try: return plugin.__enabled
        except AttributeError: return False

    def list(self,all=True):
        kinds = set()
        for Kind in self.Kinds:
            kinds.update(self.find_subclasses(Kind, all))
        return list(kinds)

    def list_failures(self):
        return self.__failures.copy()

