# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
###


import gtk
import os
import re

import utils
from config import config
import vfs
import stock

from helper import Dispatcher, SignalCollector
from library import ListenDB
from player import Player
from web_threading import WebFetchThread

from source import Source, SourceItem
from widget.song_menu import SongMenuManager
from widget.htmlview import HtmlView, get_template

from plugins.lyrics import LyricsManager

from logger import Logger
vfs.makedirs(os.path.expanduser("~/.lyrics"))

LyricsManager = LyricsManager()

class LyricsBox(gtk.VBox, Logger):
    def __init__(self):
        gtk.VBox.__init__(self, False, 6)
        self.song = None
        
        self.embed = HtmlView()
        self.embed.set_open_uri_callback(self.link_uri_cb)
        
        self.text = gtk.TextView(gtk.TextBuffer())
        self.text.set_editable(False)
        padding = 5
        self.text.set_property("pixels-above-lines", padding)
        self.text.set_property("pixels-below-lines", padding)
        self.text.set_property("right_margin", padding)
        self.text.set_property("left_margin", padding)
        
        self.auto_update = gtk.CheckButton("Auto-updating")
        self.auto_update.set_property("active", True)
        
        
        self.entry_artist = gtk.Entry()
        self.entry_title = gtk.Entry()
        self.entry_album = gtk.Entry()
        
        self.entry_artist.connect("activate", self.on_search_changed)
        self.entry_title.connect("activate", self.on_search_changed)
        self.entry_album.connect("activate", self.on_search_changed)
        
        
        self.entry_artist.set_sensitive(False)
        self.entry_title.set_sensitive(False)
        self.entry_album.set_sensitive(False)
        
        
        #model = gtk.ListStore(gobject.TYPE_STRING)
        self.dropdown_server = gtk.combo_box_new_text()


        self.dropdown_server.connect("changed", self.on_change_lyrics_server)
        self.dropdown_server.set_tooltip_text(_("Change Lyrics Server"))
        
        self.box_search = gtk.HBox(False, 6)
        """self.box_search.pack_start(gtk.Label(_("Artist")),False,False)
        self.box_search.pack_start(self.entry_artist,True,True)
        self.box_search.pack_start(gtk.Label(_("Title")),False,False)
        self.box_search.pack_start(self.entry_title,True,True)"""
        l = gtk.Label(_("Lyrics server"))
        l.set_alignment(0, 0.5)
        self.box_search.pack_start(l, False, False)
        self.box_search.pack_start(self.dropdown_server, False, False)
        self.box_search.pack_end(self.auto_update, False, False)
        
        self.pack_start(self.box_search, False, False)
        self.pack_start(self.embed, True, True)

        #Dispatcher.connect("show-lyrics",self.new_media_cb)
        SignalCollector.connect("lyrics", Player, "new-song", self.new_media_cb)
        
        self.download_thread = WebFetchThread(1024, self.fail_fetch)
        #self.download_thread.connect("failed",self.fail_fetch)
        
        self.is_realize = False   
        self.current_html = None

        self.__lyrics_plugins = {}
                
        #Dispatcher.connect("reload-plugins",self.reload_plugin)
        self.reload_plugin()

    def unload(self):
        for _name, obj in self.__lyrics_plugins.iteritems():
            del obj.download_data 
            del obj.failed
            del obj.render
            del obj
        self.__lyrics_plugins = {}

    def on_change_lyrics_server(self, *arg):
        self.server = self.dropdown_server.get_active_text()
        config.set("lyrics", "server", self.server)
        self.on_search_changed(True)

    def reload_plugin(self, *args):
        self.__lyrics_plugins = {}
        LyricsManager.scan()
        for Kind in LyricsManager.list(True):
                obj = Kind()
                # Bind some method
                obj.download_data = self.download_thread.fetch_url
                obj.failed = self.fail_fetch
                obj.render = self.render_data
                self.__lyrics_plugins[obj.server_name] = obj
                
        self.fill_drop_down()
    
    def link_uri_cb(self, uri):
        # not really load uri
        return True
        
    def fill_drop_down(self):
        active = 0
        i = 0
        self.server = ""
        self.dropdown_server.get_model().clear()
        for server in self.__lyrics_plugins.keys():
            if server == config.get("lyrics", "server"):
                active = i
                self.server = server
            self.dropdown_server.append_text(server)
            i += 1
        self.dropdown_server.set_active(active)

    def fail_fetch(self):
        self.render_data(get_template() % (_("Server did not respond.")))
        
    def set_text(self, text):
        buffer = self.text.get_buffer()
        buffer.set_text(text)
        
    def force_select(self, song):
        self.new_media_cb(None, song)

    def new_media_cb(self, widget, song):
        if not self.auto_update.get_property("active"): return 
        
        if not ListenDB.song_has_capability(song, "lyrics") or not song.get("artist") or not song.get("title"):
            self.songs = None
            self.entry_artist.set_sensitive(False)
            self.entry_title.set_sensitive(False)
            self.entry_album.set_sensitive(False)
            self.render_data(get_template() % ("" + _("Lyrics not available for this media type") + ""))
            return 

        self.song = song

        if config.get("setting", "offline") == "true" :
            self.entry_artist.set_sensitive(False)
            self.entry_title.set_sensitive(False)
            self.entry_album.set_sensitive(False)
            HTML = get_template() % ("<h3>" + _("Offline mode") + "</h3>")
            self.render_data(HTML)
            return

        self.entry_artist.set_sensitive(True)
        self.entry_title.set_sensitive(True)
        self.entry_album.set_sensitive(True)
        self.entry_artist.set_text(self.song.get_str("artist"))
        self.entry_album.set_text(self.song.get_str("album"))

        title = self.song.get_str("title")
        self.entry_title.set_text(title)

        self.on_search_changed()

        
    def on_search_changed(self, w=None):
        if not self.song: return
        if w is None and vfs.exists(self.song.lyric_uri):
            text = vfs.read_entire_file(self.song.lyric_uri)
            self.render_data(text.replace("\n", "<br />"), None, True)
        else:
            if not self.server:
                self.render_data(get_template() % ("<h3>" + _("No plugin found for lyrics support") + "</h3>"))
                return 

            self.render_data(
                get_template() % (_("Fetching lyrics for") + " \"" + \
                self.entry_artist.get_text() + " - " + \
                self.entry_title.get_text() + "\"<br />" + \
                _("From") + " \"" + self.server + "\"..."))
            
            artist = utils.filter_info_song(self.entry_artist.get_text())
            title = utils.filter_info_song(self.entry_title.get_text())
            album = utils.filter_info_song(self.entry_album.get_text())
            
            try:self.__lyrics_plugins[self.server].process_lyrics(artist, album, title, self.song)
            except:
                self.logexception("Plugins process lyrics failed")
                self.fail_fetch()


            return 
            
    def render_data(self, html, song=None, striphtml=False):
        if striphtml:
            html = html.replace("\n", "")
            html = html.replace("\r", "")
            if html.find("<body") != -1:
                html = html[html.find("<body"):html.find("</body>")]
            html = re.sub("class=\"(.[^>]*)\"", "", html)
            html = re.sub("id=\"(.[^>]*)\"", "", html)
            html = re.sub("style=\"(.[^>]*)\"", "", html)
            html = re.sub("<script.*?>.*?</script>", "", html, re.S)
            html = re.sub("<center.*?>.*?</center>", "", html, re.S)
            html = re.sub("<font.*?>.*?</font>", "", html, re.S)
            html = html.replace("<br />", "\n")
            html = re.sub('<(.*)>', "", html)
            
        if song and len(html) > 0:
            vfs.safe_unlink(song.lyric_uri)
            vfs.makedirs(song.lyric_uri[:self.song.lyric_uri.rfind("/")])
            try:
                f = file(vfs.get_path_from_uri(song.lyric_uri), "w")
            except:pass
            else:
                f.write(html)
                f.close()

        if striphtml:    
            html = html.replace("\n", "<br />")    
            #Scrappy way to detect latin-1 string
            title = "<h2>" + self.song.get_str("title", True) + " - <i>" + self.song.get_str("artist", True) + '</i></h2>'
            try:html = html.encode("utf-8")
            except:
                for codec in ['iso-8859-1', 'iso-8559-15', 'utf-8']:
                    try: html = html.decode(codec)
                    except (UnicodeError, LookupError): pass
                    else:
                        html = title + html
                        break
            else:
                html = title + html
            html = get_template() % html
            
        self.embed.load_html_string(html, "file://%s/%s"%(self.server,self.song.get_str("title")))



class LyricsItem(SourceItem):
    widget_klass = LyricsBox
    config_code = "lyrics"
    label = _("Lyrics")
    stock = stock.SRC_LYRICS
    source_id = "lyrics"

class LyricsSource(Source):
    PLUGIN_NAME = "Lyrics Support"
    PLUGIN_DESC = _("Display lyric of current playing song")

    categorie = "info"
    display_index = 2
    signal_collector_id = "lyrics"

    def __init__(self):
        Source.__init__(self)
        item = LyricsItem()
        self.items = [ item ]

        def song_menu_action(song_menu_manager, id_menu, songs):
            if id_menu == "lyrics":
                Dispatcher.select_source_id("lyrics")
                item.widget.force_select(songs[0])
 
        self.autoconnect(SongMenuManager, "action", song_menu_action)
        SongMenuManager.register_item("lyrics", 80, stock.LYRICS)
        for type in [ "local", "unknown_local"]:
            SongMenuManager.allow_item_for_type("lyrics", type)


    def delete_thyself(self):
        SongMenuManager.unregister_item("lyrics")
        Source.delete_thyself(self)

