# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
###

import gtk
import os
from config import config

from logger import newLogger, Logger

try:
    import webkit
except ImportError:
    webkit = None
try: 
    from widget.mozembed_wrap import MozClient
except ImportError:
    MozClient = None
except: 
    MozClient = None


#FIXME: Need replace this by a abstract class
backend = os.environ.get("LISTEN_BROWSER",None)
if webkit and backend == "webkit":
    RENDERING = "webkit"
elif MozClient and backend == "mozilla":
    RENDERING = "mozilla"
else:
    if not webkit and not MozClient:
        raise ImportError("missing python-webkit (recommended) or python-mozembed")
    elif backend:
        raise ImportError('LISTEN_BROWSER support only "webkit" or "mozilla"')
    # Fallback
    elif webkit:
        RENDERING = "webkit"
    elif MozClient:
        RENDERING = "mozilla"


mylogger = newLogger("widget.htmlview")
mylogger.loginfo("html rendering use %s has backend",RENDERING)

if RENDERING == "webkit":
    klass = gtk.ScrolledWindow
elif RENDERING == "mozilla":
    klass = gtk.Frame
else:
    klass = gtk.Frame

class HtmlView(klass, Logger):
    def __init__(self):
        klass.__init__(self)

        self.__current_uri = ""

        if RENDERING == "webkit":
            self.embed = webkit.WebView()
            self.set_shadow_type(gtk.SHADOW_IN)
            self.embed.load_html_string("<html><head></head><body></body></html>", "" )
            self.embed.connect("navigation-policy-decision-requested", self.__webkit_link_uri_cb)
        elif RENDERING == "mozilla":
            self.embed = MozClient()
            self.embed.connect("open-uri",self.__moz_link_uri_cb)
        else:
            self.embed = None

        if self.embed:
            self.add(self.embed)

        self.__open_uri_callback = None

    def set_open_uri_callback(self, callback):
        self.__open_uri_callback = callback

    def open(self, uri):
        self.__current_uri = uri
        if RENDERING == "webkit":
            return self.embed.open(uri)
        elif RENDERING == "mozilla":
            return self.embed.load_url(uri)

    def load_html_string(self, html, uri):
        self.__current_uri = uri
        return self.embed.load_html_string(html, uri)

    def __moz_link_uri_cb(self, view, uri):
        return self.do_uri_request(uri)

    def __webkit_link_uri_cb(self, view, frame, networkRequest, navigation_action, policy_decision):
        uri = networkRequest.get_uri()
        ret = False
        if uri != self.__current_uri:
            ret = self.do_uri_request(uri)
        if ret:
            policy_decision.use()
        return ret
    
    def do_uri_request(self, uri):
        ret = False
        if self.__open_uri_callback:
            ret = self.__open_uri_callback(uri)
        self.logdebug("request %s: interrupt automatic loading:%s", uri, ret)
        return ret

    def destroy(self):
        del self.__open_uri_callback
        klass.destroy(self)


def get_template():
    font = "Sans"
    size = "11"
    full_font = config.get("setting","web_font")
    try : font = full_font [:full_font.rindex(" ")]
    except:pass
    try : size = full_font [full_font.rindex(" ")+1:]
    except:pass
    
    color_text = config.get("setting","web_color_text")
    color_link = config.get("setting","web_color_link")
    color_bg = config.get("setting","web_color_bg")
    return """
        <html>
            <head>
                <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
                <style>*{
                         font-size:11px;
                         color:%s
                         background-color:%s
                        }
                        a{color:%s}
                        /*a:hover{color:blue}*/
                       body{
                         margin:0px;
                         padding:7px;
                         font-family: "%s";
                         font-size:%spx;
                         background-color:%s;
                        }
                        p,ul,li,form,blockquote,dt,dd,a,b,i,u,div,span,h1,h2,h3,h4,h5,h6{
                           font-family: "%s";
                           font-size:%spx;
                        }
                        h1{font-size:1.6em;font-weight:bold;}
                        h2{font-size:1.4em;font-weight:bold;}
                        h3{font-size:1.2em;}
                        h4{font-size:1.1em;}
                        h5{font-size:1.0em;}
                        h6{font-size:0.8em;}
                        img{border:0px;}
                </style>
                </head>
            <body>
            %s
            </body>
        </html>
                """%(color_text,color_bg,color_link, font,size,color_bg,font,size,"%s")


