# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
###


import gtk

from action_manager import ActionManager
from player import Player

from widget.cover import PlayerCoverButton
from widget.information import PlayInfo
from widget.timer import SongTimer
from widget.control import VolumeSlider

MINI_ICON_SIZE = gtk.icon_size_register("listen-mini-icon-size", 12, 12)
#REQUEST_BUTTON_SIZE = (

class ListenMenuBar(gtk.HBox):
    def __init__(self):
        super(ListenMenuBar,self).__init__()


        self.set_border_width(3)

        def get_icon(stock):
            icon = gtk.image_new_from_stock(stock, gtk.ICON_SIZE_BUTTON)
            icon.show_all()
            return icon

        Player.connect("played",self.__swap_btn_play, True)
        Player.connect("paused",self.__swap_btn_play, False)
        Player.connect("stopped",self.__swap_btn_play, False)

        self.cover = PlayerCoverButton()
        self.cover.show_all()

        self.__play = gtk.ToggleButton()
        self.__play.add(gtk.image_new_from_stock(gtk.STOCK_MEDIA_PLAY,gtk.ICON_SIZE_BUTTON))
        self.__id_signal_play = self.__play.connect("toggled",lambda w: Player.playpause() )
        self.__play.show_all()
        self.__play.set_tooltip_text(_("Play"))

        prev = self.__build_btn(_("Previous"),gtk.STOCK_MEDIA_PREVIOUS,"previous")
        next = self.__build_btn(_("Next"),gtk.STOCK_MEDIA_NEXT,"next")

        self.vol = VolumeSlider()
        # Set correct size of vol button
        self.vol.set_size_request(*self.__play.size_request())
        self.vol.set_tooltip_text(_("Volume"))


        st = SongTimer()

        self.action = gtk.HBox()

        central = gtk.VBox()
        central.pack_start(PlayInfo(), True, True)
        central.pack_start(st.get_label(), False, False)
        
        mainbtn = gtk.HBox()
        mainbtn.pack_start(prev, False, False)
        mainbtn.pack_start(self.__play, False, False)
        mainbtn.pack_start(next, False, False)

        control = gtk.HBox(spacing=3)
        control.pack_start(mainbtn, False, False)
        control.pack_start(self.action, True, True)
        control.pack_start(self.vol, False, False)

        current_info = gtk.HBox(spacing=6)
        current_info.pack_start(self.cover, False, False)
        current_info.pack_start(central, True, True)

        information = gtk.VBox(spacing=6)
        information.pack_start(control,False,False)
        information.pack_start(current_info,False,False)
        information.pack_start(st,False,False)

        self.pack_start(information, True, True)

        Player.connect("stopped",self.reload_action_btn)
        Player.connect("instant-new-song",self.on_new_song)

        self.__actions_widget = []

        ActionManager.connect("action-added",self.reload_action_btn)
        ActionManager.connect("action-removed",self.reload_action_btn)
        self.reload_action_btn()


    def __hide_action(self,*args,**kwargs):
        for w in self.__actions_widget:
            self.action.remove(w)
            if hasattr(w,"clicked_id"):
                w.disconnect(w.clicked_id)
            del w
        self.__actions_widget = []

    def reload_action_btn(self,*args):
        self.on_new_song(Player,Player.song)

    def on_new_song(self,player,song):
        self.__hide_action()
        actions = ActionManager.get_actions(song)
        for action in actions:
            _position, _types, widget, pack_end = action
            if type(widget) == tuple:
                stock, func = widget
                btn = gtk.Button()
                btn.add(gtk.image_new_from_stock(stock, gtk.ICON_SIZE_BUTTON))
                btn.clicked_id = btn.connect("clicked",func)
            else:
                btn = widget
            if pack_end:
                self.action.pack_end(btn, False, False)
            else:
                self.action.pack_start(btn, False, False)
            self.__actions_widget.append(btn)
        self.action.show_all()


    def __swap_btn_play(self,obj,active):
        self.__play.handler_block(self.__id_signal_play)
        self.__play.set_active(active)
        self.__play.handler_unblock(self.__id_signal_play)

    def __build_btn(self,label,stock, msg , size=gtk.ICON_SIZE_BUTTON):
        btn = gtk.Button()
        btn.add(gtk.image_new_from_stock(stock, size))
        btn.connect("clicked", self.player_control, msg)
        btn.set_tooltip_text(label)
        return btn

    def player_control(self, btn, name):
        getattr(Player, name)()
              
