# -*- coding: utf-8 -*-
# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
###


import os
import gobject, gtk

from config import config
import utils

from player import Player
from xdg_support import get_xdg_tmp_file
from cover_manager import CoverManager


import dbus #@UnusedImport
import dbus.glib #@UnusedImport

class Notify(object):
    timeout = 10000
    current_song = None
    dbus_notify = None    
    title = "\xe2\x99\xaa "+_("Now playing")
    actions = []
    hints = []
    last_id = 0
    __id_tray = None
    def __init__(self,tray):
        interface = 'org.freedesktop.Notifications' 
        path = '/org/freedesktop/Notifications'    
        self.tray = tray
        bus = dbus.SessionBus()
            
        if utils.dbus_service_available(bus,interface,True):
            
            obj = bus.get_object(interface, path) 
            self.dbus_notify = dbus.Interface(obj, interface)
            
            self.dbus_notify.connect_to_signal("ActionInvoked",self.action_cb)
            #self.dbus_notify.connect_to_signal("NotificationClosed",self.on_notificationclosed)

            self.notify_server_info = self.dbus_notify.GetServerInformation()
            self.notify_capabilities = self.dbus_notify.GetCapabilities()

            if (self.notify_capabilities == None) or ("actions" in self.notify_capabilities):
                self.actions = ["previous","Previous","next","Next"]

            Player.connect("instant-new-song",self.on_new_song)
            
            self.tray.eventbox.connect("enter-notify-event", self.on_mouse_over)
            self.tray.eventbox.connect("leave-notify-event", self.on_mouse_out)
            
        else:
            self.dbus_notify = None
            gobject.timeout_add(1000, self.tray.update_tooltips)
            print "No Notify support"
            
    def on_notificationclosed(self,id,reason):
        print "Closed",id,reason
        self.last_id = 0
        
    def on_mouse_over(self,*args):
        if self.dbus_notify!=None and config.get("setting","notification")=="true":      
            self.__id_tray = gobject.timeout_add(1000,self.show_mouse_over)
            
    def show_mouse_over(self):
        value = Player.get_position()
        song = Player.song
        if song!=None:
            text = []    
            title = ""
            if song.get_str("station"):
                title += "<b>"+song.get_str("station",True)
                title += "</b>"+"\n"
            if song.get_str("title"):
                title += "<b>"+song.get_str("title",True)
                title += "</b>"
            if Player.is_paused():
                title += " - <i>"+_("Paused")+"</i>"
            text.append(title)
            if song.get("artist"):
                text.append("<i>"+song.get_str("artist",True)+"</i>")
            if song.get("album"):
                text.append(song.get_str("album",True))
            text.append(utils.duration_to_string(value, "00:00", 1)+" "+_("of")+" "+utils.duration_to_string(Player.get_length(),"00:00",1))
            
            text = "\n".join(text)
        else:
            text = _("No Playing")
            
        self.close_notification()
        self.display_notification(Player.song,text,100000,id=self.last_id)
        
        #refresh do a ugly things
        #self.__id_tray = gobject.timeout_add(5000,self.on_mouse_over)
        return False
        
    def on_mouse_out(self,*args):
        if self.__id_tray:
            try:gobject.source_remove(self.__id_tray)
            except:pass
            self.__id_tray = None
        self.close_notification()
        
    
    def action_cb(self,id,action):
        #print "I:widget/notify:action_cb",id,action
        # action is previous or next
        if hasattr(Player,action):
            getattr(Player, action)()
        
    def on_new_song(self,player,song):
        if self.dbus_notify is not None and config.get("setting","notification") == "true":
            
            text = []
            if song.get_str("title"):
                title = "<b>"+song.get_str("title",True)
                if song.get("#duration"):
                    title += " ("+song.get_str("#duration",True)+")"
                title += "</b>"
                text.append(title)
            if song.get("artist"):
                text.append("<i>"+song.get_str("artist",True)+"</i>")
            if song.get("album"):
                text.append(song.get_str("album",True))
            
            text = "\n".join(text)
            self.close_notification()
            if text:
                self.display_notification(song, text, self.timeout, actions = self.actions)

            
    def display_notification(self,song,text,timeout,actions=[],id=0):
        if not actions: actions = self.actions
        if self.dbus_notify!=None:  
            icon = ""  
            if song:
                try:
                    if self.notify_server_info[0] == "notify-osd":
                        #Larger image to improve image quality when scaled by notify-osd
                        pixbuf = CoverManager.get_pixbuf_from_song(song, 256, 256, False)
                    else:
                        pixbuf = CoverManager.get_pixbuf_from_song(song, 40, 40, False)
                    w, h = pixbuf.get_width(), pixbuf.get_height()
                    line = gtk.gdk.Pixbuf(gtk.gdk.COLORSPACE_RGB, True, 8, w + 2, h + 2)
                    line.fill(0x000000ff)
                    pixbuf.copy_area(0, 0, w, h, line, 1, 1)
                    icon = os.path.join( get_xdg_tmp_file("cover.png") )
                    line.save(icon, "png", {})
                except:
                    icon = ""
            
            self.hints = self.get_hints()
            self.last_id = self.dbus_notify.Notify("Listen", id, icon,self.title, text, actions, self.hints, timeout)
            return self.last_id
        return 0
            
    def close_notification(self):
        if self.dbus_notify is not None:
            # Catch exception in case id is not longer valid
            try: self.dbus_notify.CloseNotification(self.last_id)   
            except dbus.exceptions.DBusException: pass
            self.last_id = 0 
        
        
    #FROM GAJIM
    def get_hints(self):
        hints = {}
        if self.tray.tray:
            x, y = self.tray.tray.window.get_origin()
            w, h = self.tray.tray.size_request()
            try: orientation = self.tray.tray.get_property("orientation")
            except: orientation = gtk.ORIENTATION_HORIZONTAL
            if orientation == gtk.ORIENTATION_VERTICAL: 
                y += h/2
                if x < 100:
                    # left-panel
                    x += w*2
                else:
                    # right-panel
                    x -= w*2
            else:
                x += w/2
                if y < 100:
                    # top-panel
                    y += h
                else:
                    # bottom-panel
                    y -= h

            hints['x'] = x
            hints['y'] = y
        hints['desktop-entry'] = "listen"
         
        return hints

        
