/* Lyrics Plasmoid.
 * Copyright (C) 2010  Mauro E. Bender <maurobender@gmail.com>
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Here we avoid loading the header multiple times
#ifndef LYRICS_HEADER
#define LYRICS_HEADER

// We need the Plasma Applet headers
#include <KIcon>
#include <Plasma/Applet>
#include <Plasma/TextEdit>
#include <Plasma/Label>
#include <Plasma/PushButton>
#include <Plasma/DataEngine>

#include <QFont>

//Qt includes
#include <QtCore/QPair>
#include <QBool>

#include "song.h"
#include "lyrics_cache.h"
#include "lyrics_getter.h"
#include "lyrics_sources.h"

// Widgets
#include "songinfo.h"
#include "titlebar.h"

class QSizeF;

#include "ui_appearanceConfig.h"
#include "ui_sourcesConfig.h"

class LyricsPlasmoid : public Plasma::Applet {
Q_OBJECT
public:
	// Basic Create/Destroy
	LyricsPlasmoid(QObject *parent, const QVariantList &args);
	~LyricsPlasmoid();
	
	void init();
	
public slots:
	void dataUpdated(const QString &name, const Plasma::DataEngine::Data &data);
	
protected:
	void createConfigurationInterface(KConfigDialog *parent);
	
protected slots:
	void configAccepted();
	
private slots:
	void playerAdded(const QString &name);
	void playerRemoved(const QString &name);
	bool selectPlayer(const QString &name);
	bool selectLyricsSource(const QString &name);
	void updateLyrics(bool, QString);
	void updateLyricsTemplate();
	
	void reloadLyrics();
	void openConfigDialog();

private:
	void findPlayer();
	void loadConfig();
	void loadLyrics(const Song &, bool = false);

	Plasma::DataEngine *m_dataEngine;
	QStringList m_availablePlayers;
	QString m_watchingPlayer;
	
	QString m_lyricTemplate;
	Plasma::TextEdit *m_lyrics;
	
	LyricsSources *m_lyricsSources;
	LyricsGetter *m_lyricsGetter;
	
	Song m_currentSong;
	QString m_currentLyrics;
	
	// Widgets
	SongInfo *m_songInfo;
	TitleBar*m_titleBar;
	
	//Config
	Ui::ConfigAppearance m_appearanceConfigUi;
	Ui::ConfigSources m_sourcesConfigUi;
	
	QString m_textColor;
	QFont m_textFont;
	QString m_textAlignment;
	
	// Cache
	LyricsCache *m_lyricsCache;
	bool m_cacheLyrics;
	bool m_priorizeMetadataLyrics;
};
 
// This is the command that links your applet to the .desktop file
K_EXPORT_PLASMA_APPLET(lyrics-plasmoid, LyricsPlasmoid)
#endif
