/* 
**  mod_authz_ldap.c -- Apache LDAP authorization module
**
**  Read the files README and mod_authz_ldap.html for instructions on
**  configuring the module. Details of the license can be found in the
**  HTML documentation.
**
**  (c) 2000 Dr. Andreas Mueller
**
**  $Id: mod_authz_ldap.c,v 1.4 2010/02/04 21:17:52 afm Exp $
*/ 

/*
 * MODULE-DEFINITION-START
 * Name: authz_ldap_module
 * ConfigStart
   LDAP_LIBS="-lldap -llber"
   LIBS="$LIBS $LDAP_LIBS"
   echo "      + using LDAP libraries for authz_ldap module"
 * ConfigEnd
 * MODULE-DEFINITION-END
 */
#include "mod_authz_ldap.h"

/*************************************************************************
** Module Record							**
*************************************************************************/

/* Dispatch list for API hooks */

static void	authz_ldap_register_hooks(apr_pool_t *p) {
	static const char	*aszPre[] = { "mod_ssl.c", NULL };
	static const char	*aszSucc[] = { "mod_auth.c", NULL };
	ap_hook_check_user_id(authz_ldap_auth, aszPre, aszSucc,
		APR_HOOK_MIDDLE);
	ap_hook_auth_checker(authz_ldap_authz, aszPre, aszSucc,
		APR_HOOK_MIDDLE);
}

module AP_MODULE_DECLARE_DATA authz_ldap_module = {
    STANDARD20_MODULE_STUFF, 
    authz_ldap_create_dir_config,
                           /* create per-dir    config structures */
    authz_ldap_merge_dir_config,
			   /* merge  per-dir    config structures */
    NULL,                  /* create per-server config structures */
    NULL,                  /* merge  per-server config structures */
    authz_ldap_cmds,       /* table of config file commands       */
    authz_ldap_register_hooks	   /* register hooks for auth and authz	  */
};

