/*
 *  Copyright (C) 2003 Guilhem Vellut <guilhem.vellut@ensimag.imag.fr>
 *  
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,MA  02111-1307  USA 
 *
 */


#include <id3.h>
#include <ruby.h>


VALUE cMp3Tag;

static VALUE set_id_NumField(VALUE self,VALUE data,ID3_FrameID id){
  ID3Frame *myFrame;
  ID3Frame *pFrame;
  ID3Tag* tag;
  
  Data_Get_Struct(self, ID3Tag, tag);
  myFrame=ID3Frame_NewID(id);
  
  pFrame = ID3Tag_FindFrameWithID(tag, id);

  if (pFrame != NULL) {
    ID3Tag_RemoveFrame(tag,pFrame);
  }
  ID3Field_SetASCII(ID3Frame_GetField(myFrame,ID3FN_TEXT),STR2CSTR(rb_funcall(data,rb_intern("to_s"),0)));
  ID3Tag_AttachFrame(tag,myFrame);
  
  return data;
}

static VALUE id_NumField(VALUE self,ID3_FrameID id){
  ID3Frame *frame;
  ID3Tag* tag;
  frame=ID3Frame_New(); 
  Data_Get_Struct(self, ID3Tag, tag);
  if(!(frame = ID3Tag_FindFrameWithID(tag, id))){ 
    return Qnil;}
  else{ 
    ID3Field* field;
    if(!(field = ID3Frame_GetField(frame, ID3FN_TEXT))){ 
      return Qnil;} 
    else{
      int size=ID3Field_Size(field)+1; 
      char getVal[size]; 
      ID3Field_GetASCII(field,getVal,size);  
      return rb_funcall(rb_str_new2(getVal),rb_intern("to_i"),0);
    }
  }
}

static VALUE set_id_StrField(VALUE self,VALUE data,ID3_FrameID id){
  ID3Frame *myFrame;
  ID3Frame *pFrame;
  ID3Tag* tag;
  
  Data_Get_Struct(self, ID3Tag, tag);
  
  myFrame=ID3Frame_NewID(id);
  
  pFrame = ID3Tag_FindFrameWithID(tag, id);
  
  if (pFrame != NULL){
    ID3Tag_RemoveFrame(tag,pFrame);
  }
  
  if (strlen(STR2CSTR(data)) > 0) {
    
    ID3Field_SetASCII(ID3Frame_GetField(myFrame,ID3FN_TEXT),STR2CSTR(data));
    ID3Tag_AttachFrame(tag,myFrame);
  }

  return data;
}

static VALUE id_StrField(VALUE self,ID3_FrameID id){
  ID3Frame *frame;
  ID3Tag* tag;
  
  frame=ID3Frame_New();
  Data_Get_Struct(self, ID3Tag, tag);
      
  if(!(frame = ID3Tag_FindFrameWithID(tag, id))){
    return Qnil;}
  else{
    ID3Field* field;
    if(!(field = ID3Frame_GetField(frame, ID3FN_TEXT))){
      return Qnil;}
    else{
      int size=ID3Field_Size(field)+1;
      char getField[size];
      ID3Field_GetASCII(field, getField, size);
      return rb_str_new2(getField);
    }
  }
}


static VALUE set_id_UrlField(VALUE self,VALUE data,ID3_FrameID id){
  ID3Frame *myFrame;
  ID3Frame *pFrame;
  ID3Tag* tag;
  
  Data_Get_Struct(self, ID3Tag, tag);
  
  myFrame=ID3Frame_NewID(id);
  
  pFrame = ID3Tag_FindFrameWithID(tag, id);
  
  if (pFrame != NULL){
    ID3Tag_RemoveFrame(tag,pFrame);
  }
  
  if (strlen(STR2CSTR(data)) > 0) {
    ID3Field_SetASCII(ID3Frame_GetField(myFrame,ID3FN_URL),STR2CSTR(data));
    ID3Tag_AttachFrame(tag,myFrame);
  }

  return data;
}

static VALUE id_UrlField(VALUE self,ID3_FrameID id){
  ID3Frame *frame;
  ID3Tag* tag;
  
  frame=ID3Frame_New();
  Data_Get_Struct(self, ID3Tag, tag);
      
  if(!(frame = ID3Tag_FindFrameWithID(tag, id))){
    return Qnil;}
  else{
    ID3Field* field;
    if(!(field = ID3Frame_GetField(frame, ID3FN_URL))){
      return Qnil;}
    else{
      int size=ID3Field_Size(field)+1;
      char getField[size];
      ID3Field_GetASCII(field, getField, size);
      return rb_str_new2(getField);
    }
  }
}




VALUE tag(VALUE self,ID3_FrameID id){

  return self;
}


/****Artist****/

static VALUE id_artist(VALUE self){
  
  return id_StrField(self,ID3FID_LEADARTIST);


}


static VALUE set_id_artist(VALUE self, VALUE artist){
  
  return set_id_StrField(self,artist,ID3FID_LEADARTIST);
  

}

/****Album****/

static VALUE id_album(VALUE self){
 
  return id_StrField(self,ID3FID_ALBUM );
}


static VALUE set_id_album(VALUE self, VALUE album){
  
  return set_id_StrField(self ,album, ID3FID_ALBUM);
    
}

/****SongName****/

static VALUE id_title(VALUE self){
 
  return id_StrField(self,ID3FID_TITLE);
}

static VALUE set_id_title(VALUE self, VALUE title){
  
  return set_id_StrField(self,title, ID3FID_TITLE);
  
}

/****Tracknum****/

static VALUE id_tracknum(VALUE self){
 
  return id_NumField(self,ID3FID_TRACKNUM);
}


static VALUE set_id_tracknum(VALUE self, VALUE tracknum){
 
  return set_id_NumField(self,tracknum, ID3FID_TRACKNUM);
  
}


static VALUE id_composer(VALUE self){
  return id_StrField(self,ID3FID_COMPOSER);
}


static VALUE set_id_composer(VALUE self, VALUE val){
 
  return set_id_StrField(self,val, ID3FID_COMPOSER);
  
}


static VALUE id_bpm(VALUE self){
  return id_NumField(self,ID3FID_BPM);
}


static VALUE set_id_bpm(VALUE self, VALUE val){
 
  return set_id_NumField(self,val, ID3FID_BPM);
  
}

static VALUE id_wwwradiopage(VALUE self){
  return id_UrlField(self,ID3FID_WWWRADIOPAGE);
}


static VALUE set_id_wwwradiopage(VALUE self, VALUE val){
 
  return set_id_UrlField(self,val, ID3FID_WWWRADIOPAGE);
  
}

static VALUE id_wwwpayment(VALUE self){
  return id_UrlField(self,ID3FID_WWWPAYMENT);
}


static VALUE set_id_wwwpayment(VALUE self, VALUE val){
 
  return set_id_UrlField(self,val, ID3FID_WWWPAYMENT);
  
}
    
static VALUE id_wwwpublisher(VALUE self){
  return id_UrlField(self,ID3FID_WWWPUBLISHER);
}


static VALUE set_id_wwwpublisher(VALUE self, VALUE val){
 
  return set_id_UrlField(self,val, ID3FID_WWWPUBLISHER);
  
}

static VALUE id_wwwcopyright(VALUE self){
  return id_UrlField(self,ID3FID_WWWCOPYRIGHT);
}


static VALUE set_id_wwwcopyright(VALUE self, VALUE val){
 
  return set_id_UrlField(self,val, ID3FID_WWWCOPYRIGHT);
  
}

static VALUE id_wwwcommercialinfo(VALUE self){
  return id_UrlField(self,ID3FID_WWWCOMMERCIALINFO);
}


  
  
static VALUE set_id_wwwcommercialinfo(VALUE self, VALUE val){
 
  return set_id_UrlField(self,val, ID3FID_WWWCOMMERCIALINFO);
  
}

static VALUE id_wwwaudiosource(VALUE self){
  return id_UrlField(self,ID3FID_WWWAUDIOSOURCE);
}


static VALUE set_id_wwwaudiosource(VALUE self, VALUE val){
 
  return set_id_UrlField(self,val, ID3FID_WWWAUDIOSOURCE);
  
}

static VALUE id_wwwartist(VALUE self){
  return id_UrlField(self,ID3FID_WWWARTIST);
}


static VALUE set_id_wwwartist(VALUE self, VALUE val){
  
  
  return set_id_UrlField(self,val, ID3FID_WWWARTIST);
  
}
  
  
 
  
static VALUE id_unsyncedlyrics(VALUE self){
  return id_StrField(self,ID3FID_UNSYNCEDLYRICS);
}


static VALUE set_id_unsyncedlyrics(VALUE self, VALUE val){
 
  return set_id_StrField(self,val, ID3FID_UNSYNCEDLYRICS);
  
}

static VALUE id_date(VALUE self){
  return id_StrField(self,ID3FID_DATE);
}


static VALUE set_id_date(VALUE self, VALUE val){
 
  return set_id_StrField(self,val, ID3FID_DATE);
  
}

static VALUE id_netradiostation(VALUE self){
  return id_StrField(self,ID3FID_NETRADIOSTATION);
}


static VALUE set_id_netradiostation(VALUE self, VALUE val){
 
  return set_id_StrField(self,val, ID3FID_NETRADIOSTATION);
  
}

static VALUE id_recordingdates(VALUE self){
  return id_StrField(self,ID3FID_RECORDINGDATES);
}


static VALUE set_id_recordingdates(VALUE self, VALUE val){
 
  return set_id_StrField(self,val, ID3FID_RECORDINGDATES);
  
}
  
  
static VALUE id_publisher(VALUE self){
  return id_StrField(self,ID3FID_PUBLISHER);
}


static VALUE set_id_publisher(VALUE self, VALUE val){
 
  return set_id_StrField(self,val, ID3FID_PUBLISHER);
  
}

static VALUE id_partinset(VALUE self){
  return id_StrField(self,ID3FID_PARTINSET);
}


static VALUE set_id_partinset(VALUE self, VALUE val){
 
  return set_id_StrField(self,val, ID3FID_PARTINSET);
  
}

static VALUE id_mixartist(VALUE self){
  return id_StrField(self,ID3FID_MIXARTIST);
}


static VALUE set_id_mixartist(VALUE self, VALUE val){
 
  return set_id_StrField(self,val, ID3FID_MIXARTIST);
  
}

  

static VALUE id_conductor(VALUE self){
  return id_StrField(self,ID3FID_CONDUCTOR);
}


static VALUE set_id_conductor(VALUE self, VALUE val){
 
  return set_id_StrField(self,val, ID3FID_CONDUCTOR);
  
}

static VALUE id_origyear(VALUE self){
  return id_NumField(self,ID3FID_ORIGYEAR);
}


static VALUE set_id_origyear(VALUE self, VALUE val){
 
  return set_id_NumField(self,val, ID3FID_ORIGYEAR);
  
}

static VALUE id_band(VALUE self){
  return id_StrField(self,ID3FID_BAND);
}


static VALUE set_id_band(VALUE self, VALUE val){
 
  return set_id_StrField(self,val, ID3FID_BAND);
  
}

static VALUE id_fileowner(VALUE self){
  return id_StrField(self,ID3FID_FILEOWNER);
}


static VALUE set_id_fileowner(VALUE self, VALUE val){
 
  return set_id_StrField(self,val, ID3FID_FILEOWNER);
  
}

static VALUE id_origartist(VALUE self){
  return id_StrField(self,ID3FID_ORIGARTIST);
}


static VALUE set_id_origartist(VALUE self, VALUE val){
 
  return set_id_StrField(self,val, ID3FID_ORIGARTIST);
  
}

static VALUE id_origlyricist(VALUE self){
  return id_StrField(self,ID3FID_ORIGLYRICIST);
}


static VALUE set_id_origlyricist(VALUE self, VALUE val){
 
  return set_id_StrField(self,val, ID3FID_ORIGLYRICIST);
  
}



static VALUE id_origalbum(VALUE self){
  return id_StrField(self,ID3FID_ORIGALBUM);
}


static VALUE set_id_origalbum(VALUE self, VALUE val){
 
  return set_id_StrField(self,val, ID3FID_ORIGALBUM);
  
}

  
 
static VALUE id_language(VALUE self){
  return id_StrField(self,ID3FID_LANGUAGE);
}


static VALUE set_id_language(VALUE self, VALUE val){
 
  return set_id_StrField(self,val, ID3FID_LANGUAGE);
  
}

static VALUE id_subtitle(VALUE self){
  return id_StrField(self,ID3FID_SUBTITLE);
}


static VALUE set_id_subtitle(VALUE self, VALUE val){
 
  return set_id_StrField(self,val, ID3FID_SUBTITLE);
  
}

static VALUE id_lyricist(VALUE self){
  return id_StrField(self,ID3FID_LYRICIST);
}


static VALUE set_id_lyricist(VALUE self, VALUE val){
 
  return set_id_StrField(self,val, ID3FID_LYRICIST);
  
}

static VALUE id_encodedby(VALUE self){
  return id_StrField(self,ID3FID_ENCODEDBY);
}


static VALUE set_id_encodedby(VALUE self, VALUE val){
 
  return set_id_StrField(self,val, ID3FID_ENCODEDBY);
  
}

static VALUE id_contenttype(VALUE self){
  return id_NumField(self,ID3FID_CONTENTTYPE);
}


static VALUE set_id_contenttype(VALUE self, VALUE val){
 
  return set_id_NumField(self,val, ID3FID_CONTENTTYPE);
  
}
  

/****Comment****/

static VALUE id_comment(VALUE self){
 
  return id_StrField(self, ID3FID_COMMENT);
}


static VALUE set_id_comment(VALUE self, VALUE comment){
  
  return set_id_StrField(self,comment, ID3FID_COMMENT);
}

/****Copyright****/

static VALUE id_copyright(VALUE self){

  return id_StrField(self, ID3FID_COPYRIGHT);
}

static VALUE set_id_copyright(VALUE self, VALUE copyright){
   
  return set_id_StrField(self,copyright, ID3FID_COPYRIGHT);
}

/****Year****/

static VALUE id_year(VALUE self){
 
  return id_NumField(self,ID3FID_YEAR);
}

static VALUE set_id_year(VALUE self,VALUE year){
 
  return set_id_NumField(self,year,ID3FID_YEAR);
}


/****Genre****/



static VALUE commit(VALUE self){
  ID3Tag* tag;
  Data_Get_Struct(self, ID3Tag, tag);
  ID3Tag_Update(tag);
  return Qnil;
}
  


static void id_free(ID3Tag *p) {
  ID3Tag_Delete(p);
}


static VALUE mp3tag_new(VALUE classe, VALUE file)
{
  ID3Tag *tag;
  VALUE tdata;
  if(!(tag=ID3Tag_New()))
    return Qnil;
  else{
    ID3Tag_Link(tag, STR2CSTR(file));
    tdata = Data_Wrap_Struct(classe, 0, id_free, tag);
    rb_obj_call_init(tdata,1,&file);
    return tdata;
  }
  
}



void Init_c_mp3tag() {
  cMp3Tag=rb_define_class("Mp3Tag",rb_cObject);
  
  rb_define_singleton_method(cMp3Tag,"new",mp3tag_new,1);
  rb_define_method(cMp3Tag, "artist", id_artist, 0);
  rb_define_method(cMp3Tag, "artist=", set_id_artist, 1);
  rb_define_method(cMp3Tag, "album", id_album, 0);
  rb_define_method(cMp3Tag, "album=", set_id_album, 1);
  rb_define_method(cMp3Tag, "title", id_title, 0);
  rb_define_method(cMp3Tag, "title=", set_id_title, 1);
  rb_define_method(cMp3Tag, "tracknum", id_tracknum, 0);
  rb_define_method(cMp3Tag, "tracknum=", set_id_tracknum, 1);
  rb_define_method(cMp3Tag, "comment", id_comment, 0);
  rb_define_method(cMp3Tag, "comment=", set_id_comment, 1);
  rb_define_method(cMp3Tag, "copyright", id_copyright, 0);
  rb_define_method(cMp3Tag, "copyright=", set_id_copyright, 1);
  rb_define_method(cMp3Tag, "year", id_year, 0);
  rb_define_method(cMp3Tag, "year=", set_id_year, 1);
  rb_define_method(cMp3Tag, "contenttype", id_contenttype, 0);
  rb_define_method(cMp3Tag, "contenttype=", set_id_contenttype, 1);
  rb_define_method(cMp3Tag, "encodedby", id_encodedby, 0);
  rb_define_method(cMp3Tag, "encodedby=", set_id_encodedby, 1);
  rb_define_method(cMp3Tag, "lyricist", id_lyricist, 0);
  rb_define_method(cMp3Tag, "lyricist=", set_id_lyricist, 1);
  rb_define_method(cMp3Tag, "subtitle", id_subtitle, 0);
  rb_define_method(cMp3Tag, "subtitle=", set_id_subtitle, 1);
  rb_define_method(cMp3Tag, "language", id_language, 0);
  rb_define_method(cMp3Tag, "language=", set_id_language, 1);
  rb_define_method(cMp3Tag, "origalbum", id_origalbum, 0);
  rb_define_method(cMp3Tag, "origalbum=", set_id_origalbum, 1);
  rb_define_method(cMp3Tag, "origlyricist", id_origlyricist, 0);
  rb_define_method(cMp3Tag, "origlyricist=", set_id_origlyricist, 1);
  rb_define_method(cMp3Tag, "origartist", id_origartist, 0);
  rb_define_method(cMp3Tag, "origartist=", set_id_origartist, 1);
  rb_define_method(cMp3Tag, "fileowner", id_fileowner, 0);
  rb_define_method(cMp3Tag, "fileowner=", set_id_fileowner, 1);
  rb_define_method(cMp3Tag, "band", id_band, 0);
  rb_define_method(cMp3Tag, "band=", set_id_band, 1);
  rb_define_method(cMp3Tag, "origyear", id_origyear, 0);
  rb_define_method(cMp3Tag, "origyear=", set_id_origyear, 1);
  rb_define_method(cMp3Tag, "conductor", id_conductor, 0);
  rb_define_method(cMp3Tag, "conductor=", set_id_conductor, 1);
  rb_define_method(cMp3Tag, "mixartist", id_mixartist, 0);
  rb_define_method(cMp3Tag, "mixartist=", set_id_mixartist, 1);
  rb_define_method(cMp3Tag, "partinset", id_partinset, 0);
  rb_define_method(cMp3Tag, "partinset=", set_id_partinset, 1);
  rb_define_method(cMp3Tag, "publisher", id_publisher, 0);
  rb_define_method(cMp3Tag, "publisher=", set_id_publisher, 1);
  rb_define_method(cMp3Tag, "recordingdates", id_recordingdates, 0);
  rb_define_method(cMp3Tag, "recordingdates=", set_id_recordingdates, 1);
  rb_define_method(cMp3Tag, "netradiostation", id_netradiostation, 0);
  rb_define_method(cMp3Tag, "netradiostation=", set_id_netradiostation, 1);
  rb_define_method(cMp3Tag, "date", id_date, 0);
  rb_define_method(cMp3Tag, "date=", set_id_date, 1);
  rb_define_method(cMp3Tag, "unsyncedlyrics", id_unsyncedlyrics, 0);
  rb_define_method(cMp3Tag, "unsyncedlyrics=", set_id_unsyncedlyrics, 1);
  rb_define_method(cMp3Tag, "wwwartist", id_wwwartist, 0);
  rb_define_method(cMp3Tag, "wwwartist=", set_id_wwwartist, 1);
  rb_define_method(cMp3Tag, "wwwaudiosource", id_wwwaudiosource, 0);
  rb_define_method(cMp3Tag, "wwwaudiosource=", set_id_wwwaudiosource, 1);
  rb_define_method(cMp3Tag, "wwwcommercialinfo", id_wwwcommercialinfo, 0);
  rb_define_method(cMp3Tag, "wwwcommercialinfo=", set_id_wwwcommercialinfo, 1);
  rb_define_method(cMp3Tag, "wwwcopyright", id_wwwcopyright, 0);
  rb_define_method(cMp3Tag, "wwwcopyright=", set_id_wwwcopyright, 1);
  rb_define_method(cMp3Tag, "wwwpublisher", id_wwwpublisher, 0);
  rb_define_method(cMp3Tag, "wwwpublisher=", set_id_wwwpublisher, 1);
  rb_define_method(cMp3Tag, "wwwpayment", id_wwwpayment, 0);
  rb_define_method(cMp3Tag, "wwwpayment=", set_id_wwwpayment, 1);
  rb_define_method(cMp3Tag, "wwwradiopage", id_wwwradiopage, 0);
  rb_define_method(cMp3Tag, "wwwradiopage=", set_id_wwwradiopage, 1);
  rb_define_method(cMp3Tag, "bpm", id_bpm, 0);
  rb_define_method(cMp3Tag, "bpm=", set_id_bpm, 1);
  rb_define_method(cMp3Tag, "composer", id_composer, 0);
  rb_define_method(cMp3Tag, "composer=", set_id_composer, 1);
  
  
  rb_define_method(cMp3Tag, "commit", commit, 0);
  
  
  

}

