#!/usr/bin/env bash

#*****************************************************************************
# xtnfold version 1.0.2
# p̃f[^Zbg̍쐬
# T.Nakahara
# 2002/01/12
# Y.Hamuro
# 2002/01/29 -t̒ǉ, -d̃fBNgŌ/ŏIĂKpȂ
# 2003/02/03 ݂̃R}hɑΉ(1.0.1)
# 2004/01/21 tops /bin/bash -> /usr/bin/env bash ɕύX(ĉwE)
# 2004/01/21 wvŃo[W\\悤ɕύX(1.0.2)
#*****************************************************************************
#G[bZ[W
function help {
cat >/dev/stderr <<EOF
------------------------
xtnfold.sh version 1.0.2
------------------------
Tv) p̃f[^Zbg쐬B
) xtnfold.sh -it@C -do̓fBNg -nfold -cNX -S ̎ [-t] [-og[jOt@C] [-OeXgt@C]
) xtnfold.sh -i dat -d fold -n 5 -c Class -o fold##.train -O fold##.test
EOF
exit 1
}

#p[^̃Zbg
  rName='fold##.data'
  sName='fold##.test'
  while getopts ":i:d:n:c:S:k:o:O:th" opt; do
    case $opt in
      i  ) input=$OPTARG ;;
      d  ) path=$OPTARG ;;
      n  ) fold=$OPTARG ;;
      c  ) cls=$OPTARG ;;
      S  ) sed=$OPTARG ;;
      o  ) rName=$OPTARG ;;
      O  ) sName=$OPTARG ;;
      t  ) txt=1 ;;
      h  ) help ;;
      \? ) help ;;
    esac
  done
  shift $(($OPTIND -1 ))

  if [ "$input" = "" ]; then
     help; exit 1
  fi
  if [ "$path" = "" ]; then
     help; exit 1
  fi
  if [ "$fold" = "" ]; then
     help; exit 1
  fi
  if [ "$cls" = "" ]; then
     help; exit 1
  fi
  if [ "$sed" = "" ]; then
     sed=-1
  fi
  if [ "$rName" = "" ]; then
     help; exit 1
  fi
  if [ "$sName" = "" ]; then
     help; exit 1
  fi

#g[jOƃeXg̓ꖼ`FbN
  if [ "$rName" = "$sName" ]; then
    echo 'file names for training and test must be different'
    exit 1
  fi

#̓t@C`FbN
  if [ ! -f $input ]; then
     echo 'file not found : '$input; exit 1
  fi

#-d̂"/"Ƃ
path=`echo $path | sed 's/\/*$//'`

#[Nt@C̃vtBbNX̐ݒ
wf=/tmp/xt##$$-xtnfold

#eLXg̏ꍇAxmlTableɕϊ
  if [ "$txt" = "1" ]; then
    fldCnt=`head -1 $input | gawk '{print NF}'`
    cnt=2
    fldName=1
    while [ $cnt -le $fldCnt ] ; do
      fldName=$fldName","$cnt
      cnt=$((cnt+1))
    done
    txt2xt -a $fldName -i $input -o $wf-01
    input=$wf-01
  fi

#o̓fBNg݂ȂȂ쐬
  if [ ! -d $path ]; then
     mkdir -p $path
  fi

#cls𕪂邽߂foldɂ킹clsԍӂ
  xtrand -a rand -S $sed -i$input |
  xtcal  -k$cls -s rand%n -c 'down(keyLine()/(keyCnt()/'$fold'+0.00001),1)' -a val >$wf-03

#clsԍɂ킹Ăꂼ̃t@Cɏo͂
  roop=0
  while [ "$roop" -lt "$fold" ]; do
    xtsel -c'$val -eq '$roop -i$wf-03\
          -u$wf-trn-$(($roop+1)) -o $wf-tst-$(($roop+1))
    roop=$((roop+1)) 
  done;

  roop=1
  while [ $roop -le $fold ] ; do
    trnName=`echo $rName | sed 's/##/'$roop'/'`
    tstName=`echo $sName | sed 's/##/'$roop'/'`
    tprName=$wf-trn-$roop
    tpsName=$wf-tst-$roop

    #eLXg̏ꍇAtextɕϊ
    if [ "$txt" = "1" ]; then
      xtcut -rfval,rand -i$tprName | xt2txt -o"$path"/$trnName
      xtcut -rfval,rand -i$tpsName | xt2txt -o"$path"/$tstName
    else 
      xtcut -rfval,rand -i$tprName -o"$path"/$trnName
      xtcut -rfval,rand -i$tpsName -o"$path"/$tstName
    fi
    roop=$((roop+1)) 
  done;

  rm $wf-*
  exit 0
