#!/usr/bin/env bash

#*****************************************************************************
# xtless version 1.0.1
# XMLtableをテキストに変換してlessで表示
# Y.Hamuro
# 2003/01/18
# 2004/01/21 top行 /bin/bash -> /usr/bin/env bash に変更(増田氏のご指摘)
# 2004/01/21 PAGER環境変数によりページャーを切替える様に変更(増田氏のご指摘)
# 2004/01/21 ヘルプでバージョン情報を表示するように変更(1.0.1)
#*****************************************************************************
#エラーメッセージ
function help {
cat >/dev/stderr <<EOF
------------------------
xtless.sh version 1.0.1
------------------------
概要) XMLtableデータを項目行付きテキストに変換してpagerで表示する。
書式) xtless [-h] ファイル名

例) xtless.sh dat.xt
EOF
exit 1
}

#パラメータのセット
  while getopts ":h" opt; do
    case $opt in
      h  ) help ;;
      \? ) help ;;
    esac
  done

#PAGER変数のチェック
  if [ -z "$PAGER" ] ; then
    PAGER=more
  fi

  xt2txt -F -i $1 | $PAGER

  exit 0
