/*
 * NETMAJ - network mahjongg -  Copyright Notice
 *     Copyright (C) 1994, 1995, 1996 Koji Suzuki (suz@kt.rim.or.jp)
 *
 *  You can redistribute it and/or modify this software under the terms 
 * of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 *  This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the author be held liable for any damages
 * arising from the use of this software.
 * See the gpl.text for more details.
 *
 *  If you would like to do something with NETMAJ that this copyright
 * prohibits (such as distributing it with a commercial product,
 * using portions of the source in some other program, etc.), please
 * contact the author (preferably via email).  Arrangements can
 * probably be worked out.
 *
 *  Koji Suzuki   : suz@kt.rim.or.jp
 */
/* $Id: rv.c,v 1.4 1996/07/31 08:06:20 suz Exp $ */

#include "pai.h"
#include "global.h"

rv_new(gp) global_t *gp; {
	int i,j;

	rvp = 0;
	cur_player = 0;
	for (i=0; i<4; i++) {
		rv_cur[i] =0;
		for (j=0; j<RIVER_MAX; j++) {
			rv[i][j].next = 0;
			rv[i][j].prev = 0;
			rv[i][j].attr = 0;
			rv[i][j].in = P_NULL;
			rv[i][j].out = P_NULL;
		}
	}
}

rv_push(gp,to) global_t *gp; {
	if (rvp) {
		if (cur_player != to) 
			rvp->next = rv[to] + rv_cur[to];
		else 
			rvp->next = rv[to] + rv_cur[to] + 1;
		rvp->next->prev = rvp;
		rvp = rvp->next;
	  	rv_cur[cur_player]++;
	} else {
		rvp = rv[to] + rv_cur[to];
	}
	cur_player = to;
if (plog) fprintf(plog,"rv_push: rvp = rv[%d][%d]\n",to,rv_cur[to]);
}


rv_find_player(gp,p) global_t *gp; river_t *p; {
	if (p < &rv[0][0] || p > &rv[3][RIVER_MAX]) return 0;
	return (p - &rv[0][0])/RIVER_MAX;
}

rv_find_cur(gp,p) global_t *gp; river_t *p; {
	if (p < &rv[0][0] || p > &rv[3][RIVER_MAX]) return 0;
	return (p - &rv[0][0])%RIVER_MAX;
}

