/*
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2003 The Apache Software Foundation.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowledgement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgement may appear in the software itself,
 *    if and wherever such third-party acknowledgements normally appear.
 *
 * 4. The names "The Jakarta Project", "Commons", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 */

package org.apache.commons.jrcs.rcs;

import junit.framework.TestCase;

import java.io.InputStream;
import java.io.FileInputStream;
import java.io.File;

public class ParsingTest extends TestCase {

	String basedir = null;

	public ParsingTest(String testName)
       	{
		super(testName);
	}

	public void setUp()
	{
		basedir = System.getProperty("rcs-input");
		assertNotNull(basedir);
	}

	public void testInputOutput() throws Exception
	{
		File infile = new File(basedir + File.separator + "inout.testfile");
		FileInputStream is = new FileInputStream(infile);
		assertNotNull(is);

		Archive ar = new Archive("inout.testfile", is);
		String output = ar.toString();

		is.close();
		is = new FileInputStream(infile);

		int infileLen = (int)infile.length();
		byte[] inputb = new byte[infileLen];

		int rlen;
		if ((rlen = is.read(inputb, 0, infileLen)) != infileLen)
			fail("Expected: " + infileLen + " bytes, got: " + rlen);

		String input = new String(inputb);

		assertTrue(output.equals(input));
	}

	/**
	 * @author Matt Quail (matt_quail AT yahoo DOT com)
	 */
	public void testIDCHAR() throws Exception
	{
		FileInputStream is = new FileInputStream(basedir + File.separator + "idchar.testfile");
		assertNotNull(is);

		Archive ar = new Archive("idchar.testfile", is);
	}

	public void testNoStrict() throws Exception
	{
		File infile = new File(basedir + File.separator + "nostrict.testfile");
		FileInputStream is = new FileInputStream(infile);
		assertNotNull(is);

		Archive ar = new Archive("nostrict.testfile", is);

		String output = ar.toString();

		is.close();
		is = new FileInputStream(infile);

		int infileLen = (int)infile.length();
		byte[] inputb = new byte[infileLen];

		int rlen;
		if ((rlen = is.read(inputb, 0, infileLen)) != infileLen)
			fail("Expected: " + infileLen + " bytes, got: " + rlen);

		String input = new String(inputb);

		assertTrue(output.equals(input));
	}

	public void testTokenNameAsIDorSYM() throws Exception
	{
		FileInputStream is = new FileInputStream(basedir + File.separator + "token.testfile");
		assertNotNull(is);

		Archive ar = new Archive("token.testfile", is);
	}

	public void testNewPhrases() throws Exception
	{
		FileInputStream is = new FileInputStream(basedir + File.separator + "newphrases.testfile");
		assertNotNull(is);

		Archive ar = new Archive("newphrases.testfile", is);
	}
}
