/*
** PHREL
** $Id: prefs.h,v 1.24 2006/04/14 05:12:28 sella Exp $
** Copyright (c) 2004 James M. Sella. All Rights Reserved.
** Released under the GPL Version 2 License.
** http://www.digitalgenesis.com
*/

#ifndef __DGS_PREFS_H
#define __DGS_PREFS_H

#include "config.h"

#include <configuration.h>

#include <arpa/inet.h>

#define MAX_THRESHOLD 64000
#define DEF_RATELIMIT 0
#define MAX_RATELIMIT 64000
#define DEF_BURST 5
#define MAX_BURST 64000
#define DEF_DECAY 900
#define MAX_DECAY 86400
#define DEF_INTERVAL 30 /* Default interval (sec used for an average calc. Larger values use CPU. */
#define MIN_INTERVAL 1
#define MAX_INTERVAL 900
#define DEF_CHECK_INTERVAL 30 /* Default interval at which hash is checked and updates occur. */
#define MIN_CHECK_INTERVAL 1
#define MAX_CHECK_INTERVAL 900
#define DEF_STATS_INTERVAL 300 /* Default interval at which hash is dumped to stats file. */
#define MIN_STATS_INTERVAL 1
#define MAX_STATS_INTERVAL 3600
#define DEF_NICENESS 5
#define MAX_CHAIN_LEN 28
#define DEF_STATS "/var/run/phreld.stat"
#define DEF_DUMP "/var/run/phreld.dump"
#define DEF_JUMP "DROP"
#define DEF_IPTABLES "/sbin/iptables"

#define PPS_ALGO_AVG 0
#define PPS_ALGO_SUM 1
#define PPS_ALGO_MAX 2
#define MAX_ALGO_NAMES 3
#define DEF_PPS_ALGO PPS_ALGO_AVG

#define USE_DEFAULT ((unsigned int) -1)
#define STALE_INTERVAL_MLT 4 /* Interval multipler to use to descide when a hash entry is stale. */
#define SELECT_TIMEOUT_SEC 5
#define DEF_SYSLOG_FACILITY LOG_LOCAL0
#define PCAP_EXPRESSION_SIZE 4096

const static char algo_names[MAX_ALGO_NAMES][4] = { "avg", "sum", "max" };

struct threshold_t {
	unsigned int threshold;
	unsigned int rate;
	unsigned int burst;
	unsigned int decay;
	struct threshold_t *next;
};

struct prefix_t {
	struct in_addr ip;
	struct in_addr mask;
	unsigned int cidr;
	unsigned int interface;
	struct prefix_t *next;
};

struct args_t {
	char *interface;
	char *expression;
	struct threshold_t *threshold;
	unsigned int rate;
	unsigned int burst;
	unsigned int decay;
	struct prefix_t *include;
	struct prefix_t *exclude;
	unsigned int algo;
	unsigned int interval;
	unsigned int check_interval;
	unsigned int stats_interval;
	unsigned int stale_interval; /* Always (interval * STALE_INTERVAL_MLT) */
	unsigned int max_samples; /* Always (interval + 1) */
	struct _snmptrap_peer_t *peer;
	unsigned int promisc;
	unsigned int test;
	char *jump;
	char *iptables;
	char *config;
	char *user;
	char *group;
	char *chroot;
	char *stats;
	char *dump;
	int nice;
	unsigned int debug;
};

int get_args(int argc, char** argv);
int process_config(struct config_node *node);
int exclude_interfaces(struct prefix_t **exclude);
void version(int flag);
void usage();
void display_args();
void free_args();

#endif 

/*
** Local Variables:
** c-basic-offset: 3
** tab-width: 3
** End:
** vim: noet ts=3 sw=3
*/
