/*!
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 *    Author: flareguner
 *    E-Mail: flareguner@gmail.com
 *    Years: 2010-2010
 */

#include "logger.h"
#include "ui_logger.h"
#include "defines.h"

#include <QtCore/QTextStream>
#include <QtCore/QDate>
#include <QtCore/QIODevice>
#include <QtCore/QFile>
#include <QtGui/QMessageBox>

Logger::Logger(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Logger)
{
    ui->setupUi(this);
    m_logging_dir.setPath(qgt_default_logdir_path);
    if(!m_logging_dir.exists())
        m_logging_dir.mkpath(qgt_default_logdir_path);

    loadLogs();

    connect(ui->listWidget, SIGNAL(currentRowChanged(int)),this,SLOT(showLog(int)));
//    connect(ui->lineEdit, SIGNAL(textChanged(QString)), this, SLOT(findText(QString)));
    connect(ui->find_pushButton, SIGNAL(clicked()),this,SLOT(findText()));
}

Logger::~Logger()
{
    delete ui;
}

//---------------------------------------------------------------------------------------------------

void Logger::changeEvent(QEvent *e) {
    QGT_RETRANSLATE_EVENT_HANDLE(QDialog,e, ui)
}

//---------------------------------------------------------------------------------------------------

void Logger::showLogs() {
    this->loadLogs();
    this->show();
}

void Logger::log(const QString &text) {
    QDateTime cur_date(QDateTime::currentDateTime());
    QFile cur_log(qgt_default_logdir_path + QDir::separator() +
                  cur_date.toString("dd.MM.yyyy") + ".txt");
    if(cur_log.open(QFile::Append | QFile::ReadWrite | QFile::Text)) {
        cur_log.write(text.toUtf8());
        cur_log.close();
    } else {
        qWarning() << Q_FUNC_INFO << "Error! Can\'t save log file:"
                      << cur_log.fileName() << "because : "
                         << cur_log.errorString();
    }
}

void Logger::loadLogs() {
    const QStringList logs = m_logging_dir.entryList(QStringList() << "*.txt");
ui->listWidget->count();
        ui->listWidget->clear();
    for(int i = 0; i < logs.size(); i++) {
        QString tmp = logs.at(i);
        tmp.remove(tmp.size() - 4, 4);
        ui->listWidget->addItem(tmp);
    }
    ui->listWidget->setCurrentRow(ui->listWidget->count() -1);

}

void Logger::showLog(const int i) {

    if(i < 0) return;

    QFile log_file(qgt_default_logdir_path + QDir::separator()
                   + ui->listWidget->item(i)->text() + ".txt");

    if(log_file.open(QFile::ReadOnly | QFile::Text)) {
        ui->textEdit->setText(QString::fromUtf8(log_file.readAll().data()));
    } else {
        qWarning() << "Error! Can\'t load log file: "
        << log_file.fileName() << "because : "
         << log_file.errorString();
    }
}

void Logger::findText() {
    const QString text = ui->lineEdit->text();
    if(text.isEmpty()) return;

    const QTextDocument *doc = ui->textEdit->document();
    const QTextDocument::FindFlags zero_flag = 0;
    QTextDocument::FindFlags flags = 0;
    QTextCursor cursor;

    bool re = ui->re_checkBox->isChecked();
    bool cs = ui->cs_checkBox->isChecked();
    bool ww = ui->ww_checkBox->isChecked();

        cs && (flags |= QTextDocument::FindCaseSensitively);
    ww && (flags |= QTextDocument::FindWholeWords);
    cursor = re ?
     doc->find(QRegExp(text), ui->textEdit->textCursor(), flags) :
     doc->find(text, ui->textEdit->textCursor(), flags);

    if(!cursor.isNull())
        ui->textEdit->setTextCursor(cursor);
}



