/*!
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 *    Author: flareguner
 *    E-Mail: flareguner@gmail.com
 *    Years: 2010-2010
 */

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QTimer>

namespace Ui {
    class MainWindow;
}

class TrayIcon;
class Settings;
class Logger;
class WordsReservation;
class ToolTip;
class Pronounce;
class Translate;
class HackedTextEdit;
class About;
class QxtGlobalShortcut;
class QFile;
class QClipboard;
class QTranslator;


class MainWindow : public QMainWindow
{
    Q_OBJECT

public:

    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

private:
    Ui::MainWindow *ui;
    TrayIcon *m_tray_icon;
    Settings *m_settings;
    Logger *m_logger;
    WordsReservation *m_words_reservator;
    ToolTip *m_tooltip;
    Pronounce *m_pronounce;
    Translate  *m_translate;
    HackedTextEdit *m_hacked_textEdit;
    About *m_about;
    QString m_latest_save_path/*, m_latest_open_path*/;
    QxtGlobalShortcut *m_translation_shortcut;
    QClipboard *m_clipboard;
    QString m_current_lang;
    QTranslator *m_current_translator;
    QTimer m_selection_translate_timer;

    bool checkModifier(Qt::KeyboardModifier);
private slots:
    //! С menu slots
    void open();
    void save();
    void saveAs();
    void print();
    void translate();
    void exit();
    //! Edit menu
    void clear();
    void copy();
    void swap();
    //! Tools menu
    void settings();
    void speech();
    //! About menu
    void aboutQt();
    //! Secondary slots
    void whenSourceTextChanged();
    void whenResultTextChanged();

    void whenSettingsChanged();
    void whenSelectionChanged();
    void whenTranslateHotkeyPressed();
    void whenInputFinished();

    void notificate(const QString &text);
    void showOrHide();
    void updateTrayTooltip();
    //! Save\read some main window params
    void readUiSettings();
    void saveUiSettings();
    void slotTranslateSelectionTimeout();
protected:
    void closeEvent(QCloseEvent *);
    void changeEvent(QEvent *);
};

#endif // MAINWINDOW_H
