/*!
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 *    Author: flareguner
 *    E-Mail: flareguner@gmail.com
 *    Years: 2010-2010
 */

#ifndef PRONOUNCE_H
#define PRONOUNCE_H

#include <QObject>

class QString;
class QProcess;

class Pronounce : public QObject
{
    Q_OBJECT
public:
    explicit Pronounce(QObject *parent = 0);
    ~Pronounce();
    //! Setup command for playing mp3 file with pronounce.
    void setPronounceCmd(const QString &command){
        m_cmd = command;
    }

    //! Say text into lang
    void say(const QString &lang, const QString &text);

    //! Return current pronounce command;
    QString getPronounceCmd() const {
        return m_cmd;
    }
private slots:
    bool isRunning();
    void stop();
private:
    QString m_cmd, m_file_path;
    QProcess *m_process;
signals:
    void finished();
private slots:
    void whenProcessFinished(int);
};

#endif // PRONOUNCE_H
