/*!
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 *    Author: flareguner
 *    E-Mail: flareguner@gmail.com
 *    Years: 2010-2010
 */

#ifndef TRAYICON_H
#define TRAYICON_H

#include <QObject>
#include <QtGui/QAction>
#include <QtGui/QSystemTrayIcon>
#include "defines.h"

class QMenu;

class TrayIcon : public QObject
{
    Q_OBJECT
public:
    explicit TrayIcon(QObject *parent = 0);
    void setTranslateActionEnabled(bool);
#ifdef Q_WS_X11
    bool scanBufferEnabled() const;
#endif
signals:
    void translationRequested();
    void swapRequested();
    void configureRequested();
    void scanSelectionChanged(bool);
    void showOrHideRequested();
    void quitRequested();
public slots:
    void show();
    void hide();
    void notificate(const QString &title /*= QString()*/, const QString &text, int msec = 10000);
    void setMainWindowHidden(bool b);
    void retranslateMenu(QWidget *MainWindow);

    void setToolTip(const QString &text);
    
#ifdef Q_WS_X11

    void setScanBufferChecked(bool);
#endif
private slots:
    void trayActivated(QSystemTrayIcon::ActivationReason reason);
private:
//    void chan

    QMenu *m_menu;
    QSystemTrayIcon *m_tray_icon;
    QAction
    // Show or hide application
    *m_action_show_or_hide,
    // Translate text
    *m_action_translate,
    // Switch languages
    *m_action_swap,
#ifdef Q_WS_X11
    // Enable\disable selection buffer
    *m_action_enable_scan_selection_buffer,
#endif
    // Configure application
    *m_action_configure,
    // Quit application
    *m_action_quit;
};

#endif // TRAYICON_H
