/****************************************************************************
    LCoV library editor for BSch3V
    Copyright (C) 2004-2005 H.Okada (http://www.suigyodo.com/online)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

#pragma once
#include "SPtnObj.h"
#include <string>
using namespace std;

class SPtnObjText :	public SPtnObj
{
public:
	//̤Υ󥿡ե
	SPtnObjText(void);
	~SPtnObjText(void);
	int id(){return VECTPTN_TXT;}
	SPtnObjText(const SPtnObjText&);					//ԡ󥹥ȥ饯
	SPtnObjText& operator=(const SPtnObjText&);		//黻
	SPtnObj* duplicate();							//ʣ
	bool qValid();									//ͭʥǡɤ֤

	//åפο֤
	int gripCount(){return 1;}
	//åפΰ֤֤
	SPoint gripPos(int grip){return m_p0;}
	//åפΰ֤ư
	void setGripPos(int grip,int x,int y);

	void move(int offsetx,int offsety);				//֤ư
	void mirrorH(int x); 							//XɸꤷƺȿžԤ
	void mirrorH();									//ȿžԤ
	void rotate(const SPoint& p);					//XY濴ɸꤷơžԤ
	void rotate();									//žԤ
	bool testIntersect(const SRect& );				//ϰϤꤷåԤ
	bool testIntersect(const SPoint& );				//ꤷåԤ
	SRect area();									//ͭϰϤ֤
	void setDrawSize(SSize size);
	void setText(const char* csz);
	bool readCe3(SReadCE3& rce3);
	bool writeCe3(SWriteCE3& wce3,SPoint* pOrigin=NULL);
	void setFontName(const char* psz);
	void setFontSize(int fontSize);
	void setFontBold(bool istrue);
	void setFontItalic(bool istrue);
	void setFontUnderline(bool istrue);
	void setFontStrikeOut(bool istrue);

public:
	SPoint m_p0;
	bool m_bHoriz;
	string m_strText;
	int m_align;
	bool m_drawSizeIsValid;
	SSize m_drawSize;
	string	m_fontName;
	int		m_fontSize;
	bool	m_fontBold;
	bool	m_fontItalic;
	bool	m_fontUnderline;
	bool	m_fontStrikeOut;


};
