/*
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */
package org.apache.qpid.server.message;

import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.store.StoredMessage;

import java.nio.ByteBuffer;

public interface ServerMessage<T extends StorableMessageMetaData> extends EnqueableMessage, MessageContentSource
{
    String getRoutingKey();

    AMQMessageHeader getMessageHeader();

    public StoredMessage<T> getStoredMessage();

    boolean isPersistent();

    long getSize();

    boolean isImmediate();

    long getExpiration();

    MessageReference newReference();

    long getMessageNumber();

    long getArrivalTime();

    public int getContent(ByteBuffer buf, int offset);

    public ByteBuffer getContent(int offset, int size);

}
