/* 
 * Copyright (C) 2005  Network Applied Communication Laboratory Co., Ltd.
 *
 * This file is part of Rast.
 * See the file COPYING for redistribution information.
 *
 */

#ifndef RAST_TYPES_H
#define RAST_TYPES_H

/**
 * @file types.h types
 */

#include "rast/macros.h"

RAST_EXTERN_C_BEGIN

/**
 * @defgroup types types
 * @{
 */

typedef apr_uint32_t rast_uint_t;
typedef rast_uint_t rast_size_t;
typedef rast_uint_t rast_doc_id_t;
typedef rast_uint_t rast_pos_t;

#define RAST_POS_MAX ((rast_pos_t) -1)

/** Enum for value types */
typedef enum {
    RAST_TYPE_STRING = 0,   /**< string */
    RAST_TYPE_DATE = 1,     /**< ISO 8601 format date */
    RAST_TYPE_DATETIME = 3, /**< ISO 8601 format date/time (this is very experimental type) */
    RAST_TYPE_UINT = 2,     /**< unsigned integer */
} rast_type_e;

/** A structure that holds values */
typedef struct {
    rast_type_e type;
    union {
        char *string;
        rast_uint_t number;
    } value;
} rast_value_t;

/** Set the value type */
#define rast_value_set_type(x, val) ((x)->type = (val))

/** Get the unsigned integer value */
#define rast_value_uint(x) ((x)->value.number)
/** Get the string value */
#define rast_value_string(x) ((x)->value.string)
/** Get the date/time value */
#define rast_value_date(x) ((x)->value.string)
/** Get the date/time value */
#define rast_value_datetime(x) ((x)->value.string)

/** Set the unsigned integer value */
#define rast_value_set_uint(x, val) ((x)->value.number = (val))
/** Set the string value */
#define rast_value_set_string(x, val) ((x)->value.string = (val))
/** Set the date/time value */
#define rast_value_set_date(x, val) ((x)->value.string = (val))
/** Set the date/time value */
#define rast_value_set_datetime(x, val) ((x)->value.string = (val))

/** @} */

RAST_EXTERN_C_END

#endif

/* vim: set filetype=c sw=4 expandtab : */
