# Copyright (C) 2005  Network Applied Communication Laboratory Co., Ltd.
#
# This file is part of Rast.
# See the file COPYING for redistribution information.
#

require "make-variable"

module Rast
  module Filter
    @@loaded_filter_filenames = {}

    def self.load_mime_filter(name)
      filename = File.join(MakeVariable::TOP_SRCDIR, "ruby", "filters", name)
      if !@@loaded_filter_filenames.key?(filename)
        self.module_eval(File.read(filename), filename)
        @@loaded_filter_filenames[filename] = true
      end
    end

    class SpoofFilter
      attr_reader :db_encoding
      attr_reader :passed
      attr_reader :properties

      def initialize(db_encoding)
        @db_encoding = db_encoding
        @passed = []
        @properties = {}
      end

      def pass(brigade, mime_type, filename = nil)
        passed.push(PassedValue.new(brigade, mime_type, filename))
      end

      def set_property(name, value)
        properties[name] = value
      end

      private

      PassedValue = Struct.new(:brigade, :mime_type, :filename)
    end
  end
end
