# Copyright (C) 2005  Network Applied Communication Laboratory Co., Ltd.
#
# This file is part of Rast.
# See the file COPYING for redistribution information.
#

require "test/unit"
require "nkf"

require "rast_test"
require "rast/filter"

module Rast
  module Filter
    load_mime_filter("writer.rb")

    class WriterTest < Test::Unit::TestCase
      def test_invoke
        invoke_test_utf_8
        invoke_test_euc_jp
      end

      def invoke_test_utf_8
        filter = SpoofFilter.new("UTF-8")
        brigade = Brigade.new
        filename = File.join(MakeVariable::TOP_SRCDIR, "tests", "data",
                             "filter", "ja", "open-office-org.sxw")
        File.open(filename) do |f|
          brigade.insert_tail(FileBucket.new(f))
          brigade.insert_tail(EOSBucket.new)
          filter_module = ApplicationVndSunXmlWriter.new
          filter_module.invoke(filter, brigade,
                               "application/vnd.sun.xml.writer")
        end

        buf = ""
        filter.passed[0].brigade.each do |bucket|
          buf.concat(bucket.read)
        end

        assert_equal("これはWriterファイルです\n<>&'\n", buf)
        assert_equal("text/plain; charset=UTF-8", filter.passed[0].mime_type)
        assert_equal(1, filter.passed.length)
        assert_equal("OpenOffice.org Writerテスト", filter.properties["title"])
        assert_equal("著者", filter.properties["author"])
        assert_equal("その他の情報1", filter.properties["Info 1"])
        assert_equal("その他の情報2", filter.properties["Info 2"])
        assert_equal("その他の情報3", filter.properties["Info 3"])
        assert_equal("<>&'", filter.properties["Info 4"])
        assert_equal(6, filter.properties.length)
      end

      def invoke_test_euc_jp
        filter = SpoofFilter.new("EUC-JP")
        brigade = Brigade.new
        filename = File.join(MakeVariable::TOP_SRCDIR, "tests", "data",
                             "filter", "ja", "open-office-org.sxw")
        File.open(filename) do |f|
          brigade.insert_tail(FileBucket.new(f))
          brigade.insert_tail(EOSBucket.new)
          filter_module = ApplicationVndSunXmlWriter.new
          filter_module.invoke(filter, brigade,
                               "application/vnd.sun.xml.writer")
        end

        buf = ""
        filter.passed[0].brigade.each do |bucket|
          buf.concat(bucket.read)
        end

        assert_equal("これはWriterファイルです\n<>&'\n", buf)
        assert_equal("text/plain; charset=UTF-8", filter.passed[0].mime_type)
        assert_equal(1, filter.passed.length)
        assert_equal(NKF.nkf("-We", "OpenOffice.org Writerテスト"),
                     filter.properties["title"])
        assert_equal(NKF.nkf("-We", "著者"), filter.properties["author"])
        assert_equal(NKF.nkf("-We", "その他の情報1"),
                     filter.properties["Info 1"])
        assert_equal(NKF.nkf("-We", "その他の情報2"),
                     filter.properties["Info 2"])
        assert_equal(NKF.nkf("-We", "その他の情報3"),
                     filter.properties["Info 3"])
        assert_equal("<>&'", filter.properties["Info 4"])
        assert_equal(6, filter.properties.length)
      end
    end
  end
end
