/* -*- c-basic-offset: 4 indent-tabs-mode: nil -*- vi:set ts=8 sts=4 sw=4: */

/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.
    Copyright 2000-2015 the Rosegarden development team.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef RG_SEGMENTMAPPERFACTORY_H
#define RG_SEGMENTMAPPERFACTORY_H

namespace Rosegarden
{

class Segment;
class RosegardenDocument;
class MarkerMapper;
class MetronomeMapper;
class SegmentMapper;
class TempoSegmentMapper;
class TimeSigSegmentMapper;

class SegmentMapperFactory
{
public:
    static SegmentMapper *makeMapperForSegment(RosegardenDocument *, Segment *);
    static MetronomeMapper *makeMetronome(RosegardenDocument *);
    static TimeSigSegmentMapper *makeTimeSig(RosegardenDocument *);
    static TempoSegmentMapper *makeTempo(RosegardenDocument *);
    static MarkerMapper *makeMarker(RosegardenDocument *);
};

}

#endif
