/* rygel-basic-management-test-nslookup.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-basic-management-test-nslookup.vala, do not modify */

/*
 * Copyright (C) 2013 Intel Corporation.
 *
 * Author: Christophe Guiraud,
 *         Jussi Kukkonen
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>


#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_BASIC_MANAGEMENT_TEST (rygel_basic_management_test_get_type ())
#define RYGEL_BASIC_MANAGEMENT_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTest))
#define RYGEL_BASIC_MANAGEMENT_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTestClass))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST))
#define RYGEL_BASIC_MANAGEMENT_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTestClass))

typedef struct _RygelBasicManagementTest RygelBasicManagementTest;
typedef struct _RygelBasicManagementTestClass RygelBasicManagementTestClass;
typedef struct _RygelBasicManagementTestPrivate RygelBasicManagementTestPrivate;

#define RYGEL_BASIC_MANAGEMENT_TEST_TYPE_INIT_STATE (rygel_basic_management_test_init_state_get_type ())

#define RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP (rygel_basic_management_test_ns_lookup_get_type ())
#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP, RygelBasicManagementTestNSLookup))
#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP, RygelBasicManagementTestNSLookupClass))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_NS_LOOKUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_NS_LOOKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP))
#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP, RygelBasicManagementTestNSLookupClass))

typedef struct _RygelBasicManagementTestNSLookup RygelBasicManagementTestNSLookup;
typedef struct _RygelBasicManagementTestNSLookupClass RygelBasicManagementTestNSLookupClass;
typedef struct _RygelBasicManagementTestNSLookupPrivate RygelBasicManagementTestNSLookupPrivate;

#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_TYPE_RESULT (rygel_basic_management_test_ns_lookup_result_get_type ())

#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_TYPE_PROCESS_STATE (rygel_basic_management_test_ns_lookup_process_state_get_type ())

#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_TYPE_RESULT_STATUS (rygel_basic_management_test_ns_lookup_result_status_get_type ())

#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_TYPE_ANSWER_TYPE (rygel_basic_management_test_ns_lookup_answer_type_get_type ())
typedef struct _RygelBasicManagementTestNSLookupResult RygelBasicManagementTestNSLookupResult;

#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_TYPE_GENERIC_STATUS (rygel_basic_management_test_ns_lookup_generic_status_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))

#define RYGEL_BASIC_MANAGEMENT_TEST_TYPE_EXECUTION_STATE (rygel_basic_management_test_execution_state_get_type ())
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_OK,
	RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_SPAWN_FAILED,
	RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER
} RygelBasicManagementTestInitState;

struct _RygelBasicManagementTest {
	GObject parent_instance;
	RygelBasicManagementTestPrivate * priv;
	GCancellable* _cancellable;
	RygelBasicManagementTestInitState init_state;
	gchar* id;
	guint iterations;
	GSpawnFlags flags;
	gchar** command;
	gint command_length1;
	gint _command_size_;
};

struct _RygelBasicManagementTestClass {
	GObjectClass parent_class;
	void (*init_iteration) (RygelBasicManagementTest* self);
	void (*handle_output) (RygelBasicManagementTest* self, const gchar* line);
	void (*handle_error) (RygelBasicManagementTest* self, const gchar* line);
	gboolean (*finish_iteration) (RygelBasicManagementTest* self);
	void (*run) (RygelBasicManagementTest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelBasicManagementTest* self, GAsyncResult* _res_);
	const gchar* (*get_method_type) (RygelBasicManagementTest* self);
	const gchar* (*get_results_type) (RygelBasicManagementTest* self);
};

struct _RygelBasicManagementTestNSLookup {
	RygelBasicManagementTest parent_instance;
	RygelBasicManagementTestNSLookupPrivate * priv;
};

struct _RygelBasicManagementTestNSLookupClass {
	RygelBasicManagementTestClass parent_class;
};

typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_INIT,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_SERVER,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_NAME
} RygelBasicManagementTestNSLookupProcessState;

typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_SUCCESS,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_DNS_SERVER_NOT_AVAILABLE,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_HOSTNAME_NOT_RESOLVED,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_TIMEOUT,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_OTHER
} RygelBasicManagementTestNSLookupResultStatus;

typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_NONE,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_AUTHORITATIVE,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_NON_AUTHORITATIVE
} RygelBasicManagementTestNSLookupAnswerType;

struct _RygelBasicManagementTestNSLookupResult {
	RygelBasicManagementTestNSLookupProcessState state;
	gchar* name_server_address;
	gchar* returned_host_name;
	gchar** addresses;
	gint addresses_length1;
	gint _addresses_size_;
	RygelBasicManagementTestNSLookupResultStatus status;
	RygelBasicManagementTestNSLookupAnswerType answer_type;
	guint execution_time;
};

typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_SUCCESS,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_DNS_SERVER_NOT_RESOLVED,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_INTERNAL,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_OTHER
} RygelBasicManagementTestNSLookupGenericStatus;

struct _RygelBasicManagementTestNSLookupPrivate {
	gchar* _host_name;
	gchar* _name_server;
	guint _interval_time_out;
	guint _repetitions;
	RygelBasicManagementTestNSLookupResult* results;
	gint results_length1;
	gint _results_size_;
	RygelBasicManagementTestNSLookupGenericStatus generic_status;
	gchar* additional_info;
	GTimer* timer;
};

typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_REQUESTED,
	RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_IN_PROGRESS,
	RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_COMPLETED,
	RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_CANCELED
} RygelBasicManagementTestExecutionState;


static gpointer rygel_basic_management_test_ns_lookup_parent_class = NULL;

GType rygel_state_machine_get_type (void) G_GNUC_CONST;
GType rygel_basic_management_test_get_type (void) G_GNUC_CONST;
GType rygel_basic_management_test_init_state_get_type (void) G_GNUC_CONST;
GType rygel_basic_management_test_ns_lookup_get_type (void) G_GNUC_CONST;
static GType rygel_basic_management_test_ns_lookup_result_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType rygel_basic_management_test_ns_lookup_process_state_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType rygel_basic_management_test_ns_lookup_result_status_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType rygel_basic_management_test_ns_lookup_answer_type_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static RygelBasicManagementTestNSLookupResult* rygel_basic_management_test_ns_lookup_result_dup (const RygelBasicManagementTestNSLookupResult* self);
static void rygel_basic_management_test_ns_lookup_result_free (RygelBasicManagementTestNSLookupResult* self);
static void rygel_basic_management_test_ns_lookup_result_copy (const RygelBasicManagementTestNSLookupResult* self, RygelBasicManagementTestNSLookupResult* dest);
static void rygel_basic_management_test_ns_lookup_result_destroy (RygelBasicManagementTestNSLookupResult* self);
static GType rygel_basic_management_test_ns_lookup_generic_status_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP, RygelBasicManagementTestNSLookupPrivate))
enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_DUMMY_PROPERTY,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_HOST_NAME,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_NAME_SERVER,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_INTERVAL_TIME_OUT,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_REPETITIONS,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_METHOD_TYPE,
	RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULTS_TYPE
};
#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_DEFAULT_INTERVAL_TIMEOUT ((guint) 1000)
#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_DEFAULT_REPETITIONS ((guint) 1)
static gchar* rygel_basic_management_test_ns_lookup_generic_status_to_string (RygelBasicManagementTestNSLookupGenericStatus self);
static gchar* rygel_basic_management_test_ns_lookup_result_status_to_string (RygelBasicManagementTestNSLookupResultStatus self);
static gchar* rygel_basic_management_test_ns_lookup_answer_type_to_string (RygelBasicManagementTestNSLookupAnswerType self);
static void _vala_RygelBasicManagementTestNSLookupResult_array_free (RygelBasicManagementTestNSLookupResult* array, gint array_length);
#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_HEADER "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" "<bms:NSLookupResult " "xmlns:bms=\"urn:schemas-upnp-org:dm:bms\" " "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" " "xsi:schemaLocation=\"" "urn:schemas-upnp-org:dm:bms " "http://www.upnp.org/schemas/dm/bms.xsd\">\n"
#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_FOOTER "</bms:NSLookupResult>\n"
#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_MAX_REPETITIONS ((guint) 100)
#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_MIN_INTERVAL_TIMEOUT ((guint) 1000)
#define RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_MAX_INTERVAL_TIMEOUT ((guint) 30000)
RygelBasicManagementTestNSLookup* rygel_basic_management_test_ns_lookup_new (const gchar* host_name, const gchar* name_server, guint repetitions, guint32 interval_time_out);
RygelBasicManagementTestNSLookup* rygel_basic_management_test_ns_lookup_construct (GType object_type, const gchar* host_name, const gchar* name_server, guint repetitions, guint32 interval_time_out);
static void rygel_basic_management_test_ns_lookup_real_constructed (GObject* base);
static guint rygel_basic_management_test_ns_lookup_get_interval_time_out (RygelBasicManagementTestNSLookup* self);
static guint rygel_basic_management_test_ns_lookup_get_repetitions (RygelBasicManagementTestNSLookup* self);
static const gchar* rygel_basic_management_test_ns_lookup_get_host_name (RygelBasicManagementTestNSLookup* self);
static const gchar* rygel_basic_management_test_ns_lookup_get_name_server (RygelBasicManagementTestNSLookup* self);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void rygel_basic_management_test_ns_lookup_real_init_iteration (RygelBasicManagementTest* base);
void rygel_basic_management_test_init_iteration (RygelBasicManagementTest* self);
static void _vala_array_add2 (RygelBasicManagementTestNSLookupResult** array, int* length, int* size, const RygelBasicManagementTestNSLookupResult* value);
static gboolean rygel_basic_management_test_ns_lookup_real_finish_iteration (RygelBasicManagementTest* base);
gboolean rygel_basic_management_test_finish_iteration (RygelBasicManagementTest* self);
static void rygel_basic_management_test_ns_lookup_real_handle_error (RygelBasicManagementTest* base, const gchar* line);
GType rygel_basic_management_test_execution_state_get_type (void) G_GNUC_CONST;
void rygel_basic_management_test_set_execution_state (RygelBasicManagementTest* self, RygelBasicManagementTestExecutionState value);
static void rygel_basic_management_test_ns_lookup_real_handle_output (RygelBasicManagementTest* base, const gchar* line);
static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value);
void rygel_basic_management_test_ns_lookup_get_results (RygelBasicManagementTestNSLookup* self, gchar** status, gchar** additional_info, guint* success_count, gchar** result_string);
static gchar* rygel_basic_management_test_ns_lookup_result_to_xml_fragment (RygelBasicManagementTestNSLookupResult *self);
static void rygel_basic_management_test_ns_lookup_set_host_name (RygelBasicManagementTestNSLookup* self, const gchar* value);
static void rygel_basic_management_test_ns_lookup_set_name_server (RygelBasicManagementTestNSLookup* self, const gchar* value);
static void rygel_basic_management_test_ns_lookup_set_interval_time_out (RygelBasicManagementTestNSLookup* self, guint value);
static void rygel_basic_management_test_ns_lookup_set_repetitions (RygelBasicManagementTestNSLookup* self, guint value);
static gchar* rygel_basic_management_test_ns_lookup_result_get_addresses_csv (RygelBasicManagementTestNSLookupResult *self);
static gchar** _vala_array_dup1 (gchar** self, int length);
static void rygel_basic_management_test_ns_lookup_finalize (GObject* obj);
const gchar* rygel_basic_management_test_get_method_type (RygelBasicManagementTest* self);
const gchar* rygel_basic_management_test_get_results_type (RygelBasicManagementTest* self);
static void _vala_rygel_basic_management_test_ns_lookup_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_basic_management_test_ns_lookup_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static GType rygel_basic_management_test_ns_lookup_process_state_get_type (void) {
	static volatile gsize rygel_basic_management_test_ns_lookup_process_state_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_basic_management_test_ns_lookup_process_state_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_INIT, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_INIT", "init"}, {RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_SERVER, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_SERVER", "server"}, {RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_NAME, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_NAME", "name"}, {0, NULL, NULL}};
		GType rygel_basic_management_test_ns_lookup_process_state_type_id;
		rygel_basic_management_test_ns_lookup_process_state_type_id = g_enum_register_static ("RygelBasicManagementTestNSLookupProcessState", values);
		g_once_init_leave (&rygel_basic_management_test_ns_lookup_process_state_type_id__volatile, rygel_basic_management_test_ns_lookup_process_state_type_id);
	}
	return rygel_basic_management_test_ns_lookup_process_state_type_id__volatile;
}


static gchar* rygel_basic_management_test_ns_lookup_generic_status_to_string (RygelBasicManagementTestNSLookupGenericStatus self) {
	gchar* result = NULL;
#line 51 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	switch (self) {
#line 51 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_SUCCESS:
#line 283 "rygel-basic-management-test-nslookup.c"
		{
			gchar* _tmp0_ = NULL;
#line 53 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp0_ = g_strdup ("Success");
#line 53 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			result = _tmp0_;
#line 53 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			return result;
#line 292 "rygel-basic-management-test-nslookup.c"
		}
#line 51 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_DNS_SERVER_NOT_RESOLVED:
#line 296 "rygel-basic-management-test-nslookup.c"
		{
			gchar* _tmp1_ = NULL;
#line 55 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp1_ = g_strdup ("Error_DNSServerNotResolved");
#line 55 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			result = _tmp1_;
#line 55 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			return result;
#line 305 "rygel-basic-management-test-nslookup.c"
		}
#line 51 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_INTERNAL:
#line 309 "rygel-basic-management-test-nslookup.c"
		{
			gchar* _tmp2_ = NULL;
#line 57 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp2_ = g_strdup ("Error_Internal");
#line 57 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			result = _tmp2_;
#line 57 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			return result;
#line 318 "rygel-basic-management-test-nslookup.c"
		}
#line 51 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_OTHER:
#line 322 "rygel-basic-management-test-nslookup.c"
		{
			gchar* _tmp3_ = NULL;
#line 59 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp3_ = g_strdup ("Error_Other");
#line 59 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			result = _tmp3_;
#line 59 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			return result;
#line 331 "rygel-basic-management-test-nslookup.c"
		}
		default:
		{
#line 61 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			g_assert_not_reached ();
#line 337 "rygel-basic-management-test-nslookup.c"
		}
	}
}


static GType rygel_basic_management_test_ns_lookup_generic_status_get_type (void) {
	static volatile gsize rygel_basic_management_test_ns_lookup_generic_status_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_basic_management_test_ns_lookup_generic_status_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_SUCCESS, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_SUCCESS", "success"}, {RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_DNS_SERVER_NOT_RESOLVED, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_DNS_SERVER_NOT_RESOLVED", "error-dns-server-not-resolved"}, {RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_INTERNAL, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_INTERNAL", "error-internal"}, {RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_OTHER, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_OTHER", "error-other"}, {0, NULL, NULL}};
		GType rygel_basic_management_test_ns_lookup_generic_status_type_id;
		rygel_basic_management_test_ns_lookup_generic_status_type_id = g_enum_register_static ("RygelBasicManagementTestNSLookupGenericStatus", values);
		g_once_init_leave (&rygel_basic_management_test_ns_lookup_generic_status_type_id__volatile, rygel_basic_management_test_ns_lookup_generic_status_type_id);
	}
	return rygel_basic_management_test_ns_lookup_generic_status_type_id__volatile;
}


static gchar* rygel_basic_management_test_ns_lookup_result_status_to_string (RygelBasicManagementTestNSLookupResultStatus self) {
	gchar* result = NULL;
#line 74 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	switch (self) {
#line 74 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_SUCCESS:
#line 361 "rygel-basic-management-test-nslookup.c"
		{
			gchar* _tmp0_ = NULL;
#line 76 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp0_ = g_strdup ("Success");
#line 76 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			result = _tmp0_;
#line 76 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			return result;
#line 370 "rygel-basic-management-test-nslookup.c"
		}
#line 74 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_DNS_SERVER_NOT_AVAILABLE:
#line 374 "rygel-basic-management-test-nslookup.c"
		{
			gchar* _tmp1_ = NULL;
#line 78 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp1_ = g_strdup ("Error_DNSServerNotAvailable");
#line 78 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			result = _tmp1_;
#line 78 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			return result;
#line 383 "rygel-basic-management-test-nslookup.c"
		}
#line 74 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_HOSTNAME_NOT_RESOLVED:
#line 387 "rygel-basic-management-test-nslookup.c"
		{
			gchar* _tmp2_ = NULL;
#line 80 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp2_ = g_strdup ("Error_HostNameNotResolved");
#line 80 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			result = _tmp2_;
#line 80 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			return result;
#line 396 "rygel-basic-management-test-nslookup.c"
		}
#line 74 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_TIMEOUT:
#line 400 "rygel-basic-management-test-nslookup.c"
		{
			gchar* _tmp3_ = NULL;
#line 82 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp3_ = g_strdup ("Error_Timeout");
#line 82 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			result = _tmp3_;
#line 82 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			return result;
#line 409 "rygel-basic-management-test-nslookup.c"
		}
#line 74 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_OTHER:
#line 413 "rygel-basic-management-test-nslookup.c"
		{
			gchar* _tmp4_ = NULL;
#line 84 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp4_ = g_strdup ("Error_Other");
#line 84 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			result = _tmp4_;
#line 84 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			return result;
#line 422 "rygel-basic-management-test-nslookup.c"
		}
		default:
		{
#line 86 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			g_assert_not_reached ();
#line 428 "rygel-basic-management-test-nslookup.c"
		}
	}
}


static GType rygel_basic_management_test_ns_lookup_result_status_get_type (void) {
	static volatile gsize rygel_basic_management_test_ns_lookup_result_status_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_basic_management_test_ns_lookup_result_status_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_SUCCESS, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_SUCCESS", "success"}, {RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_DNS_SERVER_NOT_AVAILABLE, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_DNS_SERVER_NOT_AVAILABLE", "error-dns-server-not-available"}, {RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_HOSTNAME_NOT_RESOLVED, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_HOSTNAME_NOT_RESOLVED", "error-hostname-not-resolved"}, {RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_TIMEOUT, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_TIMEOUT", "error-timeout"}, {RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_OTHER, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_OTHER", "error-other"}, {0, NULL, NULL}};
		GType rygel_basic_management_test_ns_lookup_result_status_type_id;
		rygel_basic_management_test_ns_lookup_result_status_type_id = g_enum_register_static ("RygelBasicManagementTestNSLookupResultStatus", values);
		g_once_init_leave (&rygel_basic_management_test_ns_lookup_result_status_type_id__volatile, rygel_basic_management_test_ns_lookup_result_status_type_id);
	}
	return rygel_basic_management_test_ns_lookup_result_status_type_id__volatile;
}


static gchar* rygel_basic_management_test_ns_lookup_answer_type_to_string (RygelBasicManagementTestNSLookupAnswerType self) {
	gchar* result = NULL;
#line 97 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	switch (self) {
#line 97 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_NONE:
#line 452 "rygel-basic-management-test-nslookup.c"
		{
			gchar* _tmp0_ = NULL;
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp0_ = g_strdup ("None");
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			result = _tmp0_;
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			return result;
#line 461 "rygel-basic-management-test-nslookup.c"
		}
#line 97 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_AUTHORITATIVE:
#line 465 "rygel-basic-management-test-nslookup.c"
		{
			gchar* _tmp1_ = NULL;
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp1_ = g_strdup ("Authoritative");
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			result = _tmp1_;
#line 101 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			return result;
#line 474 "rygel-basic-management-test-nslookup.c"
		}
#line 97 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_NON_AUTHORITATIVE:
#line 478 "rygel-basic-management-test-nslookup.c"
		{
			gchar* _tmp2_ = NULL;
#line 103 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp2_ = g_strdup ("NonAuthoritative");
#line 103 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			result = _tmp2_;
#line 103 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			return result;
#line 487 "rygel-basic-management-test-nslookup.c"
		}
		default:
		{
#line 105 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			g_assert_not_reached ();
#line 493 "rygel-basic-management-test-nslookup.c"
		}
	}
}


static GType rygel_basic_management_test_ns_lookup_answer_type_get_type (void) {
	static volatile gsize rygel_basic_management_test_ns_lookup_answer_type_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_basic_management_test_ns_lookup_answer_type_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_NONE, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_NONE", "none"}, {RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_AUTHORITATIVE, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_AUTHORITATIVE", "authoritative"}, {RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_NON_AUTHORITATIVE, "RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_NON_AUTHORITATIVE", "non-authoritative"}, {0, NULL, NULL}};
		GType rygel_basic_management_test_ns_lookup_answer_type_type_id;
		rygel_basic_management_test_ns_lookup_answer_type_type_id = g_enum_register_static ("RygelBasicManagementTestNSLookupAnswerType", values);
		g_once_init_leave (&rygel_basic_management_test_ns_lookup_answer_type_type_id__volatile, rygel_basic_management_test_ns_lookup_answer_type_type_id);
	}
	return rygel_basic_management_test_ns_lookup_answer_type_type_id__volatile;
}


static void _vala_RygelBasicManagementTestNSLookupResult_array_free (RygelBasicManagementTestNSLookupResult* array, gint array_length) {
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	if (array != NULL) {
#line 514 "rygel-basic-management-test-nslookup.c"
		int i;
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			rygel_basic_management_test_ns_lookup_result_destroy (&array[i]);
#line 520 "rygel-basic-management-test-nslookup.c"
		}
	}
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	g_free (array);
#line 525 "rygel-basic-management-test-nslookup.c"
}


RygelBasicManagementTestNSLookup* rygel_basic_management_test_ns_lookup_construct (GType object_type, const gchar* host_name, const gchar* name_server, guint repetitions, guint32 interval_time_out) {
	RygelBasicManagementTestNSLookup * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint32 _tmp3_ = 0U;
#line 203 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	g_return_val_if_fail (host_name != NULL, NULL);
#line 207 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp0_ = host_name;
#line 207 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp1_ = name_server;
#line 207 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp2_ = repetitions;
#line 207 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp3_ = interval_time_out;
#line 207 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	self = (RygelBasicManagementTestNSLookup*) g_object_new (object_type, "host-name", _tmp0_, "name-server", _tmp1_, "repetitions", _tmp2_, "interval-time-out", _tmp3_, NULL);
#line 203 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	return self;
#line 549 "rygel-basic-management-test-nslookup.c"
}


RygelBasicManagementTestNSLookup* rygel_basic_management_test_ns_lookup_new (const gchar* host_name, const gchar* name_server, guint repetitions, guint32 interval_time_out) {
#line 203 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	return rygel_basic_management_test_ns_lookup_construct (RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP, host_name, name_server, repetitions, interval_time_out);
#line 556 "rygel-basic-management-test-nslookup.c"
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
#line 225 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	if ((*length) == (*size)) {
#line 225 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 225 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 567 "rygel-basic-management-test-nslookup.c"
	}
#line 225 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	(*array)[(*length)++] = value;
#line 225 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	(*array)[*length] = NULL;
#line 573 "rygel-basic-management-test-nslookup.c"
}


static void rygel_basic_management_test_ns_lookup_real_constructed (GObject* base) {
	RygelBasicManagementTestNSLookup * self;
	gchar* _tmp0_ = NULL;
	RygelBasicManagementTestNSLookupResult* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	gchar* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar** _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	const gchar* _tmp13_ = NULL;
	guint _tmp20_ = 0U;
	guint _tmp21_ = 0U;
#line 213 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	self = (RygelBasicManagementTestNSLookup*) base;
#line 214 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	G_OBJECT_CLASS (rygel_basic_management_test_ns_lookup_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTest));
#line 216 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	self->priv->generic_status = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_INTERNAL;
#line 217 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp0_ = g_strdup ("");
#line 217 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_g_free0 (self->priv->additional_info);
#line 217 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	self->priv->additional_info = _tmp0_;
#line 218 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp1_ = g_new0 (RygelBasicManagementTestNSLookupResult, 0);
#line 218 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	self->priv->results = (_vala_RygelBasicManagementTestNSLookupResult_array_free (self->priv->results, self->priv->results_length1), NULL);
#line 218 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	self->priv->results = _tmp1_;
#line 218 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	self->priv->results_length1 = 0;
#line 218 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	self->priv->_results_size_ = self->priv->results_length1;
#line 220 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp2_ = g_strdup ("nslookup");
#line 220 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp3_ = rygel_basic_management_test_ns_lookup_get_interval_time_out (self);
#line 220 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp4_ = _tmp3_;
#line 220 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp5_ = g_strdup_printf ("-timeout=%u", _tmp4_ / 1000);
#line 220 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp6_ = rygel_basic_management_test_ns_lookup_get_repetitions (self);
#line 220 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp7_ = _tmp6_;
#line 220 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp8_ = g_strdup_printf ("-retry=%u", _tmp7_);
#line 220 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp9_ = self->priv->_host_name;
#line 220 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp10_ = g_strdup (_tmp9_);
#line 220 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp11_ = g_new0 (gchar*, 4 + 1);
#line 220 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp11_[0] = _tmp2_;
#line 220 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp11_[1] = _tmp5_;
#line 220 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp11_[2] = _tmp8_;
#line 220 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp11_[3] = _tmp10_;
#line 220 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	((RygelBasicManagementTest*) self)->command = (_vala_array_free (((RygelBasicManagementTest*) self)->command, ((RygelBasicManagementTest*) self)->command_length1, (GDestroyNotify) g_free), NULL);
#line 220 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	((RygelBasicManagementTest*) self)->command = _tmp11_;
#line 220 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	((RygelBasicManagementTest*) self)->command_length1 = 4;
#line 220 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	((RygelBasicManagementTest*) self)->_command_size_ = ((RygelBasicManagementTest*) self)->command_length1;
#line 224 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp13_ = self->priv->_name_server;
#line 224 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	if (_tmp13_ != NULL) {
#line 657 "rygel-basic-management-test-nslookup.c"
		const gchar* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
#line 224 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		_tmp14_ = self->priv->_name_server;
#line 224 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		_tmp15_ = strlen (_tmp14_);
#line 224 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		_tmp16_ = _tmp15_;
#line 224 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		_tmp12_ = _tmp16_ > 0;
#line 669 "rygel-basic-management-test-nslookup.c"
	} else {
#line 224 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		_tmp12_ = FALSE;
#line 673 "rygel-basic-management-test-nslookup.c"
	}
#line 224 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	if (_tmp12_) {
#line 677 "rygel-basic-management-test-nslookup.c"
		gchar** _tmp17_ = NULL;
		gint _tmp17__length1 = 0;
		const gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
#line 225 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		_tmp17_ = ((RygelBasicManagementTest*) self)->command;
#line 225 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		_tmp17__length1 = ((RygelBasicManagementTest*) self)->command_length1;
#line 225 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		_tmp18_ = self->priv->_name_server;
#line 225 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		_tmp19_ = g_strdup (_tmp18_);
#line 225 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		_vala_array_add1 (&((RygelBasicManagementTest*) self)->command, &((RygelBasicManagementTest*) self)->command_length1, &((RygelBasicManagementTest*) self)->_command_size_, _tmp19_);
#line 692 "rygel-basic-management-test-nslookup.c"
	}
#line 229 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp20_ = rygel_basic_management_test_ns_lookup_get_repetitions (self);
#line 229 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp21_ = _tmp20_;
#line 229 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	if (_tmp21_ > RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_MAX_REPETITIONS) {
#line 700 "rygel-basic-management-test-nslookup.c"
		gchar* msg = NULL;
		gchar* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		guint _tmp24_ = 0U;
		guint _tmp25_ = 0U;
		gchar* _tmp26_ = NULL;
#line 230 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		((RygelBasicManagementTest*) self)->init_state = RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER;
#line 231 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		_tmp22_ = g_strdup ("NumberOfRepetitions %u is not in allowed range [0, %u]");
#line 231 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		msg = _tmp22_;
#line 232 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		_tmp23_ = msg;
#line 232 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		_tmp24_ = rygel_basic_management_test_ns_lookup_get_repetitions (self);
#line 232 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		_tmp25_ = _tmp24_;
#line 232 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		_tmp26_ = g_strdup_printf (_tmp23_, _tmp25_, RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_MAX_REPETITIONS);
#line 232 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		_g_free0 (self->priv->additional_info);
#line 232 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		self->priv->additional_info = _tmp26_;
#line 229 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		_g_free0 (msg);
#line 727 "rygel-basic-management-test-nslookup.c"
	} else {
		gboolean _tmp27_ = FALSE;
		guint _tmp28_ = 0U;
		guint _tmp29_ = 0U;
#line 234 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		_tmp28_ = rygel_basic_management_test_ns_lookup_get_interval_time_out (self);
#line 234 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		_tmp29_ = _tmp28_;
#line 234 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		if (_tmp29_ < RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_MIN_INTERVAL_TIMEOUT) {
#line 234 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp27_ = TRUE;
#line 740 "rygel-basic-management-test-nslookup.c"
		} else {
			guint _tmp30_ = 0U;
			guint _tmp31_ = 0U;
#line 235 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp30_ = rygel_basic_management_test_ns_lookup_get_interval_time_out (self);
#line 235 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp31_ = _tmp30_;
#line 235 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp27_ = _tmp31_ > RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_MAX_INTERVAL_TIMEOUT;
#line 750 "rygel-basic-management-test-nslookup.c"
		}
#line 234 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		if (_tmp27_) {
#line 754 "rygel-basic-management-test-nslookup.c"
			gchar* msg = NULL;
			gchar* _tmp32_ = NULL;
			const gchar* _tmp33_ = NULL;
			guint _tmp34_ = 0U;
			guint _tmp35_ = 0U;
			gchar* _tmp36_ = NULL;
#line 236 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			((RygelBasicManagementTest*) self)->init_state = RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER;
#line 237 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp32_ = g_strdup ("Timeout %u is not in allowed range [%u, %u]");
#line 237 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			msg = _tmp32_;
#line 238 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp33_ = msg;
#line 238 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp34_ = rygel_basic_management_test_ns_lookup_get_interval_time_out (self);
#line 238 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp35_ = _tmp34_;
#line 238 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp36_ = g_strdup_printf (_tmp33_, _tmp35_, RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_MIN_INTERVAL_TIMEOUT, RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_MAX_INTERVAL_TIMEOUT);
#line 238 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_g_free0 (self->priv->additional_info);
#line 238 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			self->priv->additional_info = _tmp36_;
#line 234 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_g_free0 (msg);
#line 781 "rygel-basic-management-test-nslookup.c"
		}
	}
}


static void _vala_array_add2 (RygelBasicManagementTestNSLookupResult** array, int* length, int* size, const RygelBasicManagementTestNSLookupResult* value) {
#line 255 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	if ((*length) == (*size)) {
#line 255 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 255 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		*array = g_renew (RygelBasicManagementTestNSLookupResult, *array, *size);
#line 794 "rygel-basic-management-test-nslookup.c"
	}
#line 255 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	(*array)[(*length)++] = *value;
#line 798 "rygel-basic-management-test-nslookup.c"
}


static void rygel_basic_management_test_ns_lookup_real_init_iteration (RygelBasicManagementTest* base) {
	RygelBasicManagementTestNSLookup * self;
	RygelBasicManagementTestNSLookupResult _result_ = {0};
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	RygelBasicManagementTestNSLookupResult _tmp3_ = {0};
	RygelBasicManagementTestNSLookupResult* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	RygelBasicManagementTestNSLookupResult _tmp5_ = {0};
	RygelBasicManagementTestNSLookupResult _tmp6_ = {0};
	GTimer* _tmp7_ = NULL;
#line 244 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	self = (RygelBasicManagementTestNSLookup*) base;
#line 245 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	RYGEL_BASIC_MANAGEMENT_TEST_CLASS (rygel_basic_management_test_ns_lookup_parent_class)->init_iteration (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTest));
#line 246 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp0_ = g_strdup ("");
#line 246 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp1_ = g_strdup ("");
#line 246 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp2_ = g_new0 (gchar*, 0 + 1);
#line 246 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	memset (&_tmp3_, 0, sizeof (RygelBasicManagementTestNSLookupResult));
#line 246 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp3_.state = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_INIT;
#line 246 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_g_free0 (_tmp3_.name_server_address);
#line 246 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp3_.name_server_address = _tmp0_;
#line 246 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_g_free0 (_tmp3_.returned_host_name);
#line 246 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp3_.returned_host_name = _tmp1_;
#line 246 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp3_.addresses = (_vala_array_free (_tmp3_.addresses, _tmp3_.addresses_length1, (GDestroyNotify) g_free), NULL);
#line 246 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp3_.addresses = _tmp2_;
#line 246 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp3_.addresses_length1 = 0;
#line 246 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp3_._addresses_size_ = _tmp3_.addresses_length1;
#line 246 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp3_.status = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_OTHER;
#line 246 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp3_.answer_type = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_NONE;
#line 246 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp3_.execution_time = (guint) 0;
#line 246 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_result_ = _tmp3_;
#line 255 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp4_ = self->priv->results;
#line 255 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp4__length1 = self->priv->results_length1;
#line 255 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp5_ = _result_;
#line 255 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	rygel_basic_management_test_ns_lookup_result_copy (&_tmp5_, &_tmp6_);
#line 255 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_vala_array_add2 (&self->priv->results, &self->priv->results_length1, &self->priv->_results_size_, &_tmp6_);
#line 257 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp7_ = self->priv->timer;
#line 257 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	g_timer_start (_tmp7_);
#line 244 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	rygel_basic_management_test_ns_lookup_result_destroy (&_result_);
#line 868 "rygel-basic-management-test-nslookup.c"
}


static gboolean rygel_basic_management_test_ns_lookup_real_finish_iteration (RygelBasicManagementTest* base) {
	RygelBasicManagementTestNSLookup * self;
	gboolean result = FALSE;
	RygelBasicManagementTestInitState _tmp0_ = 0;
	gboolean _tmp13_ = FALSE;
#line 260 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	self = (RygelBasicManagementTestNSLookup*) base;
#line 261 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp0_ = ((RygelBasicManagementTest*) self)->init_state;
#line 261 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	switch (_tmp0_) {
#line 261 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_SPAWN_FAILED:
#line 885 "rygel-basic-management-test-nslookup.c"
		{
			gchar* _tmp1_ = NULL;
			RygelBasicManagementTestNSLookupResult* _tmp2_ = NULL;
			gint _tmp2__length1 = 0;
			RygelBasicManagementTestNSLookupResult* _tmp3_ = NULL;
			gint _tmp3__length1 = 0;
#line 264 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			self->priv->generic_status = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_INTERNAL;
#line 265 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp1_ = g_strdup ("Failed to spawn nslookup");
#line 265 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_g_free0 (self->priv->additional_info);
#line 265 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			self->priv->additional_info = _tmp1_;
#line 266 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp2_ = self->priv->results;
#line 266 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp2__length1 = self->priv->results_length1;
#line 266 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp3_ = self->priv->results;
#line 266 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp3__length1 = self->priv->results_length1;
#line 266 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp2_[_tmp3__length1 - 1].status = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_OTHER;
#line 269 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			break;
#line 912 "rygel-basic-management-test-nslookup.c"
		}
#line 261 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER:
#line 916 "rygel-basic-management-test-nslookup.c"
		{
			RygelBasicManagementTestNSLookupResult* _tmp4_ = NULL;
			gint _tmp4__length1 = 0;
			RygelBasicManagementTestNSLookupResult* _tmp5_ = NULL;
			gint _tmp5__length1 = 0;
#line 273 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			self->priv->generic_status = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_OTHER;
#line 274 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp4_ = self->priv->results;
#line 274 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp4__length1 = self->priv->results_length1;
#line 274 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp5_ = self->priv->results;
#line 274 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp5__length1 = self->priv->results_length1;
#line 274 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp4_[_tmp5__length1 - 1].status = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_OTHER;
#line 277 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			break;
#line 936 "rygel-basic-management-test-nslookup.c"
		}
		default:
		{
			gdouble elapsed_msec = 0.0;
			GTimer* _tmp6_ = NULL;
			gdouble _tmp7_ = 0.0;
			guint exec_time = 0U;
			gdouble _tmp8_ = 0.0;
			gdouble _tmp9_ = 0.0;
			RygelBasicManagementTestNSLookupResult* _tmp10_ = NULL;
			gint _tmp10__length1 = 0;
			RygelBasicManagementTestNSLookupResult* _tmp11_ = NULL;
			gint _tmp11__length1 = 0;
			guint _tmp12_ = 0U;
#line 279 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp6_ = self->priv->timer;
#line 279 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp7_ = g_timer_elapsed (_tmp6_, NULL);
#line 279 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			elapsed_msec = _tmp7_ * 1000;
#line 280 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp8_ = elapsed_msec;
#line 280 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp9_ = round (_tmp8_);
#line 280 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			exec_time = (guint) _tmp9_;
#line 281 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp10_ = self->priv->results;
#line 281 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp10__length1 = self->priv->results_length1;
#line 281 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp11_ = self->priv->results;
#line 281 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp11__length1 = self->priv->results_length1;
#line 281 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp12_ = exec_time;
#line 281 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp10_[_tmp11__length1 - 1].execution_time = _tmp12_;
#line 283 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			break;
#line 977 "rygel-basic-management-test-nslookup.c"
		}
	}
#line 286 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp13_ = RYGEL_BASIC_MANAGEMENT_TEST_CLASS (rygel_basic_management_test_ns_lookup_parent_class)->finish_iteration (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTest));
#line 286 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	result = _tmp13_;
#line 286 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	return result;
#line 986 "rygel-basic-management-test-nslookup.c"
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 1278 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1278 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1279 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1279 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1279 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1279 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 1006 "rygel-basic-management-test-nslookup.c"
}


static void rygel_basic_management_test_ns_lookup_real_handle_error (RygelBasicManagementTest* base, const gchar* line) {
	RygelBasicManagementTestNSLookup * self;
	RygelBasicManagementTestNSLookupResult* _result_ = NULL;
	RygelBasicManagementTestNSLookupResult* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	RygelBasicManagementTestNSLookupResult* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 289 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	self = (RygelBasicManagementTestNSLookup*) base;
#line 289 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	g_return_if_fail (line != NULL);
#line 290 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp0_ = self->priv->results;
#line 290 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp0__length1 = self->priv->results_length1;
#line 290 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp1_ = self->priv->results;
#line 290 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp1__length1 = self->priv->results_length1;
#line 290 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_result_ = &_tmp0_[_tmp1__length1 - 1];
#line 292 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp2_ = line;
#line 292 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp3_ = string_contains (_tmp2_, "couldn't get address for");
#line 292 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	if (_tmp3_) {
#line 293 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		self->priv->generic_status = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_DNS_SERVER_NOT_RESOLVED;
#line 294 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		rygel_basic_management_test_set_execution_state ((RygelBasicManagementTest*) self, RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_COMPLETED);
#line 295 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		(*_result_).status = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_DNS_SERVER_NOT_AVAILABLE;
#line 1045 "rygel-basic-management-test-nslookup.c"
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 1115 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1116 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1116 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1117 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1117 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_strstrip (_tmp1_);
#line 1118 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _result_;
#line 1118 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 1069 "rygel-basic-management-test-nslookup.c"
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1197 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1197 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1197 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1197 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1198 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1198 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 1092 "rygel-basic-management-test-nslookup.c"
		glong _tmp4_ = 0L;
#line 1199 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1199 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1199 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 1100 "rygel-basic-management-test-nslookup.c"
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 1201 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1201 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1201 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1201 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 1112 "rygel-basic-management-test-nslookup.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
#line 1208 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 1136 "rygel-basic-management-test-nslookup.c"
		glong _tmp2_ = 0L;
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 1142 "rygel-basic-management-test-nslookup.c"
	} else {
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 1146 "rygel-basic-management-test-nslookup.c"
	}
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 1150 "rygel-basic-management-test-nslookup.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
#line 1212 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp3_ = offset;
#line 1212 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = len;
#line 1212 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
#line 1212 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		string_length = _tmp5_;
#line 1162 "rygel-basic-management-test-nslookup.c"
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 1214 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = strlen (self);
#line 1214 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp6_;
#line 1214 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp7_;
#line 1172 "rygel-basic-management-test-nslookup.c"
	}
#line 1217 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp8_ = offset;
#line 1217 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp8_ < ((glong) 0)) {
#line 1178 "rygel-basic-management-test-nslookup.c"
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1218 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp9_ = string_length;
#line 1218 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp10_ = offset;
#line 1218 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		offset = _tmp9_ + _tmp10_;
#line 1219 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1219 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
#line 1192 "rygel-basic-management-test-nslookup.c"
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
#line 1221 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1221 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp13_ = string_length;
#line 1221 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
#line 1202 "rygel-basic-management-test-nslookup.c"
	}
#line 1223 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp14_ = len;
#line 1223 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp14_ < ((glong) 0)) {
#line 1208 "rygel-basic-management-test-nslookup.c"
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
#line 1224 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1224 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp16_ = offset;
#line 1224 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		len = _tmp15_ - _tmp16_;
#line 1217 "rygel-basic-management-test-nslookup.c"
	}
#line 1226 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp17_ = offset;
#line 1226 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp18_ = len;
#line 1226 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp19_ = string_length;
#line 1226 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp20_ = offset;
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp21_ = len;
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp22_;
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 1237 "rygel-basic-management-test-nslookup.c"
}


static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value) {
#line 322 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	if ((*length) == (*size)) {
#line 322 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 322 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1248 "rygel-basic-management-test-nslookup.c"
	}
#line 322 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	(*array)[(*length)++] = value;
#line 322 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	(*array)[*length] = NULL;
#line 1254 "rygel-basic-management-test-nslookup.c"
}


static void rygel_basic_management_test_ns_lookup_real_handle_output (RygelBasicManagementTest* base, const gchar* line) {
	RygelBasicManagementTestNSLookup * self;
	RygelBasicManagementTestNSLookupResult* _result_ = NULL;
	RygelBasicManagementTestNSLookupResult* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	RygelBasicManagementTestNSLookupResult* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
#line 299 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	self = (RygelBasicManagementTestNSLookup*) base;
#line 299 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	g_return_if_fail (line != NULL);
#line 300 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp0_ = self->priv->results;
#line 300 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp0__length1 = self->priv->results_length1;
#line 300 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp1_ = self->priv->results;
#line 300 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp1__length1 = self->priv->results_length1;
#line 300 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_result_ = &_tmp0_[_tmp1__length1 - 1];
#line 302 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp2_ = line;
#line 302 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp3_ = string_strip (_tmp2_);
#line 302 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp4_ = _tmp3_;
#line 302 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_g_free0 (_tmp4_);
#line 303 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp5_ = line;
#line 303 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp6_ = g_str_has_prefix (_tmp5_, "Server:");
#line 303 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	if (_tmp6_) {
#line 1298 "rygel-basic-management-test-nslookup.c"
		RygelBasicManagementTestNSLookupResult* _tmp7_ = NULL;
		RygelBasicManagementTestNSLookupProcessState _tmp8_ = 0;
#line 304 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		_tmp7_ = _result_;
#line 304 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		_tmp8_ = (*_tmp7_).state;
#line 304 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		if (_tmp8_ != RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_INIT) {
#line 305 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			g_debug ("rygel-basic-management-test-nslookup.vala:305: nslookup parser: Unexpe" \
"cted 'Server:' line.\n");
#line 1309 "rygel-basic-management-test-nslookup.c"
		}
#line 307 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		(*_result_).state = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_SERVER;
#line 1313 "rygel-basic-management-test-nslookup.c"
	} else {
		const gchar* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
#line 308 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		_tmp9_ = line;
#line 308 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		_tmp10_ = g_str_has_prefix (_tmp9_, "Name:");
#line 308 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		if (_tmp10_) {
#line 1323 "rygel-basic-management-test-nslookup.c"
			RygelBasicManagementTestNSLookupResult* _tmp11_ = NULL;
			RygelBasicManagementTestNSLookupProcessState _tmp12_ = 0;
#line 309 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp11_ = _result_;
#line 309 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp12_ = (*_tmp11_).state;
#line 309 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			if (_tmp12_ == RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_INIT) {
#line 310 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
				g_debug ("rygel-basic-management-test-nslookup.vala:310: nslookup parser: Unexpe" \
"cted 'Name:' line");
#line 1334 "rygel-basic-management-test-nslookup.c"
			} else {
				RygelBasicManagementTestNSLookupResult* _tmp13_ = NULL;
				RygelBasicManagementTestNSLookupProcessState _tmp14_ = 0;
#line 311 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
				_tmp13_ = _result_;
#line 311 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
				_tmp14_ = (*_tmp13_).state;
#line 311 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
				if (_tmp14_ == RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_SERVER) {
#line 1344 "rygel-basic-management-test-nslookup.c"
					gchar* name = NULL;
					const gchar* _tmp15_ = NULL;
					gint _tmp16_ = 0;
					gint _tmp17_ = 0;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					gchar* _tmp20_ = NULL;
					gchar* _tmp21_ = NULL;
					const gchar* _tmp22_ = NULL;
					gchar* _tmp23_ = NULL;
#line 312 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					_tmp15_ = line;
#line 312 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					_tmp16_ = strlen ("Name:");
#line 312 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					_tmp17_ = _tmp16_;
#line 312 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					_tmp18_ = string_substring (_tmp15_, (glong) _tmp17_, (glong) (-1));
#line 312 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					_tmp19_ = _tmp18_;
#line 312 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					_tmp20_ = string_strip (_tmp19_);
#line 312 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					_tmp21_ = _tmp20_;
#line 312 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					_g_free0 (_tmp19_);
#line 312 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					name = _tmp21_;
#line 313 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					_tmp22_ = name;
#line 313 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					_tmp23_ = g_strdup (_tmp22_);
#line 313 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					_g_free0 ((*_result_).returned_host_name);
#line 313 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					(*_result_).returned_host_name = _tmp23_;
#line 311 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					_g_free0 (name);
#line 1383 "rygel-basic-management-test-nslookup.c"
				}
			}
#line 315 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			(*_result_).state = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_NAME;
#line 1388 "rygel-basic-management-test-nslookup.c"
		} else {
			const gchar* _tmp24_ = NULL;
			gboolean _tmp25_ = FALSE;
#line 316 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp24_ = line;
#line 316 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp25_ = g_str_has_prefix (_tmp24_, "Address:");
#line 316 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			if (_tmp25_) {
#line 1398 "rygel-basic-management-test-nslookup.c"
				RygelBasicManagementTestNSLookupResult* _tmp26_ = NULL;
				RygelBasicManagementTestNSLookupProcessState _tmp27_ = 0;
#line 317 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
				_tmp26_ = _result_;
#line 317 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
				_tmp27_ = (*_tmp26_).state;
#line 317 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
				if (_tmp27_ == RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_SERVER) {
#line 1407 "rygel-basic-management-test-nslookup.c"
					gchar* address = NULL;
					const gchar* _tmp28_ = NULL;
					gint _tmp29_ = 0;
					gint _tmp30_ = 0;
					gchar* _tmp31_ = NULL;
					gchar* _tmp32_ = NULL;
					gchar* _tmp33_ = NULL;
					gchar* _tmp34_ = NULL;
					const gchar* _tmp35_ = NULL;
					gchar** _tmp36_ = NULL;
					gchar** _tmp37_ = NULL;
					gchar** _tmp38_ = NULL;
					gint _tmp38__length1 = 0;
					const gchar* _tmp39_ = NULL;
					gchar* _tmp40_ = NULL;
#line 318 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					_tmp28_ = line;
#line 318 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					_tmp29_ = strlen ("Address:");
#line 318 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					_tmp30_ = _tmp29_;
#line 318 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					_tmp31_ = string_substring (_tmp28_, (glong) _tmp30_, (glong) (-1));
#line 318 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					_tmp32_ = _tmp31_;
#line 318 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					_tmp33_ = string_strip (_tmp32_);
#line 318 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					_tmp34_ = _tmp33_;
#line 318 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					_g_free0 (_tmp32_);
#line 318 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					address = _tmp34_;
#line 319 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					_tmp35_ = address;
#line 319 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					_tmp37_ = _tmp36_ = g_strsplit (_tmp35_, "#", 2);
#line 319 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					_tmp38_ = _tmp37_;
#line 319 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					_tmp38__length1 = _vala_array_length (_tmp36_);
#line 319 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					_tmp39_ = _tmp38_[0];
#line 319 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					_tmp40_ = g_strdup (_tmp39_);
#line 319 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					_g_free0 ((*_result_).name_server_address);
#line 319 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					(*_result_).name_server_address = _tmp40_;
#line 319 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					_tmp38_ = (_vala_array_free (_tmp38_, _tmp38__length1, (GDestroyNotify) g_free), NULL);
#line 320 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					self->priv->generic_status = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_SUCCESS;
#line 317 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					_g_free0 (address);
#line 1463 "rygel-basic-management-test-nslookup.c"
				} else {
					RygelBasicManagementTestNSLookupResult* _tmp41_ = NULL;
					RygelBasicManagementTestNSLookupProcessState _tmp42_ = 0;
#line 321 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					_tmp41_ = _result_;
#line 321 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					_tmp42_ = (*_tmp41_).state;
#line 321 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					if (_tmp42_ == RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_PROCESS_STATE_NAME) {
#line 1473 "rygel-basic-management-test-nslookup.c"
						gchar** _tmp43_ = NULL;
						gint _tmp43__length1 = 0;
						const gchar* _tmp44_ = NULL;
						gint _tmp45_ = 0;
						gint _tmp46_ = 0;
						gchar* _tmp47_ = NULL;
						gchar* _tmp48_ = NULL;
						gchar* _tmp49_ = NULL;
						RygelBasicManagementTestNSLookupResult* _tmp50_ = NULL;
						RygelBasicManagementTestNSLookupAnswerType _tmp51_ = 0;
#line 322 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
						_tmp43_ = (*_result_).addresses;
#line 322 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
						_tmp43__length1 = (*_result_).addresses_length1;
#line 322 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
						_tmp44_ = line;
#line 322 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
						_tmp45_ = strlen ("Address:");
#line 322 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
						_tmp46_ = _tmp45_;
#line 322 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
						_tmp47_ = string_substring (_tmp44_, (glong) _tmp46_, (glong) (-1));
#line 322 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
						_tmp48_ = _tmp47_;
#line 322 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
						_tmp49_ = string_strip (_tmp48_);
#line 322 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
						_vala_array_add3 (&(*_result_).addresses, &(*_result_).addresses_length1, &(*_result_)._addresses_size_, _tmp49_);
#line 322 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
						_g_free0 (_tmp48_);
#line 323 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
						(*_result_).status = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_SUCCESS;
#line 324 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
						_tmp50_ = _result_;
#line 324 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
						_tmp51_ = (*_tmp50_).answer_type;
#line 324 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
						if (_tmp51_ == RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_NONE) {
#line 325 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
							(*_result_).answer_type = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_AUTHORITATIVE;
#line 1514 "rygel-basic-management-test-nslookup.c"
						}
					} else {
#line 328 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
						g_debug ("rygel-basic-management-test-nslookup.vala:328: nslookup parser: Unexpe" \
"cted 'Address:' line");
#line 1519 "rygel-basic-management-test-nslookup.c"
					}
				}
			} else {
				const gchar* _tmp52_ = NULL;
				gboolean _tmp53_ = FALSE;
#line 330 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
				_tmp52_ = line;
#line 330 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
				_tmp53_ = g_str_has_prefix (_tmp52_, "Non-authoritative answer:");
#line 330 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
				if (_tmp53_) {
#line 331 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					(*_result_).answer_type = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_ANSWER_TYPE_NON_AUTHORITATIVE;
#line 1533 "rygel-basic-management-test-nslookup.c"
				} else {
					const gchar* _tmp54_ = NULL;
					gboolean _tmp55_ = FALSE;
#line 332 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					_tmp54_ = line;
#line 332 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					_tmp55_ = string_contains (_tmp54_, "server can't find");
#line 332 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					if (_tmp55_) {
#line 333 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
						(*_result_).status = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_HOSTNAME_NOT_RESOLVED;
#line 1545 "rygel-basic-management-test-nslookup.c"
					} else {
						const gchar* _tmp56_ = NULL;
						gboolean _tmp57_ = FALSE;
#line 334 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
						_tmp56_ = line;
#line 334 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
						_tmp57_ = string_contains (_tmp56_, "couldn't get address for");
#line 334 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
						if (_tmp57_) {
#line 335 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
							self->priv->generic_status = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GENERIC_STATUS_ERROR_DNS_SERVER_NOT_RESOLVED;
#line 336 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
							(*_result_).status = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_DNS_SERVER_NOT_AVAILABLE;
#line 337 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
							rygel_basic_management_test_set_execution_state ((RygelBasicManagementTest*) self, RYGEL_BASIC_MANAGEMENT_TEST_EXECUTION_STATE_COMPLETED);
#line 1561 "rygel-basic-management-test-nslookup.c"
						} else {
							const gchar* _tmp58_ = NULL;
							gboolean _tmp59_ = FALSE;
#line 338 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
							_tmp58_ = line;
#line 338 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
							_tmp59_ = string_contains (_tmp58_, "no servers could be reached");
#line 338 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
							if (_tmp59_) {
#line 339 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
								(*_result_).status = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_ERROR_DNS_SERVER_NOT_AVAILABLE;
#line 1573 "rygel-basic-management-test-nslookup.c"
							}
						}
					}
				}
			}
		}
	}
}


void rygel_basic_management_test_ns_lookup_get_results (RygelBasicManagementTestNSLookup* self, gchar** status, gchar** additional_info, guint* success_count, gchar** result_string) {
	gchar* _vala_status = NULL;
	gchar* _vala_additional_info = NULL;
	guint _vala_success_count = 0U;
	gchar* _vala_result_string = NULL;
	GString* builder = NULL;
	GString* _tmp0_ = NULL;
	RygelBasicManagementTestNSLookupResult* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	GString* _tmp9_ = NULL;
	GString* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	RygelBasicManagementTestNSLookupGenericStatus _tmp13_ = 0;
	gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
#line 344 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	g_return_if_fail (self != NULL);
#line 348 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_vala_success_count = (guint) 0;
#line 349 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp0_ = g_string_new (RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_HEADER);
#line 349 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	builder = _tmp0_;
#line 351 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp1_ = self->priv->results;
#line 351 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp1__length1 = self->priv->results_length1;
#line 1613 "rygel-basic-management-test-nslookup.c"
	{
		RygelBasicManagementTestNSLookupResult* result_collection = NULL;
		gint result_collection_length1 = 0;
		gint _result_collection_size_ = 0;
		gint result_it = 0;
#line 351 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		result_collection = _tmp1_;
#line 351 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		result_collection_length1 = _tmp1__length1;
#line 351 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		for (result_it = 0; result_it < _tmp1__length1; result_it = result_it + 1) {
#line 1625 "rygel-basic-management-test-nslookup.c"
			RygelBasicManagementTestNSLookupResult _tmp2_ = {0};
			RygelBasicManagementTestNSLookupResult _result_ = {0};
#line 351 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			rygel_basic_management_test_ns_lookup_result_copy (&result_collection[result_it], &_tmp2_);
#line 351 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_result_ = _tmp2_;
#line 1632 "rygel-basic-management-test-nslookup.c"
			{
				GString* _tmp3_ = NULL;
				gchar* _tmp4_ = NULL;
				gchar* _tmp5_ = NULL;
				RygelBasicManagementTestNSLookupResult _tmp6_ = {0};
				RygelBasicManagementTestNSLookupResultStatus _tmp7_ = 0;
#line 352 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
				_tmp3_ = builder;
#line 352 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
				_tmp4_ = rygel_basic_management_test_ns_lookup_result_to_xml_fragment (&_result_);
#line 352 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
				_tmp5_ = _tmp4_;
#line 352 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
				g_string_append (_tmp3_, _tmp5_);
#line 352 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
				_g_free0 (_tmp5_);
#line 353 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
				_tmp6_ = _result_;
#line 353 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
				_tmp7_ = _tmp6_.status;
#line 353 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
				if (_tmp7_ == RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULT_STATUS_SUCCESS) {
#line 1655 "rygel-basic-management-test-nslookup.c"
					guint _tmp8_ = 0U;
#line 354 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					_tmp8_ = _vala_success_count;
#line 354 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					_vala_success_count = _tmp8_ + 1;
#line 1661 "rygel-basic-management-test-nslookup.c"
				}
#line 351 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
				rygel_basic_management_test_ns_lookup_result_destroy (&_result_);
#line 1665 "rygel-basic-management-test-nslookup.c"
			}
		}
	}
#line 357 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp9_ = builder;
#line 357 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	g_string_append (_tmp9_, RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_FOOTER);
#line 358 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp10_ = builder;
#line 358 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp11_ = _tmp10_->str;
#line 358 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp12_ = g_strdup (_tmp11_);
#line 358 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_g_free0 (_vala_result_string);
#line 358 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_vala_result_string = _tmp12_;
#line 360 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp13_ = self->priv->generic_status;
#line 360 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp14_ = rygel_basic_management_test_ns_lookup_generic_status_to_string (_tmp13_);
#line 360 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_g_free0 (_vala_status);
#line 360 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_vala_status = _tmp14_;
#line 361 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp15_ = self->priv->additional_info;
#line 361 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp16_ = g_strdup (_tmp15_);
#line 361 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_g_free0 (_vala_additional_info);
#line 361 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_vala_additional_info = _tmp16_;
#line 344 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_g_string_free0 (builder);
#line 344 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	if (status) {
#line 344 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		*status = _vala_status;
#line 1705 "rygel-basic-management-test-nslookup.c"
	} else {
#line 344 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		_g_free0 (_vala_status);
#line 1709 "rygel-basic-management-test-nslookup.c"
	}
#line 344 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	if (additional_info) {
#line 344 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		*additional_info = _vala_additional_info;
#line 1715 "rygel-basic-management-test-nslookup.c"
	} else {
#line 344 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		_g_free0 (_vala_additional_info);
#line 1719 "rygel-basic-management-test-nslookup.c"
	}
#line 344 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	if (success_count) {
#line 344 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		*success_count = _vala_success_count;
#line 1725 "rygel-basic-management-test-nslookup.c"
	}
#line 344 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	if (result_string) {
#line 344 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		*result_string = _vala_result_string;
#line 1731 "rygel-basic-management-test-nslookup.c"
	} else {
#line 344 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		_g_free0 (_vala_result_string);
#line 1735 "rygel-basic-management-test-nslookup.c"
	}
}


static const gchar* rygel_basic_management_test_ns_lookup_get_host_name (RygelBasicManagementTestNSLookup* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 154 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 154 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp0_ = self->priv->_host_name;
#line 154 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	result = _tmp0_;
#line 154 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	return result;
#line 1751 "rygel-basic-management-test-nslookup.c"
}


static void rygel_basic_management_test_ns_lookup_set_host_name (RygelBasicManagementTestNSLookup* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 154 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	g_return_if_fail (self != NULL);
#line 154 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp0_ = value;
#line 154 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 154 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_g_free0 (self->priv->_host_name);
#line 154 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	self->priv->_host_name = _tmp1_;
#line 154 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	g_object_notify ((GObject *) self, "host-name");
#line 1770 "rygel-basic-management-test-nslookup.c"
}


static const gchar* rygel_basic_management_test_ns_lookup_get_name_server (RygelBasicManagementTestNSLookup* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp0_ = self->priv->_name_server;
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	result = _tmp0_;
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	return result;
#line 1785 "rygel-basic-management-test-nslookup.c"
}


static void rygel_basic_management_test_ns_lookup_set_name_server (RygelBasicManagementTestNSLookup* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	g_return_if_fail (self != NULL);
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp0_ = value;
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_g_free0 (self->priv->_name_server);
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	self->priv->_name_server = _tmp1_;
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	g_object_notify ((GObject *) self, "name-server");
#line 1804 "rygel-basic-management-test-nslookup.c"
}


static guint rygel_basic_management_test_ns_lookup_get_interval_time_out (RygelBasicManagementTestNSLookup* self) {
	guint result;
	guint _tmp0_ = 0U;
#line 164 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 165 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp0_ = self->priv->_interval_time_out;
#line 165 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	result = _tmp0_;
#line 165 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	return result;
#line 1819 "rygel-basic-management-test-nslookup.c"
}


static void rygel_basic_management_test_ns_lookup_set_interval_time_out (RygelBasicManagementTestNSLookup* self, guint value) {
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
#line 159 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	g_return_if_fail (self != NULL);
#line 160 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp0_ = value;
#line 160 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	self->priv->_interval_time_out = _tmp0_;
#line 161 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp1_ = self->priv->_interval_time_out;
#line 161 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	if (_tmp1_ == ((guint) 0)) {
#line 162 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		self->priv->_interval_time_out = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_DEFAULT_INTERVAL_TIMEOUT;
#line 1838 "rygel-basic-management-test-nslookup.c"
	}
#line 159 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	g_object_notify ((GObject *) self, "interval-time-out");
#line 1842 "rygel-basic-management-test-nslookup.c"
}


static guint rygel_basic_management_test_ns_lookup_get_repetitions (RygelBasicManagementTestNSLookup* self) {
	guint result;
	guint _tmp0_ = 0U;
#line 180 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 181 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp0_ = self->priv->_repetitions;
#line 181 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	result = _tmp0_;
#line 181 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	return result;
#line 1857 "rygel-basic-management-test-nslookup.c"
}


static void rygel_basic_management_test_ns_lookup_set_repetitions (RygelBasicManagementTestNSLookup* self, guint value) {
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
#line 172 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	g_return_if_fail (self != NULL);
#line 173 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	((RygelBasicManagementTest*) self)->iterations = (guint) 1;
#line 174 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp0_ = value;
#line 174 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	self->priv->_repetitions = _tmp0_;
#line 175 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp1_ = self->priv->_repetitions;
#line 175 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	if (_tmp1_ == ((guint) 0)) {
#line 176 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		self->priv->_repetitions = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_DEFAULT_REPETITIONS;
#line 1878 "rygel-basic-management-test-nslookup.c"
	}
#line 172 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	g_object_notify ((GObject *) self, "repetitions");
#line 1882 "rygel-basic-management-test-nslookup.c"
}


static const gchar* rygel_basic_management_test_ns_lookup_real_get_method_type (RygelBasicManagementTest* base) {
	const gchar* result;
	RygelBasicManagementTestNSLookup* self;
#line 192 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	self = (RygelBasicManagementTestNSLookup*) base;
#line 193 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	result = "NSLookup";
#line 193 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	return result;
#line 1895 "rygel-basic-management-test-nslookup.c"
}


static const gchar* rygel_basic_management_test_ns_lookup_real_get_results_type (RygelBasicManagementTest* base) {
	const gchar* result;
	RygelBasicManagementTestNSLookup* self;
#line 198 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	self = (RygelBasicManagementTestNSLookup*) base;
#line 199 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	result = "GetNSLookupResult";
#line 199 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	return result;
#line 1908 "rygel-basic-management-test-nslookup.c"
}


static gchar* rygel_basic_management_test_ns_lookup_result_get_addresses_csv (RygelBasicManagementTestNSLookupResult *self) {
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	GString* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
#line 126 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp0_ = g_string_new ("");
#line 126 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	builder = _tmp0_;
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp1_ = (*self).addresses;
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp1__length1 = (*self).addresses_length1;
#line 1929 "rygel-basic-management-test-nslookup.c"
	{
		gchar** address_collection = NULL;
		gint address_collection_length1 = 0;
		gint _address_collection_size_ = 0;
		gint address_it = 0;
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		address_collection = _tmp1_;
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		address_collection_length1 = _tmp1__length1;
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		for (address_it = 0; address_it < _tmp1__length1; address_it = address_it + 1) {
#line 1941 "rygel-basic-management-test-nslookup.c"
			gchar* _tmp2_ = NULL;
			gchar* address = NULL;
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			_tmp2_ = g_strdup (address_collection[address_it]);
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
			address = _tmp2_;
#line 1948 "rygel-basic-management-test-nslookup.c"
			{
				GString* _tmp3_ = NULL;
				gssize _tmp4_ = 0L;
				GString* _tmp6_ = NULL;
				const gchar* _tmp7_ = NULL;
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
				_tmp3_ = builder;
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
				_tmp4_ = _tmp3_->len;
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
				if (_tmp4_ != ((gssize) 0)) {
#line 1960 "rygel-basic-management-test-nslookup.c"
					GString* _tmp5_ = NULL;
#line 129 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					_tmp5_ = builder;
#line 129 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
					g_string_append (_tmp5_, ",");
#line 1966 "rygel-basic-management-test-nslookup.c"
				}
#line 131 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
				_tmp6_ = builder;
#line 131 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
				_tmp7_ = address;
#line 131 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
				g_string_append (_tmp6_, _tmp7_);
#line 127 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
				_g_free0 (address);
#line 1976 "rygel-basic-management-test-nslookup.c"
			}
		}
	}
#line 134 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp8_ = builder;
#line 134 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp9_ = _tmp8_->str;
#line 134 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp10_ = g_strdup (_tmp9_);
#line 134 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	result = _tmp10_;
#line 134 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_g_string_free0 (builder);
#line 134 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	return result;
#line 1992 "rygel-basic-management-test-nslookup.c"
}


static gchar* rygel_basic_management_test_ns_lookup_result_to_xml_fragment (RygelBasicManagementTestNSLookupResult *self) {
	gchar* result = NULL;
	RygelBasicManagementTestNSLookupResultStatus _tmp0_ = 0;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	RygelBasicManagementTestNSLookupAnswerType _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp0_ = (*self).status;
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp1_ = rygel_basic_management_test_ns_lookup_result_status_to_string (_tmp0_);
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp2_ = _tmp1_;
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp3_ = (*self).answer_type;
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp4_ = rygel_basic_management_test_ns_lookup_answer_type_to_string (_tmp3_);
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp5_ = _tmp4_;
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp6_ = (*self).returned_host_name;
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp7_ = rygel_basic_management_test_ns_lookup_result_get_addresses_csv (&(*self));
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp8_ = _tmp7_;
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp9_ = (*self).name_server_address;
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp10_ = (*self).execution_time;
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp11_ = g_strdup_printf ("<Result>\n" "<Status>%s</Status>\n" "<AnswerType>%s</AnswerType>\n" "<HostNameReturned>%s</HostNameReturned>\n" "<IPAddresses>%s</IPAddresses>\n" "<DNSServerIP>%s</DNSServerIP>\n" "<ResponseTime>%u</ResponseTime>\n" "</Result>\n", _tmp2_, _tmp5_, _tmp6_, _tmp8_, _tmp9_, _tmp10_);
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp12_ = _tmp11_;
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_g_free0 (_tmp8_);
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_g_free0 (_tmp5_);
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_g_free0 (_tmp2_);
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	result = _tmp12_;
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	return result;
#line 2047 "rygel-basic-management-test-nslookup.c"
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	result = g_new0 (gchar*, length + 1);
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	for (i = 0; i < length; i++) {
#line 2058 "rygel-basic-management-test-nslookup.c"
		gchar* _tmp0_ = NULL;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		_tmp0_ = g_strdup (self[i]);
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		result[i] = _tmp0_;
#line 2064 "rygel-basic-management-test-nslookup.c"
	}
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	return result;
#line 2068 "rygel-basic-management-test-nslookup.c"
}


static void rygel_basic_management_test_ns_lookup_result_copy (const RygelBasicManagementTestNSLookupResult* self, RygelBasicManagementTestNSLookupResult* dest) {
	RygelBasicManagementTestNSLookupProcessState _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	RygelBasicManagementTestNSLookupResultStatus _tmp7_ = 0;
	RygelBasicManagementTestNSLookupAnswerType _tmp8_ = 0;
	guint _tmp9_ = 0U;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp0_ = (*self).state;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	(*dest).state = _tmp0_;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp1_ = (*self).name_server_address;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_g_free0 ((*dest).name_server_address);
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	(*dest).name_server_address = _tmp2_;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp3_ = (*self).returned_host_name;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_g_free0 ((*dest).returned_host_name);
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	(*dest).returned_host_name = _tmp4_;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp5_ = (*self).addresses;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp5__length1 = (*self).addresses_length1;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup1 (_tmp5_, _tmp5__length1) : ((gpointer) _tmp5_);
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp6__length1 = _tmp5__length1;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	(*dest).addresses = (_vala_array_free ((*dest).addresses, (*dest).addresses_length1, (GDestroyNotify) g_free), NULL);
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	(*dest).addresses = _tmp6_;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	(*dest).addresses_length1 = _tmp6__length1;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	(*dest)._addresses_size_ = (*dest).addresses_length1;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp7_ = (*self).status;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	(*dest).status = _tmp7_;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp8_ = (*self).answer_type;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	(*dest).answer_type = _tmp8_;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp9_ = (*self).execution_time;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	(*dest).execution_time = _tmp9_;
#line 2133 "rygel-basic-management-test-nslookup.c"
}


static void rygel_basic_management_test_ns_lookup_result_destroy (RygelBasicManagementTestNSLookupResult* self) {
#line 118 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_g_free0 ((*self).name_server_address);
#line 119 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_g_free0 ((*self).returned_host_name);
#line 120 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	(*self).addresses = (_vala_array_free ((*self).addresses, (*self).addresses_length1, (GDestroyNotify) g_free), NULL);
#line 2144 "rygel-basic-management-test-nslookup.c"
}


static RygelBasicManagementTestNSLookupResult* rygel_basic_management_test_ns_lookup_result_dup (const RygelBasicManagementTestNSLookupResult* self) {
	RygelBasicManagementTestNSLookupResult* dup;
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	dup = g_new0 (RygelBasicManagementTestNSLookupResult, 1);
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	rygel_basic_management_test_ns_lookup_result_copy (self, dup);
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	return dup;
#line 2156 "rygel-basic-management-test-nslookup.c"
}


static void rygel_basic_management_test_ns_lookup_result_free (RygelBasicManagementTestNSLookupResult* self) {
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	rygel_basic_management_test_ns_lookup_result_destroy (self);
#line 116 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	g_free (self);
#line 2165 "rygel-basic-management-test-nslookup.c"
}


static GType rygel_basic_management_test_ns_lookup_result_get_type (void) {
	static volatile gsize rygel_basic_management_test_ns_lookup_result_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_basic_management_test_ns_lookup_result_type_id__volatile)) {
		GType rygel_basic_management_test_ns_lookup_result_type_id;
		rygel_basic_management_test_ns_lookup_result_type_id = g_boxed_type_register_static ("RygelBasicManagementTestNSLookupResult", (GBoxedCopyFunc) rygel_basic_management_test_ns_lookup_result_dup, (GBoxedFreeFunc) rygel_basic_management_test_ns_lookup_result_free);
		g_once_init_leave (&rygel_basic_management_test_ns_lookup_result_type_id__volatile, rygel_basic_management_test_ns_lookup_result_type_id);
	}
	return rygel_basic_management_test_ns_lookup_result_type_id__volatile;
}


static void rygel_basic_management_test_ns_lookup_class_init (RygelBasicManagementTestNSLookupClass * klass) {
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	rygel_basic_management_test_ns_lookup_parent_class = g_type_class_peek_parent (klass);
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	g_type_class_add_private (klass, sizeof (RygelBasicManagementTestNSLookupPrivate));
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	((GObjectClass *) klass)->constructed = rygel_basic_management_test_ns_lookup_real_constructed;
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	((RygelBasicManagementTestClass *) klass)->init_iteration = rygel_basic_management_test_ns_lookup_real_init_iteration;
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	((RygelBasicManagementTestClass *) klass)->finish_iteration = rygel_basic_management_test_ns_lookup_real_finish_iteration;
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	((RygelBasicManagementTestClass *) klass)->handle_error = rygel_basic_management_test_ns_lookup_real_handle_error;
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	((RygelBasicManagementTestClass *) klass)->handle_output = rygel_basic_management_test_ns_lookup_real_handle_output;
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	RYGEL_BASIC_MANAGEMENT_TEST_CLASS (klass)->get_method_type = rygel_basic_management_test_ns_lookup_real_get_method_type;
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	RYGEL_BASIC_MANAGEMENT_TEST_CLASS (klass)->get_results_type = rygel_basic_management_test_ns_lookup_real_get_results_type;
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_basic_management_test_ns_lookup_get_property;
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_basic_management_test_ns_lookup_set_property;
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_basic_management_test_ns_lookup_finalize;
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_HOST_NAME, g_param_spec_string ("host-name", "host-name", "host-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_NAME_SERVER, g_param_spec_string ("name-server", "name-server", "name-server", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_INTERVAL_TIME_OUT, g_param_spec_uint ("interval-time-out", "interval-time-out", "interval-time-out", 0, G_MAXUINT, RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_DEFAULT_INTERVAL_TIMEOUT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_REPETITIONS, g_param_spec_uint ("repetitions", "repetitions", "repetitions", 0, G_MAXUINT, RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_DEFAULT_REPETITIONS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_METHOD_TYPE, g_param_spec_string ("method-type", "method-type", "method-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULTS_TYPE, g_param_spec_string ("results-type", "results-type", "results-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2217 "rygel-basic-management-test-nslookup.c"
}


static void rygel_basic_management_test_ns_lookup_instance_init (RygelBasicManagementTestNSLookup * self) {
	gchar* _tmp0_ = NULL;
	GTimer* _tmp1_ = NULL;
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	self->priv = RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_GET_PRIVATE (self);
#line 154 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp0_ = g_strdup ("");
#line 154 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	self->priv->_host_name = _tmp0_;
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	self->priv->_name_server = NULL;
#line 189 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_tmp1_ = g_timer_new ();
#line 189 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	self->priv->timer = _tmp1_;
#line 2236 "rygel-basic-management-test-nslookup.c"
}


static void rygel_basic_management_test_ns_lookup_finalize (GObject* obj) {
	RygelBasicManagementTestNSLookup * self;
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP, RygelBasicManagementTestNSLookup);
#line 154 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_g_free0 (self->priv->_host_name);
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_g_free0 (self->priv->_name_server);
#line 186 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	self->priv->results = (_vala_RygelBasicManagementTestNSLookupResult_array_free (self->priv->results, self->priv->results_length1), NULL);
#line 188 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_g_free0 (self->priv->additional_info);
#line 189 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	_g_timer_destroy0 (self->priv->timer);
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	G_OBJECT_CLASS (rygel_basic_management_test_ns_lookup_parent_class)->finalize (obj);
#line 2256 "rygel-basic-management-test-nslookup.c"
}


GType rygel_basic_management_test_ns_lookup_get_type (void) {
	static volatile gsize rygel_basic_management_test_ns_lookup_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_basic_management_test_ns_lookup_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelBasicManagementTestNSLookupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_basic_management_test_ns_lookup_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelBasicManagementTestNSLookup), 0, (GInstanceInitFunc) rygel_basic_management_test_ns_lookup_instance_init, NULL };
		GType rygel_basic_management_test_ns_lookup_type_id;
		rygel_basic_management_test_ns_lookup_type_id = g_type_register_static (RYGEL_TYPE_BASIC_MANAGEMENT_TEST, "RygelBasicManagementTestNSLookup", &g_define_type_info, 0);
		g_once_init_leave (&rygel_basic_management_test_ns_lookup_type_id__volatile, rygel_basic_management_test_ns_lookup_type_id);
	}
	return rygel_basic_management_test_ns_lookup_type_id__volatile;
}


static void _vala_rygel_basic_management_test_ns_lookup_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelBasicManagementTestNSLookup * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP, RygelBasicManagementTestNSLookup);
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	switch (property_id) {
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_HOST_NAME:
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		g_value_set_string (value, rygel_basic_management_test_ns_lookup_get_host_name (self));
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		break;
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_NAME_SERVER:
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		g_value_set_string (value, rygel_basic_management_test_ns_lookup_get_name_server (self));
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		break;
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_INTERVAL_TIME_OUT:
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		g_value_set_uint (value, rygel_basic_management_test_ns_lookup_get_interval_time_out (self));
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		break;
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_REPETITIONS:
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		g_value_set_uint (value, rygel_basic_management_test_ns_lookup_get_repetitions (self));
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		break;
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_METHOD_TYPE:
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		g_value_set_string (value, rygel_basic_management_test_get_method_type ((RygelBasicManagementTest*) self));
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		break;
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_RESULTS_TYPE:
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		g_value_set_string (value, rygel_basic_management_test_get_results_type ((RygelBasicManagementTest*) self));
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		break;
#line 2313 "rygel-basic-management-test-nslookup.c"
		default:
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		break;
#line 2319 "rygel-basic-management-test-nslookup.c"
	}
}


static void _vala_rygel_basic_management_test_ns_lookup_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelBasicManagementTestNSLookup * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_BASIC_MANAGEMENT_TEST_NS_LOOKUP, RygelBasicManagementTestNSLookup);
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
	switch (property_id) {
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_HOST_NAME:
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		rygel_basic_management_test_ns_lookup_set_host_name (self, g_value_get_string (value));
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		break;
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_NAME_SERVER:
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		rygel_basic_management_test_ns_lookup_set_name_server (self, g_value_get_string (value));
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		break;
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_INTERVAL_TIME_OUT:
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		rygel_basic_management_test_ns_lookup_set_interval_time_out (self, g_value_get_uint (value));
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		break;
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		case RYGEL_BASIC_MANAGEMENT_TEST_NS_LOOKUP_REPETITIONS:
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		rygel_basic_management_test_ns_lookup_set_repetitions (self, g_value_get_uint (value));
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		break;
#line 2353 "rygel-basic-management-test-nslookup.c"
		default:
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 26 "/home/jens/Source/rygel/src/librygel-core/rygel-basic-management-test-nslookup.vala"
		break;
#line 2359 "rygel-basic-management-test-nslookup.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



