/* rygel-description-file.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-description-file.vala, do not modify */

/*
 * Copyright (C) 2011 Jens Georg
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Jens Georg <mail@jensge.org>
 *         Parthiban Balasubramanian <P.Balasubramanian-contractor@cablelabs.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <libxml/tree.h>
#include <gee.h>
#include <libxml/xpath.h>
#include <libxml/parser.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>


#define RYGEL_TYPE_DESCRIPTION_FILE (rygel_description_file_get_type ())
#define RYGEL_DESCRIPTION_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DESCRIPTION_FILE, RygelDescriptionFile))
#define RYGEL_DESCRIPTION_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DESCRIPTION_FILE, RygelDescriptionFileClass))
#define RYGEL_IS_DESCRIPTION_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DESCRIPTION_FILE))
#define RYGEL_IS_DESCRIPTION_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DESCRIPTION_FILE))
#define RYGEL_DESCRIPTION_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DESCRIPTION_FILE, RygelDescriptionFileClass))

typedef struct _RygelDescriptionFile RygelDescriptionFile;
typedef struct _RygelDescriptionFileClass RygelDescriptionFileClass;
typedef struct _RygelDescriptionFilePrivate RygelDescriptionFilePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_PLUGIN_CAPABILITIES (rygel_plugin_capabilities_get_type ())

#define RYGEL_TYPE_META_CONFIG (rygel_meta_config_get_type ())
#define RYGEL_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfig))
#define RYGEL_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))
#define RYGEL_IS_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_META_CONFIG))
#define RYGEL_IS_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_META_CONFIG))
#define RYGEL_META_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))

typedef struct _RygelMetaConfig RygelMetaConfig;
typedef struct _RygelMetaConfigClass RygelMetaConfigClass;

#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _xmlXPathFreeContext0(var) ((var == NULL) ? NULL : (var = (xmlXPathFreeContext (var), NULL)))

#define RYGEL_TYPE_RESOURCE_INFO (rygel_resource_info_get_type ())
#define RYGEL_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfo))
#define RYGEL_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))
#define RYGEL_IS_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_IS_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_RESOURCE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))

typedef struct _RygelResourceInfo RygelResourceInfo;
typedef struct _RygelResourceInfoClass RygelResourceInfoClass;
typedef struct _RygelResourceInfoPrivate RygelResourceInfoPrivate;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;
typedef struct _RygelIconInfoPrivate RygelIconInfoPrivate;
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _RygelDescriptionFile {
	GObject parent_instance;
	RygelDescriptionFilePrivate * priv;
};

struct _RygelDescriptionFileClass {
	GObjectClass parent_class;
};

struct _RygelDescriptionFilePrivate {
	gchar** device_elements;
	gint device_elements_length1;
	gint _device_elements_size_;
	GUPnPXMLDoc* doc;
};

typedef enum  {
	RYGEL_PLUGIN_CAPABILITIES_NONE = 0,
	RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD = 1 << 0,
	RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD = 1 << 1,
	RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD = 1 << 2,
	RYGEL_PLUGIN_CAPABILITIES_UPLOAD = (RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD | RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD) | RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD,
	RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES = 1 << 3,
	RYGEL_PLUGIN_CAPABILITIES_CREATE_CONTAINERS = 1 << 4,
	RYGEL_PLUGIN_CAPABILITIES_DIAGNOSTICS = 1 << 5,
	RYGEL_PLUGIN_CAPABILITIES_ENERGY_MANAGEMENT = 1 << 6
} RygelPluginCapabilities;

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gboolean (*get_upnp_enabled) (RygelConfiguration* self, GError** error);
	gchar* (*get_interface) (RygelConfiguration* self, GError** error);
	gchar** (*get_interfaces) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_upload) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_deletion) (RygelConfiguration* self, GError** error);
	gchar* (*get_log_levels) (RygelConfiguration* self, GError** error);
	gchar* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_engine_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_media_engine) (RygelConfiguration* self, GError** error);
	gchar* (*get_video_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_music_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_picture_upload_folder) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_title) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_string) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
};

struct _RygelResourceInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelResourceInfoPrivate * priv;
	gchar* upnp_type;
	gchar* upnp_id;
	gchar* description_path;
	GType type;
};

struct _RygelResourceInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelResourceInfo *self);
};

struct _RygelIconInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelIconInfoPrivate * priv;
	gchar* mime_type;
	gchar* uri;
	gchar* file_extension;
	gint64 size;
	gint width;
	gint height;
	gint depth;
};

struct _RygelIconInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelIconInfo *self);
};


static gpointer rygel_description_file_parent_class = NULL;

GType rygel_description_file_get_type (void) G_GNUC_CONST;
#define RYGEL_DESCRIPTION_FILE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_DESCRIPTION_FILE, RygelDescriptionFilePrivate))
enum  {
	RYGEL_DESCRIPTION_FILE_DUMMY_PROPERTY
};
#define RYGEL_DESCRIPTION_FILE_SERVICE_TYPE_TEMPLATE "//*[.='%s']"
#define RYGEL_DESCRIPTION_FILE_X_DLNADOC_NODE "X_DLNADOC"
#define RYGEL_DESCRIPTION_FILE_X_DLNADOC_NON_DEVCAP_XPATH "//*[local-name()=" " 'X_DLNADOC'" " and not(contains(.,\"DIAGE\"))" " and not(contains(.,\"LPE\"))]"
#define RYGEL_DESCRIPTION_FILE_X_DLNADOC_DIAGE_XPATH "//*[local-name()='X_DLNADOC'" " and contains(.,\"DIAGE\")]"
#define RYGEL_DESCRIPTION_FILE_DIAGE_DEV_CAP "+DIAGE+"
#define RYGEL_DESCRIPTION_FILE_X_DLNADOC_LPE_XPATH "//*[local-name()='X_DLNADOC'" " and contains(.,\"LPE\")]"
#define RYGEL_DESCRIPTION_FILE_LPE_DEV_CAP "+LPE+"
RygelDescriptionFile* rygel_description_file_new (const gchar* template_file, GError** error);
RygelDescriptionFile* rygel_description_file_construct (GType object_type, const gchar* template_file, GError** error);
RygelDescriptionFile* rygel_description_file_new_from_xml_document (GUPnPXMLDoc* doc);
RygelDescriptionFile* rygel_description_file_construct_from_xml_document (GType object_type, GUPnPXMLDoc* doc);
void rygel_description_file_set_device_type (RygelDescriptionFile* self, const gchar* device_type);
static xmlNode* rygel_description_file_set_device_element (RygelDescriptionFile* self, const gchar* element, const gchar* new_value, const gchar* ns);
void rygel_description_file_set_model_description (RygelDescriptionFile* self, const gchar* model_description);
void rygel_description_file_set_model_name (RygelDescriptionFile* self, const gchar* model_name);
void rygel_description_file_set_model_number (RygelDescriptionFile* self, const gchar* model_number);
void rygel_description_file_set_friendly_name (RygelDescriptionFile* self, const gchar* friendly_name);
gchar* rygel_description_file_get_friendly_name (RygelDescriptionFile* self);
xmlNode* rygel_xml_utils_get_element (xmlNode* node, ...);
void rygel_description_file_set_udn (RygelDescriptionFile* self, const gchar* udn);
gchar* rygel_description_file_get_udn (RygelDescriptionFile* self);
GType rygel_plugin_capabilities_get_type (void) G_GNUC_CONST;
void rygel_description_file_set_dlna_caps (RygelDescriptionFile* self, RygelPluginCapabilities capabilities);
GType rygel_meta_config_get_type (void) G_GNUC_CONST;
RygelMetaConfig* rygel_meta_config_get_default (void);
GType rygel_configuration_get_type (void) G_GNUC_CONST;
gboolean rygel_configuration_get_allow_upload (RygelConfiguration* self, GError** error);
gboolean rygel_configuration_get_allow_deletion (RygelConfiguration* self, GError** error);
static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add8 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add9 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add10 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add11 (gchar*** array, int* length, int* size, gchar* value);
void rygel_description_file_add_dlna_doc_element (RygelDescriptionFile* self, const gchar* dlnadoc_xpath, const gchar* dlnadoc_non_xpath, const gchar* dev_cap);
void rygel_description_file_remove_dlna_doc_element (RygelDescriptionFile* self, const gchar* dlnadoc_xpath);
static void _vala_array_add12 (gchar*** array, int* length, int* size, gchar* value);
static void rygel_description_file_remove_device_element (RygelDescriptionFile* self, const gchar* element);
void rygel_description_file_clear_service_list (RygelDescriptionFile* self);
static gboolean rygel_description_file_apply_xpath (RygelDescriptionFile* self, const gchar* xpath, xmlXPathObject** xpo);
static xmlNode* rygel_description_file_get_device_element (RygelDescriptionFile* self);
gpointer rygel_resource_info_ref (gpointer instance);
void rygel_resource_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_resource_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_resource_info (GValue* value, gpointer v_object);
void rygel_value_take_resource_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_resource_info (const GValue* value);
GType rygel_resource_info_get_type (void) G_GNUC_CONST;
void rygel_description_file_add_service (RygelDescriptionFile* self, const gchar* device_name, RygelResourceInfo* resource_info);
void rygel_description_file_clear_icon_list (RygelDescriptionFile* self);
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
void rygel_description_file_add_icon (RygelDescriptionFile* self, const gchar* device_name, RygelIconInfo* icon_info, const gchar* url);
void rygel_description_file_modify_service_type (RygelDescriptionFile* self, const gchar* old_type, const gchar* new_type);
void rygel_description_file_save (RygelDescriptionFile* self, const gchar* path, GError** error);
static gint rygel_description_file_index_of_device_element (RygelDescriptionFile* self, const gchar* element);
static void rygel_description_file_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
     * Constructor to load a description file from disk
     *
     * @param template_file the path to the description file.
     * @throws GUPnP.XMLError.PARSE if there was an error reading or parsing
     * the file.
     */
RygelDescriptionFile* rygel_description_file_construct (GType object_type, const gchar* template_file, GError** error) {
	RygelDescriptionFile * self = NULL;
	GUPnPXMLDoc* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GUPnPXMLDoc* _tmp2_ = NULL;
	GUPnPXMLDoc* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
#line 89 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_val_if_fail (template_file != NULL, NULL);
#line 89 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	self = (RygelDescriptionFile*) g_object_new (object_type, NULL);
#line 90 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp1_ = template_file;
#line 90 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp2_ = gupnp_xml_doc_new_from_path (_tmp1_, &_inner_error_);
#line 90 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = _tmp2_;
#line 90 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 90 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		g_propagate_error (error, _inner_error_);
#line 90 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_g_object_unref0 (self);
#line 90 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		return NULL;
#line 301 "rygel-description-file.c"
	}
#line 90 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp3_ = _tmp0_;
#line 90 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = NULL;
#line 90 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_object_unref0 (self->priv->doc);
#line 90 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	self->priv->doc = _tmp3_;
#line 89 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_object_unref0 (_tmp0_);
#line 89 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	return self;
#line 315 "rygel-description-file.c"
}


RygelDescriptionFile* rygel_description_file_new (const gchar* template_file, GError** error) {
#line 89 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	return rygel_description_file_construct (RYGEL_TYPE_DESCRIPTION_FILE, template_file, error);
#line 322 "rygel-description-file.c"
}


/**
     * Constructor which wraps an existing GUPnP.XMLDoc as a description file.
     *
     * @param doc is the GUPnP.XMLDoc to wrap.
     */
static gpointer _g_object_ref0 (gpointer self) {
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	return self ? g_object_ref (self) : NULL;
#line 334 "rygel-description-file.c"
}


RygelDescriptionFile* rygel_description_file_construct_from_xml_document (GType object_type, GUPnPXMLDoc* doc) {
	RygelDescriptionFile * self = NULL;
	GUPnPXMLDoc* _tmp0_ = NULL;
	GUPnPXMLDoc* _tmp1_ = NULL;
#line 98 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_val_if_fail (doc != NULL, NULL);
#line 98 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	self = (RygelDescriptionFile*) g_object_new (object_type, NULL);
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = doc;
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_object_unref0 (self->priv->doc);
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	self->priv->doc = _tmp1_;
#line 98 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	return self;
#line 356 "rygel-description-file.c"
}


RygelDescriptionFile* rygel_description_file_new_from_xml_document (GUPnPXMLDoc* doc) {
#line 98 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	return rygel_description_file_construct_from_xml_document (RYGEL_TYPE_DESCRIPTION_FILE, doc);
#line 363 "rygel-description-file.c"
}


/**
     * Change the type of a service.
     *
     * Usually used to modify the device version, e.g. default device type is
     * "MediaServer:2" and device_type = "MediaServer:1".
     *
     * @param device_type is the current content of serviceType.
     */
void rygel_description_file_set_device_type (RygelDescriptionFile* self, const gchar* device_type) {
	const gchar* _tmp0_ = NULL;
#line 110 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (self != NULL);
#line 110 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (device_type != NULL);
#line 111 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = device_type;
#line 111 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	rygel_description_file_set_device_element (self, "deviceType", _tmp0_, NULL);
#line 385 "rygel-description-file.c"
}


/**
     * Modify the model description.
     *
     * A longer user friendly description of the device.
     *
     * @param model_description is the new model description.
     */
void rygel_description_file_set_model_description (RygelDescriptionFile* self, const gchar* model_description) {
	const gchar* _tmp0_ = NULL;
#line 121 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (self != NULL);
#line 121 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (model_description != NULL);
#line 122 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = model_description;
#line 122 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	rygel_description_file_set_device_element (self, "modelDescription", _tmp0_, NULL);
#line 406 "rygel-description-file.c"
}


/**
     * Modify the model name.
     *
     * Usually the name of the software implementing this device.
     *
     * @param model_name is the new model name.
     */
void rygel_description_file_set_model_name (RygelDescriptionFile* self, const gchar* model_name) {
	const gchar* _tmp0_ = NULL;
#line 132 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (self != NULL);
#line 132 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (model_name != NULL);
#line 133 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = model_name;
#line 133 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	rygel_description_file_set_device_element (self, "modelName", _tmp0_, NULL);
#line 427 "rygel-description-file.c"
}


/**
     * Modify the model number.
     *
     * Usually the version of the software implementing this device.
     *
     * @param model_number is the new model number.
     */
void rygel_description_file_set_model_number (RygelDescriptionFile* self, const gchar* model_number) {
	const gchar* _tmp0_ = NULL;
#line 143 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (self != NULL);
#line 143 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (model_number != NULL);
#line 144 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = model_number;
#line 144 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	rygel_description_file_set_device_element (self, "modelNumber", _tmp0_, NULL);
#line 448 "rygel-description-file.c"
}


/**
     * Set the friendly name of the device.
     *
     * The friendly name is the one usually presented to the user in control
     * points or DMPs
     *
     * @param friendly_name is the new friendly name of the device.
     */
void rygel_description_file_set_friendly_name (RygelDescriptionFile* self, const gchar* friendly_name) {
	const gchar* _tmp0_ = NULL;
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (self != NULL);
#line 155 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (friendly_name != NULL);
#line 156 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = friendly_name;
#line 156 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	rygel_description_file_set_device_element (self, "friendlyName", _tmp0_, NULL);
#line 470 "rygel-description-file.c"
}


/**
     * Get the current friendly name of the device.
     *
     * @return The currenly set friendly name.
     */
gchar* rygel_description_file_get_friendly_name (RygelDescriptionFile* self) {
	gchar* result = NULL;
	xmlNode* element = NULL;
	GUPnPXMLDoc* _tmp0_ = NULL;
	xmlDoc* _tmp1_ = NULL;
	xmlNode* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 164 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 165 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = self->priv->doc;
#line 165 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp1_ = _tmp0_->doc;
#line 165 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp2_ = rygel_xml_utils_get_element ((xmlNode*) _tmp1_, "root", "device", "friendlyName", NULL);
#line 165 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	element = _tmp2_;
#line 169 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_vala_assert (element != NULL, "element != null");
#line 171 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp3_ = (gchar*) xmlNodeGetContent (element);
#line 171 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	result = _tmp3_;
#line 171 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	return result;
#line 504 "rygel-description-file.c"
}


/**
     * Set the Unique Device Name of the device.
     *
     * Unique Device Name is the UUID of this particular device instance.
     *
     * @param udn is the Unique Device Name of the device.
     */
void rygel_description_file_set_udn (RygelDescriptionFile* self, const gchar* udn) {
	const gchar* _tmp0_ = NULL;
#line 181 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (self != NULL);
#line 181 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (udn != NULL);
#line 182 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = udn;
#line 182 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	rygel_description_file_set_device_element (self, "UDN", _tmp0_, NULL);
#line 525 "rygel-description-file.c"
}


/**
     * Get the current UDN of the device.
     *
     * @return The currenly set UDN.
     */
gchar* rygel_description_file_get_udn (RygelDescriptionFile* self) {
	gchar* result = NULL;
	xmlNode* element = NULL;
	GUPnPXMLDoc* _tmp0_ = NULL;
	xmlDoc* _tmp1_ = NULL;
	xmlNode* _tmp2_ = NULL;
	xmlNode* _tmp3_ = NULL;
	xmlNode* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
#line 190 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 191 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = self->priv->doc;
#line 191 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp1_ = _tmp0_->doc;
#line 191 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp2_ = rygel_xml_utils_get_element ((xmlNode*) _tmp1_, "root", "device", "UDN", NULL);
#line 191 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	element = _tmp2_;
#line 195 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp3_ = element;
#line 195 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if (_tmp3_ == NULL) {
#line 196 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		result = NULL;
#line 196 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		return result;
#line 561 "rygel-description-file.c"
	}
#line 199 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp4_ = element;
#line 199 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp5_ = (gchar*) xmlNodeGetContent (_tmp4_);
#line 199 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	result = _tmp5_;
#line 199 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	return result;
#line 571 "rygel-description-file.c"
}


/**
     * Set the DLNA caps of this root device and while taking the
     * capabilities of the plugin into account.
     *
     * @param capabilities RygelPluginCapabilities flags
     */
static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value) {
#line 227 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if ((*length) == (*size)) {
#line 227 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 227 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 588 "rygel-description-file.c"
	}
#line 227 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	(*array)[(*length)++] = value;
#line 227 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	(*array)[*length] = NULL;
#line 594 "rygel-description-file.c"
}


static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value) {
#line 232 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if ((*length) == (*size)) {
#line 232 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 232 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 605 "rygel-description-file.c"
	}
#line 232 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	(*array)[(*length)++] = value;
#line 232 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	(*array)[*length] = NULL;
#line 611 "rygel-description-file.c"
}


static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value) {
#line 237 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if ((*length) == (*size)) {
#line 237 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 237 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 622 "rygel-description-file.c"
	}
#line 237 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	(*array)[(*length)++] = value;
#line 237 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	(*array)[*length] = NULL;
#line 628 "rygel-description-file.c"
}


static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value) {
#line 244 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if ((*length) == (*size)) {
#line 244 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 244 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 639 "rygel-description-file.c"
	}
#line 244 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	(*array)[(*length)++] = value;
#line 244 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	(*array)[*length] = NULL;
#line 645 "rygel-description-file.c"
}


static void _vala_array_add8 (gchar*** array, int* length, int* size, gchar* value) {
#line 250 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if ((*length) == (*size)) {
#line 250 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 250 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 656 "rygel-description-file.c"
	}
#line 250 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	(*array)[(*length)++] = value;
#line 250 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	(*array)[*length] = NULL;
#line 662 "rygel-description-file.c"
}


static void _vala_array_add9 (gchar*** array, int* length, int* size, gchar* value) {
#line 251 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if ((*length) == (*size)) {
#line 251 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 251 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 673 "rygel-description-file.c"
	}
#line 251 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	(*array)[(*length)++] = value;
#line 251 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	(*array)[*length] = NULL;
#line 679 "rygel-description-file.c"
}


static void _vala_array_add10 (gchar*** array, int* length, int* size, gchar* value) {
#line 258 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if ((*length) == (*size)) {
#line 258 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 258 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 690 "rygel-description-file.c"
	}
#line 258 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	(*array)[(*length)++] = value;
#line 258 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	(*array)[*length] = NULL;
#line 696 "rygel-description-file.c"
}


static void _vala_array_add11 (gchar*** array, int* length, int* size, gchar* value) {
#line 262 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if ((*length) == (*size)) {
#line 262 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 262 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 707 "rygel-description-file.c"
	}
#line 262 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	(*array)[(*length)++] = value;
#line 262 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	(*array)[*length] = NULL;
#line 713 "rygel-description-file.c"
}


static void _vala_array_add12 (gchar*** array, int* length, int* size, gchar* value) {
#line 276 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if ((*length) == (*size)) {
#line 276 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 276 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 724 "rygel-description-file.c"
	}
#line 276 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	(*array)[(*length)++] = value;
#line 276 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	(*array)[*length] = NULL;
#line 730 "rygel-description-file.c"
}


static gchar* _vala_g_strjoinv (const gchar* separator, gchar** str_array, int str_array_length1) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
#line 964 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = separator;
#line 964 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp0_ == NULL) {
#line 965 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		separator = "";
#line 747 "rygel-description-file.c"
	}
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp3_ = str_array;
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp3__length1 = str_array_length1;
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp2_ = TRUE;
#line 757 "rygel-description-file.c"
	} else {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = str_array;
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4__length1 = str_array_length1;
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp4__length1 > 0;
#line 767 "rygel-description-file.c"
	}
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp2_) {
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 773 "rygel-description-file.c"
	} else {
		gboolean _tmp5_ = FALSE;
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = str_array;
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6__length1 = str_array_length1;
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (_tmp6__length1 == (-1)) {
#line 784 "rygel-description-file.c"
			gchar** _tmp7_ = NULL;
			gint _tmp7__length1 = 0;
			const gchar* _tmp8_ = NULL;
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_tmp7_ = str_array;
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_tmp7__length1 = str_array_length1;
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_tmp8_ = _tmp7_[0];
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_tmp5_ = _tmp8_ != NULL;
#line 796 "rygel-description-file.c"
		} else {
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_tmp5_ = FALSE;
#line 800 "rygel-description-file.c"
		}
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp1_ = _tmp5_;
#line 804 "rygel-description-file.c"
	}
#line 967 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp1_) {
#line 808 "rygel-description-file.c"
		gint i = 0;
		gsize len = 0UL;
		gint _tmp31_ = 0;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		gsize _tmp35_ = 0UL;
		const gchar* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		const gchar* res = NULL;
		gsize _tmp40_ = 0UL;
		void* _tmp41_ = NULL;
		void* ptr = NULL;
		const gchar* _tmp42_ = NULL;
		gchar** _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		const gchar* _tmp44_ = NULL;
		void* _tmp45_ = NULL;
		const gchar* _tmp62_ = NULL;
#line 969 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		len = (gsize) 1;
#line 831 "rygel-description-file.c"
		{
			gboolean _tmp9_ = FALSE;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			i = 0;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_tmp9_ = TRUE;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			while (TRUE) {
#line 840 "rygel-description-file.c"
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp21_ = 0;
				gchar** _tmp22_ = NULL;
				gint _tmp22__length1 = 0;
				gint _tmp23_ = 0;
				const gchar* _tmp24_ = NULL;
				gsize _tmp30_ = 0UL;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				if (!_tmp9_) {
#line 853 "rygel-description-file.c"
					gint _tmp10_ = 0;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp10_ = i;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					i = _tmp10_ + 1;
#line 859 "rygel-description-file.c"
				}
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp9_ = FALSE;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp13_ = str_array;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp13__length1 = str_array_length1;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				if (_tmp13__length1 != (-1)) {
#line 869 "rygel-description-file.c"
					gint _tmp14_ = 0;
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp14_ = i;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp15_ = str_array;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp15__length1 = str_array_length1;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp12_ = _tmp14_ < _tmp15__length1;
#line 881 "rygel-description-file.c"
				} else {
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp12_ = FALSE;
#line 885 "rygel-description-file.c"
				}
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				if (_tmp12_) {
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp11_ = TRUE;
#line 891 "rygel-description-file.c"
				} else {
					gboolean _tmp16_ = FALSE;
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp17_ = str_array;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp17__length1 = str_array_length1;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					if (_tmp17__length1 == (-1)) {
#line 902 "rygel-description-file.c"
						gchar** _tmp18_ = NULL;
						gint _tmp18__length1 = 0;
						gint _tmp19_ = 0;
						const gchar* _tmp20_ = NULL;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
						_tmp18_ = str_array;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
						_tmp18__length1 = str_array_length1;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
						_tmp19_ = i;
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
						_tmp20_ = _tmp18_[_tmp19_];
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
						_tmp16_ = _tmp20_ != NULL;
#line 917 "rygel-description-file.c"
					} else {
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
						_tmp16_ = FALSE;
#line 921 "rygel-description-file.c"
					}
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp11_ = _tmp16_;
#line 925 "rygel-description-file.c"
				}
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				if (!_tmp11_) {
#line 970 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					break;
#line 931 "rygel-description-file.c"
				}
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp22_ = str_array;
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp22__length1 = str_array_length1;
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp23_ = i;
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp24_ = _tmp22_[_tmp23_];
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				if (_tmp24_ != NULL) {
#line 943 "rygel-description-file.c"
					gchar** _tmp25_ = NULL;
					gint _tmp25__length1 = 0;
					gint _tmp26_ = 0;
					const gchar* _tmp27_ = NULL;
					gint _tmp28_ = 0;
					gint _tmp29_ = 0;
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp25_ = str_array;
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp25__length1 = str_array_length1;
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp26_ = i;
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp27_ = _tmp25_[_tmp26_];
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp28_ = strlen ((const gchar*) _tmp27_);
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp29_ = _tmp28_;
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp21_ = _tmp29_;
#line 964 "rygel-description-file.c"
				} else {
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp21_ = 0;
#line 968 "rygel-description-file.c"
				}
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp30_ = len;
#line 971 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				len = _tmp30_ + _tmp21_;
#line 974 "rygel-description-file.c"
			}
		}
#line 973 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp31_ = i;
#line 973 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (_tmp31_ == 0) {
#line 981 "rygel-description-file.c"
			gchar* _tmp32_ = NULL;
#line 974 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_tmp32_ = g_strdup ("");
#line 974 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			result = _tmp32_;
#line 974 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			return result;
#line 989 "rygel-description-file.c"
		}
#line 976 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp33_ = i;
#line 976 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		str_array_length1 = _tmp33_;
#line 976 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp34_ = str_array_length1;
#line 977 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp35_ = len;
#line 977 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp36_ = separator;
#line 977 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp37_ = strlen ((const gchar*) _tmp36_);
#line 977 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp38_ = _tmp37_;
#line 977 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp39_ = i;
#line 977 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		len = _tmp35_ + (_tmp38_ * (_tmp39_ - 1));
#line 979 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp40_ = len;
#line 979 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp41_ = g_malloc (_tmp40_);
#line 979 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		res = _tmp41_;
#line 980 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp42_ = res;
#line 980 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp43_ = str_array;
#line 980 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp43__length1 = str_array_length1;
#line 980 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp44_ = _tmp43_[0];
#line 980 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp45_ = g_stpcpy ((void*) _tmp42_, (const gchar*) _tmp44_);
#line 980 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		ptr = _tmp45_;
#line 1027 "rygel-description-file.c"
		{
			gboolean _tmp46_ = FALSE;
#line 981 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			i = 1;
#line 981 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_tmp46_ = TRUE;
#line 981 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			while (TRUE) {
#line 1036 "rygel-description-file.c"
				gint _tmp48_ = 0;
				gchar** _tmp49_ = NULL;
				gint _tmp49__length1 = 0;
				void* _tmp50_ = NULL;
				const gchar* _tmp51_ = NULL;
				void* _tmp52_ = NULL;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_ = NULL;
				gint _tmp54__length1 = 0;
				gint _tmp55_ = 0;
				const gchar* _tmp56_ = NULL;
				void* _tmp60_ = NULL;
				void* _tmp61_ = NULL;
#line 981 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				if (!_tmp46_) {
#line 1052 "rygel-description-file.c"
					gint _tmp47_ = 0;
#line 981 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp47_ = i;
#line 981 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					i = _tmp47_ + 1;
#line 1058 "rygel-description-file.c"
				}
#line 981 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp46_ = FALSE;
#line 981 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp48_ = i;
#line 981 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp49_ = str_array;
#line 981 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp49__length1 = str_array_length1;
#line 981 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				if (!(_tmp48_ < _tmp49__length1)) {
#line 981 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					break;
#line 1072 "rygel-description-file.c"
				}
#line 982 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp50_ = ptr;
#line 982 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp51_ = separator;
#line 982 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp52_ = g_stpcpy (_tmp50_, (const gchar*) _tmp51_);
#line 982 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				ptr = _tmp52_;
#line 983 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp54_ = str_array;
#line 983 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp54__length1 = str_array_length1;
#line 983 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp55_ = i;
#line 983 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp56_ = _tmp54_[_tmp55_];
#line 983 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				if (_tmp56_ != NULL) {
#line 1092 "rygel-description-file.c"
					gchar** _tmp57_ = NULL;
					gint _tmp57__length1 = 0;
					gint _tmp58_ = 0;
					const gchar* _tmp59_ = NULL;
#line 983 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp57_ = str_array;
#line 983 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp57__length1 = str_array_length1;
#line 983 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp58_ = i;
#line 983 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp59_ = _tmp57_[_tmp58_];
#line 983 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp53_ = (const gchar*) _tmp59_;
#line 1107 "rygel-description-file.c"
				} else {
#line 983 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
					_tmp53_ = "";
#line 1111 "rygel-description-file.c"
				}
#line 983 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp60_ = ptr;
#line 983 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				_tmp61_ = g_stpcpy (_tmp60_, _tmp53_);
#line 983 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
				ptr = _tmp61_;
#line 1119 "rygel-description-file.c"
			}
		}
#line 986 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp62_ = res;
#line 986 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		res = NULL;
#line 986 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = (gchar*) _tmp62_;
#line 986 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 1130 "rygel-description-file.c"
	} else {
		gchar* _tmp63_ = NULL;
#line 988 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp63_ = g_strdup ("");
#line 988 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = _tmp63_;
#line 988 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 1139 "rygel-description-file.c"
	}
}


void rygel_description_file_set_dlna_caps (RygelDescriptionFile* self, RygelPluginCapabilities capabilities) {
	gchar** flags = NULL;
	gchar** _tmp0_ = NULL;
	gint flags_length1 = 0;
	gint _flags_size_ = 0;
	RygelPluginCapabilities _tmp1_ = 0;
	RygelPluginCapabilities _tmp24_ = 0;
	gboolean _tmp29_ = FALSE;
	RygelPluginCapabilities _tmp30_ = 0;
	RygelPluginCapabilities _tmp34_ = 0;
	RygelPluginCapabilities _tmp37_ = 0;
	gchar** _tmp40_ = NULL;
	gint _tmp40__length1 = 0;
	GError * _inner_error_ = NULL;
#line 208 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (self != NULL);
#line 209 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = g_new0 (gchar*, 0 + 1);
#line 209 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	flags = _tmp0_;
#line 209 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	flags_length1 = 0;
#line 209 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_flags_size_ = flags_length1;
#line 211 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp1_ = capabilities;
#line 211 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if ((RYGEL_PLUGIN_CAPABILITIES_UPLOAD & _tmp1_) != 0) {
#line 1172 "rygel-description-file.c"
		gboolean allow_upload = FALSE;
		gboolean allow_delete = FALSE;
		gboolean _tmp9_ = FALSE;
#line 215 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		allow_upload = TRUE;
#line 216 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		allow_delete = FALSE;
#line 1180 "rygel-description-file.c"
		{
			RygelMetaConfig* config = NULL;
			RygelMetaConfig* _tmp2_ = NULL;
			gboolean _tmp3_ = FALSE;
			RygelMetaConfig* _tmp4_ = NULL;
			gboolean _tmp5_ = FALSE;
			gboolean _tmp6_ = FALSE;
			RygelMetaConfig* _tmp7_ = NULL;
			gboolean _tmp8_ = FALSE;
#line 219 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_tmp2_ = rygel_meta_config_get_default ();
#line 219 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			config = _tmp2_;
#line 220 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_tmp4_ = config;
#line 220 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_tmp5_ = rygel_configuration_get_allow_upload ((RygelConfiguration*) _tmp4_, &_inner_error_);
#line 220 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_tmp3_ = _tmp5_;
#line 220 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 220 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_g_object_unref0 (config);
#line 1204 "rygel-description-file.c"
				goto __catch5_g_error;
			}
#line 220 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			allow_upload = _tmp3_;
#line 221 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_tmp7_ = config;
#line 221 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_tmp8_ = rygel_configuration_get_allow_deletion ((RygelConfiguration*) _tmp7_, &_inner_error_);
#line 221 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_tmp6_ = _tmp8_;
#line 221 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 221 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_g_object_unref0 (config);
#line 1219 "rygel-description-file.c"
				goto __catch5_g_error;
			}
#line 221 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			allow_delete = _tmp6_;
#line 218 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_g_object_unref0 (config);
#line 1226 "rygel-description-file.c"
		}
		goto __finally5;
		__catch5_g_error:
		{
			GError* _error_ = NULL;
#line 218 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_error_ = _inner_error_;
#line 218 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_inner_error_ = NULL;
#line 218 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_g_error_free0 (_error_);
#line 1238 "rygel-description-file.c"
		}
		__finally5:
#line 218 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 218 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			flags = (_vala_array_free (flags, flags_length1, (GDestroyNotify) g_free), NULL);
#line 218 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 218 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			g_clear_error (&_inner_error_);
#line 218 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			return;
#line 1251 "rygel-description-file.c"
		}
#line 224 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp9_ = allow_upload;
#line 224 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		if (_tmp9_) {
#line 1257 "rygel-description-file.c"
			gboolean can_upload = FALSE;
			RygelPluginCapabilities _tmp10_ = 0;
			RygelPluginCapabilities _tmp13_ = 0;
			RygelPluginCapabilities _tmp16_ = 0;
			gboolean _tmp19_ = FALSE;
			gboolean _tmp20_ = FALSE;
#line 225 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			can_upload = FALSE;
#line 226 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_tmp10_ = capabilities;
#line 226 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			if ((_tmp10_ & RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD) == RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD) {
#line 1270 "rygel-description-file.c"
				gchar** _tmp11_ = NULL;
				gint _tmp11__length1 = 0;
				gchar* _tmp12_ = NULL;
#line 227 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp11_ = flags;
#line 227 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp11__length1 = flags_length1;
#line 227 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp12_ = g_strdup ("image-upload");
#line 227 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_vala_array_add4 (&flags, &flags_length1, &_flags_size_, _tmp12_);
#line 228 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				can_upload = TRUE;
#line 1284 "rygel-description-file.c"
			}
#line 231 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_tmp13_ = capabilities;
#line 231 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			if ((_tmp13_ & RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD) == RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD) {
#line 1290 "rygel-description-file.c"
				gchar** _tmp14_ = NULL;
				gint _tmp14__length1 = 0;
				gchar* _tmp15_ = NULL;
#line 232 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp14_ = flags;
#line 232 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp14__length1 = flags_length1;
#line 232 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp15_ = g_strdup ("av-upload");
#line 232 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_vala_array_add5 (&flags, &flags_length1, &_flags_size_, _tmp15_);
#line 233 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				can_upload = TRUE;
#line 1304 "rygel-description-file.c"
			}
#line 236 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_tmp16_ = capabilities;
#line 236 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			if ((_tmp16_ & RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD) == RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD) {
#line 1310 "rygel-description-file.c"
				gchar** _tmp17_ = NULL;
				gint _tmp17__length1 = 0;
				gchar* _tmp18_ = NULL;
#line 237 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp17_ = flags;
#line 237 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp17__length1 = flags_length1;
#line 237 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp18_ = g_strdup ("audio-upload");
#line 237 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_vala_array_add6 (&flags, &flags_length1, &_flags_size_, _tmp18_);
#line 238 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				can_upload = TRUE;
#line 1324 "rygel-description-file.c"
			}
#line 243 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_tmp20_ = allow_delete;
#line 243 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			if (_tmp20_) {
#line 1330 "rygel-description-file.c"
				gboolean _tmp21_ = FALSE;
#line 243 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp21_ = can_upload;
#line 243 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp19_ = _tmp21_;
#line 1336 "rygel-description-file.c"
			} else {
#line 243 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp19_ = FALSE;
#line 1340 "rygel-description-file.c"
			}
#line 243 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			if (_tmp19_) {
#line 1344 "rygel-description-file.c"
				gchar** _tmp22_ = NULL;
				gint _tmp22__length1 = 0;
				gchar* _tmp23_ = NULL;
#line 244 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp22_ = flags;
#line 244 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp22__length1 = flags_length1;
#line 244 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp23_ = g_strdup ("create-item-with-OCM-destroy-item");
#line 244 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_vala_array_add7 (&flags, &flags_length1, &_flags_size_, _tmp23_);
#line 1356 "rygel-description-file.c"
			}
		}
	}
#line 249 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp24_ = capabilities;
#line 249 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if ((_tmp24_ & RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES) == RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES) {
#line 1364 "rygel-description-file.c"
		gchar** _tmp25_ = NULL;
		gint _tmp25__length1 = 0;
		gchar* _tmp26_ = NULL;
		gchar** _tmp27_ = NULL;
		gint _tmp27__length1 = 0;
		gchar* _tmp28_ = NULL;
#line 250 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp25_ = flags;
#line 250 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp25__length1 = flags_length1;
#line 250 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp26_ = g_strdup ("content-synchronization");
#line 250 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_vala_array_add8 (&flags, &flags_length1, &_flags_size_, _tmp26_);
#line 251 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp27_ = flags;
#line 251 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp27__length1 = flags_length1;
#line 251 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp28_ = g_strdup ("create-child-container");
#line 251 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_vala_array_add9 (&flags, &flags_length1, &_flags_size_, _tmp28_);
#line 1387 "rygel-description-file.c"
	}
#line 256 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp30_ = capabilities;
#line 256 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if ((_tmp30_ & RYGEL_PLUGIN_CAPABILITIES_CREATE_CONTAINERS) == RYGEL_PLUGIN_CAPABILITIES_CREATE_CONTAINERS) {
#line 1393 "rygel-description-file.c"
		RygelPluginCapabilities _tmp31_ = 0;
#line 257 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp31_ = capabilities;
#line 257 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp29_ = !((_tmp31_ & RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES) == RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES);
#line 1399 "rygel-description-file.c"
	} else {
#line 256 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp29_ = FALSE;
#line 1403 "rygel-description-file.c"
	}
#line 256 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if (_tmp29_) {
#line 1407 "rygel-description-file.c"
		gchar** _tmp32_ = NULL;
		gint _tmp32__length1 = 0;
		gchar* _tmp33_ = NULL;
#line 258 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp32_ = flags;
#line 258 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp32__length1 = flags_length1;
#line 258 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp33_ = g_strdup ("create-child-container");
#line 258 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_vala_array_add10 (&flags, &flags_length1, &_flags_size_, _tmp33_);
#line 1419 "rygel-description-file.c"
	}
#line 261 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp34_ = capabilities;
#line 261 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if ((_tmp34_ & RYGEL_PLUGIN_CAPABILITIES_DIAGNOSTICS) == RYGEL_PLUGIN_CAPABILITIES_DIAGNOSTICS) {
#line 1425 "rygel-description-file.c"
		gchar** _tmp35_ = NULL;
		gint _tmp35__length1 = 0;
		gchar* _tmp36_ = NULL;
#line 262 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp35_ = flags;
#line 262 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp35__length1 = flags_length1;
#line 262 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp36_ = g_strdup (RYGEL_DESCRIPTION_FILE_DIAGE_DEV_CAP);
#line 262 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_vala_array_add11 (&flags, &flags_length1, &_flags_size_, _tmp36_);
#line 266 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		rygel_description_file_add_dlna_doc_element (self, RYGEL_DESCRIPTION_FILE_X_DLNADOC_DIAGE_XPATH, RYGEL_DESCRIPTION_FILE_X_DLNADOC_NON_DEVCAP_XPATH, RYGEL_DESCRIPTION_FILE_DIAGE_DEV_CAP);
#line 1439 "rygel-description-file.c"
	} else {
#line 272 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		rygel_description_file_remove_dlna_doc_element (self, RYGEL_DESCRIPTION_FILE_X_DLNADOC_DIAGE_XPATH);
#line 1443 "rygel-description-file.c"
	}
#line 275 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp37_ = capabilities;
#line 275 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if ((_tmp37_ & RYGEL_PLUGIN_CAPABILITIES_ENERGY_MANAGEMENT) == RYGEL_PLUGIN_CAPABILITIES_ENERGY_MANAGEMENT) {
#line 1449 "rygel-description-file.c"
		gchar** _tmp38_ = NULL;
		gint _tmp38__length1 = 0;
		gchar* _tmp39_ = NULL;
#line 276 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp38_ = flags;
#line 276 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp38__length1 = flags_length1;
#line 276 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp39_ = g_strdup (RYGEL_DESCRIPTION_FILE_LPE_DEV_CAP);
#line 276 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_vala_array_add12 (&flags, &flags_length1, &_flags_size_, _tmp39_);
#line 280 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		rygel_description_file_add_dlna_doc_element (self, RYGEL_DESCRIPTION_FILE_X_DLNADOC_LPE_XPATH, RYGEL_DESCRIPTION_FILE_X_DLNADOC_NON_DEVCAP_XPATH, RYGEL_DESCRIPTION_FILE_LPE_DEV_CAP);
#line 1463 "rygel-description-file.c"
	} else {
#line 286 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		rygel_description_file_remove_dlna_doc_element (self, RYGEL_DESCRIPTION_FILE_X_DLNADOC_LPE_XPATH);
#line 1467 "rygel-description-file.c"
	}
#line 291 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp40_ = flags;
#line 291 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp40__length1 = flags_length1;
#line 291 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if (_tmp40__length1 > 0) {
#line 1475 "rygel-description-file.c"
		gchar* content = NULL;
		gchar** _tmp41_ = NULL;
		gint _tmp41__length1 = 0;
		gchar* _tmp42_ = NULL;
		const gchar* _tmp43_ = NULL;
#line 292 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp41_ = flags;
#line 292 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp41__length1 = flags_length1;
#line 292 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp42_ = _vala_g_strjoinv (",", _tmp41_, _tmp41__length1);
#line 292 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		content = _tmp42_;
#line 293 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp43_ = content;
#line 293 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		rygel_description_file_set_device_element (self, "X_DLNACAP", _tmp43_, "dlna");
#line 291 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_g_free0 (content);
#line 1495 "rygel-description-file.c"
	} else {
#line 295 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		rygel_description_file_remove_device_element (self, "X_DLNACAP");
#line 1499 "rygel-description-file.c"
	}
#line 208 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	flags = (_vala_array_free (flags, flags_length1, (GDestroyNotify) g_free), NULL);
#line 1503 "rygel-description-file.c"
}


void rygel_description_file_clear_service_list (RygelDescriptionFile* self) {
#line 299 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (self != NULL);
#line 300 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	rygel_description_file_remove_device_element (self, "serviceList");
#line 1512 "rygel-description-file.c"
}


static gint string_last_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 910 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 910 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 911 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 911 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = needle;
#line 911 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp2_ = g_strrstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
#line 911 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 913 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 913 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 1539 "rygel-description-file.c"
		gchar* _tmp4_ = NULL;
#line 914 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 914 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 914 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 1547 "rygel-description-file.c"
	} else {
#line 916 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = -1;
#line 916 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 1553 "rygel-description-file.c"
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
#line 1230 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1231 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1231 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1231 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1232 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1232 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 1587 "rygel-description-file.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
#line 1233 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1233 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1233 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 1596 "rygel-description-file.c"
	}
#line 1235 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1235 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 1602 "rygel-description-file.c"
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
#line 1236 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1236 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1236 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 1611 "rygel-description-file.c"
	}
#line 1238 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1238 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 1617 "rygel-description-file.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1238 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1238 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1238 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 1626 "rygel-description-file.c"
	} else {
#line 1238 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 1630 "rygel-description-file.c"
	}
#line 1238 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp8_, NULL);
#line 1239 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp13_ = end;
#line 1239 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp13_ >= ((glong) 0)) {
#line 1638 "rygel-description-file.c"
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
#line 1239 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp14_ = end;
#line 1239 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1239 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp12_ = _tmp14_ <= _tmp15_;
#line 1647 "rygel-description-file.c"
	} else {
#line 1239 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp12_ = FALSE;
#line 1651 "rygel-description-file.c"
	}
#line 1239 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1240 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp16_ = start;
#line 1240 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp17_ = end;
#line 1240 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
#line 1241 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1241 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1241 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1241 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
#line 1241 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp21_;
#line 1241 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 1673 "rygel-description-file.c"
}


void rygel_description_file_add_dlna_doc_element (RygelDescriptionFile* self, const gchar* dlnadoc_xpath, const gchar* dlnadoc_non_xpath, const gchar* dev_cap) {
	xmlXPathObject* dlna_doc_object = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	xmlXPathObject* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	xmlXPathObject* _tmp48_ = NULL;
#line 304 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (self != NULL);
#line 304 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (dlnadoc_xpath != NULL);
#line 304 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (dlnadoc_non_xpath != NULL);
#line 304 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (dev_cap != NULL);
#line 307 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	dlna_doc_object = NULL;
#line 312 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = dlnadoc_xpath;
#line 312 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp1_ = rygel_description_file_apply_xpath (self, _tmp0_, NULL);
#line 312 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if (_tmp1_) {
#line 313 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		return;
#line 1703 "rygel-description-file.c"
	}
#line 317 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp2_ = dlnadoc_non_xpath;
#line 317 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp4_ = rygel_description_file_apply_xpath (self, _tmp2_, &_tmp3_);
#line 317 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	dlna_doc_object = _tmp3_;
#line 317 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if (!_tmp4_) {
#line 318 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		return;
#line 1715 "rygel-description-file.c"
	}
	{
		gint i = 0;
#line 321 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		i = 0;
#line 1721 "rygel-description-file.c"
		{
			gboolean _tmp5_ = FALSE;
#line 321 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_tmp5_ = TRUE;
#line 321 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			while (TRUE) {
#line 1728 "rygel-description-file.c"
				gint _tmp7_ = 0;
				xmlXPathObject* _tmp8_ = NULL;
				xmlNodeSet* _tmp9_ = NULL;
				gint _tmp10_ = 0;
				xmlNode* node = NULL;
				xmlXPathObject* _tmp11_ = NULL;
				xmlNodeSet* _tmp12_ = NULL;
				gint _tmp13_ = 0;
				xmlNode* _tmp14_ = NULL;
				gchar* node_content = NULL;
				xmlNode* _tmp15_ = NULL;
				gchar* _tmp16_ = NULL;
				gint doc_index = 0;
				const gchar* _tmp17_ = NULL;
				gint _tmp18_ = 0;
				gchar* devcap_content = NULL;
				xmlNode* device = NULL;
				xmlNode* _tmp19_ = NULL;
				xmlNode* devcap_element = NULL;
				xmlNode* _tmp20_ = NULL;
				xmlNode* _tmp21_ = NULL;
				xmlNs* _tmp22_ = NULL;
				xmlNode* _tmp23_ = NULL;
				gint _tmp24_ = 0;
				const gchar* _tmp33_ = NULL;
				gchar* _tmp34_ = NULL;
				gchar* _tmp35_ = NULL;
				const gchar* _tmp36_ = NULL;
				gchar* _tmp37_ = NULL;
				gchar* _tmp38_ = NULL;
				xmlNode* _tmp39_ = NULL;
				const gchar* _tmp40_ = NULL;
				gchar* _tmp41_ = NULL;
				gchar* _tmp42_ = NULL;
				const gchar* _tmp43_ = NULL;
				gchar* _tmp44_ = NULL;
				gchar* _tmp45_ = NULL;
				xmlNode* _tmp46_ = NULL;
				xmlNode* _tmp47_ = NULL;
#line 321 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				if (!_tmp5_) {
#line 1770 "rygel-description-file.c"
					gint _tmp6_ = 0;
#line 321 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					_tmp6_ = i;
#line 321 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					i = _tmp6_ + 1;
#line 1776 "rygel-description-file.c"
				}
#line 321 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp5_ = FALSE;
#line 321 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp7_ = i;
#line 321 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp8_ = dlna_doc_object;
#line 321 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp9_ = _tmp8_->nodesetval;
#line 321 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp10_ = xmlXPathNodeSetGetLength (_tmp9_);
#line 321 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				if (!(_tmp7_ < _tmp10_)) {
#line 321 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					break;
#line 1792 "rygel-description-file.c"
				}
#line 322 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp11_ = dlna_doc_object;
#line 322 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp12_ = _tmp11_->nodesetval;
#line 322 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp13_ = i;
#line 322 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp14_ = xmlXPathNodeSetItem (_tmp12_, _tmp13_);
#line 322 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				node = _tmp14_;
#line 323 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp15_ = node;
#line 323 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp16_ = (gchar*) xmlNodeGetContent (_tmp15_);
#line 323 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				node_content = _tmp16_;
#line 324 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp17_ = node_content;
#line 324 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp18_ = string_last_index_of (_tmp17_, "/", 0);
#line 324 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				doc_index = _tmp18_;
#line 329 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp19_ = rygel_description_file_get_device_element (self);
#line 329 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				device = _tmp19_;
#line 330 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp20_ = device;
#line 330 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp21_ = node;
#line 330 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp22_ = _tmp21_->ns;
#line 330 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp23_ = xmlNewChild (_tmp20_, _tmp22_, (xmlChar*) RYGEL_DESCRIPTION_FILE_X_DLNADOC_NODE, (xmlChar*) NULL);
#line 330 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				devcap_element = _tmp23_;
#line 331 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp24_ = doc_index;
#line 331 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				if (_tmp24_ != (-1)) {
#line 1834 "rygel-description-file.c"
					const gchar* _tmp25_ = NULL;
					gint _tmp26_ = 0;
					const gchar* _tmp27_ = NULL;
					gint _tmp28_ = 0;
					gint _tmp29_ = 0;
					gchar* _tmp30_ = NULL;
#line 332 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					_tmp25_ = node_content;
#line 332 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					_tmp26_ = doc_index;
#line 332 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					_tmp27_ = node_content;
#line 332 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					_tmp28_ = strlen (_tmp27_);
#line 332 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					_tmp29_ = _tmp28_;
#line 332 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					_tmp30_ = string_slice (_tmp25_, (glong) (_tmp26_ + 1), (glong) _tmp29_);
#line 332 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					_g_free0 (devcap_content);
#line 332 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					devcap_content = _tmp30_;
#line 1857 "rygel-description-file.c"
				} else {
					const gchar* _tmp31_ = NULL;
					gchar* _tmp32_ = NULL;
#line 334 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					_tmp31_ = node_content;
#line 334 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					_tmp32_ = g_strdup (_tmp31_);
#line 334 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					_g_free0 (devcap_content);
#line 334 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					devcap_content = _tmp32_;
#line 1869 "rygel-description-file.c"
				}
#line 336 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp33_ = dev_cap;
#line 336 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp34_ = g_strconcat (_tmp33_, "/", NULL);
#line 336 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp35_ = _tmp34_;
#line 336 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp36_ = devcap_content;
#line 336 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp37_ = g_strconcat (_tmp35_, _tmp36_, NULL);
#line 336 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp38_ = _tmp37_;
#line 336 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				g_debug ("rygel-description-file.vala:336: %s", _tmp38_);
#line 336 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_g_free0 (_tmp38_);
#line 336 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_g_free0 (_tmp35_);
#line 337 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp39_ = devcap_element;
#line 337 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp40_ = dev_cap;
#line 337 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp41_ = g_strconcat (_tmp40_, "/", NULL);
#line 337 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp42_ = _tmp41_;
#line 337 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp43_ = devcap_content;
#line 337 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp44_ = g_strconcat (_tmp42_, _tmp43_, NULL);
#line 337 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp45_ = _tmp44_;
#line 337 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				xmlNodeSetContent (_tmp39_, (xmlChar*) _tmp45_);
#line 337 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_g_free0 (_tmp45_);
#line 337 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_g_free0 (_tmp42_);
#line 338 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp46_ = node;
#line 338 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp47_ = devcap_element;
#line 338 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				xmlAddNextSibling (_tmp46_, _tmp47_);
#line 321 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_g_free0 (devcap_content);
#line 321 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_g_free0 (node_content);
#line 1919 "rygel-description-file.c"
			}
		}
	}
#line 341 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp48_ = dlna_doc_object;
#line 341 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xmlXPathFreeObject (_tmp48_);
#line 1927 "rygel-description-file.c"
}


void rygel_description_file_remove_dlna_doc_element (RygelDescriptionFile* self, const gchar* dlnadoc_xpath) {
	xmlXPathObject* devcap_object = NULL;
	const gchar* _tmp0_ = NULL;
	xmlXPathObject* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	xmlXPathObject* _tmp16_ = NULL;
#line 345 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (self != NULL);
#line 345 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (dlnadoc_xpath != NULL);
#line 346 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	devcap_object = NULL;
#line 347 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = dlnadoc_xpath;
#line 347 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp2_ = rygel_description_file_apply_xpath (self, _tmp0_, &_tmp1_);
#line 347 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	devcap_object = _tmp1_;
#line 347 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if (!_tmp2_) {
#line 348 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		return;
#line 1953 "rygel-description-file.c"
	}
	{
		gint i = 0;
#line 351 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		i = 0;
#line 1959 "rygel-description-file.c"
		{
			gboolean _tmp3_ = FALSE;
#line 351 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_tmp3_ = TRUE;
#line 351 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			while (TRUE) {
#line 1966 "rygel-description-file.c"
				gint _tmp5_ = 0;
				xmlXPathObject* _tmp6_ = NULL;
				xmlNodeSet* _tmp7_ = NULL;
				gint _tmp8_ = 0;
				xmlNode* node = NULL;
				xmlXPathObject* _tmp9_ = NULL;
				xmlNodeSet* _tmp10_ = NULL;
				gint _tmp11_ = 0;
				xmlNode* _tmp12_ = NULL;
				xmlNode* _tmp13_ = NULL;
				xmlNode* _tmp14_ = NULL;
				xmlNode* _tmp15_ = NULL;
#line 351 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				if (!_tmp3_) {
#line 1981 "rygel-description-file.c"
					gint _tmp4_ = 0;
#line 351 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					_tmp4_ = i;
#line 351 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					i = _tmp4_ + 1;
#line 1987 "rygel-description-file.c"
				}
#line 351 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp3_ = FALSE;
#line 351 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp5_ = i;
#line 351 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp6_ = devcap_object;
#line 351 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp7_ = _tmp6_->nodesetval;
#line 351 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp8_ = xmlXPathNodeSetGetLength (_tmp7_);
#line 351 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				if (!(_tmp5_ < _tmp8_)) {
#line 351 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					break;
#line 2003 "rygel-description-file.c"
				}
#line 352 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp9_ = devcap_object;
#line 352 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp10_ = _tmp9_->nodesetval;
#line 352 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp11_ = i;
#line 352 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp12_ = xmlXPathNodeSetItem (_tmp10_, _tmp11_);
#line 352 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				node = _tmp12_;
#line 353 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp13_ = node;
#line 353 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				if (_tmp13_ == NULL) {
#line 354 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					continue;
#line 2021 "rygel-description-file.c"
				}
#line 357 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp14_ = node;
#line 357 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				xmlUnlinkNode (_tmp14_);
#line 359 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp15_ = node;
#line 359 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				xmlFreeNode (_tmp15_);
#line 2031 "rygel-description-file.c"
			}
		}
	}
#line 362 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp16_ = devcap_object;
#line 362 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xmlXPathFreeObject (_tmp16_);
#line 2039 "rygel-description-file.c"
}


static xmlNode* rygel_description_file_get_device_element (RygelDescriptionFile* self) {
	xmlNode* result = NULL;
	GUPnPXMLDoc* _tmp0_ = NULL;
	xmlDoc* _tmp1_ = NULL;
	xmlNode* _tmp2_ = NULL;
#line 365 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 366 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = self->priv->doc;
#line 366 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp1_ = _tmp0_->doc;
#line 366 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp2_ = rygel_xml_utils_get_element ((xmlNode*) _tmp1_, "root", "device", NULL);
#line 366 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	result = _tmp2_;
#line 366 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	return result;
#line 2060 "rygel-description-file.c"
}


static gboolean rygel_description_file_apply_xpath (RygelDescriptionFile* self, const gchar* xpath, xmlXPathObject** xpo) {
	xmlXPathObject* _vala_xpo = NULL;
	gboolean result = FALSE;
	xmlXPathContext* context = NULL;
	GUPnPXMLDoc* _tmp0_ = NULL;
	xmlDoc* _tmp1_ = NULL;
	xmlXPathContext* _tmp2_ = NULL;
	xmlXPathObject* _result_ = NULL;
	xmlXPathContext* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	xmlXPathObject* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	xmlXPathObject* _tmp8_ = NULL;
	gboolean retval = FALSE;
	xmlXPathObject* _tmp14_ = NULL;
#line 372 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 372 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_val_if_fail (xpath != NULL, FALSE);
#line 373 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = self->priv->doc;
#line 373 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp1_ = _tmp0_->doc;
#line 373 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp2_ = xmlXPathNewContext (_tmp1_);
#line 373 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	context = _tmp2_;
#line 374 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp3_ = context;
#line 374 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp4_ = xpath;
#line 374 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp5_ = xmlXPathEvalExpression ((xmlChar*) _tmp4_, _tmp3_);
#line 374 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_result_ = _tmp5_;
#line 376 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp8_ = _result_;
#line 376 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if (_tmp8_ != NULL) {
#line 2104 "rygel-description-file.c"
		xmlXPathObject* _tmp9_ = NULL;
		xmlXPathObjectType _tmp10_ = 0;
#line 377 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp9_ = _result_;
#line 377 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp10_ = _tmp9_->type;
#line 377 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp7_ = _tmp10_ == XPATH_NODESET;
#line 2113 "rygel-description-file.c"
	} else {
#line 376 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp7_ = FALSE;
#line 2117 "rygel-description-file.c"
	}
#line 376 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if (_tmp7_) {
#line 2121 "rygel-description-file.c"
		xmlXPathObject* _tmp11_ = NULL;
		xmlNodeSet* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
#line 378 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp11_ = _result_;
#line 378 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp12_ = _tmp11_->nodesetval;
#line 378 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp13_ = xmlXPathNodeSetIsEmpty (_tmp12_);
#line 378 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp6_ = !_tmp13_;
#line 2133 "rygel-description-file.c"
	} else {
#line 376 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp6_ = FALSE;
#line 2137 "rygel-description-file.c"
	}
#line 376 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	retval = _tmp6_;
#line 380 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp14_ = _result_;
#line 380 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_vala_xpo = _tmp14_;
#line 382 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	result = retval;
#line 382 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_xmlXPathFreeContext0 (context);
#line 382 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if (xpo) {
#line 382 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		*xpo = _vala_xpo;
#line 2153 "rygel-description-file.c"
	}
#line 382 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	return result;
#line 2157 "rygel-description-file.c"
}


void rygel_description_file_add_service (RygelDescriptionFile* self, const gchar* device_name, RygelResourceInfo* resource_info) {
	xmlNode* list = NULL;
	GUPnPXMLDoc* _tmp0_ = NULL;
	xmlDoc* _tmp1_ = NULL;
	xmlNode* _tmp2_ = NULL;
	xmlNode* _tmp3_ = NULL;
	xmlNode* service_node = NULL;
	xmlNode* _tmp5_ = NULL;
	xmlNode* _tmp6_ = NULL;
	RygelResourceInfo* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	RygelResourceInfo* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* url = NULL;
	RygelResourceInfo* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	RygelResourceInfo* _tmp20_ = NULL;
	GType _tmp21_ = 0UL;
	const gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	RygelResourceInfo* _tmp30_ = NULL;
	GType _tmp31_ = 0UL;
	const gchar* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
#line 385 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (self != NULL);
#line 385 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (device_name != NULL);
#line 385 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (resource_info != NULL);
#line 386 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = self->priv->doc;
#line 386 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp1_ = _tmp0_->doc;
#line 386 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp2_ = rygel_xml_utils_get_element ((xmlNode*) _tmp1_, "root", "device", "serviceList", NULL);
#line 386 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	list = _tmp2_;
#line 391 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp3_ = list;
#line 391 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if (_tmp3_ == NULL) {
#line 2217 "rygel-description-file.c"
		xmlNode* _tmp4_ = NULL;
#line 392 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp4_ = rygel_description_file_set_device_element (self, "serviceList", NULL, NULL);
#line 392 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		list = _tmp4_;
#line 2223 "rygel-description-file.c"
	}
#line 395 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp5_ = list;
#line 395 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp6_ = xmlNewChild (_tmp5_, NULL, (xmlChar*) "service", (xmlChar*) NULL);
#line 395 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	service_node = _tmp6_;
#line 397 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp7_ = resource_info;
#line 397 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp8_ = _tmp7_->upnp_type;
#line 397 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xmlNewChild (service_node, NULL, (xmlChar*) "serviceType", (xmlChar*) _tmp8_);
#line 398 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp9_ = resource_info;
#line 398 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp10_ = _tmp9_->upnp_id;
#line 398 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xmlNewChild (service_node, NULL, (xmlChar*) "serviceId", (xmlChar*) _tmp10_);
#line 401 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp11_ = resource_info;
#line 401 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp12_ = _tmp11_->description_path;
#line 401 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp13_ = g_strconcat ("/", _tmp12_, NULL);
#line 401 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	url = _tmp13_;
#line 402 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp14_ = url;
#line 402 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xmlNewChild (service_node, NULL, (xmlChar*) "SCPDURL", (xmlChar*) _tmp14_);
#line 404 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp15_ = device_name;
#line 404 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp16_ = g_strconcat ("/Control/", _tmp15_, NULL);
#line 404 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp17_ = _tmp16_;
#line 404 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp18_ = g_strconcat (_tmp17_, "/", NULL);
#line 404 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp19_ = _tmp18_;
#line 404 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp20_ = resource_info;
#line 404 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp21_ = _tmp20_->type;
#line 404 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp22_ = g_type_name (_tmp21_);
#line 404 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp23_ = g_strconcat (_tmp19_, _tmp22_, NULL);
#line 404 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_free0 (url);
#line 404 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	url = _tmp23_;
#line 404 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_free0 (_tmp19_);
#line 404 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_free0 (_tmp17_);
#line 405 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp24_ = url;
#line 405 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xmlNewChild (service_node, NULL, (xmlChar*) "controlURL", (xmlChar*) _tmp24_);
#line 407 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp25_ = device_name;
#line 407 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp26_ = g_strconcat ("/Event/", _tmp25_, NULL);
#line 407 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp27_ = _tmp26_;
#line 407 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp28_ = g_strconcat (_tmp27_, "/", NULL);
#line 407 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp29_ = _tmp28_;
#line 407 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp30_ = resource_info;
#line 407 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp31_ = _tmp30_->type;
#line 407 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp32_ = g_type_name (_tmp31_);
#line 407 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp33_ = g_strconcat (_tmp29_, _tmp32_, NULL);
#line 407 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_free0 (url);
#line 407 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	url = _tmp33_;
#line 407 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_free0 (_tmp29_);
#line 407 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_free0 (_tmp27_);
#line 408 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp34_ = url;
#line 408 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xmlNewChild (service_node, NULL, (xmlChar*) "eventSubURL", (xmlChar*) _tmp34_);
#line 385 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_free0 (url);
#line 2317 "rygel-description-file.c"
}


void rygel_description_file_clear_icon_list (RygelDescriptionFile* self) {
#line 411 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (self != NULL);
#line 412 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	rygel_description_file_remove_device_element (self, "iconList");
#line 2326 "rygel-description-file.c"
}


void rygel_description_file_add_icon (RygelDescriptionFile* self, const gchar* device_name, RygelIconInfo* icon_info, const gchar* url) {
	xmlNode* list = NULL;
	GUPnPXMLDoc* _tmp0_ = NULL;
	xmlDoc* _tmp1_ = NULL;
	xmlNode* _tmp2_ = NULL;
	xmlNode* _tmp3_ = NULL;
	xmlNode* icon_node = NULL;
	xmlNode* _tmp5_ = NULL;
	xmlNode* _tmp6_ = NULL;
	gchar* width = NULL;
	RygelIconInfo* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gchar* _tmp9_ = NULL;
	gchar* height = NULL;
	RygelIconInfo* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gchar* _tmp12_ = NULL;
	gchar* depth = NULL;
	RygelIconInfo* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gchar* _tmp15_ = NULL;
	RygelIconInfo* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
#line 415 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (self != NULL);
#line 415 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (device_name != NULL);
#line 415 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (icon_info != NULL);
#line 415 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (url != NULL);
#line 418 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = self->priv->doc;
#line 418 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp1_ = _tmp0_->doc;
#line 418 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp2_ = rygel_xml_utils_get_element ((xmlNode*) _tmp1_, "root", "device", "iconList", NULL);
#line 418 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	list = _tmp2_;
#line 423 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp3_ = list;
#line 423 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if (_tmp3_ == NULL) {
#line 2374 "rygel-description-file.c"
		xmlNode* _tmp4_ = NULL;
#line 424 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp4_ = rygel_description_file_set_device_element (self, "iconList", NULL, NULL);
#line 424 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		list = _tmp4_;
#line 2380 "rygel-description-file.c"
	}
#line 427 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp5_ = list;
#line 427 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp6_ = xmlNewChild (_tmp5_, NULL, (xmlChar*) "icon", (xmlChar*) NULL);
#line 427 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	icon_node = _tmp6_;
#line 429 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp7_ = icon_info;
#line 429 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp8_ = _tmp7_->width;
#line 429 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp9_ = g_strdup_printf ("%i", _tmp8_);
#line 429 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	width = _tmp9_;
#line 430 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp10_ = icon_info;
#line 430 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp11_ = _tmp10_->height;
#line 430 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp12_ = g_strdup_printf ("%i", _tmp11_);
#line 430 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	height = _tmp12_;
#line 431 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp13_ = icon_info;
#line 431 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp14_ = _tmp13_->depth;
#line 431 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp15_ = g_strdup_printf ("%i", _tmp14_);
#line 431 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	depth = _tmp15_;
#line 433 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp16_ = icon_info;
#line 433 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp17_ = _tmp16_->mime_type;
#line 433 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xmlNewChild (icon_node, NULL, (xmlChar*) "mimetype", (xmlChar*) _tmp17_);
#line 434 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xmlNewChild (icon_node, NULL, (xmlChar*) "width", (xmlChar*) width);
#line 435 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xmlNewChild (icon_node, NULL, (xmlChar*) "height", (xmlChar*) height);
#line 436 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xmlNewChild (icon_node, NULL, (xmlChar*) "depth", (xmlChar*) depth);
#line 437 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp18_ = url;
#line 437 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xmlNewChild (icon_node, NULL, (xmlChar*) "url", (xmlChar*) _tmp18_);
#line 415 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_free0 (depth);
#line 415 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_free0 (height);
#line 415 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_free0 (width);
#line 2434 "rygel-description-file.c"
}


/**
     * Change the type of a service.
     *
     * Usually used to modify the service version, e.g. old_type =
     * "ContentDirectory:2" and new_type = "ContentDirectory:1".
     *
     * @param old_type is the current content of serviceType.
     * @param new_type is the content serviceType will be set to.
     */
void rygel_description_file_modify_service_type (RygelDescriptionFile* self, const gchar* old_type, const gchar* new_type) {
	xmlXPathObject* xpath_object = NULL;
	gchar* xpath = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	xmlXPathObject* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 449 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (self != NULL);
#line 449 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (old_type != NULL);
#line 449 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (new_type != NULL);
#line 451 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xpath_object = NULL;
#line 453 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = old_type;
#line 453 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp1_ = g_strdup_printf (RYGEL_DESCRIPTION_FILE_SERVICE_TYPE_TEMPLATE, _tmp0_);
#line 453 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xpath = _tmp1_;
#line 454 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp2_ = xpath;
#line 454 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp4_ = rygel_description_file_apply_xpath (self, _tmp2_, &_tmp3_);
#line 454 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xpath_object = _tmp3_;
#line 454 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if (_tmp4_) {
#line 2477 "rygel-description-file.c"
		xmlXPathObject* _tmp5_ = NULL;
		xmlNodeSet* _tmp6_ = NULL;
		xmlNode* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		xmlXPathObject* _tmp9_ = NULL;
#line 455 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp5_ = xpath_object;
#line 455 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp6_ = _tmp5_->nodesetval;
#line 455 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp7_ = xmlXPathNodeSetItem (_tmp6_, 0);
#line 455 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp8_ = new_type;
#line 455 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		xmlNodeSetContent (_tmp7_, (xmlChar*) _tmp8_);
#line 457 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp9_ = xpath_object;
#line 457 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		xmlXPathFreeObject (_tmp9_);
#line 2497 "rygel-description-file.c"
	}
#line 449 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_free0 (xpath);
#line 2501 "rygel-description-file.c"
}


/**
     * Writes the current document to a file.
     *
     * It makes sure that the resulting file has the correct UTF-8 encoding
     * and does not have any kind of newlines. This is necessary as some
     * devices with broken XML parsers can't cope with UNIX newlines.
     * If a file with the same name exists it will be overwritten.
     *
     * @param path is a path to a file.
     * @throws GLib.Error if anything fails while creating the XML dump.
     */
static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1282 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1282 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1282 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 2525 "rygel-description-file.c"
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 2556 "rygel-description-file.c"
				goto __catch6_g_regex_error;
			}
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			return NULL;
#line 2565 "rygel-description-file.c"
		}
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = regex;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp7_ = replacement;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = _tmp8_;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 2581 "rygel-description-file.c"
				goto __catch6_g_regex_error;
			}
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			return NULL;
#line 2592 "rygel-description-file.c"
		}
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp9_ = _tmp5_;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = NULL;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = _tmp9_;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_free0 (_tmp5_);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 2606 "rygel-description-file.c"
	}
	goto __finally6;
	__catch6_g_regex_error:
	{
		GError* e = NULL;
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1287 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 2620 "rygel-description-file.c"
	}
	__finally6:
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return NULL;
#line 2631 "rygel-description-file.c"
	}
}


void rygel_description_file_save (RygelDescriptionFile* self, const gchar* path, GError** error) {
	FILE* file = NULL;
	const gchar* _tmp0_ = NULL;
	FILE* _tmp1_ = NULL;
	gchar* message = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	FILE* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gchar* mem = NULL;
	gint len = 0;
	GUPnPXMLDoc* _tmp9_ = NULL;
	xmlDoc* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gboolean _tmp14_ = FALSE;
	FILE* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	GError * _inner_error_ = NULL;
#line 472 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (self != NULL);
#line 472 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (path != NULL);
#line 473 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = path;
#line 473 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp1_ = g_fopen (_tmp0_, "w+");
#line 473 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	file = _tmp1_;
#line 474 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp2_ = _ ("Failed to write modified description to %s");
#line 474 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 474 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	message = _tmp3_;
#line 476 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp4_ = file;
#line 476 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp5_ = G_UNLIKELY (_tmp4_ == NULL);
#line 476 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if (_tmp5_) {
#line 2680 "rygel-description-file.c"
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		GError* _tmp8_ = NULL;
#line 477 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp6_ = message;
#line 477 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp7_ = path;
#line 477 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp8_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, _tmp6_, _tmp7_);
#line 477 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_inner_error_ = _tmp8_;
#line 477 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		g_propagate_error (error, _inner_error_);
#line 477 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_g_free0 (message);
#line 477 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_fclose0 (file);
#line 477 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		return;
#line 2700 "rygel-description-file.c"
	}
#line 480 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	mem = NULL;
#line 481 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	len = -1;
#line 482 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp9_ = self->priv->doc;
#line 482 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp10_ = _tmp9_->doc;
#line 482 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xmlDocDumpMemoryEnc (_tmp10_, (xmlChar**) (&_tmp11_), &_tmp12_, "UTF-8");
#line 482 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_free0 (mem);
#line 482 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	mem = _tmp11_;
#line 482 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	len = _tmp12_;
#line 484 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp13_ = len;
#line 484 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp14_ = G_UNLIKELY (_tmp13_ <= 0);
#line 484 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if (_tmp14_) {
#line 2724 "rygel-description-file.c"
		const gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		GError* _tmp17_ = NULL;
#line 485 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp15_ = message;
#line 485 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp16_ = path;
#line 485 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp17_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, _tmp15_, _tmp16_);
#line 485 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_inner_error_ = _tmp17_;
#line 485 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		g_propagate_error (error, _inner_error_);
#line 485 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_g_free0 (mem);
#line 485 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_g_free0 (message);
#line 485 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_fclose0 (file);
#line 485 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		return;
#line 2746 "rygel-description-file.c"
	}
#line 489 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp18_ = file;
#line 489 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp19_ = mem;
#line 489 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp20_ = string_replace (_tmp19_, "\n", "");
#line 489 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp21_ = _tmp20_;
#line 489 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	fputs (_tmp21_, _tmp18_);
#line 489 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_free0 (_tmp21_);
#line 472 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_free0 (mem);
#line 472 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_free0 (message);
#line 472 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_fclose0 (file);
#line 2766 "rygel-description-file.c"
}


static gint rygel_description_file_index_of_device_element (RygelDescriptionFile* self, const gchar* element) {
	gint result = 0;
#line 492 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 492 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_val_if_fail (element != NULL, 0);
#line 2776 "rygel-description-file.c"
	{
		gint i = 0;
#line 493 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		i = 0;
#line 2781 "rygel-description-file.c"
		{
			gboolean _tmp0_ = FALSE;
#line 493 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_tmp0_ = TRUE;
#line 493 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			while (TRUE) {
#line 2788 "rygel-description-file.c"
				gint _tmp2_ = 0;
				gchar** _tmp3_ = NULL;
				gint _tmp3__length1 = 0;
				gchar** _tmp4_ = NULL;
				gint _tmp4__length1 = 0;
				gint _tmp5_ = 0;
				const gchar* _tmp6_ = NULL;
				const gchar* _tmp7_ = NULL;
#line 493 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				if (!_tmp0_) {
#line 2799 "rygel-description-file.c"
					gint _tmp1_ = 0;
#line 493 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					_tmp1_ = i;
#line 493 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					i = _tmp1_ + 1;
#line 2805 "rygel-description-file.c"
				}
#line 493 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp0_ = FALSE;
#line 493 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp2_ = i;
#line 493 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp3_ = self->priv->device_elements;
#line 493 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp3__length1 = self->priv->device_elements_length1;
#line 493 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				if (!(_tmp2_ < _tmp3__length1)) {
#line 493 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					break;
#line 2819 "rygel-description-file.c"
				}
#line 494 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp4_ = self->priv->device_elements;
#line 494 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp4__length1 = self->priv->device_elements_length1;
#line 494 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp5_ = i;
#line 494 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp6_ = _tmp4_[_tmp5_];
#line 494 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp7_ = element;
#line 494 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				if (g_strcmp0 (_tmp6_, _tmp7_) == 0) {
#line 495 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					result = i;
#line 495 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					return result;
#line 2837 "rygel-description-file.c"
				}
			}
		}
	}
#line 499 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	result = -1;
#line 499 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	return result;
#line 2846 "rygel-description-file.c"
}


/**
     * Internal helper function to set an element to a new value,
     * creating it if needed.
     *
     * @param element below /root/device to be set.
     * @param new_value is the new content of that element.
     *
     * @returns the element that was modified (or created) or null
     */
static xmlNode* rygel_description_file_set_device_element (RygelDescriptionFile* self, const gchar* element, const gchar* new_value, const gchar* ns) {
	xmlNode* result = NULL;
	xmlNode* xml_element = NULL;
	GUPnPXMLDoc* _tmp0_ = NULL;
	xmlDoc* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	xmlNode* _tmp3_ = NULL;
	xmlNode* _tmp4_ = NULL;
	xmlNode* device_element = NULL;
	GUPnPXMLDoc* _tmp8_ = NULL;
	xmlDoc* _tmp9_ = NULL;
	xmlNode* _tmp10_ = NULL;
	xmlNs* xml_ns = NULL;
	const gchar* _tmp11_ = NULL;
	xmlNode* _tmp17_ = NULL;
	xmlNs* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	xmlNode* _tmp21_ = NULL;
	gint index = 0;
	const gchar* _tmp22_ = NULL;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	xmlNode* _tmp46_ = NULL;
#line 511 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 511 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_val_if_fail (element != NULL, NULL);
#line 514 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = self->priv->doc;
#line 514 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp1_ = _tmp0_->doc;
#line 514 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp2_ = element;
#line 514 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp3_ = rygel_xml_utils_get_element ((xmlNode*) _tmp1_, "root", "device", _tmp2_, NULL);
#line 514 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xml_element = _tmp3_;
#line 519 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp4_ = xml_element;
#line 519 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if (_tmp4_ != NULL) {
#line 2901 "rygel-description-file.c"
		xmlNode* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		xmlNode* _tmp7_ = NULL;
#line 520 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp5_ = xml_element;
#line 520 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp6_ = new_value;
#line 520 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		xmlNodeSetContent (_tmp5_, (xmlChar*) _tmp6_);
#line 521 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp7_ = xml_element;
#line 521 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		result = _tmp7_;
#line 521 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		return result;
#line 2917 "rygel-description-file.c"
	}
#line 525 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp8_ = self->priv->doc;
#line 525 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp9_ = _tmp8_->doc;
#line 525 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp10_ = rygel_xml_utils_get_element ((xmlNode*) _tmp9_, "root", "device", NULL);
#line 525 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	device_element = _tmp10_;
#line 530 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xml_ns = NULL;
#line 531 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp11_ = ns;
#line 531 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if (_tmp11_ != NULL) {
#line 2933 "rygel-description-file.c"
		GUPnPXMLDoc* _tmp12_ = NULL;
		xmlDoc* _tmp13_ = NULL;
		xmlNode* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		xmlNs* _tmp16_ = NULL;
#line 532 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp12_ = self->priv->doc;
#line 532 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp13_ = _tmp12_->doc;
#line 532 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp14_ = device_element;
#line 532 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp15_ = ns;
#line 532 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp16_ = xmlSearchNs (_tmp13_, _tmp14_, _tmp15_);
#line 532 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		xml_ns = _tmp16_;
#line 2951 "rygel-description-file.c"
	}
#line 535 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp17_ = device_element;
#line 535 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp18_ = xml_ns;
#line 535 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp19_ = element;
#line 535 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp20_ = new_value;
#line 535 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp21_ = xmlNewChild (_tmp17_, _tmp18_, (xmlChar*) _tmp19_, (xmlChar*) _tmp20_);
#line 535 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xml_element = _tmp21_;
#line 538 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp22_ = element;
#line 538 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp23_ = rygel_description_file_index_of_device_element (self, _tmp22_);
#line 538 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	index = _tmp23_;
#line 539 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp24_ = index;
#line 539 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if (_tmp24_ > (-1)) {
#line 2975 "rygel-description-file.c"
		xmlNode* sibling = NULL;
		xmlNode* _tmp39_ = NULL;
#line 541 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		sibling = NULL;
#line 2980 "rygel-description-file.c"
		{
			gint _tmp25_ = 0;
			gboolean _tmp26_ = FALSE;
#line 542 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_tmp25_ = index;
#line 542 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			index = _tmp25_ - 1;
#line 542 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_tmp26_ = TRUE;
#line 542 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			while (TRUE) {
#line 2992 "rygel-description-file.c"
				gint _tmp28_ = 0;
				GUPnPXMLDoc* _tmp29_ = NULL;
				xmlDoc* _tmp30_ = NULL;
				gchar** _tmp31_ = NULL;
				gint _tmp31__length1 = 0;
				gint _tmp32_ = 0;
				const gchar* _tmp33_ = NULL;
				xmlNode* _tmp34_ = NULL;
				xmlNode* _tmp35_ = NULL;
#line 542 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				if (!_tmp26_) {
#line 3004 "rygel-description-file.c"
					gint _tmp27_ = 0;
#line 542 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					_tmp27_ = index;
#line 542 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					index = _tmp27_ - 1;
#line 3010 "rygel-description-file.c"
				}
#line 542 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp26_ = FALSE;
#line 542 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp28_ = index;
#line 542 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				if (!(_tmp28_ > 0)) {
#line 542 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					break;
#line 3020 "rygel-description-file.c"
				}
#line 543 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp29_ = self->priv->doc;
#line 543 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp30_ = _tmp29_->doc;
#line 543 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp31_ = self->priv->device_elements;
#line 543 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp31__length1 = self->priv->device_elements_length1;
#line 543 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp32_ = index;
#line 543 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp33_ = _tmp31_[_tmp32_];
#line 543 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp34_ = rygel_xml_utils_get_element ((xmlNode*) _tmp30_, "root", "device", _tmp33_, NULL);
#line 543 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				sibling = _tmp34_;
#line 548 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp35_ = sibling;
#line 548 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				if (_tmp35_ != NULL) {
#line 3042 "rygel-description-file.c"
					xmlNode* _tmp36_ = NULL;
					xmlNode* _tmp37_ = NULL;
					xmlNode* _tmp38_ = NULL;
#line 549 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					_tmp36_ = sibling;
#line 549 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					_tmp37_ = xml_element;
#line 549 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					_tmp38_ = xmlAddNextSibling (_tmp36_, _tmp37_);
#line 549 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					xml_element = _tmp38_;
#line 551 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
					break;
#line 3056 "rygel-description-file.c"
				}
			}
		}
#line 555 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp39_ = sibling;
#line 555 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		if (_tmp39_ == NULL) {
#line 3064 "rygel-description-file.c"
			xmlNode* _tmp40_ = NULL;
			xmlNode* _tmp41_ = NULL;
			xmlNode* _tmp42_ = NULL;
#line 557 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_tmp40_ = device_element;
#line 557 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_tmp41_ = xmlFirstElementChild (_tmp40_);
#line 557 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			sibling = _tmp41_;
#line 558 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			_tmp42_ = sibling;
#line 558 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
			if (_tmp42_ != NULL) {
#line 3078 "rygel-description-file.c"
				xmlNode* _tmp43_ = NULL;
				xmlNode* _tmp44_ = NULL;
				xmlNode* _tmp45_ = NULL;
#line 559 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp43_ = sibling;
#line 559 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp44_ = xml_element;
#line 559 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				_tmp45_ = xmlAddPrevSibling (_tmp43_, _tmp44_);
#line 559 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
				xml_element = _tmp45_;
#line 3090 "rygel-description-file.c"
			}
		}
	}
#line 564 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp46_ = xml_element;
#line 564 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	result = _tmp46_;
#line 564 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	return result;
#line 3100 "rygel-description-file.c"
}


/**
     * Internal helper function to remove an element (if it exists).
     *
     * @param element below /root/device to be removed.
     */
static void rygel_description_file_remove_device_element (RygelDescriptionFile* self, const gchar* element) {
	xmlNode* xml_element = NULL;
	GUPnPXMLDoc* _tmp0_ = NULL;
	xmlDoc* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	xmlNode* _tmp3_ = NULL;
	xmlNode* _tmp4_ = NULL;
#line 572 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (self != NULL);
#line 572 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_return_if_fail (element != NULL);
#line 573 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = self->priv->doc;
#line 573 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp1_ = _tmp0_->doc;
#line 573 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp2_ = element;
#line 573 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp3_ = rygel_xml_utils_get_element ((xmlNode*) _tmp1_, "root", "device", _tmp2_, NULL);
#line 573 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	xml_element = _tmp3_;
#line 578 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp4_ = xml_element;
#line 578 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	if (_tmp4_ != NULL) {
#line 3134 "rygel-description-file.c"
		xmlNode* _tmp5_ = NULL;
		xmlNode* _tmp6_ = NULL;
#line 579 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp5_ = xml_element;
#line 579 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		xmlUnlinkNode (_tmp5_);
#line 580 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		_tmp6_ = xml_element;
#line 580 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
		xmlFreeNode (_tmp6_);
#line 3145 "rygel-description-file.c"
	}
}


static void rygel_description_file_class_init (RygelDescriptionFileClass * klass) {
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	rygel_description_file_parent_class = g_type_class_peek_parent (klass);
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	g_type_class_add_private (klass, sizeof (RygelDescriptionFilePrivate));
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_description_file_finalize;
#line 3157 "rygel-description-file.c"
}


static void rygel_description_file_instance_init (RygelDescriptionFile * self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar** _tmp15_ = NULL;
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	self->priv = RYGEL_DESCRIPTION_FILE_GET_PRIVATE (self);
#line 34 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp0_ = g_strdup ("deviceType");
#line 34 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp1_ = g_strdup ("friendlyName");
#line 34 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp2_ = g_strdup ("manufacturer");
#line 34 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp3_ = g_strdup ("manufacturerURL");
#line 34 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp4_ = g_strdup ("modelDescription");
#line 34 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp5_ = g_strdup ("modelName");
#line 34 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp6_ = g_strdup ("modelNumber");
#line 34 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp7_ = g_strdup ("modelURL");
#line 34 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp8_ = g_strdup ("serialNumber");
#line 34 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp9_ = g_strdup ("UDN");
#line 34 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp10_ = g_strdup ("UPC");
#line 34 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp11_ = g_strdup ("iconList");
#line 34 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp12_ = g_strdup ("serviceList");
#line 34 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp13_ = g_strdup ("deviceList");
#line 34 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp14_ = g_strdup ("presentationURL");
#line 34 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp15_ = g_new0 (gchar*, 15 + 1);
#line 34 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp15_[0] = _tmp0_;
#line 34 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp15_[1] = _tmp1_;
#line 34 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp15_[2] = _tmp2_;
#line 34 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp15_[3] = _tmp3_;
#line 34 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp15_[4] = _tmp4_;
#line 34 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp15_[5] = _tmp5_;
#line 34 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp15_[6] = _tmp6_;
#line 34 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp15_[7] = _tmp7_;
#line 34 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp15_[8] = _tmp8_;
#line 34 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp15_[9] = _tmp9_;
#line 34 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp15_[10] = _tmp10_;
#line 34 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp15_[11] = _tmp11_;
#line 34 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp15_[12] = _tmp12_;
#line 34 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp15_[13] = _tmp13_;
#line 34 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_tmp15_[14] = _tmp14_;
#line 34 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	self->priv->device_elements = _tmp15_;
#line 34 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	self->priv->device_elements_length1 = 15;
#line 34 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	self->priv->_device_elements_size_ = self->priv->device_elements_length1;
#line 3248 "rygel-description-file.c"
}


static void rygel_description_file_finalize (GObject* obj) {
	RygelDescriptionFile * self;
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_DESCRIPTION_FILE, RygelDescriptionFile);
#line 34 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	self->priv->device_elements = (_vala_array_free (self->priv->device_elements, self->priv->device_elements_length1, (GDestroyNotify) g_free), NULL);
#line 53 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	_g_object_unref0 (self->priv->doc);
#line 32 "/home/jens/Source/rygel/src/librygel-core/rygel-description-file.vala"
	G_OBJECT_CLASS (rygel_description_file_parent_class)->finalize (obj);
#line 3262 "rygel-description-file.c"
}


/**
 * Represents a device description document and offers methods for easy
 * manipulation of those.
 */
GType rygel_description_file_get_type (void) {
	static volatile gsize rygel_description_file_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_description_file_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelDescriptionFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_description_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelDescriptionFile), 0, (GInstanceInitFunc) rygel_description_file_instance_init, NULL };
		GType rygel_description_file_type_id;
		rygel_description_file_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelDescriptionFile", &g_define_type_info, 0);
		g_once_init_leave (&rygel_description_file_type_id__volatile, rygel_description_file_type_id);
	}
	return rygel_description_file_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



