/* rygel-energy-management.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-energy-management.vala, do not modify */

/*
 * Copyright (C) 2013 Intel Corporation.
 *
 * Author: Jussi Kukkonen <jussi.kukkonen@intel.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
/* EnergyManagement service implementation. The service will be run on
 * plugins that have
 *     energy-management=true
 * set in their configuration. It requires UPower to function properly.
 *
 * Every network interface that supports Wake-On should have a
 * configuration group:
 *     [EnergyManagement-eth0]
 *     mode-on-suspend=IP-down-WakeOn
 *     supported-transport=UDP-Broadcast
 *     password=FEEDDEADBEEF
 * mode-on-suspend is required (without it the mode will always be
 * "Unimplemented"), other configuration items are not.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <stdlib.h>
#include <gee.h>
#include <libgssdp/gssdp.h>
#include <glib/gi18n-lib.h>


#define TYPE_UPOWER (upower_get_type ())
#define UPOWER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UPOWER, UPower))
#define IS_UPOWER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UPOWER))
#define UPOWER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_UPOWER, UPowerIface))

typedef struct _UPower UPower;
typedef struct _UPowerIface UPowerIface;

#define TYPE_UPOWER_PROXY (upower_proxy_get_type ())
typedef GDBusProxy UPowerProxy;
typedef GDBusProxyClass UPowerProxyClass;

#define RYGEL_TYPE_ENERGY_MANAGEMENT (rygel_energy_management_get_type ())
#define RYGEL_ENERGY_MANAGEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ENERGY_MANAGEMENT, RygelEnergyManagement))
#define RYGEL_ENERGY_MANAGEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ENERGY_MANAGEMENT, RygelEnergyManagementClass))
#define RYGEL_IS_ENERGY_MANAGEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ENERGY_MANAGEMENT))
#define RYGEL_IS_ENERGY_MANAGEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ENERGY_MANAGEMENT))
#define RYGEL_ENERGY_MANAGEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ENERGY_MANAGEMENT, RygelEnergyManagementClass))

typedef struct _RygelEnergyManagement RygelEnergyManagement;
typedef struct _RygelEnergyManagementClass RygelEnergyManagementClass;
typedef struct _RygelEnergyManagementPrivate RygelEnergyManagementPrivate;

#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_META_CONFIG (rygel_meta_config_get_type ())
#define RYGEL_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfig))
#define RYGEL_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))
#define RYGEL_IS_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_META_CONFIG))
#define RYGEL_IS_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_META_CONFIG))
#define RYGEL_META_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))

typedef struct _RygelMetaConfig RygelMetaConfig;
typedef struct _RygelMetaConfigClass RygelMetaConfigClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _UPowerIface {
	GTypeInterface parent_iface;
};

struct _RygelEnergyManagement {
	GUPnPService parent_instance;
	RygelEnergyManagementPrivate * priv;
};

struct _RygelEnergyManagementClass {
	GUPnPServiceClass parent_class;
};

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gboolean (*get_upnp_enabled) (RygelConfiguration* self, GError** error);
	gchar* (*get_interface) (RygelConfiguration* self, GError** error);
	gchar** (*get_interfaces) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_upload) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_deletion) (RygelConfiguration* self, GError** error);
	gchar* (*get_log_levels) (RygelConfiguration* self, GError** error);
	gchar* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_engine_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_media_engine) (RygelConfiguration* self, GError** error);
	gchar* (*get_video_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_music_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_picture_upload_folder) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_title) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_string) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
};

struct _RygelEnergyManagementPrivate {
	RygelConfiguration* config;
	gboolean sleeping;
	UPower* upower;
};


static gpointer rygel_energy_management_parent_class = NULL;

GType upower_get_type (void) G_GNUC_CONST;
GType upower_proxy_get_type (void) G_GNUC_CONST;
guint upower_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
static void upower_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_upower_sleeping (UPower* self, GVariant* parameters);
static void _dbus_handle_upower_resuming (UPower* self, GVariant* parameters);
static void upower_proxy_upower_interface_init (UPowerIface* iface);
static void upower_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* upower_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean upower_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_upower_sleeping (GObject* _sender, gpointer* _data);
static void _dbus_upower_resuming (GObject* _sender, gpointer* _data);
static void _upower_unregister_object (gpointer user_data);
GType rygel_energy_management_get_type (void) G_GNUC_CONST;
GType rygel_configuration_get_type (void) G_GNUC_CONST;
#define RYGEL_ENERGY_MANAGEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_ENERGY_MANAGEMENT, RygelEnergyManagementPrivate))
enum  {
	RYGEL_ENERGY_MANAGEMENT_DUMMY_PROPERTY
};
#define RYGEL_ENERGY_MANAGEMENT_UPNP_ID "urn:upnp-org:serviceId:EnergyManagement"
#define RYGEL_ENERGY_MANAGEMENT_UPNP_TYPE "urn:schemas-upnp-org:service:EnergyManagement:1"
#define RYGEL_ENERGY_MANAGEMENT_DESCRIPTION_PATH "xml/EnergyManagement.xml"
#define RYGEL_ENERGY_MANAGEMENT_TEMPLATE "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" "<NetworkInterfaceInfo xsi:schemaLocation=\"urn:schemas-upnp-org:lp:em-" \
"NetworkInterfaceInfo http://www.upnp.org/schemas/lp/em-NetworkInterfac" \
"eInfo.xsd\" " "                      xmlns=\"urn:schemas-upnp-org:lp:em-NetworkInterf" \
"aceInfo\" " "                      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-ins" \
"tance\">" "%s" "</NetworkInterfaceInfo>"
static void rygel_energy_management_real_constructed (GObject* base);
GType rygel_meta_config_get_type (void) G_GNUC_CONST;
RygelMetaConfig* rygel_meta_config_get_default (void);
static void rygel_energy_management_upower_sleeping_cb (RygelEnergyManagement* self);
static void _rygel_energy_management_upower_sleeping_cb_upower_sleeping (UPower* _sender, gpointer self);
static void rygel_energy_management_upower_resuming_cb (RygelEnergyManagement* self);
static void _rygel_energy_management_upower_resuming_cb_upower_resuming (UPower* _sender, gpointer self);
static void rygel_energy_management_query_network_interface_info_cb (RygelEnergyManagement* self, GUPnPService* em, const gchar* var, GValue* val);
static void _rygel_energy_management_query_network_interface_info_cb_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_energy_management_query_proxied_network_interface_info_cb (RygelEnergyManagement* self, GUPnPService* em, const gchar* var, GValue* val);
static void _rygel_energy_management_query_proxied_network_interface_info_cb_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_energy_management_get_interface_info_cb (RygelEnergyManagement* self, GUPnPService* em, GUPnPServiceAction* action);
static void _rygel_energy_management_get_interface_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static gchar* rygel_energy_management_create_network_interface_info (RygelEnergyManagement* self);
gboolean rygel_energy_management_get_mac_and_network_type (const gchar* iface, gchar** mac, gchar** type);
gchar* rygel_configuration_get_string (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
static gchar* rygel_energy_management_create_proxied_network_interface_info (RygelEnergyManagement* self);
RygelEnergyManagement* rygel_energy_management_new (void);
RygelEnergyManagement* rygel_energy_management_construct (GType object_type);
static void rygel_energy_management_finalize (GObject* obj);

static const GDBusMethodInfo * const _upower_dbus_method_info[] = {NULL};
static const GDBusArgInfo * const _upower_dbus_arg_info_sleeping[] = {NULL};
static const GDBusSignalInfo _upower_dbus_signal_info_sleeping = {-1, "Sleeping", (GDBusArgInfo **) (&_upower_dbus_arg_info_sleeping)};
static const GDBusArgInfo * const _upower_dbus_arg_info_resuming[] = {NULL};
static const GDBusSignalInfo _upower_dbus_signal_info_resuming = {-1, "Resuming", (GDBusArgInfo **) (&_upower_dbus_arg_info_resuming)};
static const GDBusSignalInfo * const _upower_dbus_signal_info[] = {&_upower_dbus_signal_info_sleeping, &_upower_dbus_signal_info_resuming, NULL};
static const GDBusPropertyInfo * const _upower_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _upower_dbus_interface_info = {-1, "org.freedesktop.UPower", (GDBusMethodInfo **) (&_upower_dbus_method_info), (GDBusSignalInfo **) (&_upower_dbus_signal_info), (GDBusPropertyInfo **) (&_upower_dbus_property_info)};
static const GDBusInterfaceVTable _upower_dbus_interface_vtable = {upower_dbus_interface_method_call, upower_dbus_interface_get_property, upower_dbus_interface_set_property};

static void upower_base_init (UPowerIface * iface) {
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	static gboolean initialized = FALSE;
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	if (!initialized) {
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		initialized = TRUE;
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		g_signal_new ("sleeping", TYPE_UPOWER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 44 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		g_signal_new ("resuming", TYPE_UPOWER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 209 "rygel-energy-management.c"
	}
}


GType upower_get_type (void) {
	static volatile gsize upower_type_id__volatile = 0;
	if (g_once_init_enter (&upower_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UPowerIface), (GBaseInitFunc) upower_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType upower_type_id;
		upower_type_id = g_type_register_static (G_TYPE_INTERFACE, "UPower", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (upower_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (upower_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) upower_proxy_get_type);
		g_type_set_qdata (upower_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.UPower");
		g_type_set_qdata (upower_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_upower_dbus_interface_info));
		g_type_set_qdata (upower_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) upower_register_object);
		g_once_init_leave (&upower_type_id__volatile, upower_type_id);
	}
	return upower_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (UPowerProxy, upower_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_UPOWER, upower_proxy_upower_interface_init) )
static void upower_proxy_class_init (UPowerProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = upower_proxy_g_signal;
}


static void _dbus_handle_upower_sleeping (UPower* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_signal_emit_by_name (self, "sleeping");
}


static void _dbus_handle_upower_resuming (UPower* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_signal_emit_by_name (self, "resuming");
}


static void upower_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "Sleeping") == 0) {
		_dbus_handle_upower_sleeping ((UPower*) proxy, parameters);
	} else if (strcmp (signal_name, "Resuming") == 0) {
		_dbus_handle_upower_resuming ((UPower*) proxy, parameters);
	}
}


static void upower_proxy_init (UPowerProxy* self) {
}


static void upower_proxy_upower_interface_init (UPowerIface* iface) {
}


static void upower_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}


static GVariant* upower_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean upower_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_upower_sleeping (GObject* _sender, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.UPower", "Sleeping", _arguments, NULL);
}


static void _dbus_upower_resuming (GObject* _sender, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.UPower", "Resuming", _arguments, NULL);
}


guint upower_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_upower_dbus_interface_info), &_upower_dbus_interface_vtable, data, _upower_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "sleeping", (GCallback) _dbus_upower_sleeping, data);
	g_signal_connect (object, "resuming", (GCallback) _dbus_upower_resuming, data);
	return result;
}


static void _upower_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_upower_sleeping, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_upower_resuming, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static void _rygel_energy_management_upower_sleeping_cb_upower_sleeping (UPower* _sender, gpointer self) {
#line 82 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	rygel_energy_management_upower_sleeping_cb ((RygelEnergyManagement*) self);
#line 353 "rygel-energy-management.c"
}


static void _rygel_energy_management_upower_resuming_cb_upower_resuming (UPower* _sender, gpointer self) {
#line 83 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	rygel_energy_management_upower_resuming_cb ((RygelEnergyManagement*) self);
#line 360 "rygel-energy-management.c"
}


static void _rygel_energy_management_query_network_interface_info_cb_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
#line 88 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	rygel_energy_management_query_network_interface_info_cb ((RygelEnergyManagement*) self, _sender, variable, value);
#line 367 "rygel-energy-management.c"
}


static void _rygel_energy_management_query_proxied_network_interface_info_cb_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
#line 90 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	rygel_energy_management_query_proxied_network_interface_info_cb ((RygelEnergyManagement*) self, _sender, variable, value);
#line 374 "rygel-energy-management.c"
}


static void _rygel_energy_management_get_interface_info_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 93 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	rygel_energy_management_get_interface_info_cb ((RygelEnergyManagement*) self, _sender, action);
#line 381 "rygel-energy-management.c"
}


static void rygel_energy_management_real_constructed (GObject* base) {
	RygelEnergyManagement * self;
	RygelMetaConfig* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
#line 68 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	self = (RygelEnergyManagement*) base;
#line 69 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	G_OBJECT_CLASS (rygel_energy_management_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gupnp_service_get_type (), GUPnPService));
#line 71 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp0_ = rygel_meta_config_get_default ();
#line 71 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_g_object_unref0 (self->priv->config);
#line 71 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	self->priv->config = (RygelConfiguration*) _tmp0_;
#line 73 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	self->priv->sleeping = FALSE;
#line 401 "rygel-energy-management.c"
	{
		UPower* _tmp1_ = NULL;
		UPower* _tmp2_ = NULL;
		UPower* _tmp3_ = NULL;
		UPower* _tmp4_ = NULL;
		UPower* _tmp5_ = NULL;
#line 77 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_tmp2_ = g_initable_new (TYPE_UPOWER_PROXY, NULL, &_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", "org.freedesktop.UPower", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/org/freedesktop/UPower", "g-interface-name", "org.freedesktop.UPower", "g-interface-info", g_type_get_qdata (TYPE_UPOWER, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
#line 77 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_tmp1_ = (UPower*) _tmp2_;
#line 77 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 77 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 416 "rygel-energy-management.c"
				goto __catch7_g_io_error;
			}
#line 77 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 77 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
			g_clear_error (&_inner_error_);
#line 77 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
			return;
#line 425 "rygel-energy-management.c"
		}
#line 77 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_tmp3_ = _tmp1_;
#line 77 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_tmp1_ = NULL;
#line 77 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_g_object_unref0 (self->priv->upower);
#line 77 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		self->priv->upower = _tmp3_;
#line 82 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_tmp4_ = self->priv->upower;
#line 82 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		g_signal_connect_object (_tmp4_, "sleeping", (GCallback) _rygel_energy_management_upower_sleeping_cb_upower_sleeping, self, 0);
#line 83 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_tmp5_ = self->priv->upower;
#line 83 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		g_signal_connect_object (_tmp5_, "resuming", (GCallback) _rygel_energy_management_upower_resuming_cb_upower_resuming, self, 0);
#line 76 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_g_object_unref0 (_tmp1_);
#line 445 "rygel-energy-management.c"
	}
	goto __finally7;
	__catch7_g_io_error:
	{
		GError* err = NULL;
#line 76 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		err = _inner_error_;
#line 76 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_inner_error_ = NULL;
#line 76 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_g_error_free0 (err);
#line 457 "rygel-energy-management.c"
	}
	__finally7:
#line 76 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 76 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 76 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		g_clear_error (&_inner_error_);
#line 76 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		return;
#line 468 "rygel-energy-management.c"
	}
#line 88 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	g_signal_connect_object ((GUPnPService*) self, "query-variable::NetworkInterfaceInfo", (GCallback) _rygel_energy_management_query_network_interface_info_cb_gupnp_service_query_variable, self, 0);
#line 90 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	g_signal_connect_object ((GUPnPService*) self, "query-variable::ProxiedNetworkInterfaceInfo", (GCallback) _rygel_energy_management_query_proxied_network_interface_info_cb_gupnp_service_query_variable, self, 0);
#line 93 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetInterfaceInfo", (GCallback) _rygel_energy_management_get_interface_info_cb_gupnp_service_action_invoked, self, 0);
#line 476 "rygel-energy-management.c"
}


static void rygel_energy_management_upower_sleeping_cb (RygelEnergyManagement* self) {
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 97 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	g_return_if_fail (self != NULL);
#line 98 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp0_ = self->priv->sleeping;
#line 98 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	if (_tmp0_ == TRUE) {
#line 99 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		return;
#line 492 "rygel-energy-management.c"
	}
#line 102 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	self->priv->sleeping = TRUE;
#line 103 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp1_ = rygel_energy_management_create_network_interface_info (self);
#line 103 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp2_ = _tmp1_;
#line 103 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	gupnp_service_notify ((GUPnPService*) self, "NetworkInterfaceInfo", G_TYPE_STRING, _tmp2_, NULL);
#line 103 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_g_free0 (_tmp2_);
#line 504 "rygel-energy-management.c"
}


static void rygel_energy_management_upower_resuming_cb (RygelEnergyManagement* self) {
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 108 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	g_return_if_fail (self != NULL);
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp0_ = self->priv->sleeping;
#line 109 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	if (_tmp0_ == FALSE) {
#line 110 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		return;
#line 520 "rygel-energy-management.c"
	}
#line 113 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	self->priv->sleeping = FALSE;
#line 114 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp1_ = rygel_energy_management_create_network_interface_info (self);
#line 114 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp2_ = _tmp1_;
#line 114 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	gupnp_service_notify ((GUPnPService*) self, "NetworkInterfaceInfo", G_TYPE_STRING, _tmp2_, NULL);
#line 114 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_g_free0 (_tmp2_);
#line 532 "rygel-energy-management.c"
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1282 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1282 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1282 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 545 "rygel-energy-management.c"
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 576 "rygel-energy-management.c"
				goto __catch8_g_regex_error;
			}
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1284 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			return NULL;
#line 585 "rygel-energy-management.c"
		}
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = regex;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp7_ = replacement;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = _tmp8_;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 601 "rygel-energy-management.c"
				goto __catch8_g_regex_error;
			}
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
			return NULL;
#line 612 "rygel-energy-management.c"
		}
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp9_ = _tmp5_;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = NULL;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = _tmp9_;
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_free0 (_tmp5_);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1285 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 626 "rygel-energy-management.c"
	}
	goto __finally8;
	__catch8_g_regex_error:
	{
		GError* e = NULL;
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1287 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 640 "rygel-energy-management.c"
	}
	__finally8:
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1283 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return NULL;
#line 651 "rygel-energy-management.c"
	}
}


static gchar* rygel_energy_management_create_network_interface_info (RygelEnergyManagement* self) {
	gchar* result = NULL;
	gchar* mac_address = NULL;
	gchar* type = NULL;
	gboolean success = FALSE;
	gchar* iface = NULL;
	GUPnPRootDevice* _tmp0_ = NULL;
	GUPnPRootDevice* _tmp1_ = NULL;
	GUPnPRootDevice* _tmp2_ = NULL;
	GUPnPContext* _tmp3_ = NULL;
	GUPnPContext* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* config_section = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	gchar* mac = NULL;
	gchar* _tmp13_ = NULL;
	gchar* wake_pattern = NULL;
	gchar* _tmp14_ = NULL;
	GInetAddress* ip_addr = NULL;
	GUPnPRootDevice* _tmp19_ = NULL;
	GUPnPRootDevice* _tmp20_ = NULL;
	GUPnPRootDevice* _tmp21_ = NULL;
	GUPnPContext* _tmp22_ = NULL;
	GUPnPContext* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	GInetAddress* _tmp26_ = NULL;
	GInetAddress* _tmp27_ = NULL;
	gboolean _tmp28_ = FALSE;
	GInetAddress* _tmp29_ = NULL;
	gboolean is_ipv6 = FALSE;
	gint _tmp33_ = 0;
	gboolean _tmp34_ = FALSE;
	gint _tmp35_ = 0;
	gboolean _tmp36_ = FALSE;
	gchar* associated_ips = NULL;
	GUPnPRootDevice* _tmp37_ = NULL;
	GUPnPRootDevice* _tmp38_ = NULL;
	GUPnPRootDevice* _tmp39_ = NULL;
	GUPnPContext* _tmp40_ = NULL;
	GUPnPContext* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	const gchar* _tmp43_ = NULL;
	gchar* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	gchar* mode = NULL;
	gboolean _tmp46_ = FALSE;
	gboolean _tmp47_ = FALSE;
	gchar* transport_node = NULL;
	gchar* device_info = NULL;
	GUPnPRootDevice* _tmp61_ = NULL;
	GUPnPRootDevice* _tmp62_ = NULL;
	GUPnPRootDevice* _tmp63_ = NULL;
	const gchar* _tmp64_ = NULL;
	const gchar* _tmp65_ = NULL;
	GUPnPRootDevice* _tmp66_ = NULL;
	GUPnPRootDevice* _tmp67_ = NULL;
	GUPnPRootDevice* _tmp68_ = NULL;
	gchar* _tmp69_ = NULL;
	gchar* _tmp70_ = NULL;
	const gchar* _tmp71_ = NULL;
	const gchar* _tmp72_ = NULL;
	const gchar* _tmp73_ = NULL;
	const gchar* _tmp74_ = NULL;
	gchar* _tmp75_ = NULL;
	gchar* _tmp76_ = NULL;
	gchar* _tmp77_ = NULL;
	GError * _inner_error_ = NULL;
#line 123 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 126 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	success = TRUE;
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	g_object_get ((GUPnPService*) self, "root-device", &_tmp0_, NULL);
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp1_ = _tmp0_;
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp2_ = _tmp1_;
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp3_ = gupnp_device_info_get_context ((GUPnPDeviceInfo*) _tmp2_);
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp4_ = _tmp3_;
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp5_ = gssdp_client_get_interface ((GSSDPClient*) _tmp4_);
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp6_ = _tmp5_;
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp8_ = _tmp7_;
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_g_object_unref0 (_tmp2_);
#line 128 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	iface = _tmp8_;
#line 129 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp9_ = g_strdup_printf ("EnergyManagement-%s", iface);
#line 129 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	config_section = _tmp9_;
#line 131 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp12_ = rygel_energy_management_get_mac_and_network_type (iface, &_tmp10_, &_tmp11_);
#line 131 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_g_free0 (mac_address);
#line 131 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	mac_address = _tmp10_;
#line 131 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_g_free0 (type);
#line 131 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	type = _tmp11_;
#line 131 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	success = _tmp12_;
#line 133 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp13_ = string_replace (mac_address, ":", "");
#line 133 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	mac = _tmp13_;
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp14_ = g_strdup_printf ("FFFFFFFFFFFF%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s", mac, mac, mac, mac, mac, mac, mac, mac, mac, mac, mac, mac, mac, mac, mac, mac);
#line 135 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	wake_pattern = _tmp14_;
#line 780 "rygel-energy-management.c"
	{
		gchar* password = NULL;
		RygelConfiguration* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
#line 139 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_tmp15_ = self->priv->config;
#line 139 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_tmp16_ = rygel_configuration_get_string (_tmp15_, config_section, "password", &_inner_error_);
#line 139 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		password = _tmp16_;
#line 139 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 795 "rygel-energy-management.c"
			goto __catch9_g_error;
		}
#line 140 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_tmp17_ = wake_pattern;
#line 140 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_tmp18_ = g_strconcat (_tmp17_, password, NULL);
#line 140 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_g_free0 (wake_pattern);
#line 140 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		wake_pattern = _tmp18_;
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_g_free0 (password);
#line 808 "rygel-energy-management.c"
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* _error_ = NULL;
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_error_ = _inner_error_;
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_inner_error_ = NULL;
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_g_error_free0 (_error_);
#line 820 "rygel-energy-management.c"
	}
	__finally9:
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_g_free0 (wake_pattern);
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_g_free0 (mac);
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_g_free0 (config_section);
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_g_free0 (iface);
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_g_free0 (type);
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_g_free0 (mac_address);
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		g_clear_error (&_inner_error_);
#line 138 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		return NULL;
#line 843 "rygel-energy-management.c"
	}
#line 143 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	g_object_get ((GUPnPService*) self, "root-device", &_tmp19_, NULL);
#line 143 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp20_ = _tmp19_;
#line 143 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp21_ = _tmp20_;
#line 143 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp22_ = gupnp_device_info_get_context ((GUPnPDeviceInfo*) _tmp21_);
#line 143 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp23_ = _tmp22_;
#line 143 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp24_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp23_);
#line 143 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp25_ = _tmp24_;
#line 143 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp26_ = g_inet_address_new_from_string (_tmp25_);
#line 143 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp27_ = _tmp26_;
#line 143 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_g_object_unref0 (_tmp21_);
#line 143 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	ip_addr = _tmp27_;
#line 144 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp29_ = ip_addr;
#line 144 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	if (_tmp29_ != NULL) {
#line 871 "rygel-energy-management.c"
		GInetAddress* _tmp30_ = NULL;
		GSocketFamily _tmp31_ = 0;
		GSocketFamily _tmp32_ = 0;
#line 144 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_tmp30_ = ip_addr;
#line 144 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_tmp31_ = g_inet_address_get_family (_tmp30_);
#line 144 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_tmp32_ = _tmp31_;
#line 144 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_tmp28_ = _tmp32_ == G_SOCKET_FAMILY_IPV6;
#line 883 "rygel-energy-management.c"
	} else {
#line 144 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_tmp28_ = FALSE;
#line 887 "rygel-energy-management.c"
	}
#line 144 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	is_ipv6 = _tmp28_;
#line 146 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp34_ = is_ipv6;
#line 146 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	if (_tmp34_) {
#line 146 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_tmp33_ = 6;
#line 897 "rygel-energy-management.c"
	} else {
#line 146 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_tmp33_ = 4;
#line 901 "rygel-energy-management.c"
	}
#line 148 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp36_ = is_ipv6;
#line 148 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	if (_tmp36_) {
#line 148 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_tmp35_ = 6;
#line 909 "rygel-energy-management.c"
	} else {
#line 148 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_tmp35_ = 4;
#line 913 "rygel-energy-management.c"
	}
#line 145 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	g_object_get ((GUPnPService*) self, "root-device", &_tmp37_, NULL);
#line 145 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp38_ = _tmp37_;
#line 145 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp39_ = _tmp38_;
#line 145 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp40_ = gupnp_device_info_get_context ((GUPnPDeviceInfo*) _tmp39_);
#line 145 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp41_ = _tmp40_;
#line 145 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp42_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp41_);
#line 145 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp43_ = _tmp42_;
#line 145 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp44_ = g_strdup_printf ("<Ipv%d>%s</Ipv%d>", _tmp33_, _tmp43_, _tmp35_);
#line 145 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp45_ = _tmp44_;
#line 145 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_g_object_unref0 (_tmp39_);
#line 145 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	associated_ips = _tmp45_;
#line 151 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp47_ = success;
#line 151 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	if (!_tmp47_) {
#line 151 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_tmp46_ = TRUE;
#line 943 "rygel-energy-management.c"
	} else {
		UPower* _tmp48_ = NULL;
#line 151 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_tmp48_ = self->priv->upower;
#line 151 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_tmp46_ = _tmp48_ == NULL;
#line 950 "rygel-energy-management.c"
	}
#line 151 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	if (_tmp46_) {
#line 954 "rygel-energy-management.c"
		gchar* _tmp49_ = NULL;
#line 152 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_tmp49_ = g_strdup ("Unimplemented");
#line 152 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_g_free0 (mode);
#line 152 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		mode = _tmp49_;
#line 962 "rygel-energy-management.c"
	} else {
		{
			gchar* sleep_mode = NULL;
			RygelConfiguration* _tmp50_ = NULL;
			gchar* _tmp51_ = NULL;
			const gchar* _tmp52_ = NULL;
			gboolean _tmp53_ = FALSE;
			gchar* _tmp55_ = NULL;
#line 156 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
			_tmp50_ = self->priv->config;
#line 156 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
			_tmp51_ = rygel_configuration_get_string (_tmp50_, config_section, "mode-on-suspend", &_inner_error_);
#line 156 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
			sleep_mode = _tmp51_;
#line 156 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 979 "rygel-energy-management.c"
				goto __catch10_g_error;
			}
#line 158 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
			_tmp53_ = self->priv->sleeping;
#line 158 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
			if (_tmp53_) {
#line 986 "rygel-energy-management.c"
				const gchar* _tmp54_ = NULL;
#line 158 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
				_tmp54_ = sleep_mode;
#line 158 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
				_tmp52_ = _tmp54_;
#line 992 "rygel-energy-management.c"
			} else {
#line 158 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
				_tmp52_ = "IP-up";
#line 996 "rygel-energy-management.c"
			}
#line 158 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
			_tmp55_ = g_strdup (_tmp52_);
#line 158 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
			_g_free0 (mode);
#line 158 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
			mode = _tmp55_;
#line 154 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
			_g_free0 (sleep_mode);
#line 1006 "rygel-energy-management.c"
		}
		goto __finally10;
		__catch10_g_error:
		{
			GError* _error_ = NULL;
			gchar* _tmp56_ = NULL;
#line 154 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
			_error_ = _inner_error_;
#line 154 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
			_inner_error_ = NULL;
#line 160 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
			_tmp56_ = g_strdup ("Unimplemented");
#line 160 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
			_g_free0 (mode);
#line 160 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
			mode = _tmp56_;
#line 154 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
			_g_error_free0 (_error_);
#line 1025 "rygel-energy-management.c"
		}
		__finally10:
#line 154 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 154 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
			_g_free0 (mode);
#line 154 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
			_g_free0 (associated_ips);
#line 154 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
			_g_object_unref0 (ip_addr);
#line 154 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
			_g_free0 (wake_pattern);
#line 154 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
			_g_free0 (mac);
#line 154 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
			_g_free0 (config_section);
#line 154 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
			_g_free0 (iface);
#line 154 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
			_g_free0 (type);
#line 154 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
			_g_free0 (mac_address);
#line 154 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 154 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
			g_clear_error (&_inner_error_);
#line 154 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
			return NULL;
#line 1054 "rygel-energy-management.c"
		}
	}
	{
		gchar* val = NULL;
		RygelConfiguration* _tmp57_ = NULL;
		gchar* _tmp58_ = NULL;
		gchar* _tmp59_ = NULL;
#line 166 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_tmp57_ = self->priv->config;
#line 166 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_tmp58_ = rygel_configuration_get_string (_tmp57_, config_section, "supported-transport", &_inner_error_);
#line 166 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		val = _tmp58_;
#line 166 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1070 "rygel-energy-management.c"
			goto __catch11_g_error;
		}
#line 168 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_tmp59_ = g_strdup_printf ("<WakeSupportedTransport>%s</WakeSupportedTransport>", val);
#line 168 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_g_free0 (transport_node);
#line 168 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		transport_node = _tmp59_;
#line 165 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_g_free0 (val);
#line 1081 "rygel-energy-management.c"
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* _error_ = NULL;
		gchar* _tmp60_ = NULL;
#line 165 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_error_ = _inner_error_;
#line 165 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_inner_error_ = NULL;
#line 171 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_tmp60_ = g_strdup ("");
#line 171 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_g_free0 (transport_node);
#line 171 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		transport_node = _tmp60_;
#line 165 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_g_error_free0 (_error_);
#line 1100 "rygel-energy-management.c"
	}
	__finally11:
#line 165 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 165 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_g_free0 (transport_node);
#line 165 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_g_free0 (mode);
#line 165 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_g_free0 (associated_ips);
#line 165 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_g_object_unref0 (ip_addr);
#line 165 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_g_free0 (wake_pattern);
#line 165 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_g_free0 (mac);
#line 165 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_g_free0 (config_section);
#line 165 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_g_free0 (iface);
#line 165 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_g_free0 (type);
#line 165 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_g_free0 (mac_address);
#line 165 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 165 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		g_clear_error (&_inner_error_);
#line 165 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		return NULL;
#line 1131 "rygel-energy-management.c"
	}
#line 174 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	g_object_get ((GUPnPService*) self, "root-device", &_tmp61_, NULL);
#line 174 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp62_ = _tmp61_;
#line 174 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp63_ = _tmp62_;
#line 174 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp64_ = gupnp_device_info_get_udn ((GUPnPDeviceInfo*) _tmp63_);
#line 174 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp65_ = _tmp64_;
#line 174 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	g_object_get ((GUPnPService*) self, "root-device", &_tmp66_, NULL);
#line 174 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp67_ = _tmp66_;
#line 174 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp68_ = _tmp67_;
#line 174 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp69_ = gupnp_device_info_get_friendly_name ((GUPnPDeviceInfo*) _tmp68_);
#line 174 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp70_ = _tmp69_;
#line 174 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp71_ = mode;
#line 174 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp72_ = associated_ips;
#line 174 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp73_ = wake_pattern;
#line 174 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp74_ = transport_node;
#line 174 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp75_ = g_strdup_printf ("<DeviceInterface>" "<DeviceUUID>%s</DeviceUUID>" "<FriendlyName>%s</FriendlyName>" "<NetworkInterface>" "<SystemName>%s</SystemName>" "<MacAddress>%s</MacAddress>" "<InterfaceType>%s</InterfaceType>" "<NetworkInterfaceMode>%s</NetworkInterfaceMode>" "<AssociatedIpAddresses>%s</AssociatedIpAddresses>" "<WakeOnPattern>%s</WakeOnPattern>" "%s" "</NetworkInterface>" "</DeviceInterface>", _tmp65_, _tmp70_, iface, mac_address, type, _tmp71_, _tmp72_, _tmp73_, _tmp74_);
#line 174 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp76_ = _tmp75_;
#line 174 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_g_free0 (_tmp70_);
#line 174 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_g_object_unref0 (_tmp68_);
#line 174 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_g_object_unref0 (_tmp63_);
#line 174 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	device_info = _tmp76_;
#line 197 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp77_ = g_strdup_printf (RYGEL_ENERGY_MANAGEMENT_TEMPLATE, device_info);
#line 197 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	result = _tmp77_;
#line 197 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_g_free0 (device_info);
#line 197 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_g_free0 (transport_node);
#line 197 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_g_free0 (mode);
#line 197 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_g_free0 (associated_ips);
#line 197 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_g_object_unref0 (ip_addr);
#line 197 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_g_free0 (wake_pattern);
#line 197 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_g_free0 (mac);
#line 197 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_g_free0 (config_section);
#line 197 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_g_free0 (iface);
#line 197 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_g_free0 (type);
#line 197 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_g_free0 (mac_address);
#line 197 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	return result;
#line 1201 "rygel-energy-management.c"
}


static gchar* rygel_energy_management_create_proxied_network_interface_info (RygelEnergyManagement* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 200 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 203 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp0_ = g_strdup_printf (RYGEL_ENERGY_MANAGEMENT_TEMPLATE, "");
#line 203 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	result = _tmp0_;
#line 203 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	return result;
#line 1216 "rygel-energy-management.c"
}


static void rygel_energy_management_query_network_interface_info_cb (RygelEnergyManagement* self, GUPnPService* em, const gchar* var, GValue* val) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 206 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	g_return_if_fail (self != NULL);
#line 206 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	g_return_if_fail (em != NULL);
#line 206 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	g_return_if_fail (var != NULL);
#line 206 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	g_return_if_fail (val != NULL);
#line 209 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	g_value_init (val, G_TYPE_STRING);
#line 210 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp0_ = rygel_energy_management_create_network_interface_info (self);
#line 210 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp1_ = _tmp0_;
#line 210 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	g_value_set_string (val, _tmp1_);
#line 210 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_g_free0 (_tmp1_);
#line 1241 "rygel-energy-management.c"
}


static void rygel_energy_management_query_proxied_network_interface_info_cb (RygelEnergyManagement* self, GUPnPService* em, const gchar* var, GValue* val) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 213 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	g_return_if_fail (self != NULL);
#line 213 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	g_return_if_fail (em != NULL);
#line 213 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	g_return_if_fail (var != NULL);
#line 213 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	g_return_if_fail (val != NULL);
#line 216 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	g_value_init (val, G_TYPE_STRING);
#line 217 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp0_ = rygel_energy_management_create_proxied_network_interface_info (self);
#line 217 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp1_ = _tmp0_;
#line 217 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	g_value_set_string (val, _tmp1_);
#line 217 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_g_free0 (_tmp1_);
#line 1266 "rygel-energy-management.c"
}


static void rygel_energy_management_get_interface_info_cb (RygelEnergyManagement* self, GUPnPService* em, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GUPnPServiceAction* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GUPnPServiceAction* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	GUPnPServiceAction* _tmp10_ = NULL;
#line 220 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	g_return_if_fail (self != NULL);
#line 220 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	g_return_if_fail (em != NULL);
#line 220 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	g_return_if_fail (action != NULL);
#line 222 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp0_ = action;
#line 222 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
#line 222 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	if (_tmp1_ != ((guint) 0)) {
#line 1292 "rygel-energy-management.c"
		GUPnPServiceAction* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 223 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_tmp2_ = action;
#line 223 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		_tmp3_ = _ ("Invalid argument");
#line 223 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
#line 225 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
		return;
#line 1303 "rygel-energy-management.c"
	}
#line 228 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp4_ = action;
#line 228 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp5_ = rygel_energy_management_create_network_interface_info (self);
#line 228 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp6_ = _tmp5_;
#line 228 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	gupnp_service_action_set (_tmp4_, "NetworkInterfaceInfo", G_TYPE_STRING, _tmp6_, NULL);
#line 228 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_g_free0 (_tmp6_);
#line 232 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp7_ = action;
#line 232 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp8_ = rygel_energy_management_create_proxied_network_interface_info (self);
#line 232 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp9_ = _tmp8_;
#line 232 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	gupnp_service_action_set (_tmp7_, "ProxiedNetworkInterfaceInfo", G_TYPE_STRING, _tmp9_, NULL);
#line 232 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_g_free0 (_tmp9_);
#line 236 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_tmp10_ = action;
#line 236 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	gupnp_service_action_return (_tmp10_);
#line 1329 "rygel-energy-management.c"
}


RygelEnergyManagement* rygel_energy_management_construct (GType object_type) {
	RygelEnergyManagement * self = NULL;
#line 52 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	self = (RygelEnergyManagement*) g_object_new (object_type, NULL);
#line 52 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	return self;
#line 1339 "rygel-energy-management.c"
}


RygelEnergyManagement* rygel_energy_management_new (void) {
#line 52 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	return rygel_energy_management_construct (RYGEL_TYPE_ENERGY_MANAGEMENT);
#line 1346 "rygel-energy-management.c"
}


static void rygel_energy_management_class_init (RygelEnergyManagementClass * klass) {
#line 52 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	rygel_energy_management_parent_class = g_type_class_peek_parent (klass);
#line 52 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	g_type_class_add_private (klass, sizeof (RygelEnergyManagementPrivate));
#line 52 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	((GObjectClass *) klass)->constructed = rygel_energy_management_real_constructed;
#line 52 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_energy_management_finalize;
#line 1359 "rygel-energy-management.c"
}


static void rygel_energy_management_instance_init (RygelEnergyManagement * self) {
#line 52 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	self->priv = RYGEL_ENERGY_MANAGEMENT_GET_PRIVATE (self);
#line 1366 "rygel-energy-management.c"
}


static void rygel_energy_management_finalize (GObject* obj) {
	RygelEnergyManagement * self;
#line 52 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_ENERGY_MANAGEMENT, RygelEnergyManagement);
#line 64 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_g_object_unref0 (self->priv->config);
#line 66 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	_g_object_unref0 (self->priv->upower);
#line 52 "/home/jens/Source/rygel/src/librygel-core/rygel-energy-management.vala"
	G_OBJECT_CLASS (rygel_energy_management_parent_class)->finalize (obj);
#line 1380 "rygel-energy-management.c"
}


/**
 * Implementation of UPnP EnergyManagement service.
 */
GType rygel_energy_management_get_type (void) {
	static volatile gsize rygel_energy_management_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_energy_management_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelEnergyManagementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_energy_management_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelEnergyManagement), 0, (GInstanceInitFunc) rygel_energy_management_instance_init, NULL };
		GType rygel_energy_management_type_id;
		rygel_energy_management_type_id = g_type_register_static (gupnp_service_get_type (), "RygelEnergyManagement", &g_define_type_info, 0);
		g_once_init_leave (&rygel_energy_management_type_id__volatile, rygel_energy_management_type_id);
	}
	return rygel_energy_management_type_id__volatile;
}



