/* rygel-media-renderer-plugin.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-media-renderer-plugin.vala, do not modify */

/*
 * Copyright (C) 2008,2010 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-core.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <libgupnp-av/gupnp-av.h>
#include <config.h>
#include <libgupnp/gupnp.h>


#define RYGEL_TYPE_MEDIA_RENDERER_PLUGIN (rygel_media_renderer_plugin_get_type ())
#define RYGEL_MEDIA_RENDERER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPlugin))
#define RYGEL_MEDIA_RENDERER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPluginClass))
#define RYGEL_IS_MEDIA_RENDERER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN))
#define RYGEL_IS_MEDIA_RENDERER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN))
#define RYGEL_MEDIA_RENDERER_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPluginClass))

typedef struct _RygelMediaRendererPlugin RygelMediaRendererPlugin;
typedef struct _RygelMediaRendererPluginClass RygelMediaRendererPluginClass;
typedef struct _RygelMediaRendererPluginPrivate RygelMediaRendererPluginPrivate;

#define RYGEL_TYPE_MEDIA_PLAYER (rygel_media_player_get_type ())
#define RYGEL_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayer))
#define RYGEL_IS_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_PLAYER))
#define RYGEL_MEDIA_PLAYER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayerIface))

typedef struct _RygelMediaPlayer RygelMediaPlayer;
typedef struct _RygelMediaPlayerIface RygelMediaPlayerIface;

#define RYGEL_TYPE_PLAYER_CONTROLLER (rygel_player_controller_get_type ())
#define RYGEL_PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAYER_CONTROLLER, RygelPlayerController))
#define RYGEL_IS_PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAYER_CONTROLLER))
#define RYGEL_PLAYER_CONTROLLER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_PLAYER_CONTROLLER, RygelPlayerControllerIface))

typedef struct _RygelPlayerController RygelPlayerController;
typedef struct _RygelPlayerControllerIface RygelPlayerControllerIface;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__rygel_dlna_profile_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__rygel_dlna_profile_unref0_ (var), NULL)))

#define RYGEL_TYPE_SINK_CONNECTION_MANAGER (rygel_sink_connection_manager_get_type ())
#define RYGEL_SINK_CONNECTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SINK_CONNECTION_MANAGER, RygelSinkConnectionManager))
#define RYGEL_SINK_CONNECTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SINK_CONNECTION_MANAGER, RygelSinkConnectionManagerClass))
#define RYGEL_IS_SINK_CONNECTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SINK_CONNECTION_MANAGER))
#define RYGEL_IS_SINK_CONNECTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SINK_CONNECTION_MANAGER))
#define RYGEL_SINK_CONNECTION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SINK_CONNECTION_MANAGER, RygelSinkConnectionManagerClass))

typedef struct _RygelSinkConnectionManager RygelSinkConnectionManager;
typedef struct _RygelSinkConnectionManagerClass RygelSinkConnectionManagerClass;

#define RYGEL_TYPE_AV_TRANSPORT (rygel_av_transport_get_type ())
#define RYGEL_AV_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransport))
#define RYGEL_AV_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransportClass))
#define RYGEL_IS_AV_TRANSPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AV_TRANSPORT))
#define RYGEL_IS_AV_TRANSPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AV_TRANSPORT))
#define RYGEL_AV_TRANSPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AV_TRANSPORT, RygelAVTransportClass))

typedef struct _RygelAVTransport RygelAVTransport;
typedef struct _RygelAVTransportClass RygelAVTransportClass;
#define _rygel_resource_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_resource_info_unref (var), NULL)))

#define RYGEL_TYPE_RENDERING_CONTROL (rygel_rendering_control_get_type ())
#define RYGEL_RENDERING_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RENDERING_CONTROL, RygelRenderingControl))
#define RYGEL_RENDERING_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RENDERING_CONTROL, RygelRenderingControlClass))
#define RYGEL_IS_RENDERING_CONTROL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RENDERING_CONTROL))
#define RYGEL_IS_RENDERING_CONTROL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RENDERING_CONTROL))
#define RYGEL_RENDERING_CONTROL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RENDERING_CONTROL, RygelRenderingControlClass))

typedef struct _RygelRenderingControl RygelRenderingControl;
typedef struct _RygelRenderingControlClass RygelRenderingControlClass;

#define RYGEL_TYPE_DEFAULT_PLAYER_CONTROLLER (rygel_default_player_controller_get_type ())
#define RYGEL_DEFAULT_PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DEFAULT_PLAYER_CONTROLLER, RygelDefaultPlayerController))
#define RYGEL_DEFAULT_PLAYER_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DEFAULT_PLAYER_CONTROLLER, RygelDefaultPlayerControllerClass))
#define RYGEL_IS_DEFAULT_PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DEFAULT_PLAYER_CONTROLLER))
#define RYGEL_IS_DEFAULT_PLAYER_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DEFAULT_PLAYER_CONTROLLER))
#define RYGEL_DEFAULT_PLAYER_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DEFAULT_PLAYER_CONTROLLER, RygelDefaultPlayerControllerClass))

typedef struct _RygelDefaultPlayerController RygelDefaultPlayerController;
typedef struct _RygelDefaultPlayerControllerClass RygelDefaultPlayerControllerClass;

struct _RygelMediaPlayerIface {
	GTypeInterface parent_iface;
	gboolean (*seek) (RygelMediaPlayer* self, gint64 time);
	gboolean (*seek_bytes) (RygelMediaPlayer* self, gint64 bytes);
	gchar** (*get_protocols) (RygelMediaPlayer* self, int* result_length1);
	gchar** (*get_mime_types) (RygelMediaPlayer* self, int* result_length1);
	gchar* (*get_playback_state) (RygelMediaPlayer* self);
	void (*set_playback_state) (RygelMediaPlayer* self, const gchar* value);
	gchar** (*get_allowed_playback_speeds) (RygelMediaPlayer* self, int* result_length1);
	gchar* (*get_playback_speed) (RygelMediaPlayer* self);
	void (*set_playback_speed) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_uri) (RygelMediaPlayer* self);
	void (*set_uri) (RygelMediaPlayer* self, const gchar* value);
	gdouble (*get_volume) (RygelMediaPlayer* self);
	void (*set_volume) (RygelMediaPlayer* self, gdouble value);
	gint64 (*get_duration) (RygelMediaPlayer* self);
	gint64 (*get_size) (RygelMediaPlayer* self);
	gchar* (*get_metadata) (RygelMediaPlayer* self);
	void (*set_metadata) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_mime_type) (RygelMediaPlayer* self);
	void (*set_mime_type) (RygelMediaPlayer* self, const gchar* value);
	gboolean (*get_can_seek) (RygelMediaPlayer* self);
	gboolean (*get_can_seek_bytes) (RygelMediaPlayer* self);
	gchar* (*get_content_features) (RygelMediaPlayer* self);
	void (*set_content_features) (RygelMediaPlayer* self, const gchar* value);
	gint64 (*get_position) (RygelMediaPlayer* self);
	gint64 (*get_byte_position) (RygelMediaPlayer* self);
};

struct _RygelPlayerControllerIface {
	GTypeInterface parent_iface;
	gboolean (*next) (RygelPlayerController* self);
	gboolean (*previous) (RygelPlayerController* self);
	void (*set_single_play_uri) (RygelPlayerController* self, const gchar* uri, const gchar* metadata, const gchar* mime, const gchar* features);
	void (*set_playlist_uri) (RygelPlayerController* self, const gchar* uri, const gchar* metadata, GUPnPMediaCollection* collection);
	void (*set_next_single_play_uri) (RygelPlayerController* self, const gchar* uri, const gchar* metadata, const gchar* mime, const gchar* features);
	void (*set_next_playlist_uri) (RygelPlayerController* self, const gchar* uri, const gchar* metadata, GUPnPMediaCollection* collection);
	gboolean (*is_play_mode_valid) (RygelPlayerController* self, const gchar* play_mode);
	const gchar* (*get_playback_state) (RygelPlayerController* self);
	void (*set_playback_state) (RygelPlayerController* self, const gchar* value);
	guint (*get_n_tracks) (RygelPlayerController* self);
	void (*set_n_tracks) (RygelPlayerController* self, guint value);
	guint (*get_track) (RygelPlayerController* self);
	void (*set_track) (RygelPlayerController* self, guint value);
	gchar* (*get_uri) (RygelPlayerController* self);
	void (*set_uri) (RygelPlayerController* self, const gchar* value);
	gchar* (*get_metadata) (RygelPlayerController* self);
	void (*set_metadata) (RygelPlayerController* self, const gchar* value);
	gchar* (*get_track_uri) (RygelPlayerController* self);
	void (*set_track_uri) (RygelPlayerController* self, const gchar* value);
	gchar* (*get_track_metadata) (RygelPlayerController* self);
	void (*set_track_metadata) (RygelPlayerController* self, const gchar* value);
	gchar* (*get_next_uri) (RygelPlayerController* self);
	void (*set_next_uri) (RygelPlayerController* self, const gchar* value);
	gchar* (*get_next_metadata) (RygelPlayerController* self);
	void (*set_next_metadata) (RygelPlayerController* self, const gchar* value);
	gchar* (*get_current_transport_actions) (RygelPlayerController* self);
	const gchar* (*get_play_mode) (RygelPlayerController* self);
	void (*set_play_mode) (RygelPlayerController* self, const gchar* value);
};

struct _RygelMediaRendererPlugin {
	RygelPlugin parent_instance;
	RygelMediaRendererPluginPrivate * priv;
};

struct _RygelMediaRendererPluginClass {
	RygelPluginClass parent_class;
	RygelMediaPlayer* (*get_player) (RygelMediaRendererPlugin* self);
	RygelPlayerController* (*get_controller) (RygelMediaRendererPlugin* self);
};

struct _RygelMediaRendererPluginPrivate {
	gchar* sink_protocol_info;
	RygelPlayerController* controller;
	GList* _supported_profiles;
};


static gpointer rygel_media_renderer_plugin_parent_class = NULL;

GType rygel_media_renderer_plugin_get_type (void) G_GNUC_CONST;
GType rygel_media_player_get_type (void) G_GNUC_CONST;
GType rygel_player_controller_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_RENDERER_PLUGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPluginPrivate))
enum  {
	RYGEL_MEDIA_RENDERER_PLUGIN_DUMMY_PROPERTY,
	RYGEL_MEDIA_RENDERER_PLUGIN_SUPPORTED_PROFILES
};
static void _rygel_dlna_profile_unref0_ (gpointer var);
static void _g_list_free__rygel_dlna_profile_unref0_ (GList* self);
#define RYGEL_MEDIA_RENDERER_PLUGIN_MEDIA_RENDERER_DESC_PATH DATA_DIR "/xml/MediaRenderer2.xml"
#define RYGEL_MEDIA_RENDERER_PLUGIN_DMR "urn:schemas-upnp-org:device:MediaRenderer"
RygelMediaRendererPlugin* rygel_media_renderer_plugin_new (const gchar* name, const gchar* title, const gchar* description, RygelPluginCapabilities capabilities);
RygelMediaRendererPlugin* rygel_media_renderer_plugin_construct (GType object_type, const gchar* name, const gchar* title, const gchar* description, RygelPluginCapabilities capabilities);
static void rygel_media_renderer_plugin_real_constructed (GObject* base);
GType rygel_sink_connection_manager_get_type (void) G_GNUC_CONST;
#define RYGEL_AV_TRANSPORT_UPNP_ID "urn:upnp-org:serviceId:AVTransport"
#define RYGEL_AV_TRANSPORT_UPNP_TYPE "urn:schemas-upnp-org:service:AVTransport:2"
#define RYGEL_AV_TRANSPORT_DESCRIPTION_PATH "xml/AVTransport2.xml"
GType rygel_av_transport_get_type (void) G_GNUC_CONST;
#define RYGEL_RENDERING_CONTROL_UPNP_ID "urn:upnp-org:serviceId:RenderingControl"
#define RYGEL_RENDERING_CONTROL_UPNP_TYPE "urn:schemas-upnp-org:service:RenderingControl:2"
#define RYGEL_RENDERING_CONTROL_DESCRIPTION_PATH "xml/RenderingControl2.xml"
GType rygel_rendering_control_get_type (void) G_GNUC_CONST;
RygelMediaPlayer* rygel_media_renderer_plugin_get_player (RygelMediaRendererPlugin* self);
static RygelMediaPlayer* rygel_media_renderer_plugin_real_get_player (RygelMediaRendererPlugin* self);
RygelPlayerController* rygel_media_renderer_plugin_get_controller (RygelMediaRendererPlugin* self);
static RygelPlayerController* rygel_media_renderer_plugin_real_get_controller (RygelMediaRendererPlugin* self);
gchar* rygel_media_renderer_plugin_get_protocol_info (RygelMediaRendererPlugin* self);
RygelDefaultPlayerController* rygel_default_player_controller_new (RygelMediaPlayer* player, const gchar* protocol_info);
RygelDefaultPlayerController* rygel_default_player_controller_construct (GType object_type, RygelMediaPlayer* player, const gchar* protocol_info);
GType rygel_default_player_controller_get_type (void) G_GNUC_CONST;
static void rygel_media_renderer_plugin_real_apply_hacks (RygelPlugin* base, RygelRootDevice* device, const gchar* description_path, GError** error);
gchar** rygel_media_player_get_protocols (RygelMediaPlayer* self, int* result_length1);
GList* rygel_media_renderer_plugin_get_supported_profiles (RygelMediaRendererPlugin* self);
gchar** rygel_media_player_get_mime_types (RygelMediaPlayer* self, int* result_length1);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value);
void rygel_media_renderer_plugin_set_supported_profiles (RygelMediaRendererPlugin* self, GList* value);
static void rygel_media_renderer_plugin_finalize (GObject* obj);
static void _vala_rygel_media_renderer_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_renderer_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _rygel_dlna_profile_unref0_ (gpointer var) {
#line 42 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	(var == NULL) ? NULL : (var = (rygel_dlna_profile_unref (var), NULL));
#line 244 "rygel-media-renderer-plugin.c"
}


static void _g_list_free__rygel_dlna_profile_unref0_ (GList* self) {
#line 42 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	g_list_foreach (self, (GFunc) _rygel_dlna_profile_unref0_, NULL);
#line 42 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	g_list_free (self);
#line 253 "rygel-media-renderer-plugin.c"
}


/**
     * Create an instance of the plugin.
     *
     * @param name The non-human-readable name for the plugin and its renderer, used in UPnP messages and in the Rygel configuration file.
     * @param title An optional human-readable name (friendlyName) of the UPnP renderer provided by the plugin. If the title is empty then the name will be used.
     * @param description An optional human-readable description (modelDescription) of the UPnP renderer provided by the plugin.
     */
RygelMediaRendererPlugin* rygel_media_renderer_plugin_construct (GType object_type, const gchar* name, const gchar* title, const gchar* description, RygelPluginCapabilities capabilities) {
	RygelMediaRendererPlugin * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	RygelPluginCapabilities _tmp3_ = 0;
#line 72 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 77 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp0_ = name;
#line 77 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp1_ = title;
#line 77 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp2_ = description;
#line 77 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp3_ = capabilities;
#line 77 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	self = (RygelMediaRendererPlugin*) g_object_new (object_type, "desc-path", RYGEL_MEDIA_RENDERER_PLUGIN_MEDIA_RENDERER_DESC_PATH, "name", _tmp0_, "title", _tmp1_, "description", _tmp2_, "capabilities", _tmp3_, NULL);
#line 72 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	return self;
#line 284 "rygel-media-renderer-plugin.c"
}


RygelMediaRendererPlugin* rygel_media_renderer_plugin_new (const gchar* name, const gchar* title, const gchar* description, RygelPluginCapabilities capabilities) {
#line 72 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	return rygel_media_renderer_plugin_construct (RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, name, title, description, capabilities);
#line 291 "rygel-media-renderer-plugin.c"
}


static void rygel_media_renderer_plugin_real_constructed (GObject* base) {
	RygelMediaRendererPlugin * self;
	RygelResourceInfo* resource = NULL;
	RygelResourceInfo* _tmp0_ = NULL;
	RygelResourceInfo* _tmp1_ = NULL;
	RygelResourceInfo* _tmp2_ = NULL;
	RygelResourceInfo* _tmp3_ = NULL;
	RygelResourceInfo* _tmp4_ = NULL;
	RygelResourceInfo* _tmp5_ = NULL;
#line 84 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	self = (RygelMediaRendererPlugin*) base;
#line 85 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	G_OBJECT_CLASS (rygel_media_renderer_plugin_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_PLUGIN, RygelPlugin));
#line 87 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp0_ = rygel_resource_info_new (RYGEL_CONNECTION_MANAGER_UPNP_ID, RYGEL_CONNECTION_MANAGER_UPNP_TYPE, RYGEL_CONNECTION_MANAGER_DESCRIPTION_PATH, RYGEL_TYPE_SINK_CONNECTION_MANAGER);
#line 87 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	resource = _tmp0_;
#line 91 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp1_ = resource;
#line 91 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	rygel_plugin_add_resource ((RygelPlugin*) self, _tmp1_);
#line 93 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp2_ = rygel_resource_info_new (RYGEL_AV_TRANSPORT_UPNP_ID, RYGEL_AV_TRANSPORT_UPNP_TYPE, RYGEL_AV_TRANSPORT_DESCRIPTION_PATH, RYGEL_TYPE_AV_TRANSPORT);
#line 93 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_rygel_resource_info_unref0 (resource);
#line 93 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	resource = _tmp2_;
#line 97 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp3_ = resource;
#line 97 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	rygel_plugin_add_resource ((RygelPlugin*) self, _tmp3_);
#line 99 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp4_ = rygel_resource_info_new (RYGEL_RENDERING_CONTROL_UPNP_ID, RYGEL_RENDERING_CONTROL_UPNP_TYPE, RYGEL_RENDERING_CONTROL_DESCRIPTION_PATH, RYGEL_TYPE_RENDERING_CONTROL);
#line 99 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_rygel_resource_info_unref0 (resource);
#line 99 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	resource = _tmp4_;
#line 103 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp5_ = resource;
#line 103 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	rygel_plugin_add_resource ((RygelPlugin*) self, _tmp5_);
#line 84 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_rygel_resource_info_unref0 (resource);
#line 338 "rygel-media-renderer-plugin.c"
}


static RygelMediaPlayer* rygel_media_renderer_plugin_real_get_player (RygelMediaRendererPlugin* self) {
	RygelMediaPlayer* result = NULL;
#line 107 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	result = NULL;
#line 107 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	return result;
#line 348 "rygel-media-renderer-plugin.c"
}


RygelMediaPlayer* rygel_media_renderer_plugin_get_player (RygelMediaRendererPlugin* self) {
#line 106 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 106 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	return RYGEL_MEDIA_RENDERER_PLUGIN_GET_CLASS (self)->get_player (self);
#line 357 "rygel-media-renderer-plugin.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 116 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	return self ? g_object_ref (self) : NULL;
#line 364 "rygel-media-renderer-plugin.c"
}


static RygelPlayerController* rygel_media_renderer_plugin_real_get_controller (RygelMediaRendererPlugin* self) {
	RygelPlayerController* result = NULL;
	RygelPlayerController* _tmp0_ = NULL;
	RygelPlayerController* _tmp6_ = NULL;
	RygelPlayerController* _tmp7_ = NULL;
#line 111 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp0_ = self->priv->controller;
#line 111 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	if (_tmp0_ == NULL) {
#line 377 "rygel-media-renderer-plugin.c"
		RygelMediaPlayer* _tmp1_ = NULL;
		RygelMediaPlayer* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		RygelDefaultPlayerController* _tmp5_ = NULL;
#line 112 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp1_ = rygel_media_renderer_plugin_get_player (self);
#line 112 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp2_ = _tmp1_;
#line 112 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp3_ = rygel_media_renderer_plugin_get_protocol_info (self);
#line 112 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp4_ = _tmp3_;
#line 112 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp5_ = rygel_default_player_controller_new (_tmp2_, _tmp4_);
#line 112 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_g_object_unref0 (self->priv->controller);
#line 112 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		self->priv->controller = (RygelPlayerController*) _tmp5_;
#line 112 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_g_free0 (_tmp4_);
#line 112 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_g_object_unref0 (_tmp2_);
#line 401 "rygel-media-renderer-plugin.c"
	}
#line 116 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp6_ = self->priv->controller;
#line 116 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 116 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	result = _tmp7_;
#line 116 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	return result;
#line 411 "rygel-media-renderer-plugin.c"
}


RygelPlayerController* rygel_media_renderer_plugin_get_controller (RygelMediaRendererPlugin* self) {
#line 110 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 110 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	return RYGEL_MEDIA_RENDERER_PLUGIN_GET_CLASS (self)->get_controller (self);
#line 420 "rygel-media-renderer-plugin.c"
}


static void rygel_media_renderer_plugin_real_apply_hacks (RygelPlugin* base, RygelRootDevice* device, const gchar* description_path, GError** error) {
	RygelMediaRendererPlugin * self;
	gchar** services = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint services_length1 = 0;
	gint _services_size_ = 0;
	RygelV1Hacks* v1_hacks = NULL;
	RygelV1Hacks* _tmp4_ = NULL;
	RygelRootDevice* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
#line 119 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	self = (RygelMediaRendererPlugin*) base;
#line 119 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	g_return_if_fail (device != NULL);
#line 119 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	g_return_if_fail (description_path != NULL);
#line 122 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp0_ = g_strdup (RYGEL_AV_TRANSPORT_UPNP_TYPE);
#line 122 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp1_ = g_strdup (RYGEL_RENDERING_CONTROL_UPNP_TYPE);
#line 122 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp2_ = g_strdup (RYGEL_CONNECTION_MANAGER_UPNP_TYPE);
#line 122 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp3_ = g_new0 (gchar*, 3 + 1);
#line 122 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp3_[0] = _tmp0_;
#line 122 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp3_[1] = _tmp1_;
#line 122 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp3_[2] = _tmp2_;
#line 122 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	services = _tmp3_;
#line 122 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	services_length1 = 3;
#line 122 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_services_size_ = services_length1;
#line 125 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp4_ = rygel_v1_hacks_new (RYGEL_MEDIA_RENDERER_PLUGIN_DMR, services, services_length1);
#line 125 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	v1_hacks = _tmp4_;
#line 126 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp5_ = device;
#line 126 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp6_ = description_path;
#line 126 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	rygel_v1_hacks_apply_on_device (v1_hacks, _tmp5_, _tmp6_, &_inner_error_);
#line 126 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 126 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		g_propagate_error (error, _inner_error_);
#line 126 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_g_object_unref0 (v1_hacks);
#line 126 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		services = (_vala_array_free (services, services_length1, (GDestroyNotify) g_free), NULL);
#line 126 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		return;
#line 484 "rygel-media-renderer-plugin.c"
	}
#line 119 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_g_object_unref0 (v1_hacks);
#line 119 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	services = (_vala_array_free (services, services_length1, (GDestroyNotify) g_free), NULL);
#line 490 "rygel-media-renderer-plugin.c"
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
#line 158 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	if ((*length) == (*size)) {
#line 158 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 158 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 501 "rygel-media-renderer-plugin.c"
	}
#line 158 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	(*array)[(*length)++] = value;
#line 158 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	(*array)[*length] = NULL;
#line 507 "rygel-media-renderer-plugin.c"
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
#line 159 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	if ((*length) == (*size)) {
#line 159 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 159 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 518 "rygel-media-renderer-plugin.c"
	}
#line 159 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	(*array)[(*length)++] = value;
#line 159 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	(*array)[*length] = NULL;
#line 524 "rygel-media-renderer-plugin.c"
}


static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value) {
#line 160 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	if ((*length) == (*size)) {
#line 160 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 160 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 535 "rygel-media-renderer-plugin.c"
	}
#line 160 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	(*array)[(*length)++] = value;
#line 160 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	(*array)[*length] = NULL;
#line 541 "rygel-media-renderer-plugin.c"
}


static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value) {
#line 161 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	if ((*length) == (*size)) {
#line 161 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 161 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 552 "rygel-media-renderer-plugin.c"
	}
#line 161 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	(*array)[(*length)++] = value;
#line 161 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	(*array)[*length] = NULL;
#line 558 "rygel-media-renderer-plugin.c"
}


gchar* rygel_media_renderer_plugin_get_protocol_info (RygelMediaRendererPlugin* self) {
	gchar* result = NULL;
	RygelMediaPlayer* player = NULL;
	RygelMediaPlayer* _tmp0_ = NULL;
	RygelMediaPlayer* _tmp1_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp77_ = NULL;
	gchar* _tmp78_ = NULL;
#line 130 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 131 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp0_ = rygel_media_renderer_plugin_get_player (self);
#line 131 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	player = _tmp0_;
#line 132 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp1_ = player;
#line 132 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	if (_tmp1_ == NULL) {
#line 580 "rygel-media-renderer-plugin.c"
		gchar* _tmp2_ = NULL;
#line 133 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp2_ = g_strdup ("");
#line 133 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		result = _tmp2_;
#line 133 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_g_object_unref0 (player);
#line 133 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		return result;
#line 590 "rygel-media-renderer-plugin.c"
	}
#line 136 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp3_ = self->priv->sink_protocol_info;
#line 136 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	if (_tmp3_ == NULL) {
#line 596 "rygel-media-renderer-plugin.c"
		gchar* _tmp4_ = NULL;
		gchar** protocols = NULL;
		RygelMediaPlayer* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gchar** _tmp7_ = NULL;
		gint protocols_length1 = 0;
		gint _protocols_size_ = 0;
		gchar** _tmp8_ = NULL;
		gint _tmp8__length1 = 0;
		gchar** mime_types = NULL;
		RygelMediaPlayer* _tmp40_ = NULL;
		gint _tmp41_ = 0;
		gchar** _tmp42_ = NULL;
		gint mime_types_length1 = 0;
		gint _mime_types_size_ = 0;
		gchar** _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		gchar* _tmp44_ = NULL;
		gchar** _tmp45_ = NULL;
		gint _tmp45__length1 = 0;
		gchar* _tmp46_ = NULL;
		gchar** _tmp47_ = NULL;
		gint _tmp47__length1 = 0;
		gchar* _tmp48_ = NULL;
		gchar** _tmp49_ = NULL;
		gint _tmp49__length1 = 0;
		gchar* _tmp50_ = NULL;
		gchar** _tmp51_ = NULL;
		gint _tmp51__length1 = 0;
#line 137 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp4_ = g_strdup ("");
#line 137 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_g_free0 (self->priv->sink_protocol_info);
#line 137 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		self->priv->sink_protocol_info = _tmp4_;
#line 139 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp5_ = player;
#line 139 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp7_ = rygel_media_player_get_protocols (_tmp5_, &_tmp6_);
#line 139 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		protocols = _tmp7_;
#line 139 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		protocols_length1 = _tmp6_;
#line 139 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_protocols_size_ = protocols_length1;
#line 141 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp8_ = protocols;
#line 141 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp8__length1 = protocols_length1;
#line 646 "rygel-media-renderer-plugin.c"
		{
			gchar** protocol_collection = NULL;
			gint protocol_collection_length1 = 0;
			gint _protocol_collection_size_ = 0;
			gint protocol_it = 0;
#line 141 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
			protocol_collection = _tmp8_;
#line 141 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
			protocol_collection_length1 = _tmp8__length1;
#line 141 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
			for (protocol_it = 0; protocol_it < _tmp8__length1; protocol_it = protocol_it + 1) {
#line 658 "rygel-media-renderer-plugin.c"
				gchar* _tmp9_ = NULL;
				gchar* protocol = NULL;
#line 141 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
				_tmp9_ = g_strdup (protocol_collection[protocol_it]);
#line 141 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
				protocol = _tmp9_;
#line 665 "rygel-media-renderer-plugin.c"
				{
					gchar** _tmp10_ = NULL;
					gint _tmp10__length1 = 0;
					const gchar* _tmp11_ = NULL;
					const gchar* _tmp12_ = NULL;
					GList* _tmp15_ = NULL;
					GList* _tmp16_ = NULL;
#line 142 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
					_tmp10_ = protocols;
#line 142 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
					_tmp10__length1 = protocols_length1;
#line 142 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
					_tmp11_ = _tmp10_[0];
#line 142 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
					_tmp12_ = protocol;
#line 142 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
					if (g_strcmp0 (_tmp11_, _tmp12_) != 0) {
#line 683 "rygel-media-renderer-plugin.c"
						const gchar* _tmp13_ = NULL;
						gchar* _tmp14_ = NULL;
#line 143 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
						_tmp13_ = self->priv->sink_protocol_info;
#line 143 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
						_tmp14_ = g_strconcat (_tmp13_, ",", NULL);
#line 143 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
						_g_free0 (self->priv->sink_protocol_info);
#line 143 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
						self->priv->sink_protocol_info = _tmp14_;
#line 694 "rygel-media-renderer-plugin.c"
					}
#line 146 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
					_tmp15_ = rygel_media_renderer_plugin_get_supported_profiles (self);
#line 146 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
					_tmp16_ = _tmp15_;
#line 700 "rygel-media-renderer-plugin.c"
					{
						GList* profile_collection = NULL;
						GList* profile_it = NULL;
#line 146 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
						profile_collection = _tmp16_;
#line 146 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
						for (profile_it = profile_collection; profile_it != NULL; profile_it = profile_it->next) {
#line 708 "rygel-media-renderer-plugin.c"
							RygelDLNAProfile* profile = NULL;
#line 146 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
							profile = (RygelDLNAProfile*) profile_it->data;
#line 712 "rygel-media-renderer-plugin.c"
							{
								GList* _tmp17_ = NULL;
								GList* _tmp18_ = NULL;
								gconstpointer _tmp19_ = NULL;
								const gchar* _tmp20_ = NULL;
								RygelDLNAProfile* _tmp21_ = NULL;
								const gchar* _tmp22_ = NULL;
								const gchar* _tmp25_ = NULL;
								const gchar* _tmp26_ = NULL;
								gchar* _tmp27_ = NULL;
								gchar* _tmp28_ = NULL;
								RygelDLNAProfile* _tmp29_ = NULL;
								const gchar* _tmp30_ = NULL;
								gchar* _tmp31_ = NULL;
								gchar* _tmp32_ = NULL;
								gchar* _tmp33_ = NULL;
								gchar* _tmp34_ = NULL;
								RygelDLNAProfile* _tmp35_ = NULL;
								const gchar* _tmp36_ = NULL;
								gchar* _tmp37_ = NULL;
								gchar* _tmp38_ = NULL;
								gchar* _tmp39_ = NULL;
#line 147 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp17_ = rygel_media_renderer_plugin_get_supported_profiles (self);
#line 147 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp18_ = _tmp17_;
#line 147 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp19_ = _tmp18_->data;
#line 147 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp20_ = ((RygelDLNAProfile*) _tmp19_)->name;
#line 147 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp21_ = profile;
#line 147 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp22_ = _tmp21_->name;
#line 147 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								if (g_strcmp0 (_tmp20_, _tmp22_) != 0) {
#line 749 "rygel-media-renderer-plugin.c"
									const gchar* _tmp23_ = NULL;
									gchar* _tmp24_ = NULL;
#line 148 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
									_tmp23_ = self->priv->sink_protocol_info;
#line 148 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
									_tmp24_ = g_strconcat (_tmp23_, ",", NULL);
#line 148 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
									_g_free0 (self->priv->sink_protocol_info);
#line 148 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
									self->priv->sink_protocol_info = _tmp24_;
#line 760 "rygel-media-renderer-plugin.c"
								}
#line 150 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp25_ = self->priv->sink_protocol_info;
#line 150 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp26_ = protocol;
#line 150 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp27_ = g_strconcat (_tmp26_, ":*:", NULL);
#line 150 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp28_ = _tmp27_;
#line 150 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp29_ = profile;
#line 150 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp30_ = _tmp29_->mime;
#line 150 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp31_ = g_strconcat (_tmp28_, _tmp30_, NULL);
#line 150 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp32_ = _tmp31_;
#line 150 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp33_ = g_strconcat (_tmp32_, ":DLNA.ORG_PN=", NULL);
#line 150 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp34_ = _tmp33_;
#line 150 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp35_ = profile;
#line 150 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp36_ = _tmp35_->name;
#line 150 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp37_ = g_strconcat (_tmp34_, _tmp36_, NULL);
#line 150 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp38_ = _tmp37_;
#line 150 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp39_ = g_strconcat (_tmp25_, _tmp38_, NULL);
#line 150 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_g_free0 (self->priv->sink_protocol_info);
#line 150 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								self->priv->sink_protocol_info = _tmp39_;
#line 150 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_g_free0 (_tmp38_);
#line 150 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_g_free0 (_tmp34_);
#line 150 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_g_free0 (_tmp32_);
#line 150 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_g_free0 (_tmp28_);
#line 804 "rygel-media-renderer-plugin.c"
							}
						}
					}
#line 141 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
					_g_free0 (protocol);
#line 810 "rygel-media-renderer-plugin.c"
				}
			}
		}
#line 156 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp40_ = player;
#line 156 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp42_ = rygel_media_player_get_mime_types (_tmp40_, &_tmp41_);
#line 156 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		mime_types = _tmp42_;
#line 156 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		mime_types_length1 = _tmp41_;
#line 156 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_mime_types_size_ = mime_types_length1;
#line 158 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp43_ = mime_types;
#line 158 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp43__length1 = mime_types_length1;
#line 158 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp44_ = g_strdup ("audio/mpegurl");
#line 158 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_vala_array_add1 (&mime_types, &mime_types_length1, &_mime_types_size_, _tmp44_);
#line 159 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp45_ = mime_types;
#line 159 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp45__length1 = mime_types_length1;
#line 159 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp46_ = g_strdup ("audio/x-mpegurl");
#line 159 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_vala_array_add2 (&mime_types, &mime_types_length1, &_mime_types_size_, _tmp46_);
#line 160 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp47_ = mime_types;
#line 160 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp47__length1 = mime_types_length1;
#line 160 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp48_ = g_strdup ("video/mpegurl");
#line 160 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_vala_array_add3 (&mime_types, &mime_types_length1, &_mime_types_size_, _tmp48_);
#line 161 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp49_ = mime_types;
#line 161 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp49__length1 = mime_types_length1;
#line 161 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp50_ = g_strdup ("video/x-mpegurl");
#line 161 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_vala_array_add4 (&mime_types, &mime_types_length1, &_mime_types_size_, _tmp50_);
#line 163 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp51_ = protocols;
#line 163 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp51__length1 = protocols_length1;
#line 860 "rygel-media-renderer-plugin.c"
		{
			gchar** protocol_collection = NULL;
			gint protocol_collection_length1 = 0;
			gint _protocol_collection_size_ = 0;
			gint protocol_it = 0;
#line 163 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
			protocol_collection = _tmp51_;
#line 163 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
			protocol_collection_length1 = _tmp51__length1;
#line 163 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
			for (protocol_it = 0; protocol_it < _tmp51__length1; protocol_it = protocol_it + 1) {
#line 872 "rygel-media-renderer-plugin.c"
				gchar* _tmp52_ = NULL;
				gchar* protocol = NULL;
#line 163 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
				_tmp52_ = g_strdup (protocol_collection[protocol_it]);
#line 163 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
				protocol = _tmp52_;
#line 879 "rygel-media-renderer-plugin.c"
				{
					gboolean _tmp53_ = FALSE;
					gchar** _tmp54_ = NULL;
					gint _tmp54__length1 = 0;
					const gchar* _tmp55_ = NULL;
					const gchar* _tmp56_ = NULL;
					gchar** _tmp60_ = NULL;
					gint _tmp60__length1 = 0;
#line 164 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
					_tmp54_ = protocols;
#line 164 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
					_tmp54__length1 = protocols_length1;
#line 164 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
					_tmp55_ = _tmp54_[0];
#line 164 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
					_tmp56_ = protocol;
#line 164 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
					if (g_strcmp0 (_tmp55_, _tmp56_) != 0) {
#line 164 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
						_tmp53_ = TRUE;
#line 900 "rygel-media-renderer-plugin.c"
					} else {
						const gchar* _tmp57_ = NULL;
#line 165 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
						_tmp57_ = self->priv->sink_protocol_info;
#line 165 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
						_tmp53_ = g_strcmp0 (_tmp57_, "") != 0;
#line 907 "rygel-media-renderer-plugin.c"
					}
#line 164 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
					if (_tmp53_) {
#line 911 "rygel-media-renderer-plugin.c"
						const gchar* _tmp58_ = NULL;
						gchar* _tmp59_ = NULL;
#line 166 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
						_tmp58_ = self->priv->sink_protocol_info;
#line 166 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
						_tmp59_ = g_strconcat (_tmp58_, ",", NULL);
#line 166 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
						_g_free0 (self->priv->sink_protocol_info);
#line 166 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
						self->priv->sink_protocol_info = _tmp59_;
#line 922 "rygel-media-renderer-plugin.c"
					}
#line 169 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
					_tmp60_ = mime_types;
#line 169 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
					_tmp60__length1 = mime_types_length1;
#line 928 "rygel-media-renderer-plugin.c"
					{
						gchar** mime_type_collection = NULL;
						gint mime_type_collection_length1 = 0;
						gint _mime_type_collection_size_ = 0;
						gint mime_type_it = 0;
#line 169 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
						mime_type_collection = _tmp60_;
#line 169 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
						mime_type_collection_length1 = _tmp60__length1;
#line 169 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
						for (mime_type_it = 0; mime_type_it < _tmp60__length1; mime_type_it = mime_type_it + 1) {
#line 940 "rygel-media-renderer-plugin.c"
							gchar* _tmp61_ = NULL;
							gchar* mime_type = NULL;
#line 169 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
							_tmp61_ = g_strdup (mime_type_collection[mime_type_it]);
#line 169 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
							mime_type = _tmp61_;
#line 947 "rygel-media-renderer-plugin.c"
							{
								gchar** _tmp62_ = NULL;
								gint _tmp62__length1 = 0;
								const gchar* _tmp63_ = NULL;
								const gchar* _tmp64_ = NULL;
								const gchar* _tmp67_ = NULL;
								const gchar* _tmp68_ = NULL;
								gchar* _tmp69_ = NULL;
								gchar* _tmp70_ = NULL;
								const gchar* _tmp71_ = NULL;
								gchar* _tmp72_ = NULL;
								gchar* _tmp73_ = NULL;
								gchar* _tmp74_ = NULL;
								gchar* _tmp75_ = NULL;
								gchar* _tmp76_ = NULL;
#line 170 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp62_ = mime_types;
#line 170 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp62__length1 = mime_types_length1;
#line 170 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp63_ = _tmp62_[0];
#line 170 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp64_ = mime_type;
#line 170 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								if (g_strcmp0 (_tmp63_, _tmp64_) != 0) {
#line 973 "rygel-media-renderer-plugin.c"
									const gchar* _tmp65_ = NULL;
									gchar* _tmp66_ = NULL;
#line 171 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
									_tmp65_ = self->priv->sink_protocol_info;
#line 171 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
									_tmp66_ = g_strconcat (_tmp65_, ",", NULL);
#line 171 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
									_g_free0 (self->priv->sink_protocol_info);
#line 171 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
									self->priv->sink_protocol_info = _tmp66_;
#line 984 "rygel-media-renderer-plugin.c"
								}
#line 174 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp67_ = self->priv->sink_protocol_info;
#line 174 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp68_ = protocol;
#line 174 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp69_ = g_strconcat (_tmp68_, ":*:", NULL);
#line 174 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp70_ = _tmp69_;
#line 174 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp71_ = mime_type;
#line 174 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp72_ = g_strconcat (_tmp70_, _tmp71_, NULL);
#line 174 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp73_ = _tmp72_;
#line 174 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp74_ = g_strconcat (_tmp73_, ":*", NULL);
#line 174 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp75_ = _tmp74_;
#line 174 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_tmp76_ = g_strconcat (_tmp67_, _tmp75_, NULL);
#line 174 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_g_free0 (self->priv->sink_protocol_info);
#line 174 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								self->priv->sink_protocol_info = _tmp76_;
#line 174 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_g_free0 (_tmp75_);
#line 174 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_g_free0 (_tmp73_);
#line 174 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_g_free0 (_tmp70_);
#line 169 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
								_g_free0 (mime_type);
#line 1018 "rygel-media-renderer-plugin.c"
							}
						}
					}
#line 163 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
					_g_free0 (protocol);
#line 1024 "rygel-media-renderer-plugin.c"
				}
			}
		}
#line 136 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		mime_types = (_vala_array_free (mime_types, mime_types_length1, (GDestroyNotify) g_free), NULL);
#line 136 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		protocols = (_vala_array_free (protocols, protocols_length1, (GDestroyNotify) g_free), NULL);
#line 1032 "rygel-media-renderer-plugin.c"
	}
#line 179 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp77_ = self->priv->sink_protocol_info;
#line 179 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp78_ = g_strdup (_tmp77_);
#line 179 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	result = _tmp78_;
#line 179 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_g_object_unref0 (player);
#line 179 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	return result;
#line 1044 "rygel-media-renderer-plugin.c"
}


GList* rygel_media_renderer_plugin_get_supported_profiles (RygelMediaRendererPlugin* self) {
	GList* result;
	GList* _tmp0_ = NULL;
#line 47 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 48 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp0_ = self->priv->_supported_profiles;
#line 48 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	result = _tmp0_;
#line 48 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	return result;
#line 1059 "rygel-media-renderer-plugin.c"
}


static gpointer _rygel_dlna_profile_ref0 (gpointer self) {
#line 55 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	return self ? rygel_dlna_profile_ref (self) : NULL;
#line 1066 "rygel-media-renderer-plugin.c"
}


void rygel_media_renderer_plugin_set_supported_profiles (RygelMediaRendererPlugin* self, GList* value) {
	GList* _tmp0_ = NULL;
#line 51 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	g_return_if_fail (self != NULL);
#line 52 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	__g_list_free__rygel_dlna_profile_unref0_0 (self->priv->_supported_profiles);
#line 52 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	self->priv->_supported_profiles = NULL;
#line 53 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_tmp0_ = value;
#line 53 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	if (_tmp0_ != NULL) {
#line 1082 "rygel-media-renderer-plugin.c"
		GList* _tmp1_ = NULL;
		RygelDLNAProfile* _tmp4_ = NULL;
#line 54 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp1_ = value;
#line 1087 "rygel-media-renderer-plugin.c"
		{
			GList* profile_collection = NULL;
			GList* profile_it = NULL;
#line 54 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
			profile_collection = _tmp1_;
#line 54 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
			for (profile_it = profile_collection; profile_it != NULL; profile_it = profile_it->next) {
#line 1095 "rygel-media-renderer-plugin.c"
				RygelDLNAProfile* profile = NULL;
#line 54 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
				profile = (RygelDLNAProfile*) profile_it->data;
#line 1099 "rygel-media-renderer-plugin.c"
				{
					RygelDLNAProfile* _tmp2_ = NULL;
					RygelDLNAProfile* _tmp3_ = NULL;
#line 55 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
					_tmp2_ = profile;
#line 55 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
					_tmp3_ = _rygel_dlna_profile_ref0 (_tmp2_);
#line 55 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
					self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp3_);
#line 1109 "rygel-media-renderer-plugin.c"
				}
			}
		}
#line 58 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		_tmp4_ = rygel_dlna_profile_new ("DIDL_S", "text/xml");
#line 58 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		self->priv->_supported_profiles = g_list_prepend (self->priv->_supported_profiles, _tmp4_);
#line 60 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		self->priv->_supported_profiles = g_list_reverse (self->priv->_supported_profiles);
#line 1119 "rygel-media-renderer-plugin.c"
	}
#line 51 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	g_object_notify ((GObject *) self, "supported-profiles");
#line 1123 "rygel-media-renderer-plugin.c"
}


static void rygel_media_renderer_plugin_class_init (RygelMediaRendererPluginClass * klass) {
#line 33 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	rygel_media_renderer_plugin_parent_class = g_type_class_peek_parent (klass);
#line 33 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	g_type_class_add_private (klass, sizeof (RygelMediaRendererPluginPrivate));
#line 33 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	((GObjectClass *) klass)->constructed = rygel_media_renderer_plugin_real_constructed;
#line 33 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	((RygelMediaRendererPluginClass *) klass)->get_player = rygel_media_renderer_plugin_real_get_player;
#line 33 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	((RygelMediaRendererPluginClass *) klass)->get_controller = rygel_media_renderer_plugin_real_get_controller;
#line 33 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	((RygelPluginClass *) klass)->apply_hacks = rygel_media_renderer_plugin_real_apply_hacks;
#line 33 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_renderer_plugin_get_property;
#line 33 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_renderer_plugin_set_property;
#line 33 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_renderer_plugin_finalize;
#line 33 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_RENDERER_PLUGIN_SUPPORTED_PROFILES, g_param_spec_pointer ("supported-profiles", "supported-profiles", "supported-profiles", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 1148 "rygel-media-renderer-plugin.c"
}


static void rygel_media_renderer_plugin_instance_init (RygelMediaRendererPlugin * self) {
#line 33 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	self->priv = RYGEL_MEDIA_RENDERER_PLUGIN_GET_PRIVATE (self);
#line 1155 "rygel-media-renderer-plugin.c"
}


static void rygel_media_renderer_plugin_finalize (GObject* obj) {
	RygelMediaRendererPlugin * self;
#line 33 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPlugin);
#line 39 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_g_free0 (self->priv->sink_protocol_info);
#line 40 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	_g_object_unref0 (self->priv->controller);
#line 42 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	__g_list_free__rygel_dlna_profile_unref0_0 (self->priv->_supported_profiles);
#line 33 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	G_OBJECT_CLASS (rygel_media_renderer_plugin_parent_class)->finalize (obj);
#line 1171 "rygel-media-renderer-plugin.c"
}


/**
 * This is the base class for every Rygel UPnP renderer plugin.
 *
 * This class is useful when implementing Rygel renderer plugins.
 *
 * Renderer plugins should also implement their own #RygelMediaPlayer
 * and return an instance of it from their get_player() implementation.
 */
GType rygel_media_renderer_plugin_get_type (void) {
	static volatile gsize rygel_media_renderer_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_renderer_plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaRendererPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_renderer_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaRendererPlugin), 0, (GInstanceInitFunc) rygel_media_renderer_plugin_instance_init, NULL };
		GType rygel_media_renderer_plugin_type_id;
		rygel_media_renderer_plugin_type_id = g_type_register_static (RYGEL_TYPE_PLUGIN, "RygelMediaRendererPlugin", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_renderer_plugin_type_id__volatile, rygel_media_renderer_plugin_type_id);
	}
	return rygel_media_renderer_plugin_type_id__volatile;
}


static void _vala_rygel_media_renderer_plugin_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaRendererPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPlugin);
#line 33 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	switch (property_id) {
#line 33 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		case RYGEL_MEDIA_RENDERER_PLUGIN_SUPPORTED_PROFILES:
#line 33 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		g_value_set_pointer (value, rygel_media_renderer_plugin_get_supported_profiles (self));
#line 33 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		break;
#line 1206 "rygel-media-renderer-plugin.c"
		default:
#line 33 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 33 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		break;
#line 1212 "rygel-media-renderer-plugin.c"
	}
}


static void _vala_rygel_media_renderer_plugin_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaRendererPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_MEDIA_RENDERER_PLUGIN, RygelMediaRendererPlugin);
#line 33 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
	switch (property_id) {
#line 33 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		case RYGEL_MEDIA_RENDERER_PLUGIN_SUPPORTED_PROFILES:
#line 33 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		rygel_media_renderer_plugin_set_supported_profiles (self, g_value_get_pointer (value));
#line 33 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		break;
#line 1228 "rygel-media-renderer-plugin.c"
		default:
#line 33 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 33 "/home/jens/Source/rygel/src/librygel-renderer/rygel-media-renderer-plugin.vala"
		break;
#line 1234 "rygel-media-renderer-plugin.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



