/* rygel-audio-item.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-audio-item.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 Nokia Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Doug Galligan <doug@sentosatech.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <gee.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_SERIALIZER (rygel_serializer_get_type ())
#define RYGEL_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializer))
#define RYGEL_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))
#define RYGEL_IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERIALIZER))
#define RYGEL_IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERIALIZER))
#define RYGEL_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))

typedef struct _RygelSerializer RygelSerializer;
typedef struct _RygelSerializerClass RygelSerializerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_MEDIA_RESOURCE (rygel_media_resource_get_type ())
#define RYGEL_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource))
#define RYGEL_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))
#define RYGEL_IS_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_IS_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_MEDIA_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))

typedef struct _RygelMediaResource RygelMediaResource;
typedef struct _RygelMediaResourceClass RygelMediaResourceClass;

#define RYGEL_TYPE_DATA_SOURCE (rygel_data_source_get_type ())
#define RYGEL_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSource))
#define RYGEL_IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATA_SOURCE))
#define RYGEL_DATA_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSourceIface))

typedef struct _RygelDataSource RygelDataSource;
typedef struct _RygelDataSourceIface RygelDataSourceIface;

#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;

#define RYGEL_TYPE_PLAY_SPEED_REQUEST (rygel_play_speed_request_get_type ())
#define RYGEL_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest))
#define RYGEL_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))
#define RYGEL_IS_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_IS_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_PLAY_SPEED_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))

typedef struct _RygelPlaySpeedRequest RygelPlaySpeedRequest;
typedef struct _RygelPlaySpeedRequestClass RygelPlaySpeedRequestClass;

#define RYGEL_TYPE_HTTP_RESPONSE_ELEMENT (rygel_http_response_element_get_type ())
#define RYGEL_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElement))
#define RYGEL_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_HTTP_RESPONSE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))

typedef struct _RygelHTTPResponseElement RygelHTTPResponseElement;
typedef struct _RygelHTTPResponseElementClass RygelHTTPResponseElementClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_MEDIA_FILE_ITEM (rygel_media_file_item_get_type ())
#define RYGEL_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem))
#define RYGEL_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))
#define RYGEL_IS_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_IS_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_MEDIA_FILE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))

typedef struct _RygelMediaFileItem RygelMediaFileItem;
typedef struct _RygelMediaFileItemClass RygelMediaFileItemClass;
typedef struct _RygelMediaFileItemPrivate RygelMediaFileItemPrivate;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _RygelDataSourceIface {
	GTypeInterface parent_iface;
	GeeList* (*preroll) (RygelDataSource* self, RygelHTTPSeekRequest* seek, RygelPlaySpeedRequest* playspeed, GError** error);
	void (*start) (RygelDataSource* self, GError** error);
	void (*freeze) (RygelDataSource* self);
	void (*thaw) (RygelDataSource* self);
	void (*stop) (RygelDataSource* self);
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	RygelMediaContainer* parent_ptr;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	void (*add_uri) (RygelMediaObject* self, const gchar* uri);
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
	RygelDataSource* (*create_stream_source_for_resource) (RygelMediaObject* self, RygelHTTPRequest* request, RygelMediaResource* resource, GError** error);
	void (*apply_didl_lite) (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
};

struct _RygelMediaFileItem {
	RygelMediaItem parent_instance;
	RygelMediaFileItemPrivate * priv;
};

struct _RygelMediaFileItemClass {
	RygelMediaItemClass parent_class;
	RygelMediaResource* (*get_primary_resource) (RygelMediaFileItem* self);
	gchar* (*get_extension) (RygelMediaFileItem* self);
	void (*add_additional_resources) (RygelMediaFileItem* self, RygelHTTPServer* server);
};

struct _RygelAudioItem {
	RygelMediaFileItem parent_instance;
	RygelAudioItemPrivate * priv;
};

struct _RygelAudioItemClass {
	RygelMediaFileItemClass parent_class;
};

struct _RygelAudioItemPrivate {
	glong _duration;
	gint _bitrate;
	gint _sample_freq;
	gint _bits_per_sample;
	gint _channels;
	gchar* _album;
};


static gpointer rygel_audio_item_parent_class = NULL;

GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_serializer_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_media_resource_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
GType rygel_play_speed_request_get_type (void) G_GNUC_CONST;
GType rygel_http_response_element_get_type (void) G_GNUC_CONST;
GType rygel_data_source_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_media_file_item_get_type (void) G_GNUC_CONST;
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
#define RYGEL_AUDIO_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemPrivate))
enum  {
	RYGEL_AUDIO_ITEM_DUMMY_PROPERTY,
	RYGEL_AUDIO_ITEM_DURATION,
	RYGEL_AUDIO_ITEM_BITRATE,
	RYGEL_AUDIO_ITEM_SAMPLE_FREQ,
	RYGEL_AUDIO_ITEM_BITS_PER_SAMPLE,
	RYGEL_AUDIO_ITEM_CHANNELS,
	RYGEL_AUDIO_ITEM_ALBUM
};
#define RYGEL_AUDIO_ITEM_UPNP_CLASS "object.item.audioItem"
RygelAudioItem* rygel_audio_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelAudioItem* rygel_audio_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
static void rygel_audio_item_real_apply_didl_lite (RygelMediaObject* base, GUPnPDIDLLiteObject* didl_object);
void rygel_media_object_apply_didl_lite (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
void rygel_audio_item_set_album (RygelAudioItem* self, const gchar* value);
static gint rygel_audio_item_real_compare_by_property (RygelMediaObject* base, RygelMediaObject* media_object, const gchar* property);
gint rygel_media_object_compare_string_props (RygelMediaObject* self, const gchar* prop1, const gchar* prop2);
const gchar* rygel_audio_item_get_album (RygelAudioItem* self);
gint rygel_media_object_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
static GUPnPDIDLLiteObject* rygel_audio_item_real_serialize (RygelMediaObject* base, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
GUPnPDIDLLiteObject* rygel_media_object_serialize (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
static RygelMediaResource* rygel_audio_item_real_get_primary_resource (RygelMediaFileItem* base);
RygelMediaResource* rygel_media_file_item_get_primary_resource (RygelMediaFileItem* self);
glong rygel_audio_item_get_duration (RygelAudioItem* self);
void rygel_media_resource_set_duration (RygelMediaResource* self, glong value);
gint rygel_audio_item_get_bitrate (RygelAudioItem* self);
void rygel_media_resource_set_bitrate (RygelMediaResource* self, gint value);
gint rygel_audio_item_get_sample_freq (RygelAudioItem* self);
void rygel_media_resource_set_sample_freq (RygelMediaResource* self, gint value);
gint rygel_audio_item_get_bits_per_sample (RygelAudioItem* self);
void rygel_media_resource_set_bits_per_sample (RygelMediaResource* self, gint value);
gint rygel_audio_item_get_channels (RygelAudioItem* self);
void rygel_media_resource_set_audio_channels (RygelMediaResource* self, gint value);
GUPnPDLNAFlags rygel_media_resource_get_dlna_flags (RygelMediaResource* self);
void rygel_media_resource_set_dlna_flags (RygelMediaResource* self, GUPnPDLNAFlags value);
void rygel_audio_item_set_duration (RygelAudioItem* self, glong value);
void rygel_audio_item_set_bitrate (RygelAudioItem* self, gint value);
void rygel_audio_item_set_sample_freq (RygelAudioItem* self, gint value);
void rygel_audio_item_set_bits_per_sample (RygelAudioItem* self, gint value);
void rygel_audio_item_set_channels (RygelAudioItem* self, gint value);
static void rygel_audio_item_finalize (GObject* obj);
static void _vala_rygel_audio_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_audio_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


RygelAudioItem* rygel_audio_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class) {
	RygelAudioItem * self = NULL;
	const gchar* _tmp0_ = NULL;
	RygelMediaContainer* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	g_return_val_if_fail (upnp_class != NULL, NULL);
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	_tmp0_ = id;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	_tmp1_ = parent;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	_tmp2_ = title;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	_tmp3_ = upnp_class;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	self = (RygelAudioItem*) g_object_new (object_type, "id", _tmp0_, "parent", _tmp1_, "title", _tmp2_, "upnp-class", _tmp3_, NULL);
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	return self;
#line 327 "rygel-audio-item.c"
}


RygelAudioItem* rygel_audio_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class) {
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	return rygel_audio_item_construct (RYGEL_TYPE_AUDIO_ITEM, id, parent, title, upnp_class);
#line 334 "rygel-audio-item.c"
}


static void rygel_audio_item_real_apply_didl_lite (RygelMediaObject* base, GUPnPDIDLLiteObject* didl_object) {
	RygelAudioItem * self;
	GUPnPDIDLLiteObject* _tmp0_ = NULL;
	GUPnPDIDLLiteObject* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	self = (RygelAudioItem*) base;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	g_return_if_fail (didl_object != NULL);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	_tmp0_ = didl_object;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	RYGEL_MEDIA_OBJECT_CLASS (rygel_audio_item_parent_class)->apply_didl_lite ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem), _tmp0_);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	_tmp1_ = didl_object;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	_tmp2_ = gupnp_didl_lite_object_get_album (_tmp1_);
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	_tmp3_ = _tmp2_;
#line 81 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	rygel_audio_item_set_album (self, _tmp3_);
#line 360 "rygel-audio-item.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	return self ? g_object_ref (self) : NULL;
#line 367 "rygel-audio-item.c"
}


static gint rygel_audio_item_real_compare_by_property (RygelMediaObject* base, RygelMediaObject* media_object, const gchar* property) {
	RygelAudioItem * self;
	gint result = 0;
	RygelMediaObject* _tmp0_ = NULL;
	RygelAudioItem* item = NULL;
	RygelMediaObject* _tmp1_ = NULL;
	RygelAudioItem* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GQuark _tmp6_ = 0U;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	static GQuark _tmp5_label0 = 0;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	self = (RygelAudioItem*) base;
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	g_return_val_if_fail (media_object != NULL, 0);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	g_return_val_if_fail (property != NULL, 0);
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	_tmp0_ = media_object;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_AUDIO_ITEM)) {
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		result = 1;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		return result;
#line 397 "rygel-audio-item.c"
	}
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	_tmp1_ = media_object;
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp1_) : NULL);
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	item = _tmp2_;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	_tmp3_ = property;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	_tmp4_ = _tmp3_;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("upnp:album")))) {
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		switch (0) {
#line 415 "rygel-audio-item.c"
			default:
			{
				const gchar* _tmp7_ = NULL;
				RygelAudioItem* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				gint _tmp10_ = 0;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
				_tmp7_ = self->priv->_album;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
				_tmp8_ = item;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
				_tmp9_ = _tmp8_->priv->_album;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
				_tmp10_ = rygel_media_object_compare_string_props ((RygelMediaObject*) self, _tmp7_, _tmp9_);
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
				result = _tmp10_;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
				_g_object_unref0 (item);
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
				return result;
#line 436 "rygel-audio-item.c"
			}
		}
	} else {
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		switch (0) {
#line 442 "rygel-audio-item.c"
			default:
			{
				RygelAudioItem* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				gint _tmp13_ = 0;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
				_tmp11_ = item;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
				_tmp12_ = property;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
				_tmp13_ = RYGEL_MEDIA_OBJECT_CLASS (rygel_audio_item_parent_class)->compare_by_property ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem), (RygelMediaObject*) _tmp11_, _tmp12_);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
				result = _tmp13_;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
				_g_object_unref0 (item);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
				return result;
#line 460 "rygel-audio-item.c"
			}
		}
	}
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	_g_object_unref0 (item);
#line 466 "rygel-audio-item.c"
}


static GUPnPDIDLLiteObject* rygel_audio_item_real_serialize (RygelMediaObject* base, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error) {
	RygelAudioItem * self;
	GUPnPDIDLLiteObject* result = NULL;
	GUPnPDIDLLiteObject* didl_item = NULL;
	RygelSerializer* _tmp0_ = NULL;
	RygelHTTPServer* _tmp1_ = NULL;
	GUPnPDIDLLiteObject* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	self = (RygelAudioItem*) base;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	g_return_val_if_fail (serializer != NULL, NULL);
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	g_return_val_if_fail (http_server != NULL, NULL);
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	_tmp0_ = serializer;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	_tmp1_ = http_server;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	_tmp2_ = RYGEL_MEDIA_OBJECT_CLASS (rygel_audio_item_parent_class)->serialize ((RygelMediaObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem), _tmp0_, _tmp1_, &_inner_error_);
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	didl_item = _tmp2_;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		g_propagate_error (error, _inner_error_);
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		return NULL;
#line 500 "rygel-audio-item.c"
	}
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	_tmp4_ = self->priv->_album;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	if (_tmp4_ != NULL) {
#line 506 "rygel-audio-item.c"
		const gchar* _tmp5_ = NULL;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		_tmp5_ = self->priv->_album;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		_tmp3_ = g_strcmp0 (_tmp5_, "") != 0;
#line 512 "rygel-audio-item.c"
	} else {
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		_tmp3_ = FALSE;
#line 516 "rygel-audio-item.c"
	}
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	if (_tmp3_) {
#line 520 "rygel-audio-item.c"
		const gchar* _tmp6_ = NULL;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		_tmp6_ = self->priv->_album;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		gupnp_didl_lite_object_set_album (didl_item, _tmp6_);
#line 526 "rygel-audio-item.c"
	}
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	result = didl_item;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	return result;
#line 532 "rygel-audio-item.c"
}


static RygelMediaResource* rygel_audio_item_real_get_primary_resource (RygelMediaFileItem* base) {
	RygelAudioItem * self;
	RygelMediaResource* result = NULL;
	RygelMediaResource* res = NULL;
	RygelMediaResource* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GUPnPDLNAFlags _tmp6_ = 0;
	GUPnPDLNAFlags _tmp7_ = 0;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	self = (RygelAudioItem*) base;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	_tmp0_ = RYGEL_MEDIA_FILE_ITEM_CLASS (rygel_audio_item_parent_class)->get_primary_resource (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem));
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	res = _tmp0_;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	_tmp1_ = self->priv->_duration;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	rygel_media_resource_set_duration (res, _tmp1_);
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	_tmp2_ = self->priv->_bitrate;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	rygel_media_resource_set_bitrate (res, _tmp2_);
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	_tmp3_ = self->priv->_sample_freq;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	rygel_media_resource_set_sample_freq (res, _tmp3_);
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	_tmp4_ = self->priv->_bits_per_sample;
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	rygel_media_resource_set_bits_per_sample (res, _tmp4_);
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	_tmp5_ = self->priv->_channels;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	rygel_media_resource_set_audio_channels (res, _tmp5_);
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	_tmp6_ = rygel_media_resource_get_dlna_flags (res);
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	_tmp7_ = _tmp6_;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	rygel_media_resource_set_dlna_flags (res, _tmp7_ | GUPNP_DLNA_FLAGS_STREAMING_TRANSFER_MODE);
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	result = res;
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	return result;
#line 584 "rygel-audio-item.c"
}


glong rygel_audio_item_get_duration (RygelAudioItem* self) {
	glong result;
	glong _tmp0_ = 0L;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	g_return_val_if_fail (self != NULL, 0L);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	_tmp0_ = self->priv->_duration;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	result = _tmp0_;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	return result;
#line 599 "rygel-audio-item.c"
}


void rygel_audio_item_set_duration (RygelAudioItem* self, glong value) {
	glong _tmp0_ = 0L;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	g_return_if_fail (self != NULL);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	_tmp0_ = value;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	self->priv->_duration = _tmp0_;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	g_object_notify ((GObject *) self, "duration");
#line 613 "rygel-audio-item.c"
}


gint rygel_audio_item_get_bitrate (RygelAudioItem* self) {
	gint result;
	gint _tmp0_ = 0;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	_tmp0_ = self->priv->_bitrate;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	result = _tmp0_;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	return result;
#line 628 "rygel-audio-item.c"
}


void rygel_audio_item_set_bitrate (RygelAudioItem* self, gint value) {
	gint _tmp0_ = 0;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	g_return_if_fail (self != NULL);
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	_tmp0_ = value;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	self->priv->_bitrate = _tmp0_;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	g_object_notify ((GObject *) self, "bitrate");
#line 642 "rygel-audio-item.c"
}


gint rygel_audio_item_get_sample_freq (RygelAudioItem* self) {
	gint result;
	gint _tmp0_ = 0;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	_tmp0_ = self->priv->_sample_freq;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	result = _tmp0_;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	return result;
#line 657 "rygel-audio-item.c"
}


void rygel_audio_item_set_sample_freq (RygelAudioItem* self, gint value) {
	gint _tmp0_ = 0;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	g_return_if_fail (self != NULL);
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	_tmp0_ = value;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	self->priv->_sample_freq = _tmp0_;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	g_object_notify ((GObject *) self, "sample-freq");
#line 671 "rygel-audio-item.c"
}


gint rygel_audio_item_get_bits_per_sample (RygelAudioItem* self) {
	gint result;
	gint _tmp0_ = 0;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	_tmp0_ = self->priv->_bits_per_sample;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	result = _tmp0_;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	return result;
#line 686 "rygel-audio-item.c"
}


void rygel_audio_item_set_bits_per_sample (RygelAudioItem* self, gint value) {
	gint _tmp0_ = 0;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	g_return_if_fail (self != NULL);
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	_tmp0_ = value;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	self->priv->_bits_per_sample = _tmp0_;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	g_object_notify ((GObject *) self, "bits-per-sample");
#line 700 "rygel-audio-item.c"
}


gint rygel_audio_item_get_channels (RygelAudioItem* self) {
	gint result;
	gint _tmp0_ = 0;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	_tmp0_ = self->priv->_channels;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	result = _tmp0_;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	return result;
#line 715 "rygel-audio-item.c"
}


void rygel_audio_item_set_channels (RygelAudioItem* self, gint value) {
	gint _tmp0_ = 0;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	g_return_if_fail (self != NULL);
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	_tmp0_ = value;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	self->priv->_channels = _tmp0_;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	g_object_notify ((GObject *) self, "channels");
#line 729 "rygel-audio-item.c"
}


const gchar* rygel_audio_item_get_album (RygelAudioItem* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	_tmp0_ = self->priv->_album;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	result = _tmp0_;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	return result;
#line 744 "rygel-audio-item.c"
}


void rygel_audio_item_set_album (RygelAudioItem* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	g_return_if_fail (self != NULL);
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	_tmp0_ = value;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	_g_free0 (self->priv->_album);
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	self->priv->_album = _tmp1_;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	g_object_notify ((GObject *) self, "album");
#line 763 "rygel-audio-item.c"
}


static void rygel_audio_item_class_init (RygelAudioItemClass * klass) {
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	rygel_audio_item_parent_class = g_type_class_peek_parent (klass);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	g_type_class_add_private (klass, sizeof (RygelAudioItemPrivate));
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	((RygelMediaObjectClass *) klass)->apply_didl_lite = rygel_audio_item_real_apply_didl_lite;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	((RygelMediaObjectClass *) klass)->compare_by_property = rygel_audio_item_real_compare_by_property;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	((RygelMediaObjectClass *) klass)->serialize = rygel_audio_item_real_serialize;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	((RygelMediaFileItemClass *) klass)->get_primary_resource = rygel_audio_item_real_get_primary_resource;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_audio_item_get_property;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_audio_item_set_property;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_audio_item_finalize;
#line 786 "rygel-audio-item.c"
	/**
	     * The duration of the source content (this.uri) in seconds.
	     * A value of -1 means the duration is unknown
	     */
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AUDIO_ITEM_DURATION, g_param_spec_long ("duration", "duration", "duration", G_MINLONG, G_MAXLONG, (glong) (-1), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 793 "rygel-audio-item.c"
	/**
	     * The bitrate of the source content (this.uri) in bytes/second.
	     * A value of -1 means the bitrate is unknown
	     */
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AUDIO_ITEM_BITRATE, g_param_spec_int ("bitrate", "bitrate", "bitrate", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 800 "rygel-audio-item.c"
	/**
	     * The sample frequency of the source content (this.uri) in Hz.
	     * A value of -1 means the sample frequency is unknown
	     */
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AUDIO_ITEM_SAMPLE_FREQ, g_param_spec_int ("sample-freq", "sample-freq", "sample-freq", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 807 "rygel-audio-item.c"
	/**
	     * The bits per sample of the source content (this.uri).
	     * A value of -1 means the bits per sample is unknown
	     */
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AUDIO_ITEM_BITS_PER_SAMPLE, g_param_spec_int ("bits-per-sample", "bits-per-sample", "bits-per-sample", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 814 "rygel-audio-item.c"
	/**
	     * The number of audio channels in the source content (this.uri).
	     * A value of -1 means the number of channels is unknown
	     */
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AUDIO_ITEM_CHANNELS, g_param_spec_int ("channels", "channels", "channels", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_AUDIO_ITEM_ALBUM, g_param_spec_string ("album", "album", "album", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 823 "rygel-audio-item.c"
}


static void rygel_audio_item_instance_init (RygelAudioItem * self) {
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	self->priv = RYGEL_AUDIO_ITEM_GET_PRIVATE (self);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	self->priv->_duration = (glong) (-1);
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	self->priv->_bitrate = -1;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	self->priv->_sample_freq = -1;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	self->priv->_bits_per_sample = -1;
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	self->priv->_channels = -1;
#line 840 "rygel-audio-item.c"
}


static void rygel_audio_item_finalize (GObject* obj) {
	RygelAudioItem * self;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem);
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	_g_free0 (self->priv->_album);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	G_OBJECT_CLASS (rygel_audio_item_parent_class)->finalize (obj);
#line 852 "rygel-audio-item.c"
}


/**
 * Represents an audio item contained in a file.
 */
GType rygel_audio_item_get_type (void) {
	static volatile gsize rygel_audio_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_audio_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelAudioItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_audio_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelAudioItem), 0, (GInstanceInitFunc) rygel_audio_item_instance_init, NULL };
		GType rygel_audio_item_type_id;
		rygel_audio_item_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_FILE_ITEM, "RygelAudioItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_audio_item_type_id__volatile, rygel_audio_item_type_id);
	}
	return rygel_audio_item_type_id__volatile;
}


static void _vala_rygel_audio_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelAudioItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	switch (property_id) {
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		case RYGEL_AUDIO_ITEM_DURATION:
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		g_value_set_long (value, rygel_audio_item_get_duration (self));
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		break;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		case RYGEL_AUDIO_ITEM_BITRATE:
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		g_value_set_int (value, rygel_audio_item_get_bitrate (self));
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		break;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		case RYGEL_AUDIO_ITEM_SAMPLE_FREQ:
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		g_value_set_int (value, rygel_audio_item_get_sample_freq (self));
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		break;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		case RYGEL_AUDIO_ITEM_BITS_PER_SAMPLE:
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		g_value_set_int (value, rygel_audio_item_get_bits_per_sample (self));
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		break;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		case RYGEL_AUDIO_ITEM_CHANNELS:
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		g_value_set_int (value, rygel_audio_item_get_channels (self));
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		break;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		case RYGEL_AUDIO_ITEM_ALBUM:
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		g_value_set_string (value, rygel_audio_item_get_album (self));
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		break;
#line 912 "rygel-audio-item.c"
		default:
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		break;
#line 918 "rygel-audio-item.c"
	}
}


static void _vala_rygel_audio_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelAudioItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
	switch (property_id) {
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		case RYGEL_AUDIO_ITEM_DURATION:
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		rygel_audio_item_set_duration (self, g_value_get_long (value));
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		break;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		case RYGEL_AUDIO_ITEM_BITRATE:
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		rygel_audio_item_set_bitrate (self, g_value_get_int (value));
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		break;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		case RYGEL_AUDIO_ITEM_SAMPLE_FREQ:
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		rygel_audio_item_set_sample_freq (self, g_value_get_int (value));
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		break;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		case RYGEL_AUDIO_ITEM_BITS_PER_SAMPLE:
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		rygel_audio_item_set_bits_per_sample (self, g_value_get_int (value));
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		break;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		case RYGEL_AUDIO_ITEM_CHANNELS:
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		rygel_audio_item_set_channels (self, g_value_get_int (value));
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		break;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		case RYGEL_AUDIO_ITEM_ALBUM:
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		rygel_audio_item_set_album (self, g_value_get_string (value));
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		break;
#line 964 "rygel-audio-item.c"
		default:
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-audio-item.vala"
		break;
#line 970 "rygel-audio-item.c"
	}
}



