/* rygel-dlna-available-seek-response.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-dlna-available-seek-response.vala, do not modify */

/*
 * Copyright (C) 2014  Cable Television Laboratories, Inc.
 * Contact: http://www.cablelabs.com/
 *
 * Author: Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
 * IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL CABLE TELEVISION LABORATORIES
 * INC. OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-core.h>
#include <gio/gio.h>
#include <libsoup/soup.h>
#include <float.h>
#include <math.h>


#define RYGEL_TYPE_HTTP_RESPONSE_ELEMENT (rygel_http_response_element_get_type ())
#define RYGEL_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElement))
#define RYGEL_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_HTTP_RESPONSE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))

typedef struct _RygelHTTPResponseElement RygelHTTPResponseElement;
typedef struct _RygelHTTPResponseElementClass RygelHTTPResponseElementClass;
typedef struct _RygelHTTPResponseElementPrivate RygelHTTPResponseElementPrivate;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE (rygel_dlna_available_seek_range_response_get_type ())
#define RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE, RygelDLNAAvailableSeekRangeResponse))
#define RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE, RygelDLNAAvailableSeekRangeResponseClass))
#define RYGEL_IS_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE))
#define RYGEL_IS_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE))
#define RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE, RygelDLNAAvailableSeekRangeResponseClass))

typedef struct _RygelDLNAAvailableSeekRangeResponse RygelDLNAAvailableSeekRangeResponse;
typedef struct _RygelDLNAAvailableSeekRangeResponseClass RygelDLNAAvailableSeekRangeResponseClass;
typedef struct _RygelDLNAAvailableSeekRangeResponsePrivate RygelDLNAAvailableSeekRangeResponsePrivate;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _RygelHTTPResponseElement {
	GObject parent_instance;
	RygelHTTPResponseElementPrivate * priv;
};

struct _RygelHTTPResponseElementClass {
	GObjectClass parent_class;
	void (*add_response_headers) (RygelHTTPResponseElement* self, RygelHTTPRequest* request);
	gchar* (*to_string) (RygelHTTPResponseElement* self);
};

struct _RygelDLNAAvailableSeekRangeResponse {
	RygelHTTPResponseElement parent_instance;
	RygelDLNAAvailableSeekRangeResponsePrivate * priv;
};

struct _RygelDLNAAvailableSeekRangeResponseClass {
	RygelHTTPResponseElementClass parent_class;
};

struct _RygelDLNAAvailableSeekRangeResponsePrivate {
	gint _mode;
	gint64 _start_time;
	gint64 _end_time;
	gint64 _start_byte;
	gint64 _end_byte;
	gint64 _range_length;
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaObject* object;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};


static gpointer rygel_dlna_available_seek_range_response_parent_class = NULL;

#define AVAILABLE_SEEK_RANGE_HEADER "availableSeekRange.dlna.org"
GType rygel_http_response_element_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_dlna_available_seek_range_response_get_type (void) G_GNUC_CONST;
#define RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE, RygelDLNAAvailableSeekRangeResponsePrivate))
enum  {
	RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_DUMMY_PROPERTY,
	RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_MODE,
	RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_START_TIME,
	RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_END_TIME,
	RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_START_BYTE,
	RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_END_BYTE,
	RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_RANGE_LENGTH
};
RygelDLNAAvailableSeekRangeResponse* rygel_dlna_available_seek_range_response_new (gint mode, gint64 start_time, gint64 end_time, gint64 start_byte, gint64 end_byte);
RygelDLNAAvailableSeekRangeResponse* rygel_dlna_available_seek_range_response_construct (GType object_type, gint mode, gint64 start_time, gint64 end_time, gint64 start_byte, gint64 end_byte);
RygelHTTPResponseElement* rygel_http_response_element_construct (GType object_type);
static void rygel_dlna_available_seek_range_response_set_mode (RygelDLNAAvailableSeekRangeResponse* self, gint value);
static void rygel_dlna_available_seek_range_response_set_start_time (RygelDLNAAvailableSeekRangeResponse* self, gint64 value);
static void rygel_dlna_available_seek_range_response_set_end_time (RygelDLNAAvailableSeekRangeResponse* self, gint64 value);
static void rygel_dlna_available_seek_range_response_set_start_byte (RygelDLNAAvailableSeekRangeResponse* self, gint64 value);
static void rygel_dlna_available_seek_range_response_set_end_byte (RygelDLNAAvailableSeekRangeResponse* self, gint64 value);
static void rygel_dlna_available_seek_range_response_set_range_length (RygelDLNAAvailableSeekRangeResponse* self, gint64 value);
RygelDLNAAvailableSeekRangeResponse* rygel_dlna_available_seek_range_response_new_time_only (gint mode, gint64 start_time, gint64 end_time);
RygelDLNAAvailableSeekRangeResponse* rygel_dlna_available_seek_range_response_construct_time_only (GType object_type, gint mode, gint64 start_time, gint64 end_time);
#define RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED ((gint64) (-1))
static void rygel_dlna_available_seek_range_response_real_add_response_headers (RygelHTTPResponseElement* base, RygelHTTPRequest* request);
static gchar* rygel_dlna_available_seek_range_response_get_response_string (RygelDLNAAvailableSeekRangeResponse* self);
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
gint64 rygel_dlna_available_seek_range_response_get_start_time (RygelDLNAAvailableSeekRangeResponse* self);
gint rygel_dlna_available_seek_range_response_get_mode (RygelDLNAAvailableSeekRangeResponse* self);
gint64 rygel_dlna_available_seek_range_response_get_end_time (RygelDLNAAvailableSeekRangeResponse* self);
gint64 rygel_dlna_available_seek_range_response_get_start_byte (RygelDLNAAvailableSeekRangeResponse* self);
gint64 rygel_dlna_available_seek_range_response_get_end_byte (RygelDLNAAvailableSeekRangeResponse* self);
static gchar* rygel_dlna_available_seek_range_response_real_to_string (RygelHTTPResponseElement* base);
gint64 rygel_dlna_available_seek_range_response_get_range_length (RygelDLNAAvailableSeekRangeResponse* self);
static void rygel_dlna_available_seek_range_response_finalize (GObject* obj);
static void _vala_rygel_dlna_available_seek_range_response_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_dlna_available_seek_range_response_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


RygelDLNAAvailableSeekRangeResponse* rygel_dlna_available_seek_range_response_construct (GType object_type, gint mode, gint64 start_time, gint64 end_time, gint64 start_byte, gint64 end_byte) {
	RygelDLNAAvailableSeekRangeResponse * self = NULL;
	gint _tmp0_ = 0;
	gint64 _tmp1_ = 0LL;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_ = 0LL;
	gint64 _tmp4_ = 0LL;
	gint64 _tmp5_ = 0LL;
	gint64 _tmp6_ = 0LL;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	self = (RygelDLNAAvailableSeekRangeResponse*) rygel_http_response_element_construct (object_type);
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_tmp0_ = mode;
#line 67 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	rygel_dlna_available_seek_range_response_set_mode (self, _tmp0_);
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_tmp1_ = start_time;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	rygel_dlna_available_seek_range_response_set_start_time (self, _tmp1_);
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_tmp2_ = end_time;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	rygel_dlna_available_seek_range_response_set_end_time (self, _tmp2_);
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_tmp3_ = start_byte;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	rygel_dlna_available_seek_range_response_set_start_byte (self, _tmp3_);
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_tmp4_ = end_byte;
#line 71 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	rygel_dlna_available_seek_range_response_set_end_byte (self, _tmp4_);
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_tmp5_ = end_byte;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_tmp6_ = start_byte;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	rygel_dlna_available_seek_range_response_set_range_length (self, (_tmp5_ - _tmp6_) + 1);
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	return self;
#line 255 "rygel-dlna-available-seek-response.c"
}


RygelDLNAAvailableSeekRangeResponse* rygel_dlna_available_seek_range_response_new (gint mode, gint64 start_time, gint64 end_time, gint64 start_byte, gint64 end_byte) {
#line 64 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	return rygel_dlna_available_seek_range_response_construct (RYGEL_TYPE_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE, mode, start_time, end_time, start_byte, end_byte);
#line 262 "rygel-dlna-available-seek-response.c"
}


RygelDLNAAvailableSeekRangeResponse* rygel_dlna_available_seek_range_response_construct_time_only (GType object_type, gint mode, gint64 start_time, gint64 end_time) {
	RygelDLNAAvailableSeekRangeResponse * self = NULL;
	gint _tmp0_ = 0;
	gint64 _tmp1_ = 0LL;
	gint64 _tmp2_ = 0LL;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	self = (RygelDLNAAvailableSeekRangeResponse*) rygel_http_response_element_construct (object_type);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_tmp0_ = mode;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	rygel_dlna_available_seek_range_response_set_mode (self, _tmp0_);
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_tmp1_ = start_time;
#line 78 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	rygel_dlna_available_seek_range_response_set_start_time (self, _tmp1_);
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_tmp2_ = end_time;
#line 79 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	rygel_dlna_available_seek_range_response_set_end_time (self, _tmp2_);
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	rygel_dlna_available_seek_range_response_set_range_length (self, RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED);
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	rygel_dlna_available_seek_range_response_set_end_byte (self, RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED);
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	rygel_dlna_available_seek_range_response_set_start_byte (self, RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED);
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	return self;
#line 293 "rygel-dlna-available-seek-response.c"
}


RygelDLNAAvailableSeekRangeResponse* rygel_dlna_available_seek_range_response_new_time_only (gint mode, gint64 start_time, gint64 end_time) {
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	return rygel_dlna_available_seek_range_response_construct_time_only (RYGEL_TYPE_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE, mode, start_time, end_time);
#line 300 "rygel-dlna-available-seek-response.c"
}


static void rygel_dlna_available_seek_range_response_real_add_response_headers (RygelHTTPResponseElement* base, RygelHTTPRequest* request) {
	RygelDLNAAvailableSeekRangeResponse * self;
	gchar* response = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	self = (RygelDLNAAvailableSeekRangeResponse*) base;
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	g_return_if_fail (request != NULL);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_tmp0_ = rygel_dlna_available_seek_range_response_get_response_string (self);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	response = _tmp0_;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_tmp1_ = response;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	if (_tmp1_ != NULL) {
#line 321 "rygel-dlna-available-seek-response.c"
		RygelHTTPRequest* _tmp2_ = NULL;
		SoupMessage* _tmp3_ = NULL;
		SoupMessageHeaders* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		_tmp2_ = request;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		_tmp3_ = _tmp2_->msg;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		_tmp4_ = _tmp3_->response_headers;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		_tmp5_ = response;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		soup_message_headers_append (_tmp4_, AVAILABLE_SEEK_RANGE_HEADER, _tmp5_);
#line 336 "rygel-dlna-available-seek-response.c"
	}
#line 83 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_g_free0 (response);
#line 340 "rygel-dlna-available-seek-response.c"
}


static gchar* rygel_dlna_available_seek_range_response_get_response_string (RygelDLNAAvailableSeekRangeResponse* self) {
	gchar* result = NULL;
	gint64 _tmp0_ = 0LL;
	GString* response = NULL;
	GString* _tmp1_ = NULL;
	GString* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GString* _tmp6_ = NULL;
	GString* _tmp7_ = NULL;
	gint64 _tmp8_ = 0LL;
	GString* _tmp9_ = NULL;
	gint64 _tmp10_ = 0LL;
	gint64 _tmp11_ = 0LL;
	GString* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_tmp0_ = self->priv->_start_time;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	if (_tmp0_ == RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED) {
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		result = NULL;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		return result;
#line 372 "rygel-dlna-available-seek-response.c"
	}
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_tmp1_ = g_string_new ("");
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	response = _tmp1_;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_tmp2_ = response;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_tmp3_ = self->priv->_mode;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_tmp4_ = g_strdup_printf ("%i", _tmp3_);
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_tmp5_ = _tmp4_;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	g_string_append (_tmp2_, _tmp5_);
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_g_free0 (_tmp5_);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_tmp6_ = response;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	g_string_append (_tmp6_, " npt=");
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_tmp7_ = response;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_tmp8_ = self->priv->_start_time;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	g_string_append_printf (_tmp7_, "%.3f-", ((gdouble) _tmp8_) / G_TIME_SPAN_SECOND);
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_tmp9_ = response;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_tmp10_ = self->priv->_end_time;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	g_string_append_printf (_tmp9_, "%.3f", ((gdouble) _tmp10_) / G_TIME_SPAN_SECOND);
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_tmp11_ = self->priv->_start_byte;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	if (_tmp11_ != RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED) {
#line 410 "rygel-dlna-available-seek-response.c"
		GString* _tmp12_ = NULL;
		GString* _tmp13_ = NULL;
		gint64 _tmp14_ = 0LL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		GString* _tmp17_ = NULL;
		GString* _tmp18_ = NULL;
		gint64 _tmp19_ = 0LL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		_tmp12_ = response;
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		g_string_append (_tmp12_, " bytes=");
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		_tmp13_ = response;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		_tmp14_ = self->priv->_start_byte;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		_tmp15_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp14_);
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		_tmp16_ = _tmp15_;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		g_string_append (_tmp13_, _tmp16_);
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		_g_free0 (_tmp16_);
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		_tmp17_ = response;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		g_string_append (_tmp17_, "-");
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		_tmp18_ = response;
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		_tmp19_ = self->priv->_end_byte;
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		_tmp20_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp19_);
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		_tmp21_ = _tmp20_;
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		g_string_append (_tmp18_, _tmp21_);
#line 120 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		_g_free0 (_tmp21_);
#line 453 "rygel-dlna-available-seek-response.c"
	}
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_tmp22_ = response;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_tmp23_ = _tmp22_->str;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_tmp24_ = g_strdup (_tmp23_);
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	result = _tmp24_;
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_g_string_free0 (response);
#line 123 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	return result;
#line 467 "rygel-dlna-available-seek-response.c"
}


static gchar* rygel_dlna_available_seek_range_response_real_to_string (RygelHTTPResponseElement* base) {
	RygelDLNAAvailableSeekRangeResponse * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	self = (RygelDLNAAvailableSeekRangeResponse*) base;
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_tmp0_ = rygel_dlna_available_seek_range_response_get_response_string (self);
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_tmp1_ = _tmp0_;
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_tmp2_ = g_strdup_printf ("HTTPTimeSeekResponse (%s)", _tmp1_);
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_tmp3_ = _tmp2_;
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_g_free0 (_tmp1_);
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	result = _tmp3_;
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	return result;
#line 494 "rygel-dlna-available-seek-response.c"
}


gint rygel_dlna_available_seek_range_response_get_mode (RygelDLNAAvailableSeekRangeResponse* self) {
	gint result;
	gint _tmp0_ = 0;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_tmp0_ = self->priv->_mode;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	result = _tmp0_;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	return result;
#line 509 "rygel-dlna-available-seek-response.c"
}


static void rygel_dlna_available_seek_range_response_set_mode (RygelDLNAAvailableSeekRangeResponse* self, gint value) {
	gint _tmp0_ = 0;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	g_return_if_fail (self != NULL);
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_tmp0_ = value;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	self->priv->_mode = _tmp0_;
#line 37 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	g_object_notify ((GObject *) self, "mode");
#line 523 "rygel-dlna-available-seek-response.c"
}


gint64 rygel_dlna_available_seek_range_response_get_start_time (RygelDLNAAvailableSeekRangeResponse* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_tmp0_ = self->priv->_start_time;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	result = _tmp0_;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	return result;
#line 538 "rygel-dlna-available-seek-response.c"
}


static void rygel_dlna_available_seek_range_response_set_start_time (RygelDLNAAvailableSeekRangeResponse* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	g_return_if_fail (self != NULL);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_tmp0_ = value;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	self->priv->_start_time = _tmp0_;
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	g_object_notify ((GObject *) self, "start-time");
#line 552 "rygel-dlna-available-seek-response.c"
}


gint64 rygel_dlna_available_seek_range_response_get_end_time (RygelDLNAAvailableSeekRangeResponse* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_tmp0_ = self->priv->_end_time;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	result = _tmp0_;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	return result;
#line 567 "rygel-dlna-available-seek-response.c"
}


static void rygel_dlna_available_seek_range_response_set_end_time (RygelDLNAAvailableSeekRangeResponse* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	g_return_if_fail (self != NULL);
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_tmp0_ = value;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	self->priv->_end_time = _tmp0_;
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	g_object_notify ((GObject *) self, "end-time");
#line 581 "rygel-dlna-available-seek-response.c"
}


gint64 rygel_dlna_available_seek_range_response_get_start_byte (RygelDLNAAvailableSeekRangeResponse* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_tmp0_ = self->priv->_start_byte;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	result = _tmp0_;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	return result;
#line 596 "rygel-dlna-available-seek-response.c"
}


static void rygel_dlna_available_seek_range_response_set_start_byte (RygelDLNAAvailableSeekRangeResponse* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	g_return_if_fail (self != NULL);
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_tmp0_ = value;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	self->priv->_start_byte = _tmp0_;
#line 52 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	g_object_notify ((GObject *) self, "start-byte");
#line 610 "rygel-dlna-available-seek-response.c"
}


gint64 rygel_dlna_available_seek_range_response_get_end_byte (RygelDLNAAvailableSeekRangeResponse* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_tmp0_ = self->priv->_end_byte;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	result = _tmp0_;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	return result;
#line 625 "rygel-dlna-available-seek-response.c"
}


static void rygel_dlna_available_seek_range_response_set_end_byte (RygelDLNAAvailableSeekRangeResponse* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	g_return_if_fail (self != NULL);
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_tmp0_ = value;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	self->priv->_end_byte = _tmp0_;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	g_object_notify ((GObject *) self, "end-byte");
#line 639 "rygel-dlna-available-seek-response.c"
}


gint64 rygel_dlna_available_seek_range_response_get_range_length (RygelDLNAAvailableSeekRangeResponse* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_tmp0_ = self->priv->_range_length;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	result = _tmp0_;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	return result;
#line 654 "rygel-dlna-available-seek-response.c"
}


static void rygel_dlna_available_seek_range_response_set_range_length (RygelDLNAAvailableSeekRangeResponse* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	g_return_if_fail (self != NULL);
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	_tmp0_ = value;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	self->priv->_range_length = _tmp0_;
#line 62 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	g_object_notify ((GObject *) self, "range-length");
#line 668 "rygel-dlna-available-seek-response.c"
}


static void rygel_dlna_available_seek_range_response_class_init (RygelDLNAAvailableSeekRangeResponseClass * klass) {
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	rygel_dlna_available_seek_range_response_parent_class = g_type_class_peek_parent (klass);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	g_type_class_add_private (klass, sizeof (RygelDLNAAvailableSeekRangeResponsePrivate));
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	((RygelHTTPResponseElementClass *) klass)->add_response_headers = rygel_dlna_available_seek_range_response_real_add_response_headers;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	((RygelHTTPResponseElementClass *) klass)->to_string = rygel_dlna_available_seek_range_response_real_to_string;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_dlna_available_seek_range_response_get_property;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_dlna_available_seek_range_response_set_property;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_dlna_available_seek_range_response_finalize;
#line 687 "rygel-dlna-available-seek-response.c"
	/**
	     * The Limited Operation mode (0 or 1)
	     */
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_MODE, g_param_spec_int ("mode", "mode", "mode", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 693 "rygel-dlna-available-seek-response.c"
	/**
	     * Available range start time, in microseconds
	     */
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_START_TIME, g_param_spec_int64 ("start-time", "start-time", "start-time", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 699 "rygel-dlna-available-seek-response.c"
	/**
	     * Available range end time, in microseconds
	     */
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_END_TIME, g_param_spec_int64 ("end-time", "end-time", "end-time", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 705 "rygel-dlna-available-seek-response.c"
	/**
	     * The start of the available range in bytes
	     */
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_START_BYTE, g_param_spec_int64 ("start-byte", "start-byte", "start-byte", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 711 "rygel-dlna-available-seek-response.c"
	/**
	     * The end of the available range in bytes (inclusive)
	     */
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_END_BYTE, g_param_spec_int64 ("end-byte", "end-byte", "end-byte", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 717 "rygel-dlna-available-seek-response.c"
	/**
	     * The length of the available range in bytes
	     */
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_RANGE_LENGTH, g_param_spec_int64 ("range-length", "range-length", "range-length", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 723 "rygel-dlna-available-seek-response.c"
}


static void rygel_dlna_available_seek_range_response_instance_init (RygelDLNAAvailableSeekRangeResponse * self) {
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	self->priv = RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_GET_PRIVATE (self);
#line 730 "rygel-dlna-available-seek-response.c"
}


static void rygel_dlna_available_seek_range_response_finalize (GObject* obj) {
	RygelDLNAAvailableSeekRangeResponse * self;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE, RygelDLNAAvailableSeekRangeResponse);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	G_OBJECT_CLASS (rygel_dlna_available_seek_range_response_parent_class)->finalize (obj);
#line 740 "rygel-dlna-available-seek-response.c"
}


GType rygel_dlna_available_seek_range_response_get_type (void) {
	static volatile gsize rygel_dlna_available_seek_range_response_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_dlna_available_seek_range_response_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelDLNAAvailableSeekRangeResponseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_dlna_available_seek_range_response_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelDLNAAvailableSeekRangeResponse), 0, (GInstanceInitFunc) rygel_dlna_available_seek_range_response_instance_init, NULL };
		GType rygel_dlna_available_seek_range_response_type_id;
		rygel_dlna_available_seek_range_response_type_id = g_type_register_static (RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, "RygelDLNAAvailableSeekRangeResponse", &g_define_type_info, 0);
		g_once_init_leave (&rygel_dlna_available_seek_range_response_type_id__volatile, rygel_dlna_available_seek_range_response_type_id);
	}
	return rygel_dlna_available_seek_range_response_type_id__volatile;
}


static void _vala_rygel_dlna_available_seek_range_response_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelDLNAAvailableSeekRangeResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE, RygelDLNAAvailableSeekRangeResponse);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	switch (property_id) {
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		case RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_MODE:
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		g_value_set_int (value, rygel_dlna_available_seek_range_response_get_mode (self));
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		break;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		case RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_START_TIME:
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		g_value_set_int64 (value, rygel_dlna_available_seek_range_response_get_start_time (self));
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		break;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		case RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_END_TIME:
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		g_value_set_int64 (value, rygel_dlna_available_seek_range_response_get_end_time (self));
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		break;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		case RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_START_BYTE:
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		g_value_set_int64 (value, rygel_dlna_available_seek_range_response_get_start_byte (self));
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		break;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		case RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_END_BYTE:
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		g_value_set_int64 (value, rygel_dlna_available_seek_range_response_get_end_byte (self));
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		break;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		case RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_RANGE_LENGTH:
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		g_value_set_int64 (value, rygel_dlna_available_seek_range_response_get_range_length (self));
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		break;
#line 797 "rygel-dlna-available-seek-response.c"
		default:
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		break;
#line 803 "rygel-dlna-available-seek-response.c"
	}
}


static void _vala_rygel_dlna_available_seek_range_response_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelDLNAAvailableSeekRangeResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE, RygelDLNAAvailableSeekRangeResponse);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
	switch (property_id) {
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		case RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_MODE:
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		rygel_dlna_available_seek_range_response_set_mode (self, g_value_get_int (value));
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		break;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		case RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_START_TIME:
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		rygel_dlna_available_seek_range_response_set_start_time (self, g_value_get_int64 (value));
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		break;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		case RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_END_TIME:
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		rygel_dlna_available_seek_range_response_set_end_time (self, g_value_get_int64 (value));
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		break;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		case RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_START_BYTE:
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		rygel_dlna_available_seek_range_response_set_start_byte (self, g_value_get_int64 (value));
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		break;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		case RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_END_BYTE:
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		rygel_dlna_available_seek_range_response_set_end_byte (self, g_value_get_int64 (value));
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		break;
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		case RYGEL_DLNA_AVAILABLE_SEEK_RANGE_RESPONSE_RANGE_LENGTH:
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		rygel_dlna_available_seek_range_response_set_range_length (self, g_value_get_int64 (value));
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		break;
#line 849 "rygel-dlna-available-seek-response.c"
		default:
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 33 "/home/jens/Source/rygel/src/librygel-server/rygel-dlna-available-seek-response.vala"
		break;
#line 855 "rygel-dlna-available-seek-response.c"
	}
}



