/* rygel-http-get-handler.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-http-get-handler.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Nokia Corporation.
 * Copyright (C) 2010 Andreas Henriksson <andreas@fatal.se>
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <rygel-core.h>


#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;
typedef struct _RygelHTTPGetHandlerPrivate RygelHTTPGetHandlerPrivate;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
#define _g_free0(var) (var = (g_free (var), NULL))

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND,
	RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR = SOUP_STATUS_INTERNAL_SERVER_ERROR
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHTTPGetHandler {
	GObject parent_instance;
	RygelHTTPGetHandlerPrivate * priv;
};

struct _RygelHTTPGetHandlerClass {
	GObjectClass parent_class;
	void (*add_response_headers) (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
	gchar* (*get_default_transfer_mode) (RygelHTTPGetHandler* self);
	gboolean (*supports_transfer_mode) (RygelHTTPGetHandler* self, const gchar* mode);
	gint64 (*get_resource_size) (RygelHTTPGetHandler* self);
	gint64 (*get_resource_duration) (RygelHTTPGetHandler* self);
	gboolean (*supports_byte_seek) (RygelHTTPGetHandler* self);
	gboolean (*supports_time_seek) (RygelHTTPGetHandler* self);
	gboolean (*supports_playspeed) (RygelHTTPGetHandler* self);
	RygelHTTPResponse* (*render_body) (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
};

struct _RygelHTTPGetHandlerPrivate {
	GCancellable* _cancellable;
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaObject* object;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};


static gpointer rygel_http_get_handler_parent_class = NULL;

GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_http_get_get_type (void) G_GNUC_CONST;
GQuark rygel_http_request_error_quark (void);
GType rygel_http_response_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_GET_HANDLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerPrivate))
enum  {
	RYGEL_HTTP_GET_HANDLER_DUMMY_PROPERTY,
	RYGEL_HTTP_GET_HANDLER_CANCELLABLE
};
#define RYGEL_HTTP_GET_HANDLER_TRANSFER_MODE_HEADER "transferMode.dlna.org"
#define RYGEL_HTTP_GET_HANDLER_TRANSFER_MODE_STREAMING "Streaming"
#define RYGEL_HTTP_GET_HANDLER_TRANSFER_MODE_INTERACTIVE "Interactive"
#define RYGEL_HTTP_GET_HANDLER_TRANSFER_MODE_BACKGROUND "Background"
void rygel_http_get_handler_add_response_headers (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
static void rygel_http_get_handler_real_add_response_headers (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
gchar* rygel_http_get_handler_get_default_transfer_mode (RygelHTTPGetHandler* self);
void rygel_client_hacks_modify_headers (RygelClientHacks* self, RygelHTTPRequest* request);
static gchar* rygel_http_get_handler_real_get_default_transfer_mode (RygelHTTPGetHandler* self);
gboolean rygel_http_get_handler_supports_transfer_mode (RygelHTTPGetHandler* self, const gchar* mode);
static gboolean rygel_http_get_handler_real_supports_transfer_mode (RygelHTTPGetHandler* self, const gchar* mode);
gint64 rygel_http_get_handler_get_resource_size (RygelHTTPGetHandler* self);
static gint64 rygel_http_get_handler_real_get_resource_size (RygelHTTPGetHandler* self);
gint64 rygel_http_get_handler_get_resource_duration (RygelHTTPGetHandler* self);
static gint64 rygel_http_get_handler_real_get_resource_duration (RygelHTTPGetHandler* self);
gboolean rygel_http_get_handler_supports_byte_seek (RygelHTTPGetHandler* self);
static gboolean rygel_http_get_handler_real_supports_byte_seek (RygelHTTPGetHandler* self);
gboolean rygel_http_get_handler_supports_time_seek (RygelHTTPGetHandler* self);
static gboolean rygel_http_get_handler_real_supports_time_seek (RygelHTTPGetHandler* self);
gboolean rygel_http_get_handler_supports_playspeed (RygelHTTPGetHandler* self);
static gboolean rygel_http_get_handler_real_supports_playspeed (RygelHTTPGetHandler* self);
RygelHTTPResponse* rygel_http_get_handler_render_body (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
static RygelHTTPResponse* rygel_http_get_handler_real_render_body (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
RygelHTTPGetHandler* rygel_http_get_handler_construct (GType object_type);
GCancellable* rygel_http_get_handler_get_cancellable (RygelHTTPGetHandler* self);
void rygel_http_get_handler_set_cancellable (RygelHTTPGetHandler* self, GCancellable* value);
static void rygel_http_get_handler_finalize (GObject* obj);
static void _vala_rygel_http_get_handler_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_http_get_handler_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * Invokes the handler to add response headers to/for the given HTTP request
     */
static void rygel_http_get_handler_real_add_response_headers (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error) {
	gchar* mode = NULL;
	RygelHTTPGet* _tmp0_ = NULL;
	SoupMessage* _tmp1_ = NULL;
	SoupMessageHeaders* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	RygelHTTPGet* _tmp15_ = NULL;
	RygelClientHacks* _tmp16_ = NULL;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	g_return_if_fail (request != NULL);
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	_tmp0_ = request;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	_tmp1_ = ((RygelHTTPRequest*) _tmp0_)->msg;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	_tmp2_ = _tmp1_->request_headers;
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	_tmp3_ = soup_message_headers_get_one (_tmp2_, RYGEL_HTTP_GET_HANDLER_TRANSFER_MODE_HEADER);
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	mode = _tmp4_;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	_tmp5_ = mode;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	if (_tmp5_ == NULL) {
#line 251 "rygel-http-get-handler.c"
		RygelHTTPGet* _tmp6_ = NULL;
		SoupMessage* _tmp7_ = NULL;
		SoupMessageHeaders* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
		_tmp6_ = request;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
		_tmp7_ = ((RygelHTTPRequest*) _tmp6_)->msg;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
		_tmp8_ = _tmp7_->response_headers;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
		_tmp9_ = rygel_http_get_handler_get_default_transfer_mode (self);
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
		_tmp10_ = _tmp9_;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
		soup_message_headers_append (_tmp8_, RYGEL_HTTP_GET_HANDLER_TRANSFER_MODE_HEADER, _tmp10_);
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
		_g_free0 (_tmp10_);
#line 271 "rygel-http-get-handler.c"
	} else {
		RygelHTTPGet* _tmp11_ = NULL;
		SoupMessage* _tmp12_ = NULL;
		SoupMessageHeaders* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
		_tmp11_ = request;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
		_tmp12_ = ((RygelHTTPRequest*) _tmp11_)->msg;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
		_tmp13_ = _tmp12_->response_headers;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
		_tmp14_ = mode;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
		soup_message_headers_append (_tmp13_, RYGEL_HTTP_GET_HANDLER_TRANSFER_MODE_HEADER, _tmp14_);
#line 287 "rygel-http-get-handler.c"
	}
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	_tmp15_ = request;
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	_tmp16_ = ((RygelHTTPRequest*) _tmp15_)->hack;
#line 59 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	if (_tmp16_ != NULL) {
#line 295 "rygel-http-get-handler.c"
		RygelHTTPGet* _tmp17_ = NULL;
		RygelClientHacks* _tmp18_ = NULL;
		RygelHTTPGet* _tmp19_ = NULL;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
		_tmp17_ = request;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
		_tmp18_ = ((RygelHTTPRequest*) _tmp17_)->hack;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
		_tmp19_ = request;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
		rygel_client_hacks_modify_headers (_tmp18_, (RygelHTTPRequest*) _tmp19_);
#line 307 "rygel-http-get-handler.c"
	}
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	_g_free0 (mode);
#line 311 "rygel-http-get-handler.c"
}


void rygel_http_get_handler_add_response_headers (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error) {
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	g_return_if_fail (self != NULL);
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	RYGEL_HTTP_GET_HANDLER_GET_CLASS (self)->add_response_headers (self, request, error);
#line 320 "rygel-http-get-handler.c"
}


/**
     * Returns the default transfer mode for the handler.
     * The default is "Interactive"
     */
static gchar* rygel_http_get_handler_real_get_default_transfer_mode (RygelHTTPGetHandler* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	_tmp0_ = g_strdup (RYGEL_HTTP_GET_HANDLER_TRANSFER_MODE_INTERACTIVE);
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	result = _tmp0_;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	return result;
#line 337 "rygel-http-get-handler.c"
}


gchar* rygel_http_get_handler_get_default_transfer_mode (RygelHTTPGetHandler* self) {
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	return RYGEL_HTTP_GET_HANDLER_GET_CLASS (self)->get_default_transfer_mode (self);
#line 346 "rygel-http-get-handler.c"
}


/**
     * Returns true if the handler supports the given transfer mode, false otherwise.
     */
static gboolean rygel_http_get_handler_real_supports_transfer_mode (RygelHTTPGetHandler* self, const gchar* mode) {
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	g_critical ("Type `%s' does not implement abstract method `rygel_http_get_handler_supports_transfer_mode'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	return FALSE;
#line 358 "rygel-http-get-handler.c"
}


gboolean rygel_http_get_handler_supports_transfer_mode (RygelHTTPGetHandler* self, const gchar* mode) {
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 75 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	return RYGEL_HTTP_GET_HANDLER_GET_CLASS (self)->supports_transfer_mode (self, mode);
#line 367 "rygel-http-get-handler.c"
}


/**
     * Returns the resource size or -1 if not known.
     */
static gint64 rygel_http_get_handler_real_get_resource_size (RygelHTTPGetHandler* self) {
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	g_critical ("Type `%s' does not implement abstract method `rygel_http_get_handler_get_resource_size'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	return 0LL;
#line 379 "rygel-http-get-handler.c"
}


gint64 rygel_http_get_handler_get_resource_size (RygelHTTPGetHandler* self) {
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	return RYGEL_HTTP_GET_HANDLER_GET_CLASS (self)->get_resource_size (self);
#line 388 "rygel-http-get-handler.c"
}


/**
     * Returns the resource duration (in microseconds) or -1 if not known.
     */
static gint64 rygel_http_get_handler_real_get_resource_duration (RygelHTTPGetHandler* self) {
	gint64 result = 0LL;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	result = (gint64) (-1);
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	return result;
#line 401 "rygel-http-get-handler.c"
}


gint64 rygel_http_get_handler_get_resource_duration (RygelHTTPGetHandler* self) {
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	return RYGEL_HTTP_GET_HANDLER_GET_CLASS (self)->get_resource_duration (self);
#line 410 "rygel-http-get-handler.c"
}


/**
     * Returns true if the handler supports full random-access byte seek.
     */
static gboolean rygel_http_get_handler_real_supports_byte_seek (RygelHTTPGetHandler* self) {
	gboolean result = FALSE;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	result = FALSE;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	return result;
#line 423 "rygel-http-get-handler.c"
}


gboolean rygel_http_get_handler_supports_byte_seek (RygelHTTPGetHandler* self) {
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	return RYGEL_HTTP_GET_HANDLER_GET_CLASS (self)->supports_byte_seek (self);
#line 432 "rygel-http-get-handler.c"
}


/**
     * Returns true if the handler supports full random-access time seek.
     */
static gboolean rygel_http_get_handler_real_supports_time_seek (RygelHTTPGetHandler* self) {
	gboolean result = FALSE;
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	result = FALSE;
#line 100 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	return result;
#line 445 "rygel-http-get-handler.c"
}


gboolean rygel_http_get_handler_supports_time_seek (RygelHTTPGetHandler* self) {
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	return RYGEL_HTTP_GET_HANDLER_GET_CLASS (self)->supports_time_seek (self);
#line 454 "rygel-http-get-handler.c"
}


/**
     * Returns true if the handler supports any play speed requests.
     */
static gboolean rygel_http_get_handler_real_supports_playspeed (RygelHTTPGetHandler* self) {
	gboolean result = FALSE;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	result = FALSE;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	return result;
#line 467 "rygel-http-get-handler.c"
}


gboolean rygel_http_get_handler_supports_playspeed (RygelHTTPGetHandler* self) {
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	return RYGEL_HTTP_GET_HANDLER_GET_CLASS (self)->supports_playspeed (self);
#line 476 "rygel-http-get-handler.c"
}


/**
     * Create an HTTPResponse object that will render the body.
     */
static RygelHTTPResponse* rygel_http_get_handler_real_render_body (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error) {
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	g_critical ("Type `%s' does not implement abstract method `rygel_http_get_handler_render_body'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	return NULL;
#line 488 "rygel-http-get-handler.c"
}


RygelHTTPResponse* rygel_http_get_handler_render_body (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error) {
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	return RYGEL_HTTP_GET_HANDLER_GET_CLASS (self)->render_body (self, request, error);
#line 497 "rygel-http-get-handler.c"
}


RygelHTTPGetHandler* rygel_http_get_handler_construct (GType object_type) {
	RygelHTTPGetHandler * self = NULL;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	self = (RygelHTTPGetHandler*) g_object_new (object_type, NULL);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	return self;
#line 507 "rygel-http-get-handler.c"
}


GCancellable* rygel_http_get_handler_get_cancellable (RygelHTTPGetHandler* self) {
	GCancellable* result;
	GCancellable* _tmp0_ = NULL;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	_tmp0_ = self->priv->_cancellable;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	result = _tmp0_;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	return result;
#line 522 "rygel-http-get-handler.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	return self ? g_object_ref (self) : NULL;
#line 529 "rygel-http-get-handler.c"
}


void rygel_http_get_handler_set_cancellable (RygelHTTPGetHandler* self, GCancellable* value) {
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	g_return_if_fail (self != NULL);
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	_tmp0_ = value;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	self->priv->_cancellable = _tmp1_;
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	g_object_notify ((GObject *) self, "cancellable");
#line 548 "rygel-http-get-handler.c"
}


static void rygel_http_get_handler_class_init (RygelHTTPGetHandlerClass * klass) {
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	rygel_http_get_handler_parent_class = g_type_class_peek_parent (klass);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPGetHandlerPrivate));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	((RygelHTTPGetHandlerClass *) klass)->add_response_headers = rygel_http_get_handler_real_add_response_headers;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	((RygelHTTPGetHandlerClass *) klass)->get_default_transfer_mode = rygel_http_get_handler_real_get_default_transfer_mode;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	((RygelHTTPGetHandlerClass *) klass)->supports_transfer_mode = rygel_http_get_handler_real_supports_transfer_mode;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	((RygelHTTPGetHandlerClass *) klass)->get_resource_size = rygel_http_get_handler_real_get_resource_size;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	((RygelHTTPGetHandlerClass *) klass)->get_resource_duration = rygel_http_get_handler_real_get_resource_duration;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	((RygelHTTPGetHandlerClass *) klass)->supports_byte_seek = rygel_http_get_handler_real_supports_byte_seek;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	((RygelHTTPGetHandlerClass *) klass)->supports_time_seek = rygel_http_get_handler_real_supports_time_seek;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	((RygelHTTPGetHandlerClass *) klass)->supports_playspeed = rygel_http_get_handler_real_supports_playspeed;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	((RygelHTTPGetHandlerClass *) klass)->render_body = rygel_http_get_handler_real_render_body;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_get_handler_get_property;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_get_handler_set_property;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_get_handler_finalize;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_GET_HANDLER_CANCELLABLE, g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 583 "rygel-http-get-handler.c"
}


static void rygel_http_get_handler_instance_init (RygelHTTPGetHandler * self) {
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	self->priv = RYGEL_HTTP_GET_HANDLER_GET_PRIVATE (self);
#line 590 "rygel-http-get-handler.c"
}


static void rygel_http_get_handler_finalize (GObject* obj) {
	RygelHTTPGetHandler * self;
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler);
#line 39 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	G_OBJECT_CLASS (rygel_http_get_handler_parent_class)->finalize (obj);
#line 602 "rygel-http-get-handler.c"
}


/**
 * HTTP GET request handler interface.
 */
GType rygel_http_get_handler_get_type (void) {
	static volatile gsize rygel_http_get_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_get_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPGetHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_get_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPGetHandler), 0, (GInstanceInitFunc) rygel_http_get_handler_instance_init, NULL };
		GType rygel_http_get_handler_type_id;
		rygel_http_get_handler_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPGetHandler", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&rygel_http_get_handler_type_id__volatile, rygel_http_get_handler_type_id);
	}
	return rygel_http_get_handler_type_id__volatile;
}


static void _vala_rygel_http_get_handler_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPGetHandler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	switch (property_id) {
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
		case RYGEL_HTTP_GET_HANDLER_CANCELLABLE:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
		g_value_set_object (value, rygel_http_get_handler_get_cancellable (self));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
		break;
#line 632 "rygel-http-get-handler.c"
		default:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
		break;
#line 638 "rygel-http-get-handler.c"
	}
}


static void _vala_rygel_http_get_handler_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPGetHandler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
	switch (property_id) {
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
		case RYGEL_HTTP_GET_HANDLER_CANCELLABLE:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
		rygel_http_get_handler_set_cancellable (self, g_value_get_object (value));
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
		break;
#line 654 "rygel-http-get-handler.c"
		default:
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 32 "/home/jens/Source/rygel/src/librygel-server/rygel-http-get-handler.vala"
		break;
#line 660 "rygel-http-get-handler.c"
	}
}



