/* rygel-http-request.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-http-request.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Nokia Corporation.
 * Copyright (C) 2006, 2007, 2008 OpenedHand Ltd.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jorn Baayen <jorn.baayen@gmail.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <rygel-core.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>
#include <libgupnp/gupnp.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelHttpRequestRunData RygelHttpRequestRunData;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_MEDIA_FILE_ITEM (rygel_media_file_item_get_type ())
#define RYGEL_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem))
#define RYGEL_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))
#define RYGEL_IS_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_IS_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_MEDIA_FILE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))

typedef struct _RygelMediaFileItem RygelMediaFileItem;
typedef struct _RygelMediaFileItemClass RygelMediaFileItemClass;
typedef struct _RygelHttpRequestFindItemData RygelHttpRequestFindItemData;

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND,
	RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR = SOUP_STATUS_INTERNAL_SERVER_ERROR
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaObject* object;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelHTTPRequestPrivate {
	RygelMediaContainer* root_container;
	GCancellable* _cancellable;
};

struct _RygelHTTPServer {
	GObject parent_instance;
	RygelHTTPServerPrivate * priv;
	RygelMediaContainer* root_container;
	GUPnPContext* context;
	GHashTable* replacements;
};

struct _RygelHTTPServerClass {
	GObjectClass parent_class;
	gchar* (*get_protocol) (RygelHTTPServer* self);
	GeeArrayList* (*get_protocol_info) (RygelHTTPServer* self);
};

typedef enum  {
	RYGEL_CLIENT_HACKS_ERROR_NA
} RygelClientHacksError;
#define RYGEL_CLIENT_HACKS_ERROR rygel_client_hacks_error_quark ()
struct _RygelHttpRequestRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPRequest* self;
	SoupServer* _tmp0_;
	SoupMessage* _tmp1_;
	RygelHTTPItemURI* _tmp2_;
	SoupMessage* _tmp3_;
	SoupURI* _tmp4_;
	SoupURI* _tmp5_;
	const gchar* _tmp6_;
	RygelHTTPServer* _tmp7_;
	RygelHTTPItemURI* _tmp8_;
	RygelHTTPItemURI* _tmp9_;
	GError* _error_;
	GError* _tmp10_;
	GError * _inner_error_;
};

struct _RygelHttpRequestFindItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPRequest* self;
	RygelMediaObject* media_object;
	RygelMediaContainer* _tmp0_;
	RygelHTTPItemURI* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	RygelMediaObject* _tmp4_;
	gboolean _tmp5_;
	RygelMediaObject* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	RygelMediaObject* _tmp9_;
	RygelHTTPItemURI* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	RygelMediaObject* _tmp13_;
	const gchar* _tmp14_;
	RygelHTTPItemURI* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	GError* _tmp18_;
	RygelMediaObject* _tmp19_;
	RygelMediaObject* _tmp20_;
	GError * _inner_error_;
};


static gpointer rygel_http_request_parent_class = NULL;
static RygelStateMachineIface* rygel_http_request_rygel_state_machine_parent_iface = NULL;

GQuark rygel_http_request_error_quark (void);
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_REQUEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestPrivate))
enum  {
	RYGEL_HTTP_REQUEST_DUMMY_PROPERTY,
	RYGEL_HTTP_REQUEST_CANCELLABLE
};
RygelHTTPRequest* rygel_http_request_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
GQuark rygel_client_hacks_error_quark (void);
RygelClientHacks* rygel_client_hacks_create (SoupMessage* message, GError** error);
static void rygel_http_request_real_run_data_free (gpointer _data);
static void rygel_http_request_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_request_real_run_co (RygelHttpRequestRunData* _data_);
RygelHTTPItemURI* rygel_http_item_uri_new_from_string (const gchar* uri, RygelHTTPServer* http_server, GError** error);
RygelHTTPItemURI* rygel_http_item_uri_construct_from_string (GType object_type, const gchar* uri, RygelHTTPServer* http_server, GError** error);
void rygel_http_request_find_item (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_http_request_find_item_finish (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
static void rygel_http_request_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_http_request_handle (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_http_request_handle_finish (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
void rygel_http_request_handle_error (RygelHTTPRequest* self, GError* _error_);
static void rygel_http_request_real_find_item_data_free (gpointer _data);
static void rygel_http_request_real_find_item (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_http_request_real_find_item_co (RygelHttpRequestFindItemData* _data_);
void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
const gchar* rygel_http_item_uri_get_item_id (RygelHTTPItemURI* self);
static void rygel_http_request_find_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
const gchar* rygel_http_item_uri_get_resource_name (RygelHTTPItemURI* self);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_media_file_item_get_type (void) G_GNUC_CONST;
void rygel_http_request_end (RygelHTTPRequest* self, guint status, const gchar* reason);
static void rygel_http_request_finalize (GObject* obj);
static void _vala_rygel_http_request_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_http_request_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GQuark rygel_http_request_error_quark (void) {
	return g_quark_from_static_string ("rygel_http_request_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	return self ? g_object_ref (self) : NULL;
#line 286 "rygel-http-request.c"
}


RygelHTTPRequest* rygel_http_request_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg) {
	RygelHTTPRequest * self = NULL;
	RygelHTTPServer* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	GCancellable* _tmp2_ = NULL;
	RygelHTTPServer* _tmp3_ = NULL;
	RygelMediaContainer* _tmp4_ = NULL;
	RygelMediaContainer* _tmp5_ = NULL;
	SoupServer* _tmp6_ = NULL;
	SoupMessage* _tmp7_ = NULL;
	SoupMessage* _tmp8_ = NULL;
	GError * _inner_error_ = NULL;
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	g_return_val_if_fail (http_server != NULL, NULL);
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	g_return_val_if_fail (server != NULL, NULL);
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	self = (RygelHTTPRequest*) g_object_new (object_type, NULL);
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_tmp0_ = http_server;
#line 54 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	self->http_server = _tmp0_;
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_tmp1_ = g_cancellable_new ();
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_tmp2_ = _tmp1_;
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp2_);
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_g_object_unref0 (_tmp2_);
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_tmp3_ = http_server;
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_tmp4_ = _tmp3_->root_container;
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_g_object_unref0 (self->priv->root_container);
#line 56 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	self->priv->root_container = _tmp5_;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_tmp6_ = server;
#line 57 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	self->server = _tmp6_;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_tmp7_ = msg;
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_g_object_unref0 (self->msg);
#line 58 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	self->msg = _tmp8_;
#line 344 "rygel-http-request.c"
	{
		RygelClientHacks* _tmp9_ = NULL;
		SoupMessage* _tmp10_ = NULL;
		RygelClientHacks* _tmp11_ = NULL;
		RygelClientHacks* _tmp12_ = NULL;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_tmp10_ = msg;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_tmp11_ = rygel_client_hacks_create (_tmp10_, &_inner_error_);
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_tmp9_ = _tmp11_;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 358 "rygel-http-request.c"
			goto __catch48_g_error;
		}
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_tmp12_ = _tmp9_;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_tmp9_ = NULL;
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_g_object_unref0 (self->hack);
#line 61 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		self->hack = _tmp12_;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_g_object_unref0 (_tmp9_);
#line 371 "rygel-http-request.c"
	}
	goto __finally48;
	__catch48_g_error:
	{
		GError* _error_ = NULL;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_error_ = _inner_error_;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_inner_error_ = NULL;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_g_error_free0 (_error_);
#line 383 "rygel-http-request.c"
	}
	__finally48:
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		g_clear_error (&_inner_error_);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		return NULL;
#line 394 "rygel-http-request.c"
	}
#line 51 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	return self;
#line 398 "rygel-http-request.c"
}


static void rygel_http_request_real_run_data_free (gpointer _data) {
	RygelHttpRequestRunData* _data_;
	_data_ = _data;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_g_object_unref0 (_data_->self);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	g_slice_free (RygelHttpRequestRunData, _data_);
#line 409 "rygel-http-request.c"
}


static void rygel_http_request_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPRequest * self;
	RygelHttpRequestRunData* _data_;
	RygelHTTPRequest* _tmp0_ = NULL;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	self = (RygelHTTPRequest*) base;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_data_ = g_slice_new0 (RygelHttpRequestRunData);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_request_real_run);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_request_real_run_data_free);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_data_->self = _tmp0_;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	rygel_http_request_real_run_co (_data_);
#line 431 "rygel-http-request.c"
}


static void rygel_http_request_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelHttpRequestRunData* _data_;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 439 "rygel-http-request.c"
}


static void rygel_http_request_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpRequestRunData* _data_;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_data_ = _user_data_;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_data_->_source_object_ = source_object;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_data_->_res_ = _res_;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	rygel_http_request_real_run_co (_data_);
#line 453 "rygel-http-request.c"
}


static gboolean rygel_http_request_real_run_co (RygelHttpRequestRunData* _data_) {
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	switch (_data_->_state_) {
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		case 0:
#line 462 "rygel-http-request.c"
		goto _state_0;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		case 1:
#line 466 "rygel-http-request.c"
		goto _state_1;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		case 2:
#line 470 "rygel-http-request.c"
		goto _state_2;
		default:
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		g_assert_not_reached ();
#line 475 "rygel-http-request.c"
	}
	_state_0:
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_data_->_tmp0_ = NULL;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_data_->_tmp0_ = _data_->self->server;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_data_->_tmp1_ = NULL;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_data_->_tmp1_ = _data_->self->msg;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	soup_server_pause_message (_data_->_tmp0_, _data_->_tmp1_);
#line 488 "rygel-http-request.c"
	{
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_data_->_tmp3_ = NULL;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_data_->_tmp3_ = _data_->self->msg;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_data_->_tmp4_ = NULL;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_data_->_tmp4_ = soup_message_get_uri (_data_->_tmp3_);
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_data_->_tmp5_ = NULL;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_data_->_tmp5_ = _data_->_tmp4_;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_data_->_tmp6_ = NULL;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_data_->_tmp6_ = _data_->_tmp5_->path;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_data_->_tmp7_ = NULL;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_data_->_tmp7_ = _data_->self->http_server;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_data_->_tmp8_ = NULL;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_data_->_tmp8_ = rygel_http_item_uri_new_from_string (_data_->_tmp6_, _data_->_tmp7_, &_data_->_inner_error_);
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_data_->_tmp2_ = _data_->_tmp8_;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 518 "rygel-http-request.c"
			goto __catch49_g_error;
		}
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_data_->_tmp9_ = NULL;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_data_->_tmp9_ = _data_->_tmp2_;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_data_->_tmp2_ = NULL;
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_g_object_unref0 (_data_->self->uri);
#line 69 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_data_->self->uri = _data_->_tmp9_;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_data_->_state_ = 1;
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		rygel_http_request_find_item (_data_->self, rygel_http_request_run_ready, _data_);
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		return FALSE;
#line 537 "rygel-http-request.c"
		_state_1:
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		rygel_http_request_find_item_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 72 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
			_g_object_unref0 (_data_->_tmp2_);
#line 545 "rygel-http-request.c"
			goto __catch49_g_error;
		}
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_data_->_state_ = 2;
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		rygel_http_request_handle (_data_->self, rygel_http_request_run_ready, _data_);
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		return FALSE;
#line 554 "rygel-http-request.c"
		_state_2:
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		rygel_http_request_handle_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 74 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
			_g_object_unref0 (_data_->_tmp2_);
#line 562 "rygel-http-request.c"
			goto __catch49_g_error;
		}
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_g_object_unref0 (_data_->_tmp2_);
#line 567 "rygel-http-request.c"
	}
	goto __finally49;
	__catch49_g_error:
	{
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_data_->_inner_error_ = NULL;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_data_->_tmp10_ = NULL;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_data_->_tmp10_ = _data_->_error_;
#line 76 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		rygel_http_request_handle_error (_data_->self, _data_->_tmp10_);
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_g_error_free0 (_data_->_error_);
#line 584 "rygel-http-request.c"
	}
	__finally49:
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		g_clear_error (&_data_->_inner_error_);
#line 68 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		return FALSE;
#line 595 "rygel-http-request.c"
	}
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	rygel_state_machine_set_cancellable ((RygelStateMachine*) _data_->self, NULL);
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	if (_data_->_state_ == 0) {
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 603 "rygel-http-request.c"
	} else {
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 607 "rygel-http-request.c"
	}
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	g_object_unref (_data_->_async_result);
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	return FALSE;
#line 613 "rygel-http-request.c"
}


void rygel_http_request_handle (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	RYGEL_HTTP_REQUEST_GET_CLASS (self)->handle (self, _callback_, _user_data_);
#line 620 "rygel-http-request.c"
}


void rygel_http_request_handle_finish (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error) {
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	RYGEL_HTTP_REQUEST_GET_CLASS (self)->handle_finish (self, _res_, error);
#line 627 "rygel-http-request.c"
}


static void rygel_http_request_real_find_item_data_free (gpointer _data) {
	RygelHttpRequestFindItemData* _data_;
	_data_ = _data;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_g_object_unref0 (_data_->self);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	g_slice_free (RygelHttpRequestFindItemData, _data_);
#line 638 "rygel-http-request.c"
}


static void rygel_http_request_real_find_item (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHttpRequestFindItemData* _data_;
	RygelHTTPRequest* _tmp0_ = NULL;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_data_ = g_slice_new0 (RygelHttpRequestFindItemData);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_request_real_find_item);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_request_real_find_item_data_free);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_data_->self = _tmp0_;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	rygel_http_request_real_find_item_co (_data_);
#line 657 "rygel-http-request.c"
}


static void rygel_http_request_real_find_item_finish (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error) {
	RygelHttpRequestFindItemData* _data_;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		return;
#line 667 "rygel-http-request.c"
	}
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 671 "rygel-http-request.c"
}


static void rygel_http_request_find_item_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpRequestFindItemData* _data_;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_data_ = _user_data_;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_data_->_source_object_ = source_object;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_data_->_res_ = _res_;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	rygel_http_request_real_find_item_co (_data_);
#line 685 "rygel-http-request.c"
}


static gboolean rygel_http_request_real_find_item_co (RygelHttpRequestFindItemData* _data_) {
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	switch (_data_->_state_) {
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		case 0:
#line 694 "rygel-http-request.c"
		goto _state_0;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		case 1:
#line 698 "rygel-http-request.c"
		goto _state_1;
		default:
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		g_assert_not_reached ();
#line 703 "rygel-http-request.c"
	}
	_state_0:
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_data_->_tmp0_ = NULL;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_data_->_tmp0_ = _data_->self->priv->root_container;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_data_->_tmp1_ = NULL;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_data_->_tmp1_ = _data_->self->uri;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_data_->_tmp2_ = NULL;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_data_->_tmp2_ = rygel_http_item_uri_get_item_id (_data_->_tmp1_);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_data_->_tmp3_ = NULL;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_data_->_tmp3_ = _data_->_tmp2_;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_data_->_state_ = 1;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	rygel_media_container_find_object (_data_->_tmp0_, _data_->_tmp3_, NULL, rygel_http_request_find_item_ready, _data_);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	return FALSE;
#line 728 "rygel-http-request.c"
	_state_1:
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_data_->_tmp4_ = NULL;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_data_->_tmp4_ = rygel_media_container_find_object_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error_);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_data_->media_object = _data_->_tmp4_;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		g_error_free (_data_->_inner_error_);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		if (_data_->_state_ == 0) {
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 746 "rygel-http-request.c"
		} else {
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 750 "rygel-http-request.c"
		}
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		g_object_unref (_data_->_async_result);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		return FALSE;
#line 756 "rygel-http-request.c"
	}
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_data_->_tmp6_ = NULL;
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_data_->_tmp6_ = _data_->media_object;
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	if (_data_->_tmp6_ == NULL) {
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_data_->_tmp5_ = TRUE;
#line 766 "rygel-http-request.c"
	} else {
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_data_->_tmp9_ = NULL;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_data_->_tmp9_ = _data_->media_object;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp9_, RYGEL_TYPE_MEDIA_CONTAINER)) {
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
			_data_->_tmp10_ = NULL;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
			_data_->_tmp10_ = _data_->self->uri;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
			_data_->_tmp11_ = NULL;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
			_data_->_tmp11_ = rygel_http_item_uri_get_resource_name (_data_->_tmp10_);
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
			_data_->_tmp12_ = NULL;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
			_data_->_tmp12_ = _data_->_tmp11_;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
			_data_->_tmp8_ = _data_->_tmp12_ != NULL;
#line 788 "rygel-http-request.c"
		} else {
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
			_data_->_tmp8_ = FALSE;
#line 792 "rygel-http-request.c"
		}
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		if (_data_->_tmp8_) {
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
			_data_->_tmp7_ = TRUE;
#line 798 "rygel-http-request.c"
		} else {
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
			_data_->_tmp13_ = NULL;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
			_data_->_tmp13_ = _data_->media_object;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
			_data_->_tmp7_ = G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp13_, RYGEL_TYPE_MEDIA_FILE_ITEM);
#line 806 "rygel-http-request.c"
		}
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_data_->_tmp5_ = !_data_->_tmp7_;
#line 810 "rygel-http-request.c"
	}
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	if (_data_->_tmp5_) {
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_data_->_tmp14_ = NULL;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_data_->_tmp14_ = _ ("Requested item '%s' not found");
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_data_->_tmp15_ = NULL;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_data_->_tmp15_ = _data_->self->uri;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_data_->_tmp16_ = NULL;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_data_->_tmp16_ = rygel_http_item_uri_get_item_id (_data_->_tmp15_);
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_data_->_tmp17_ = NULL;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_data_->_tmp17_ = _data_->_tmp16_;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_data_->_tmp18_ = NULL;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_data_->_tmp18_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, _data_->_tmp14_, _data_->_tmp17_);
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_data_->_inner_error_ = _data_->_tmp18_;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		g_error_free (_data_->_inner_error_);
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_g_object_unref0 (_data_->media_object);
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		if (_data_->_state_ == 0) {
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 846 "rygel-http-request.c"
		} else {
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 850 "rygel-http-request.c"
		}
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		g_object_unref (_data_->_async_result);
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		return FALSE;
#line 856 "rygel-http-request.c"
	}
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_data_->_tmp19_ = NULL;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_data_->_tmp19_ = _data_->media_object;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_data_->_tmp20_ = NULL;
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_data_->_tmp20_ = _g_object_ref0 (_data_->_tmp19_);
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_g_object_unref0 (_data_->self->object);
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_data_->self->object = _data_->_tmp20_;
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_g_object_unref0 (_data_->media_object);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	if (_data_->_state_ == 0) {
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 876 "rygel-http-request.c"
	} else {
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 880 "rygel-http-request.c"
	}
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	g_object_unref (_data_->_async_result);
#line 85 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	return FALSE;
#line 886 "rygel-http-request.c"
}


void rygel_http_request_find_item (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	RYGEL_HTTP_REQUEST_GET_CLASS (self)->find_item (self, _callback_, _user_data_);
#line 893 "rygel-http-request.c"
}


void rygel_http_request_find_item_finish (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error) {
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	RYGEL_HTTP_REQUEST_GET_CLASS (self)->find_item_finish (self, _res_, error);
#line 900 "rygel-http-request.c"
}


void rygel_http_request_handle_error (RygelHTTPRequest* self, GError* _error_) {
	GError* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	SoupServer* _tmp2_ = NULL;
	SoupMessage* _tmp3_ = NULL;
	guint status = 0U;
	GError* _tmp4_ = NULL;
	guint _tmp7_ = 0U;
	GError* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	g_return_if_fail (self != NULL);
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_tmp0_ = _error_;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_tmp1_ = _tmp0_->message;
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	g_warning ("rygel-http-request.vala:103: %s", _tmp1_);
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_tmp2_ = self->server;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_tmp3_ = self->msg;
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	soup_server_unpause_message (_tmp2_, _tmp3_);
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_tmp4_ = _error_;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	if (_tmp4_->domain == RYGEL_HTTP_REQUEST_ERROR) {
#line 932 "rygel-http-request.c"
		GError* _tmp5_ = NULL;
		gint _tmp6_ = 0;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_tmp5_ = _error_;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_tmp6_ = _tmp5_->code;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		status = (guint) _tmp6_;
#line 941 "rygel-http-request.c"
	} else {
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		status = (guint) SOUP_STATUS_NOT_FOUND;
#line 945 "rygel-http-request.c"
	}
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_tmp7_ = status;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_tmp8_ = _error_;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_tmp9_ = _tmp8_->message;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	rygel_http_request_end (self, _tmp7_, _tmp9_);
#line 955 "rygel-http-request.c"
}


void rygel_http_request_end (RygelHTTPRequest* self, guint status, const gchar* reason) {
	guint _tmp0_ = 0U;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	g_return_if_fail (self != NULL);
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_tmp0_ = status;
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	if (_tmp0_ != ((guint) SOUP_STATUS_NONE)) {
#line 967 "rygel-http-request.c"
		const gchar* _tmp1_ = NULL;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		_tmp1_ = reason;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		if (_tmp1_ == NULL) {
#line 973 "rygel-http-request.c"
			SoupMessage* _tmp2_ = NULL;
			guint _tmp3_ = 0U;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
			_tmp2_ = self->msg;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
			_tmp3_ = status;
#line 119 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
			soup_message_set_status (_tmp2_, _tmp3_);
#line 982 "rygel-http-request.c"
		} else {
			SoupMessage* _tmp4_ = NULL;
			guint _tmp5_ = 0U;
			const gchar* _tmp6_ = NULL;
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
			_tmp4_ = self->msg;
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
			_tmp5_ = status;
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
			_tmp6_ = reason;
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
			soup_message_set_status_full (_tmp4_, _tmp5_, _tmp6_);
#line 995 "rygel-http-request.c"
		}
	}
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
#line 1000 "rygel-http-request.c"
}


static GCancellable* rygel_http_request_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelHTTPRequest* self;
	GCancellable* _tmp0_ = NULL;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	self = (RygelHTTPRequest*) base;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_tmp0_ = self->priv->_cancellable;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	result = _tmp0_;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	return result;
#line 1016 "rygel-http-request.c"
}


static void rygel_http_request_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelHTTPRequest* self;
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	self = (RygelHTTPRequest*) base;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_tmp0_ = value;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	self->priv->_cancellable = _tmp1_;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	g_object_notify ((GObject *) self, "cancellable");
#line 1036 "rygel-http-request.c"
}


static void rygel_http_request_class_init (RygelHTTPRequestClass * klass) {
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	rygel_http_request_parent_class = g_type_class_peek_parent (klass);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPRequestPrivate));
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	((RygelHTTPRequestClass *) klass)->find_item = rygel_http_request_real_find_item;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	((RygelHTTPRequestClass *) klass)->find_item_finish = rygel_http_request_real_find_item_finish;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_request_get_property;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_request_set_property;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_request_finalize;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_REQUEST_CANCELLABLE, g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1057 "rygel-http-request.c"
}


static void rygel_http_request_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	rygel_http_request_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	iface->run = (void (*)(RygelStateMachine*)) rygel_http_request_real_run;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	iface->run_finish = rygel_http_request_real_run_finish;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	iface->get_cancellable = rygel_http_request_real_get_cancellable;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	iface->set_cancellable = rygel_http_request_real_set_cancellable;
#line 1072 "rygel-http-request.c"
}


static void rygel_http_request_instance_init (RygelHTTPRequest * self) {
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	self->priv = RYGEL_HTTP_REQUEST_GET_PRIVATE (self);
#line 1079 "rygel-http-request.c"
}


static void rygel_http_request_finalize (GObject* obj) {
	RygelHTTPRequest * self;
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_g_object_unref0 (self->priv->root_container);
#line 42 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_g_object_unref0 (self->msg);
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 46 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_g_object_unref0 (self->uri);
#line 47 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_g_object_unref0 (self->object);
#line 49 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	_g_object_unref0 (self->hack);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	G_OBJECT_CLASS (rygel_http_request_parent_class)->finalize (obj);
#line 1101 "rygel-http-request.c"
}


/**
 * Base class for HTTP client requests.
 */
GType rygel_http_request_get_type (void) {
	static volatile gsize rygel_http_request_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_request_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPRequestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_request_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPRequest), 0, (GInstanceInitFunc) rygel_http_request_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_http_request_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_http_request_type_id;
		rygel_http_request_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPRequest", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_type_add_interface_static (rygel_http_request_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_http_request_type_id__volatile, rygel_http_request_type_id);
	}
	return rygel_http_request_type_id__volatile;
}


static void _vala_rygel_http_request_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	switch (property_id) {
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		case RYGEL_HTTP_REQUEST_CANCELLABLE:
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		break;
#line 1133 "rygel-http-request.c"
		default:
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		break;
#line 1139 "rygel-http-request.c"
	}
}


static void _vala_rygel_http_request_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
	switch (property_id) {
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		case RYGEL_HTTP_REQUEST_CANCELLABLE:
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		break;
#line 1155 "rygel-http-request.c"
		default:
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 38 "/home/jens/Source/rygel/src/librygel-server/rygel-http-request.vala"
		break;
#line 1161 "rygel-http-request.c"
	}
}



