/* rygel-http-time-seek-response.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-http-time-seek-response.vala, do not modify */

/*
 * Copyright (C) 2013  Cable Television Laboratories, Inc.
 * Contact: http://www.cablelabs.com/
 *
 * Author: Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
 * IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL CABLE TELEVISION LABORATORIES
 * INC. OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-core.h>
#include <gio/gio.h>
#include <libsoup/soup.h>
#include <float.h>
#include <math.h>


#define RYGEL_TYPE_HTTP_RESPONSE_ELEMENT (rygel_http_response_element_get_type ())
#define RYGEL_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElement))
#define RYGEL_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_HTTP_RESPONSE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))

typedef struct _RygelHTTPResponseElement RygelHTTPResponseElement;
typedef struct _RygelHTTPResponseElementClass RygelHTTPResponseElementClass;
typedef struct _RygelHTTPResponseElementPrivate RygelHTTPResponseElementPrivate;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_HTTP_TIME_SEEK_RESPONSE (rygel_http_time_seek_response_get_type ())
#define RYGEL_HTTP_TIME_SEEK_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TIME_SEEK_RESPONSE, RygelHTTPTimeSeekResponse))
#define RYGEL_HTTP_TIME_SEEK_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TIME_SEEK_RESPONSE, RygelHTTPTimeSeekResponseClass))
#define RYGEL_IS_HTTP_TIME_SEEK_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TIME_SEEK_RESPONSE))
#define RYGEL_IS_HTTP_TIME_SEEK_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TIME_SEEK_RESPONSE))
#define RYGEL_HTTP_TIME_SEEK_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TIME_SEEK_RESPONSE, RygelHTTPTimeSeekResponseClass))

typedef struct _RygelHTTPTimeSeekResponse RygelHTTPTimeSeekResponse;
typedef struct _RygelHTTPTimeSeekResponseClass RygelHTTPTimeSeekResponseClass;
typedef struct _RygelHTTPTimeSeekResponsePrivate RygelHTTPTimeSeekResponsePrivate;

#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;

#define RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST (rygel_http_time_seek_request_get_type ())
#define RYGEL_HTTP_TIME_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST, RygelHTTPTimeSeekRequest))
#define RYGEL_HTTP_TIME_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST, RygelHTTPTimeSeekRequestClass))
#define RYGEL_IS_HTTP_TIME_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST))
#define RYGEL_IS_HTTP_TIME_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST))
#define RYGEL_HTTP_TIME_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST, RygelHTTPTimeSeekRequestClass))

typedef struct _RygelHTTPTimeSeekRequest RygelHTTPTimeSeekRequest;
typedef struct _RygelHTTPTimeSeekRequestClass RygelHTTPTimeSeekRequestClass;
typedef struct _RygelHTTPSeekRequestPrivate RygelHTTPSeekRequestPrivate;
typedef struct _RygelHTTPTimeSeekRequestPrivate RygelHTTPTimeSeekRequestPrivate;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _RygelHTTPResponseElement {
	GObject parent_instance;
	RygelHTTPResponseElementPrivate * priv;
};

struct _RygelHTTPResponseElementClass {
	GObjectClass parent_class;
	void (*add_response_headers) (RygelHTTPResponseElement* self, RygelHTTPRequest* request);
	gchar* (*to_string) (RygelHTTPResponseElement* self);
};

struct _RygelHTTPTimeSeekResponse {
	RygelHTTPResponseElement parent_instance;
	RygelHTTPTimeSeekResponsePrivate * priv;
};

struct _RygelHTTPTimeSeekResponseClass {
	RygelHTTPResponseElementClass parent_class;
};

struct _RygelHTTPTimeSeekResponsePrivate {
	gint64 _start_time;
	gint64 _end_time;
	gint64 _range_duration;
	gint64 _total_duration;
	gint64 _start_byte;
	gint64 _end_byte;
	gint64 _response_length;
	gint64 _total_size;
};

struct _RygelHTTPSeekRequest {
	GObject parent_instance;
	RygelHTTPSeekRequestPrivate * priv;
};

struct _RygelHTTPSeekRequestClass {
	GObjectClass parent_class;
};

struct _RygelHTTPTimeSeekRequest {
	RygelHTTPSeekRequest parent_instance;
	RygelHTTPTimeSeekRequestPrivate * priv;
	gint64 start_time;
	gint64 end_time;
	gint64 range_duration;
	gint64 total_duration;
};

struct _RygelHTTPTimeSeekRequestClass {
	RygelHTTPSeekRequestClass parent_class;
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaObject* object;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};


static gpointer rygel_http_time_seek_response_parent_class = NULL;

GType rygel_http_response_element_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_http_time_seek_response_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_TIME_SEEK_RESPONSE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_TIME_SEEK_RESPONSE, RygelHTTPTimeSeekResponsePrivate))
enum  {
	RYGEL_HTTP_TIME_SEEK_RESPONSE_DUMMY_PROPERTY,
	RYGEL_HTTP_TIME_SEEK_RESPONSE_START_TIME,
	RYGEL_HTTP_TIME_SEEK_RESPONSE_END_TIME,
	RYGEL_HTTP_TIME_SEEK_RESPONSE_RANGE_DURATION,
	RYGEL_HTTP_TIME_SEEK_RESPONSE_TOTAL_DURATION,
	RYGEL_HTTP_TIME_SEEK_RESPONSE_START_BYTE,
	RYGEL_HTTP_TIME_SEEK_RESPONSE_END_BYTE,
	RYGEL_HTTP_TIME_SEEK_RESPONSE_RESPONSE_LENGTH,
	RYGEL_HTTP_TIME_SEEK_RESPONSE_TOTAL_SIZE
};
RygelHTTPTimeSeekResponse* rygel_http_time_seek_response_new (gint64 start_time, gint64 end_time, gint64 total_duration, gint64 start_byte, gint64 end_byte, gint64 total_size);
RygelHTTPTimeSeekResponse* rygel_http_time_seek_response_construct (GType object_type, gint64 start_time, gint64 end_time, gint64 total_duration, gint64 start_byte, gint64 end_byte, gint64 total_size);
RygelHTTPResponseElement* rygel_http_response_element_construct (GType object_type);
static void rygel_http_time_seek_response_set_start_time (RygelHTTPTimeSeekResponse* self, gint64 value);
static void rygel_http_time_seek_response_set_end_time (RygelHTTPTimeSeekResponse* self, gint64 value);
static void rygel_http_time_seek_response_set_total_duration (RygelHTTPTimeSeekResponse* self, gint64 value);
static void rygel_http_time_seek_response_set_start_byte (RygelHTTPTimeSeekResponse* self, gint64 value);
static void rygel_http_time_seek_response_set_end_byte (RygelHTTPTimeSeekResponse* self, gint64 value);
#define RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED ((gint64) (-1))
static void rygel_http_time_seek_response_set_response_length (RygelHTTPTimeSeekResponse* self, gint64 value);
static void rygel_http_time_seek_response_set_total_size (RygelHTTPTimeSeekResponse* self, gint64 value);
RygelHTTPTimeSeekResponse* rygel_http_time_seek_response_new_time_only (gint64 start_time, gint64 end_time, gint64 total_duration);
RygelHTTPTimeSeekResponse* rygel_http_time_seek_response_construct_time_only (GType object_type, gint64 start_time, gint64 end_time, gint64 total_duration);
RygelHTTPTimeSeekResponse* rygel_http_time_seek_response_new_with_length (gint64 start_time, gint64 end_time, gint64 total_duration, gint64 start_byte, gint64 end_byte, gint64 total_size, gint64 response_length);
RygelHTTPTimeSeekResponse* rygel_http_time_seek_response_construct_with_length (GType object_type, gint64 start_time, gint64 end_time, gint64 total_duration, gint64 start_byte, gint64 end_byte, gint64 total_size, gint64 response_length);
GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
GType rygel_http_time_seek_request_get_type (void) G_GNUC_CONST;
RygelHTTPTimeSeekResponse* rygel_http_time_seek_response_new_from_request (RygelHTTPTimeSeekRequest* time_seek_request, gint64 total_duration);
RygelHTTPTimeSeekResponse* rygel_http_time_seek_response_construct_from_request (GType object_type, RygelHTTPTimeSeekRequest* time_seek_request, gint64 total_duration);
static void rygel_http_time_seek_response_real_add_response_headers (RygelHTTPResponseElement* base, RygelHTTPRequest* request);
static gchar* rygel_http_time_seek_response_get_response_string (RygelHTTPTimeSeekResponse* self);
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER "TimeSeekRange.dlna.org"
gint64 rygel_http_time_seek_response_get_response_length (RygelHTTPTimeSeekResponse* self);
gint64 rygel_http_time_seek_response_get_start_time (RygelHTTPTimeSeekResponse* self);
gint64 rygel_http_time_seek_response_get_end_time (RygelHTTPTimeSeekResponse* self);
gint64 rygel_http_time_seek_response_get_total_duration (RygelHTTPTimeSeekResponse* self);
gint64 rygel_http_time_seek_response_get_start_byte (RygelHTTPTimeSeekResponse* self);
gint64 rygel_http_time_seek_response_get_end_byte (RygelHTTPTimeSeekResponse* self);
gint64 rygel_http_time_seek_response_get_total_size (RygelHTTPTimeSeekResponse* self);
static gchar* rygel_http_time_seek_response_real_to_string (RygelHTTPResponseElement* base);
gint64 rygel_http_time_seek_response_get_range_duration (RygelHTTPTimeSeekResponse* self);
static void rygel_http_time_seek_response_set_range_duration (RygelHTTPTimeSeekResponse* self, gint64 value);
static void rygel_http_time_seek_response_finalize (GObject* obj);
static void _vala_rygel_http_time_seek_response_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_http_time_seek_response_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * Construct a HTTPTimeSeekResponse with time and byte range
     *
     * start_time and start_byte must be specified.
     *
     * if total_duration and total_size are UNSPECIFIED, then the content duration/size
     * will be signaled as unknown ("*")
     *
     * if end_time is UNSPECIFIED, then the time range end will be omitted from the
     * response. If the end_byte is UNSPECIFIED, the entire byte range response will be
     * omitted. (see DLNA 7.5.4.3.2.24.3)
     */
RygelHTTPTimeSeekResponse* rygel_http_time_seek_response_construct (GType object_type, gint64 start_time, gint64 end_time, gint64 total_duration, gint64 start_byte, gint64 end_byte, gint64 total_size) {
	RygelHTTPTimeSeekResponse * self = NULL;
	gint64 _tmp0_ = 0LL;
	gint64 _tmp1_ = 0LL;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_ = 0LL;
	gint64 _tmp4_ = 0LL;
	gint64 _tmp5_ = 0LL;
	gint64 _tmp6_ = 0LL;
	gint64 _tmp9_ = 0LL;
#line 86 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	self = (RygelHTTPTimeSeekResponse*) rygel_http_response_element_construct (object_type);
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp0_ = start_time;
#line 87 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	rygel_http_time_seek_response_set_start_time (self, _tmp0_);
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp1_ = end_time;
#line 88 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	rygel_http_time_seek_response_set_end_time (self, _tmp1_);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp2_ = total_duration;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	rygel_http_time_seek_response_set_total_duration (self, _tmp2_);
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp3_ = start_byte;
#line 91 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	rygel_http_time_seek_response_set_start_byte (self, _tmp3_);
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp4_ = end_byte;
#line 92 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	rygel_http_time_seek_response_set_end_byte (self, _tmp4_);
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp6_ = end_byte;
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	if (_tmp6_ == RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED) {
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		_tmp5_ = RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED;
#line 324 "rygel-http-time-seek-response.c"
	} else {
		gint64 _tmp7_ = 0LL;
		gint64 _tmp8_ = 0LL;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		_tmp7_ = end_byte;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		_tmp8_ = start_byte;
#line 94 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		_tmp5_ = (_tmp7_ - _tmp8_) + 1;
#line 334 "rygel-http-time-seek-response.c"
	}
#line 93 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	rygel_http_time_seek_response_set_response_length (self, _tmp5_);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp9_ = total_size;
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	rygel_http_time_seek_response_set_total_size (self, _tmp9_);
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	return self;
#line 344 "rygel-http-time-seek-response.c"
}


RygelHTTPTimeSeekResponse* rygel_http_time_seek_response_new (gint64 start_time, gint64 end_time, gint64 total_duration, gint64 start_byte, gint64 end_byte, gint64 total_size) {
#line 84 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	return rygel_http_time_seek_response_construct (RYGEL_TYPE_HTTP_TIME_SEEK_RESPONSE, start_time, end_time, total_duration, start_byte, end_byte, total_size);
#line 351 "rygel-http-time-seek-response.c"
}


/**
     * Create a HTTPTimeSeekResponse only containing a time range
     *
     * Note: This form is only valid when byte-seek is not supported, according to the
     * associated resource's ProtocolInfo (see DLNA 7.5.4.3.2.24.5)
     */
RygelHTTPTimeSeekResponse* rygel_http_time_seek_response_construct_time_only (GType object_type, gint64 start_time, gint64 end_time, gint64 total_duration) {
	RygelHTTPTimeSeekResponse * self = NULL;
	gint64 _tmp0_ = 0LL;
	gint64 _tmp1_ = 0LL;
	gint64 _tmp2_ = 0LL;
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	self = (RygelHTTPTimeSeekResponse*) rygel_http_response_element_construct (object_type);
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp0_ = start_time;
#line 106 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	rygel_http_time_seek_response_set_start_time (self, _tmp0_);
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp1_ = end_time;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	rygel_http_time_seek_response_set_end_time (self, _tmp1_);
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp2_ = total_duration;
#line 108 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	rygel_http_time_seek_response_set_total_duration (self, _tmp2_);
#line 110 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	rygel_http_time_seek_response_set_start_byte (self, RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED);
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	rygel_http_time_seek_response_set_end_byte (self, RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED);
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	rygel_http_time_seek_response_set_response_length (self, RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED);
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	rygel_http_time_seek_response_set_total_size (self, RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED);
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	return self;
#line 390 "rygel-http-time-seek-response.c"
}


RygelHTTPTimeSeekResponse* rygel_http_time_seek_response_new_time_only (gint64 start_time, gint64 end_time, gint64 total_duration) {
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	return rygel_http_time_seek_response_construct_time_only (RYGEL_TYPE_HTTP_TIME_SEEK_RESPONSE, start_time, end_time, total_duration);
#line 397 "rygel-http-time-seek-response.c"
}


/**
     * Construct a HTTPTimeSeekResponse with time and byte range and allowing for a
     * response length override. This is useful when the response body is larger than the
     * specified byte range from the original content binary.
     *
     * start_time and start_byte must be specified.
     *
     * If total_duration and total_size are UNSPECIFIED, then the content duration/size
     * will be signaled as unknown ("*")
     *
     * if end_time is UNSPECIFIED, then the time range end will be omitted from the
     * response. If the end_byte is UNSPECIFIED, the entire byte range response will be
     * omitted. (see DLNA 7.5.4.3.2.24.3)
     */
RygelHTTPTimeSeekResponse* rygel_http_time_seek_response_construct_with_length (GType object_type, gint64 start_time, gint64 end_time, gint64 total_duration, gint64 start_byte, gint64 end_byte, gint64 total_size, gint64 response_length) {
	RygelHTTPTimeSeekResponse * self = NULL;
	gint64 _tmp0_ = 0LL;
	gint64 _tmp1_ = 0LL;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_ = 0LL;
	gint64 _tmp4_ = 0LL;
	gint64 _tmp5_ = 0LL;
	gint64 _tmp6_ = 0LL;
#line 135 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	self = (RygelHTTPTimeSeekResponse*) rygel_http_response_element_construct (object_type);
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp0_ = start_time;
#line 136 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	rygel_http_time_seek_response_set_start_time (self, _tmp0_);
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp1_ = end_time;
#line 137 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	rygel_http_time_seek_response_set_end_time (self, _tmp1_);
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp2_ = total_duration;
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	rygel_http_time_seek_response_set_total_duration (self, _tmp2_);
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp3_ = start_byte;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	rygel_http_time_seek_response_set_start_byte (self, _tmp3_);
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp4_ = end_byte;
#line 141 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	rygel_http_time_seek_response_set_end_byte (self, _tmp4_);
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp5_ = response_length;
#line 142 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	rygel_http_time_seek_response_set_response_length (self, _tmp5_);
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp6_ = total_size;
#line 143 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	rygel_http_time_seek_response_set_total_size (self, _tmp6_);
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	return self;
#line 456 "rygel-http-time-seek-response.c"
}


RygelHTTPTimeSeekResponse* rygel_http_time_seek_response_new_with_length (gint64 start_time, gint64 end_time, gint64 total_duration, gint64 start_byte, gint64 end_byte, gint64 total_size, gint64 response_length) {
#line 130 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	return rygel_http_time_seek_response_construct_with_length (RYGEL_TYPE_HTTP_TIME_SEEK_RESPONSE, start_time, end_time, total_duration, start_byte, end_byte, total_size, response_length);
#line 463 "rygel-http-time-seek-response.c"
}


/**
     * Create a HTTPTimeSeekResponse from a HTTPTimeSeekRequest
     *
     * Note: This form is only valid when byte-seek is not supported, according to the
     * associated resource's ProtocolInfo (see DLNA 7.5.4.3.2.24.5)
     */
RygelHTTPTimeSeekResponse* rygel_http_time_seek_response_construct_from_request (GType object_type, RygelHTTPTimeSeekRequest* time_seek_request, gint64 total_duration) {
	RygelHTTPTimeSeekResponse * self = NULL;
	RygelHTTPTimeSeekRequest* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	RygelHTTPTimeSeekRequest* _tmp2_ = NULL;
	gint64 _tmp3_ = 0LL;
	gint64 _tmp4_ = 0LL;
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	g_return_val_if_fail (time_seek_request != NULL, NULL);
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp0_ = time_seek_request;
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp1_ = _tmp0_->start_time;
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp2_ = time_seek_request;
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp3_ = _tmp2_->end_time;
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp4_ = total_duration;
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	self = (RygelHTTPTimeSeekResponse*) rygel_http_time_seek_response_construct_time_only (object_type, _tmp1_, _tmp3_, _tmp4_);
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	return self;
#line 496 "rygel-http-time-seek-response.c"
}


RygelHTTPTimeSeekResponse* rygel_http_time_seek_response_new_from_request (RygelHTTPTimeSeekRequest* time_seek_request, gint64 total_duration) {
#line 152 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	return rygel_http_time_seek_response_construct_from_request (RYGEL_TYPE_HTTP_TIME_SEEK_RESPONSE, time_seek_request, total_duration);
#line 503 "rygel-http-time-seek-response.c"
}


static void rygel_http_time_seek_response_real_add_response_headers (RygelHTTPResponseElement* base, RygelHTTPRequest* request) {
	RygelHTTPTimeSeekResponse * self;
	gchar* response = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	self = (RygelHTTPTimeSeekResponse*) base;
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	g_return_if_fail (request != NULL);
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp0_ = rygel_http_time_seek_response_get_response_string (self);
#line 160 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	response = _tmp0_;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp1_ = response;
#line 161 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	if (_tmp1_ != NULL) {
#line 524 "rygel-http-time-seek-response.c"
		RygelHTTPRequest* _tmp2_ = NULL;
		SoupMessage* _tmp3_ = NULL;
		SoupMessageHeaders* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gint64 _tmp6_ = 0LL;
		RygelHTTPRequest* _tmp11_ = NULL;
		SoupMessage* _tmp12_ = NULL;
		SoupHTTPVersion _tmp13_ = 0;
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		_tmp2_ = request;
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		_tmp3_ = _tmp2_->msg;
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		_tmp4_ = _tmp3_->response_headers;
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		_tmp5_ = response;
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		soup_message_headers_append (_tmp4_, RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER, _tmp5_);
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		_tmp6_ = self->priv->_response_length;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		if (_tmp6_ != RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED) {
#line 547 "rygel-http-time-seek-response.c"
			RygelHTTPRequest* _tmp7_ = NULL;
			SoupMessage* _tmp8_ = NULL;
			SoupMessageHeaders* _tmp9_ = NULL;
			gint64 _tmp10_ = 0LL;
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
			_tmp7_ = request;
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
			_tmp8_ = _tmp7_->msg;
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
			_tmp9_ = _tmp8_->response_headers;
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
			_tmp10_ = self->priv->_response_length;
#line 166 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
			soup_message_headers_set_content_length (_tmp9_, _tmp10_);
#line 562 "rygel-http-time-seek-response.c"
		}
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		_tmp11_ = request;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		_tmp12_ = _tmp11_->msg;
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		_tmp13_ = soup_message_get_http_version (_tmp12_);
#line 168 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		if (_tmp13_ == SOUP_HTTP_1_0) {
#line 572 "rygel-http-time-seek-response.c"
			RygelHTTPRequest* _tmp14_ = NULL;
			SoupMessage* _tmp15_ = NULL;
			SoupMessageHeaders* _tmp16_ = NULL;
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
			_tmp14_ = request;
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
			_tmp15_ = _tmp14_->msg;
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
			_tmp16_ = _tmp15_->response_headers;
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
			soup_message_headers_replace (_tmp16_, "Pragma", "no-cache");
#line 584 "rygel-http-time-seek-response.c"
		}
	}
#line 159 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_g_free0 (response);
#line 589 "rygel-http-time-seek-response.c"
}


static gchar* rygel_http_time_seek_response_get_response_string (RygelHTTPTimeSeekResponse* self) {
	gchar* result = NULL;
	gint64 _tmp0_ = 0LL;
	GString* response = NULL;
	GString* _tmp1_ = NULL;
	GString* _tmp2_ = NULL;
	GString* _tmp3_ = NULL;
	gint64 _tmp4_ = 0LL;
	gint64 _tmp5_ = 0LL;
	gint64 _tmp8_ = 0LL;
	gboolean _tmp12_ = FALSE;
	gint64 _tmp13_ = 0LL;
	GString* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 175 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp0_ = self->priv->_start_time;
#line 175 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	if (_tmp0_ == RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED) {
#line 176 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		result = NULL;
#line 176 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		return result;
#line 618 "rygel-http-time-seek-response.c"
	}
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp1_ = g_string_new ("");
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	response = _tmp1_;
#line 194 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp2_ = response;
#line 194 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	g_string_append (_tmp2_, "npt=");
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp3_ = response;
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp4_ = self->priv->_start_time;
#line 195 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	g_string_append_printf (_tmp3_, "%.3f-", ((gdouble) _tmp4_) / G_TIME_SPAN_SECOND);
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp5_ = self->priv->_end_time;
#line 196 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	if (_tmp5_ != RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED) {
#line 638 "rygel-http-time-seek-response.c"
		GString* _tmp6_ = NULL;
		gint64 _tmp7_ = 0LL;
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		_tmp6_ = response;
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		_tmp7_ = self->priv->_end_time;
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		g_string_append_printf (_tmp6_, "%.3f", ((gdouble) _tmp7_) / G_TIME_SPAN_SECOND);
#line 647 "rygel-http-time-seek-response.c"
	}
#line 199 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp8_ = self->priv->_total_duration;
#line 199 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	if (_tmp8_ != RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED) {
#line 653 "rygel-http-time-seek-response.c"
		GString* _tmp9_ = NULL;
		gint64 _tmp10_ = 0LL;
#line 200 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		_tmp9_ = response;
#line 200 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		_tmp10_ = self->priv->_total_duration;
#line 200 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		g_string_append_printf (_tmp9_, "/%.3f", ((gdouble) _tmp10_) / G_TIME_SPAN_SECOND);
#line 662 "rygel-http-time-seek-response.c"
	} else {
		GString* _tmp11_ = NULL;
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		_tmp11_ = response;
#line 202 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		g_string_append (_tmp11_, "/*");
#line 669 "rygel-http-time-seek-response.c"
	}
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp13_ = self->priv->_start_byte;
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	if (_tmp13_ != RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED) {
#line 675 "rygel-http-time-seek-response.c"
		gint64 _tmp14_ = 0LL;
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		_tmp14_ = self->priv->_end_byte;
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		_tmp12_ = _tmp14_ != RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED;
#line 681 "rygel-http-time-seek-response.c"
	} else {
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		_tmp12_ = FALSE;
#line 685 "rygel-http-time-seek-response.c"
	}
#line 205 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	if (_tmp12_) {
#line 689 "rygel-http-time-seek-response.c"
		GString* _tmp15_ = NULL;
		GString* _tmp16_ = NULL;
		gint64 _tmp17_ = 0LL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		GString* _tmp20_ = NULL;
		GString* _tmp21_ = NULL;
		gint64 _tmp22_ = 0LL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		GString* _tmp25_ = NULL;
		gint64 _tmp26_ = 0LL;
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		_tmp15_ = response;
#line 206 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		g_string_append (_tmp15_, " bytes=");
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		_tmp16_ = response;
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		_tmp17_ = self->priv->_start_byte;
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		_tmp18_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp17_);
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		_tmp19_ = _tmp18_;
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		g_string_append (_tmp16_, _tmp19_);
#line 207 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		_g_free0 (_tmp19_);
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		_tmp20_ = response;
#line 208 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		g_string_append (_tmp20_, "-");
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		_tmp21_ = response;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		_tmp22_ = self->priv->_end_byte;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		_tmp23_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp22_);
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		_tmp24_ = _tmp23_;
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		g_string_append (_tmp21_, _tmp24_);
#line 209 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		_g_free0 (_tmp24_);
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		_tmp25_ = response;
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		g_string_append (_tmp25_, "/");
#line 211 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		_tmp26_ = self->priv->_total_size;
#line 211 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		if (_tmp26_ != RYGEL_HTTP_RESPONSE_ELEMENT_UNSPECIFIED) {
#line 742 "rygel-http-time-seek-response.c"
			GString* _tmp27_ = NULL;
			gint64 _tmp28_ = 0LL;
			gchar* _tmp29_ = NULL;
			gchar* _tmp30_ = NULL;
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
			_tmp27_ = response;
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
			_tmp28_ = self->priv->_total_size;
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
			_tmp29_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp28_);
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
			_tmp30_ = _tmp29_;
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
			g_string_append (_tmp27_, _tmp30_);
#line 212 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
			_g_free0 (_tmp30_);
#line 759 "rygel-http-time-seek-response.c"
		} else {
			GString* _tmp31_ = NULL;
#line 214 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
			_tmp31_ = response;
#line 214 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
			g_string_append (_tmp31_, "*");
#line 766 "rygel-http-time-seek-response.c"
		}
	}
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp32_ = response;
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp33_ = _tmp32_->str;
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp34_ = g_strdup (_tmp33_);
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	result = _tmp34_;
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_g_string_free0 (response);
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	return result;
#line 781 "rygel-http-time-seek-response.c"
}


static gchar* rygel_http_time_seek_response_real_to_string (RygelHTTPResponseElement* base) {
	RygelHTTPTimeSeekResponse * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 221 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	self = (RygelHTTPTimeSeekResponse*) base;
#line 222 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp0_ = rygel_http_time_seek_response_get_response_string (self);
#line 222 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp1_ = _tmp0_;
#line 222 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp2_ = g_strdup_printf ("HTTPTimeSeekResponse (%s)", _tmp1_);
#line 222 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp3_ = _tmp2_;
#line 222 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_g_free0 (_tmp1_);
#line 222 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	result = _tmp3_;
#line 222 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	return result;
#line 808 "rygel-http-time-seek-response.c"
}


gint64 rygel_http_time_seek_response_get_start_time (RygelHTTPTimeSeekResponse* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp0_ = self->priv->_start_time;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	result = _tmp0_;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	return result;
#line 823 "rygel-http-time-seek-response.c"
}


static void rygel_http_time_seek_response_set_start_time (RygelHTTPTimeSeekResponse* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	g_return_if_fail (self != NULL);
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp0_ = value;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	self->priv->_start_time = _tmp0_;
#line 35 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	g_object_notify ((GObject *) self, "start-time");
#line 837 "rygel-http-time-seek-response.c"
}


gint64 rygel_http_time_seek_response_get_end_time (RygelHTTPTimeSeekResponse* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp0_ = self->priv->_end_time;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	result = _tmp0_;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	return result;
#line 852 "rygel-http-time-seek-response.c"
}


static void rygel_http_time_seek_response_set_end_time (RygelHTTPTimeSeekResponse* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	g_return_if_fail (self != NULL);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp0_ = value;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	self->priv->_end_time = _tmp0_;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	g_object_notify ((GObject *) self, "end-time");
#line 866 "rygel-http-time-seek-response.c"
}


gint64 rygel_http_time_seek_response_get_range_duration (RygelHTTPTimeSeekResponse* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp0_ = self->priv->_range_duration;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	result = _tmp0_;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	return result;
#line 881 "rygel-http-time-seek-response.c"
}


static void rygel_http_time_seek_response_set_range_duration (RygelHTTPTimeSeekResponse* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	g_return_if_fail (self != NULL);
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp0_ = value;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	self->priv->_range_duration = _tmp0_;
#line 45 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	g_object_notify ((GObject *) self, "range-duration");
#line 895 "rygel-http-time-seek-response.c"
}


gint64 rygel_http_time_seek_response_get_total_duration (RygelHTTPTimeSeekResponse* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp0_ = self->priv->_total_duration;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	result = _tmp0_;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	return result;
#line 910 "rygel-http-time-seek-response.c"
}


static void rygel_http_time_seek_response_set_total_duration (RygelHTTPTimeSeekResponse* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	g_return_if_fail (self != NULL);
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp0_ = value;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	self->priv->_total_duration = _tmp0_;
#line 50 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	g_object_notify ((GObject *) self, "total-duration");
#line 924 "rygel-http-time-seek-response.c"
}


gint64 rygel_http_time_seek_response_get_start_byte (RygelHTTPTimeSeekResponse* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp0_ = self->priv->_start_byte;
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	result = _tmp0_;
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	return result;
#line 939 "rygel-http-time-seek-response.c"
}


static void rygel_http_time_seek_response_set_start_byte (RygelHTTPTimeSeekResponse* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	g_return_if_fail (self != NULL);
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp0_ = value;
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	self->priv->_start_byte = _tmp0_;
#line 55 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	g_object_notify ((GObject *) self, "start-byte");
#line 953 "rygel-http-time-seek-response.c"
}


gint64 rygel_http_time_seek_response_get_end_byte (RygelHTTPTimeSeekResponse* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp0_ = self->priv->_end_byte;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	result = _tmp0_;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	return result;
#line 968 "rygel-http-time-seek-response.c"
}


static void rygel_http_time_seek_response_set_end_byte (RygelHTTPTimeSeekResponse* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	g_return_if_fail (self != NULL);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp0_ = value;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	self->priv->_end_byte = _tmp0_;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	g_object_notify ((GObject *) self, "end-byte");
#line 982 "rygel-http-time-seek-response.c"
}


gint64 rygel_http_time_seek_response_get_response_length (RygelHTTPTimeSeekResponse* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp0_ = self->priv->_response_length;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	result = _tmp0_;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	return result;
#line 997 "rygel-http-time-seek-response.c"
}


static void rygel_http_time_seek_response_set_response_length (RygelHTTPTimeSeekResponse* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	g_return_if_fail (self != NULL);
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp0_ = value;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	self->priv->_response_length = _tmp0_;
#line 65 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	g_object_notify ((GObject *) self, "response-length");
#line 1011 "rygel-http-time-seek-response.c"
}


gint64 rygel_http_time_seek_response_get_total_size (RygelHTTPTimeSeekResponse* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp0_ = self->priv->_total_size;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	result = _tmp0_;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	return result;
#line 1026 "rygel-http-time-seek-response.c"
}


static void rygel_http_time_seek_response_set_total_size (RygelHTTPTimeSeekResponse* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	g_return_if_fail (self != NULL);
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	_tmp0_ = value;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	self->priv->_total_size = _tmp0_;
#line 70 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	g_object_notify ((GObject *) self, "total-size");
#line 1040 "rygel-http-time-seek-response.c"
}


static void rygel_http_time_seek_response_class_init (RygelHTTPTimeSeekResponseClass * klass) {
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	rygel_http_time_seek_response_parent_class = g_type_class_peek_parent (klass);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPTimeSeekResponsePrivate));
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	((RygelHTTPResponseElementClass *) klass)->add_response_headers = rygel_http_time_seek_response_real_add_response_headers;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	((RygelHTTPResponseElementClass *) klass)->to_string = rygel_http_time_seek_response_real_to_string;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_time_seek_response_get_property;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_time_seek_response_set_property;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_time_seek_response_finalize;
#line 1059 "rygel-http-time-seek-response.c"
	/**
	     * Effective range start time, in microseconds
	     */
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_TIME_SEEK_RESPONSE_START_TIME, g_param_spec_int64 ("start-time", "start-time", "start-time", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1065 "rygel-http-time-seek-response.c"
	/**
	     * Effective range end time, in microseconds
	     */
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_TIME_SEEK_RESPONSE_END_TIME, g_param_spec_int64 ("end-time", "end-time", "end-time", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1071 "rygel-http-time-seek-response.c"
	/**
	     * Effective range duration, in microseconds
	     */
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_TIME_SEEK_RESPONSE_RANGE_DURATION, g_param_spec_int64 ("range-duration", "range-duration", "range-duration", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1077 "rygel-http-time-seek-response.c"
	/**
	     * The total duration of the resource, in microseconds
	     */
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_TIME_SEEK_RESPONSE_TOTAL_DURATION, g_param_spec_int64 ("total-duration", "total-duration", "total-duration", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1083 "rygel-http-time-seek-response.c"
	/**
	     * The start of the range in bytes
	     */
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_TIME_SEEK_RESPONSE_START_BYTE, g_param_spec_int64 ("start-byte", "start-byte", "start-byte", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1089 "rygel-http-time-seek-response.c"
	/**
	     * The end of the range in bytes (inclusive)
	     */
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_TIME_SEEK_RESPONSE_END_BYTE, g_param_spec_int64 ("end-byte", "end-byte", "end-byte", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1095 "rygel-http-time-seek-response.c"
	/**
	     * The response length in bytes
	     */
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_TIME_SEEK_RESPONSE_RESPONSE_LENGTH, g_param_spec_int64 ("response-length", "response-length", "response-length", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1101 "rygel-http-time-seek-response.c"
	/**
	     * The length of the resource in bytes
	     */
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_TIME_SEEK_RESPONSE_TOTAL_SIZE, g_param_spec_int64 ("total-size", "total-size", "total-size", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1107 "rygel-http-time-seek-response.c"
}


static void rygel_http_time_seek_response_instance_init (RygelHTTPTimeSeekResponse * self) {
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	self->priv = RYGEL_HTTP_TIME_SEEK_RESPONSE_GET_PRIVATE (self);
#line 1114 "rygel-http-time-seek-response.c"
}


static void rygel_http_time_seek_response_finalize (GObject* obj) {
	RygelHTTPTimeSeekResponse * self;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_TIME_SEEK_RESPONSE, RygelHTTPTimeSeekResponse);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	G_OBJECT_CLASS (rygel_http_time_seek_response_parent_class)->finalize (obj);
#line 1124 "rygel-http-time-seek-response.c"
}


GType rygel_http_time_seek_response_get_type (void) {
	static volatile gsize rygel_http_time_seek_response_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_time_seek_response_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPTimeSeekResponseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_time_seek_response_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPTimeSeekResponse), 0, (GInstanceInitFunc) rygel_http_time_seek_response_instance_init, NULL };
		GType rygel_http_time_seek_response_type_id;
		rygel_http_time_seek_response_type_id = g_type_register_static (RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, "RygelHTTPTimeSeekResponse", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_time_seek_response_type_id__volatile, rygel_http_time_seek_response_type_id);
	}
	return rygel_http_time_seek_response_type_id__volatile;
}


static void _vala_rygel_http_time_seek_response_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPTimeSeekResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_TIME_SEEK_RESPONSE, RygelHTTPTimeSeekResponse);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	switch (property_id) {
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_START_TIME:
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		g_value_set_int64 (value, rygel_http_time_seek_response_get_start_time (self));
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		break;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_END_TIME:
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		g_value_set_int64 (value, rygel_http_time_seek_response_get_end_time (self));
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		break;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_RANGE_DURATION:
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		g_value_set_int64 (value, rygel_http_time_seek_response_get_range_duration (self));
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		break;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_TOTAL_DURATION:
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		g_value_set_int64 (value, rygel_http_time_seek_response_get_total_duration (self));
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		break;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_START_BYTE:
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		g_value_set_int64 (value, rygel_http_time_seek_response_get_start_byte (self));
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		break;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_END_BYTE:
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		g_value_set_int64 (value, rygel_http_time_seek_response_get_end_byte (self));
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		break;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_RESPONSE_LENGTH:
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		g_value_set_int64 (value, rygel_http_time_seek_response_get_response_length (self));
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		break;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_TOTAL_SIZE:
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		g_value_set_int64 (value, rygel_http_time_seek_response_get_total_size (self));
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		break;
#line 1193 "rygel-http-time-seek-response.c"
		default:
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		break;
#line 1199 "rygel-http-time-seek-response.c"
	}
}


static void _vala_rygel_http_time_seek_response_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPTimeSeekResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_TIME_SEEK_RESPONSE, RygelHTTPTimeSeekResponse);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
	switch (property_id) {
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_START_TIME:
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		rygel_http_time_seek_response_set_start_time (self, g_value_get_int64 (value));
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		break;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_END_TIME:
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		rygel_http_time_seek_response_set_end_time (self, g_value_get_int64 (value));
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		break;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_RANGE_DURATION:
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		rygel_http_time_seek_response_set_range_duration (self, g_value_get_int64 (value));
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		break;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_TOTAL_DURATION:
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		rygel_http_time_seek_response_set_total_duration (self, g_value_get_int64 (value));
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		break;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_START_BYTE:
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		rygel_http_time_seek_response_set_start_byte (self, g_value_get_int64 (value));
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		break;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_END_BYTE:
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		rygel_http_time_seek_response_set_end_byte (self, g_value_get_int64 (value));
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		break;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_RESPONSE_LENGTH:
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		rygel_http_time_seek_response_set_response_length (self, g_value_get_int64 (value));
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		break;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		case RYGEL_HTTP_TIME_SEEK_RESPONSE_TOTAL_SIZE:
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		rygel_http_time_seek_response_set_total_size (self, g_value_get_int64 (value));
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		break;
#line 1257 "rygel-http-time-seek-response.c"
		default:
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-http-time-seek-response.vala"
		break;
#line 1263 "rygel-http-time-seek-response.c"
	}
}



