/* rygel-object-creator.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-object-creator.vala, do not modify */

/*
 * Copyright (C) 2010-2011 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <gee.h>
#include <gio/gio.h>
#include <rygel-core.h>
#include <libgupnp/gupnp.h>
#include <glib/gi18n-lib.h>
#include <libsoup/soup.h>
#include <stdio.h>
#include <uuid/uuid.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_SERIALIZER (rygel_serializer_get_type ())
#define RYGEL_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializer))
#define RYGEL_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))
#define RYGEL_IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERIALIZER))
#define RYGEL_IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERIALIZER))
#define RYGEL_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))

typedef struct _RygelSerializer RygelSerializer;
typedef struct _RygelSerializerClass RygelSerializerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_MEDIA_RESOURCE (rygel_media_resource_get_type ())
#define RYGEL_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource))
#define RYGEL_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))
#define RYGEL_IS_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_IS_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_MEDIA_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))

typedef struct _RygelMediaResource RygelMediaResource;
typedef struct _RygelMediaResourceClass RygelMediaResourceClass;

#define RYGEL_TYPE_DATA_SOURCE (rygel_data_source_get_type ())
#define RYGEL_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSource))
#define RYGEL_IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATA_SOURCE))
#define RYGEL_DATA_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSourceIface))

typedef struct _RygelDataSource RygelDataSource;
typedef struct _RygelDataSourceIface RygelDataSourceIface;

#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;

#define RYGEL_TYPE_PLAY_SPEED_REQUEST (rygel_play_speed_request_get_type ())
#define RYGEL_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest))
#define RYGEL_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))
#define RYGEL_IS_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_IS_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_PLAY_SPEED_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))

typedef struct _RygelPlaySpeedRequest RygelPlaySpeedRequest;
typedef struct _RygelPlaySpeedRequestClass RygelPlaySpeedRequestClass;

#define RYGEL_TYPE_HTTP_RESPONSE_ELEMENT (rygel_http_response_element_get_type ())
#define RYGEL_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElement))
#define RYGEL_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_HTTP_RESPONSE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))

typedef struct _RygelHTTPResponseElement RygelHTTPResponseElement;
typedef struct _RygelHTTPResponseElementClass RygelHTTPResponseElementClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;

#define RYGEL_TYPE_BASE_MEDIA_CONTAINER (rygel_base_media_container_get_type ())
#define RYGEL_BASE_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BASE_MEDIA_CONTAINER, RygelBaseMediaContainer))
#define RYGEL_BASE_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BASE_MEDIA_CONTAINER, RygelBaseMediaContainerClass))
#define RYGEL_IS_BASE_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BASE_MEDIA_CONTAINER))
#define RYGEL_IS_BASE_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BASE_MEDIA_CONTAINER))
#define RYGEL_BASE_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BASE_MEDIA_CONTAINER, RygelBaseMediaContainerClass))

typedef struct _RygelBaseMediaContainer RygelBaseMediaContainer;
typedef struct _RygelBaseMediaContainerClass RygelBaseMediaContainerClass;
typedef struct _RygelBaseMediaContainerPrivate RygelBaseMediaContainerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelBaseMediaContainerGetChildrenData RygelBaseMediaContainerGetChildrenData;
typedef struct _RygelBaseMediaContainerFindObjectData RygelBaseMediaContainerFindObjectData;

#define RYGEL_TYPE_OBJECT_CREATOR (rygel_object_creator_get_type ())
#define RYGEL_OBJECT_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_OBJECT_CREATOR, RygelObjectCreator))
#define RYGEL_OBJECT_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_OBJECT_CREATOR, RygelObjectCreatorClass))
#define RYGEL_IS_OBJECT_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_OBJECT_CREATOR))
#define RYGEL_IS_OBJECT_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_OBJECT_CREATOR))
#define RYGEL_OBJECT_CREATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_OBJECT_CREATOR, RygelObjectCreatorClass))

typedef struct _RygelObjectCreator RygelObjectCreator;
typedef struct _RygelObjectCreatorClass RygelObjectCreatorClass;
typedef struct _RygelObjectCreatorPrivate RygelObjectCreatorPrivate;

#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;
#define __vala_GUPnPServiceAction_free0(var) ((var == NULL) ? NULL : (var = (_vala_GUPnPServiceAction_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _RygelContentDirectoryPrivate RygelContentDirectoryPrivate;

#define RYGEL_TYPE_SERIALIZER_TYPE (rygel_serializer_type_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_WRITABLE_CONTAINER (rygel_writable_container_get_type ())
#define RYGEL_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainer))
#define RYGEL_IS_WRITABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER))
#define RYGEL_WRITABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_WRITABLE_CONTAINER, RygelWritableContainerIface))

typedef struct _RygelWritableContainer RygelWritableContainer;
typedef struct _RygelWritableContainerIface RygelWritableContainerIface;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_MEDIA_FILE_ITEM (rygel_media_file_item_get_type ())
#define RYGEL_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem))
#define RYGEL_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))
#define RYGEL_IS_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_IS_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_MEDIA_FILE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))

typedef struct _RygelMediaFileItem RygelMediaFileItem;
typedef struct _RygelMediaFileItemClass RygelMediaFileItemClass;

#define RYGEL_TYPE_OBJECT_REMOVAL_QUEUE (rygel_object_removal_queue_get_type ())
#define RYGEL_OBJECT_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE, RygelObjectRemovalQueue))
#define RYGEL_OBJECT_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE, RygelObjectRemovalQueueClass))
#define RYGEL_IS_OBJECT_REMOVAL_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE))
#define RYGEL_IS_OBJECT_REMOVAL_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE))
#define RYGEL_OBJECT_REMOVAL_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_OBJECT_REMOVAL_QUEUE, RygelObjectRemovalQueueClass))

typedef struct _RygelObjectRemovalQueue RygelObjectRemovalQueue;
typedef struct _RygelObjectRemovalQueueClass RygelObjectRemovalQueueClass;
typedef struct _RygelObjectCreatorRunData RygelObjectCreatorRunData;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))

#define RYGEL_TYPE_SEARCH_CRITERIA_PARSER (rygel_search_criteria_parser_get_type ())
#define RYGEL_SEARCH_CRITERIA_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParser))
#define RYGEL_SEARCH_CRITERIA_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParserClass))
#define RYGEL_IS_SEARCH_CRITERIA_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_CRITERIA_PARSER))
#define RYGEL_IS_SEARCH_CRITERIA_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_CRITERIA_PARSER))
#define RYGEL_SEARCH_CRITERIA_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_CRITERIA_PARSER, RygelSearchCriteriaParserClass))

typedef struct _RygelSearchCriteriaParser RygelSearchCriteriaParser;
typedef struct _RygelSearchCriteriaParserClass RygelSearchCriteriaParserClass;

#define RYGEL_TYPE_LOGICAL_EXPRESSION (rygel_logical_expression_get_type ())
#define RYGEL_LOGICAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LOGICAL_EXPRESSION, RygelLogicalExpression))
#define RYGEL_LOGICAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LOGICAL_EXPRESSION, RygelLogicalExpressionClass))
#define RYGEL_IS_LOGICAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LOGICAL_EXPRESSION))
#define RYGEL_IS_LOGICAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LOGICAL_EXPRESSION))
#define RYGEL_LOGICAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LOGICAL_EXPRESSION, RygelLogicalExpressionClass))

typedef struct _RygelLogicalExpression RygelLogicalExpression;
typedef struct _RygelLogicalExpressionClass RygelLogicalExpressionClass;

#define RYGEL_TYPE_LOGICAL_OPERATOR (rygel_logical_operator_get_type ())
typedef struct _RygelSearchExpressionPrivate RygelSearchExpressionPrivate;
typedef struct _RygelSearchCriteriaParserPrivate RygelSearchCriteriaParserPrivate;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _RygelObjectCreatorBuildCreateClassExpressionData RygelObjectCreatorBuildCreateClassExpressionData;

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerIface))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerIface RygelSearchableContainerIface;

#define RYGEL_TYPE_RELATIONAL_EXPRESSION (rygel_relational_expression_get_type ())
#define RYGEL_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpression))
#define RYGEL_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))
#define RYGEL_IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))

typedef struct _RygelRelationalExpression RygelRelationalExpression;
typedef struct _RygelRelationalExpressionClass RygelRelationalExpressionClass;
typedef struct _RygelObjectCreatorFindAnyContainerData RygelObjectCreatorFindAnyContainerData;
typedef struct _RygelObjectCreatorFetchContainerData RygelObjectCreatorFetchContainerData;

#define RYGEL_TYPE_IMAGE_ITEM (rygel_image_item_get_type ())
#define RYGEL_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_IMAGE_ITEM, RygelImageItem))
#define RYGEL_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_IMAGE_ITEM, RygelImageItemClass))
#define RYGEL_IS_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_IMAGE_ITEM))
#define RYGEL_IS_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_IMAGE_ITEM))
#define RYGEL_IMAGE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_IMAGE_ITEM, RygelImageItemClass))

typedef struct _RygelImageItem RygelImageItem;
typedef struct _RygelImageItemClass RygelImageItemClass;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;
typedef struct _RygelObjectCreatorCreateObjectFromDidlData RygelObjectCreatorCreateObjectFromDidlData;
#define __vala_SoupDate_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupDate_free (var), NULL)))

#define RYGEL_TYPE_PHOTO_ITEM (rygel_photo_item_get_type ())
#define RYGEL_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItem))
#define RYGEL_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItemClass))
#define RYGEL_IS_PHOTO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PHOTO_ITEM))
#define RYGEL_IS_PHOTO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PHOTO_ITEM))
#define RYGEL_PHOTO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PHOTO_ITEM, RygelPhotoItemClass))

typedef struct _RygelPhotoItem RygelPhotoItem;
typedef struct _RygelPhotoItemClass RygelPhotoItemClass;

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;

#define RYGEL_TYPE_PLAYLIST_ITEM (rygel_playlist_item_get_type ())
#define RYGEL_PLAYLIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAYLIST_ITEM, RygelPlaylistItem))
#define RYGEL_PLAYLIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAYLIST_ITEM, RygelPlaylistItemClass))
#define RYGEL_IS_PLAYLIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAYLIST_ITEM))
#define RYGEL_IS_PLAYLIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAYLIST_ITEM))
#define RYGEL_PLAYLIST_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAYLIST_ITEM, RygelPlaylistItemClass))

typedef struct _RygelPlaylistItem RygelPlaylistItem;
typedef struct _RygelPlaylistItemClass RygelPlaylistItemClass;
#define __vala_SoupURI_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupURI_free (var), NULL)))
typedef struct _RygelObjectCreatorCreateUriData RygelObjectCreatorCreateUriData;
typedef struct _Block8Data Block8Data;
typedef struct _Block9Data Block9Data;

#define RYGEL_TYPE_OBJECT_EVENT_TYPE (rygel_object_event_type_get_type ())
typedef struct _RygelObjectCreatorWaitForObjectData RygelObjectCreatorWaitForObjectData;

#define RYGEL_TYPE_MEDIA_SERVER_PLUGIN (rygel_media_server_plugin_get_type ())
#define RYGEL_MEDIA_SERVER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPlugin))
#define RYGEL_MEDIA_SERVER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPluginClass))
#define RYGEL_IS_MEDIA_SERVER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_SERVER_PLUGIN))
#define RYGEL_IS_MEDIA_SERVER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_SERVER_PLUGIN))
#define RYGEL_MEDIA_SERVER_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPluginClass))

typedef struct _RygelMediaServerPlugin RygelMediaServerPlugin;
typedef struct _RygelMediaServerPluginClass RygelMediaServerPluginClass;
#define _rygel_dlna_profile_unref0(var) ((var == NULL) ? NULL : (var = (rygel_dlna_profile_unref (var), NULL)))

struct _RygelDataSourceIface {
	GTypeInterface parent_iface;
	GeeList* (*preroll) (RygelDataSource* self, RygelHTTPSeekRequest* seek, RygelPlaySpeedRequest* playspeed, GError** error);
	void (*start) (RygelDataSource* self, GError** error);
	void (*freeze) (RygelDataSource* self);
	void (*thaw) (RygelDataSource* self);
	void (*stop) (RygelDataSource* self);
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	RygelMediaContainer* parent_ptr;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	void (*add_uri) (RygelMediaObject* self, const gchar* uri);
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
	RygelDataSource* (*create_stream_source_for_resource) (RygelMediaObject* self, RygelHTTPRequest* request, RygelMediaResource* resource, GError** error);
	void (*apply_didl_lite) (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	guint32 update_id;
	gint64 storage_used;
	gint64 total_deleted_child_count;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
	void (*get_children) (RygelMediaContainer* self, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*get_children_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
	void (*find_object) (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObject* (*find_object_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
};

struct _RygelBaseMediaContainer {
	RygelMediaContainer parent_instance;
	RygelBaseMediaContainerPrivate * priv;
};

struct _RygelBaseMediaContainerClass {
	RygelMediaContainerClass parent_class;
};

struct _RygelBaseMediaContainerGetChildrenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelBaseMediaContainer* self;
	guint offset;
	guint max_count;
	gchar* sort_criteria;
	GCancellable* cancellable;
	RygelMediaObjects* result;
};

struct _RygelBaseMediaContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelBaseMediaContainer* self;
	gchar* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
};

struct _RygelObjectCreator {
	GObject parent_instance;
	RygelObjectCreatorPrivate * priv;
};

struct _RygelObjectCreatorClass {
	GObjectClass parent_class;
};

struct _RygelObjectCreatorPrivate {
	gchar* container_id;
	gchar* elements;
	GUPnPDIDLLiteObject* didl_object;
	RygelMediaObject* object;
	RygelContentDirectory* content_dir;
	GUPnPServiceAction* action;
	RygelSerializer* serializer;
	GUPnPDIDLLiteParser* didl_parser;
	GRegex* title_regex;
	GCancellable* _cancellable;
};

struct _RygelContentDirectory {
	GUPnPService parent_instance;
	RygelContentDirectoryPrivate * priv;
	gchar* feature_list;
	RygelHTTPServer* http_server;
	RygelMediaContainer* root_container;
	GCancellable* cancellable;
	guint32 system_update_id;
};

struct _RygelContentDirectoryClass {
	GUPnPServiceClass parent_class;
};

typedef enum  {
	RYGEL_SERIALIZER_TYPE_GENERIC_DIDL,
	RYGEL_SERIALIZER_TYPE_DIDL_S,
	RYGEL_SERIALIZER_TYPE_M3UEXT
} RygelSerializerType;

struct _RygelWritableContainerIface {
	GTypeInterface parent_iface;
	void (*add_item) (RygelWritableContainer* self, RygelMediaFileItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*add_container) (RygelWritableContainer* self, RygelMediaContainer* container, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_container_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*add_reference) (RygelWritableContainer* self, RygelMediaObject* object, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar* (*add_reference_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*remove_item) (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_item_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	void (*remove_container) (RygelWritableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_container_finish) (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
	GeeArrayList* (*get_create_classes) (RygelWritableContainer* self);
	void (*set_create_classes) (RygelWritableContainer* self, GeeArrayList* value);
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_CURRENT_TAG_VALUE = 702,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_NEW_TAG_VALUE = 703,
	RYGEL_CONTENT_DIRECTORY_ERROR_REQUIRED_TAG = 704,
	RYGEL_CONTENT_DIRECTORY_ERROR_READ_ONLY_TAG = 705,
	RYGEL_CONTENT_DIRECTORY_ERROR_PARAMETER_MISMATCH = 706,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SEARCH_CRITERIA = 708,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SORT_CRITERIA = 709,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_CONTAINER = 710,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT = 711,
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA = 712,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT = 713,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_FILE_TRANSFER = 717,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_DESTINATION_RESOURCE = 718,
	RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS = 720,
	RYGEL_CONTENT_DIRECTORY_ERROR_OUTDATED_OBJECT_METADATA = 728,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
struct _RygelObjectCreatorRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelObjectCreator* self;
	RygelWritableContainer* container;
	RygelWritableContainer* _tmp0_;
	gboolean _tmp1_;
	RygelWritableContainer* _tmp2_;
	GUPnPDIDLLiteObject* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_;
	const gchar* _tmp7_;
	GUPnPDIDLLiteObject* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	RygelWritableContainer* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	GError* _tmp14_;
	gboolean _tmp15_;
	GUPnPDIDLLiteObject* _tmp16_;
	RygelWritableContainer* _tmp17_;
	gboolean _tmp18_;
	const gchar* _tmp19_;
	GError* _tmp20_;
	RygelWritableContainer* _tmp21_;
	RygelMediaObject* _tmp22_;
	RygelWritableContainer* _tmp23_;
	RygelMediaObject* _tmp24_;
	GCancellable* _tmp25_;
	GCancellable* _tmp26_;
	RygelWritableContainer* _tmp27_;
	RygelMediaObject* _tmp28_;
	GCancellable* _tmp29_;
	GCancellable* _tmp30_;
	RygelWritableContainer* _tmp31_;
	RygelMediaObject* _tmp32_;
	RygelSerializer* _tmp33_;
	RygelContentDirectory* _tmp34_;
	RygelHTTPServer* _tmp35_;
	GUPnPDIDLLiteObject* _tmp36_;
	GUPnPDIDLLiteObject* _tmp37_;
	gboolean _tmp38_;
	const gchar* _tmp39_;
	gboolean _tmp40_;
	RygelMediaObject* _tmp41_;
	RygelMediaObject* _tmp42_;
	gboolean _tmp43_;
	gboolean _tmp44_;
	RygelObjectRemovalQueue* queue;
	RygelObjectRemovalQueue* _tmp45_;
	RygelObjectRemovalQueue* _tmp46_;
	RygelMediaObject* _tmp47_;
	GCancellable* _tmp48_;
	GCancellable* _tmp49_;
	GError* err;
	GError* _tmp50_;
	GError * _inner_error_;
};

typedef enum  {
	RYGEL_LOGICAL_OPERATOR_AND,
	RYGEL_LOGICAL_OPERATOR_OR
} RygelLogicalOperator;

struct _RygelSearchExpression {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSearchExpressionPrivate * priv;
	gpointer op;
	gpointer operand1;
	gpointer operand2;
};

struct _RygelSearchExpressionClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSearchExpression *self);
	gboolean (*satisfied_by) (RygelSearchExpression* self, RygelMediaObject* media_object);
	gchar* (*to_string) (RygelSearchExpression* self);
};

struct _RygelSearchCriteriaParser {
	GObject parent_instance;
	RygelSearchCriteriaParserPrivate * priv;
	gchar* str;
	RygelSearchExpression* expression;
	GError* err;
};

struct _RygelSearchCriteriaParserClass {
	GObjectClass parent_class;
};

struct _RygelObjectCreatorBuildCreateClassExpressionData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelObjectCreator* self;
	RygelSearchExpression* expression;
	RygelSearchExpression* result;
	GUPnPDIDLLiteObject* _tmp0_;
	RygelSearchExpression* _tmp1_;
	RygelSearchExpression* _tmp2_;
	GUPnPDIDLLiteContainer* didl_container;
	GUPnPDIDLLiteObject* _tmp3_;
	GUPnPDIDLLiteContainer* _tmp4_;
	GList* create_classes;
	GUPnPDIDLLiteContainer* _tmp5_;
	GList* _tmp6_;
	GList* _tmp7_;
	RygelSearchExpression* _tmp8_;
	RygelSearchExpression* _tmp9_;
	GString* builder;
	GString* _tmp10_;
	GList* _tmp11_;
	GList* create_class_collection;
	GList* create_class_it;
	gchar* _tmp12_;
	gchar* create_class;
	GString* _tmp13_;
	const gchar* _tmp14_;
	GString* _tmp15_;
	GString* _tmp16_;
	gssize _tmp17_;
	GString* _tmp18_;
	RygelSearchCriteriaParser* parser;
	GString* _tmp19_;
	const gchar* _tmp20_;
	RygelSearchCriteriaParser* _tmp21_;
	RygelSearchCriteriaParser* _tmp22_;
	RygelLogicalExpression* rel;
	RygelLogicalExpression* _tmp23_;
	RygelLogicalExpression* _tmp24_;
	RygelSearchExpression* _tmp25_;
	RygelSearchExpression* _tmp26_;
	RygelLogicalExpression* _tmp27_;
	RygelLogicalExpression* _tmp28_;
	RygelSearchCriteriaParser* _tmp29_;
	RygelSearchExpression* _tmp30_;
	RygelSearchExpression* _tmp31_;
	GError* _error_;
	GError * _inner_error_;
};

struct _RygelSearchableContainerIface {
	GTypeInterface parent_iface;
	void (*search) (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	GeeArrayList* (*get_search_classes) (RygelSearchableContainer* self);
	void (*set_search_classes) (RygelSearchableContainer* self, GeeArrayList* value);
};

struct _RygelObjectCreatorFindAnyContainerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelObjectCreator* self;
	RygelMediaObject* result;
	RygelSearchableContainer* root_container;
	RygelContentDirectory* _tmp0_;
	RygelMediaContainer* _tmp1_;
	RygelSearchableContainer* _tmp2_;
	RygelSearchableContainer* _tmp3_;
	gchar* upnp_class;
	GUPnPDIDLLiteObject* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	RygelRelationalExpression* expression;
	RygelRelationalExpression* _tmp8_;
	RygelRelationalExpression* _tmp9_;
	RygelRelationalExpression* _tmp10_;
	gchar* _tmp11_;
	RygelSearchExpression* search_expression;
	RygelRelationalExpression* _tmp12_;
	RygelSearchExpression* _tmp13_;
	const gchar* _tmp14_;
	RygelRelationalExpression* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	guint total_matches;
	RygelMediaObjects* _result_;
	RygelSearchableContainer* _tmp18_;
	RygelSearchExpression* _tmp19_;
	RygelSearchableContainer* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	GCancellable* _tmp23_;
	GCancellable* _tmp24_;
	guint _tmp25_;
	RygelMediaObjects* _tmp26_;
	RygelMediaObjects* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	GUPnPDIDLLiteObject* _tmp30_;
	const gchar* _tmp31_;
	RygelMediaObjects* _tmp32_;
	gpointer _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	GUPnPDIDLLiteObject* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	GError* _tmp39_;
	GError * _inner_error_;
};

struct _RygelObjectCreatorFetchContainerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelObjectCreator* self;
	RygelWritableContainer* result;
	RygelMediaObject* media_object;
	const gchar* _tmp0_;
	RygelMediaObject* _tmp1_;
	RygelMediaObject* _tmp2_;
	RygelMediaObject* _tmp3_;
	RygelMediaObject* _tmp4_;
	RygelContentDirectory* _tmp5_;
	RygelMediaContainer* _tmp6_;
	const gchar* _tmp7_;
	GCancellable* _tmp8_;
	GCancellable* _tmp9_;
	RygelMediaObject* _tmp10_;
	RygelMediaObject* _tmp11_;
	gboolean _tmp12_;
	RygelMediaObject* _tmp13_;
	RygelMediaObject* _tmp14_;
	const gchar* _tmp15_;
	GError* _tmp16_;
	RygelMediaObject* _tmp17_;
	const gchar* _tmp18_;
	RygelMediaObject* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	GError* _tmp22_;
	gboolean _tmp23_;
	gboolean _tmp24_;
	GUPnPDIDLLiteObject* _tmp25_;
	RygelMediaObject* _tmp26_;
	GUPnPOCMFlags _tmp27_;
	GUPnPOCMFlags _tmp28_;
	gboolean _tmp29_;
	GUPnPDIDLLiteObject* _tmp30_;
	RygelMediaObject* _tmp31_;
	GUPnPOCMFlags _tmp32_;
	GUPnPOCMFlags _tmp33_;
	const gchar* _tmp34_;
	RygelMediaObject* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	GError* _tmp38_;
	RygelMediaObject* _tmp39_;
	RygelWritableContainer* _tmp40_;
	GError * _inner_error_;
};

struct _RygelObjectCreatorCreateObjectFromDidlData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelObjectCreator* self;
	RygelWritableContainer* container;
	RygelMediaObject* _tmp0_;
	GUPnPDIDLLiteObject* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	RygelWritableContainer* _tmp4_;
	GUPnPDIDLLiteObject* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	GUPnPDIDLLiteObject* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	RygelMediaObject* _tmp11_;
	RygelMediaObject* _tmp12_;
	RygelMediaObject* _tmp13_;
	GUPnPDIDLLiteObject* _tmp14_;
	RygelMediaObject* _tmp15_;
	RygelMediaObject* _tmp16_;
	GeeList* _tmp17_;
	GeeList* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	gchar* uri;
	RygelWritableContainer* _tmp22_;
	RygelMediaObject* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	RygelMediaObject* _tmp27_;
	const gchar* _tmp28_;
	RygelMediaObject* _tmp29_;
	RygelMediaObject* _tmp30_;
	RygelMediaObject* _tmp31_;
	GFile* file;
	RygelMediaObject* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	GFile* _tmp35_;
	GFile* _tmp36_;
	RygelMediaObject* _tmp37_;
	GFile* _tmp38_;
	gboolean _tmp39_;
	RygelMediaObject* _tmp40_;
	RygelMediaObject* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	GError * _inner_error_;
};

struct _RygelObjectCreatorCreateUriData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelObjectCreator* self;
	RygelWritableContainer* container;
	gchar* title;
	gchar* result;
	GFile* dir;
	RygelWritableContainer* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	const gchar* _tmp5_;
	RygelWritableContainer* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GError* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	GFile* file;
	GFile* _tmp13_;
	GFile* _tmp14_;
	GFile* _tmp15_;
	gchar* _tmp16_;
	GError * _inner_error_;
};

struct _Block8Data {
	int _ref_count_;
	RygelObjectCreator* self;
	RygelWritableContainer* container;
	gpointer _async_data_;
};

struct _Block9Data {
	int _ref_count_;
	Block8Data * _data8_;
	guint timeout;
};

typedef enum  {
	RYGEL_OBJECT_EVENT_TYPE_ADDED = 0,
	RYGEL_OBJECT_EVENT_TYPE_MODIFIED = 1,
	RYGEL_OBJECT_EVENT_TYPE_DELETED = 2
} RygelObjectEventType;

struct _RygelObjectCreatorWaitForObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelObjectCreator* self;
	RygelWritableContainer* container;
	Block8Data* _data8_;
	RygelWritableContainer* _tmp0_;
	RygelWritableContainer* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	RygelMediaObject* object;
	RygelMediaObject* _tmp4_;
	RygelMediaObject* _tmp5_;
	RygelWritableContainer* _tmp6_;
	RygelMediaObject* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	GCancellable* _tmp10_;
	GCancellable* _tmp11_;
	RygelMediaObject* _tmp12_;
	RygelMediaObject* _tmp13_;
	GError* _error_;
	gchar* msg;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	RygelWritableContainer* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	RygelMediaObject* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	GError* _tmp23_;
	const gchar* _tmp24_;
	RygelMediaObject* _tmp25_;
	Block9Data* _data9_;
	gulong id;
	RygelWritableContainer* _tmp26_;
	gulong _tmp27_;
	guint _tmp28_;
	RygelWritableContainer* _tmp29_;
	gulong _tmp30_;
	guint _tmp31_;
	guint _tmp32_;
	RygelWritableContainer* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	RygelMediaObject* _tmp36_;
	RygelMediaObject* _tmp37_;
	GError * _inner_error_;
};


static gpointer rygel_base_media_container_parent_class = NULL;
static gpointer rygel_object_creator_parent_class = NULL;
static GPatternSpec* rygel_object_creator_comment_pattern;
static GPatternSpec* rygel_object_creator_comment_pattern = NULL;
static RygelStateMachineIface* rygel_object_creator_rygel_state_machine_parent_iface = NULL;

GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_serializer_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_media_resource_get_type (void) G_GNUC_CONST;
GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
GType rygel_play_speed_request_get_type (void) G_GNUC_CONST;
GType rygel_http_response_element_get_type (void) G_GNUC_CONST;
GType rygel_data_source_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
GType rygel_base_media_container_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_BASE_MEDIA_CONTAINER_DUMMY_PROPERTY
};
RygelBaseMediaContainer* rygel_base_media_container_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, gint child_count);
RygelBaseMediaContainer* rygel_base_media_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, gint child_count);
static void rygel_base_media_container_real_get_children_data_free (gpointer _data);
static void rygel_base_media_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_base_media_container_real_get_children_co (RygelBaseMediaContainerGetChildrenData* _data_);
static void rygel_base_media_container_real_find_object_data_free (gpointer _data);
static void rygel_base_media_container_real_find_object (RygelMediaContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_base_media_container_real_find_object_co (RygelBaseMediaContainerFindObjectData* _data_);
GType rygel_object_creator_get_type (void) G_GNUC_CONST;
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
#define RYGEL_OBJECT_CREATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_OBJECT_CREATOR, RygelObjectCreatorPrivate))
enum  {
	RYGEL_OBJECT_CREATOR_DUMMY_PROPERTY,
	RYGEL_OBJECT_CREATOR_CANCELLABLE
};
static void _vala_GUPnPServiceAction_free (GUPnPServiceAction* self);
#define RYGEL_OBJECT_CREATOR_INVALID_CHARS "/?<>\\:*|\""
RygelObjectCreator* rygel_object_creator_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelObjectCreator* rygel_object_creator_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
GType rygel_serializer_type_get_type (void) G_GNUC_CONST;
RygelSerializer* rygel_serializer_new (RygelSerializerType type);
RygelSerializer* rygel_serializer_construct (GType object_type, RygelSerializerType type);
static void rygel_object_creator_real_run_data_free (gpointer _data);
static void rygel_object_creator_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_object_creator_real_run_co (RygelObjectCreatorRunData* _data_);
static void rygel_object_creator_parse_args (RygelObjectCreator* self, GError** error);
static void rygel_object_creator_parse_didl (RygelObjectCreator* self, GError** error);
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_media_file_item_get_type (void) G_GNUC_CONST;
GType rygel_writable_container_get_type (void) G_GNUC_CONST;
static void rygel_object_creator_fetch_container (RygelObjectCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static RygelWritableContainer* rygel_object_creator_fetch_container_finish (RygelObjectCreator* self, GAsyncResult* _res_, GError** error);
static void rygel_object_creator_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gboolean rygel_writable_container_can_create (RygelWritableContainer* self, const gchar* upnp_class);
#define RYGEL_MEDIA_CONTAINER_ANY "DLNA.ORG_AnyContainer"
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
GQuark rygel_content_directory_error_quark (void);
static gboolean rygel_object_creator_validate_create_class (RygelObjectCreator* self, RygelWritableContainer* container);
static void rygel_object_creator_create_object_from_didl (RygelObjectCreator* self, RygelWritableContainer* container, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_object_creator_create_object_from_didl_finish (RygelObjectCreator* self, GAsyncResult* _res_, GError** error);
void rygel_writable_container_add_item (RygelWritableContainer* self, RygelMediaFileItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_writable_container_add_item_finish (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
void rygel_writable_container_add_container (RygelWritableContainer* self, RygelMediaContainer* container, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_writable_container_add_container_finish (RygelWritableContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_object_creator_wait_for_object (RygelObjectCreator* self, RygelWritableContainer* container, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_object_creator_wait_for_object_finish (RygelObjectCreator* self, GAsyncResult* _res_);
GUPnPDIDLLiteObject* rygel_media_object_serialize (RygelMediaObject* self, RygelSerializer* serializer, RygelHTTPServer* http_server, GError** error);
static void rygel_object_creator_conclude (RygelObjectCreator* self);
gboolean rygel_media_file_item_get_place_holder (RygelMediaFileItem* self);
GType rygel_object_removal_queue_get_type (void) G_GNUC_CONST;
RygelObjectRemovalQueue* rygel_object_removal_queue_get_default (void);
void rygel_object_removal_queue_queue (RygelObjectRemovalQueue* self, RygelMediaObject* object, GCancellable* cancellable);
static void rygel_object_creator_handle_error (RygelObjectCreator* self, GError* _error_);
static void __lambda12_ (RygelObjectCreator* self, GUPnPDIDLLiteObject* didl_object);
static void ___lambda12__gupnp_didl_lite_parser_object_available (GUPnPDIDLLiteParser* _sender, GUPnPDIDLLiteObject* object, gpointer self);
#define RYGEL_PLAYLIST_ITEM_UPNP_CLASS "object.item.playlistItem"
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void rygel_object_creator_generalize_upnp_class (RygelObjectCreator* self, gchar** upnp_class);
static void rygel_object_creator_build_create_class_expression_data_free (gpointer _data);
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
void rygel_value_take_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void) G_GNUC_CONST;
static void rygel_object_creator_build_create_class_expression (RygelObjectCreator* self, RygelSearchExpression* expression, GAsyncReadyCallback _callback_, gpointer _user_data_);
static RygelSearchExpression* rygel_object_creator_build_create_class_expression_finish (RygelObjectCreator* self, GAsyncResult* _res_);
static gboolean rygel_object_creator_build_create_class_expression_co (RygelObjectCreatorBuildCreateClassExpressionData* _data_);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
GType rygel_search_criteria_parser_get_type (void) G_GNUC_CONST;
RygelSearchCriteriaParser* rygel_search_criteria_parser_new (const gchar* str, GError** error);
RygelSearchCriteriaParser* rygel_search_criteria_parser_construct (GType object_type, const gchar* str, GError** error);
static void rygel_object_creator_build_create_class_expression_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GType rygel_logical_expression_get_type (void) G_GNUC_CONST;
RygelLogicalExpression* rygel_logical_expression_new (void);
RygelLogicalExpression* rygel_logical_expression_construct (GType object_type);
GType rygel_logical_operator_get_type (void) G_GNUC_CONST;
static void rygel_object_creator_find_any_container_data_free (gpointer _data);
static void rygel_object_creator_find_any_container (RygelObjectCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static RygelMediaObject* rygel_object_creator_find_any_container_finish (RygelObjectCreator* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_object_creator_find_any_container_co (RygelObjectCreatorFindAnyContainerData* _data_);
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
GType rygel_relational_expression_get_type (void) G_GNUC_CONST;
RygelRelationalExpression* rygel_relational_expression_new (void);
RygelRelationalExpression* rygel_relational_expression_construct (GType object_type);
static void rygel_object_creator_find_any_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_searchable_container_search (RygelSearchableContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_searchable_container_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
const gchar* rygel_media_container_get_sort_criteria (RygelMediaContainer* self);
static void rygel_object_creator_fetch_container_data_free (gpointer _data);
static gboolean rygel_object_creator_fetch_container_co (RygelObjectCreatorFetchContainerData* _data_);
static void rygel_object_creator_fetch_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
GUPnPOCMFlags rygel_media_object_get_ocm_flags (RygelMediaObject* self);
gchar* rygel_serializer_get_string (RygelSerializer* self);
static gchar* rygel_object_creator_get_generic_mime_type (RygelObjectCreator* self);
GType rygel_image_item_get_type (void) G_GNUC_CONST;
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_video_item_get_type (void) G_GNUC_CONST;
static void rygel_object_creator_create_object_from_didl_data_free (gpointer _data);
static gboolean rygel_object_creator_create_object_from_didl_co (RygelObjectCreatorCreateObjectFromDidlData* _data_);
static RygelMediaObject* rygel_object_creator_create_object (RygelObjectCreator* self, const gchar* id, RygelWritableContainer* parent, const gchar* title, const gchar* upnp_class, GError** error);
void rygel_media_object_apply_didl_lite (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
static void rygel_object_creator_extract_item_parameters (RygelObjectCreator* self, GError** error);
GeeList* rygel_media_object_get_uris (RygelMediaObject* self);
static void rygel_object_creator_create_uri (RygelObjectCreator* self, RygelWritableContainer* container, const gchar* title, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gchar* rygel_object_creator_create_uri_finish (RygelObjectCreator* self, GAsyncResult* _res_, GError** error);
const gchar* rygel_media_object_get_title (RygelMediaObject* self);
static void rygel_object_creator_create_object_from_didl_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_media_object_add_uri (RygelMediaObject* self, const gchar* uri);
void rygel_media_file_item_set_place_holder (RygelMediaFileItem* self, gboolean value);
gchar* rygel_media_object_get_primary_uri (RygelMediaObject* self);
void rygel_media_object_set_id (RygelMediaObject* self, const gchar* value);
static void rygel_object_creator_parse_and_verify_didl_date (RygelObjectCreator* self, GError** error);
static gboolean rygel_object_creator_is_profile_valid (RygelObjectCreator* self, const gchar* profile);
void rygel_media_file_item_set_dlna_profile (RygelMediaFileItem* self, const gchar* value);
void rygel_media_file_item_set_mime_type (RygelMediaFileItem* self, const gchar* value);
static gboolean rygel_object_creator_is_valid_uri (RygelObjectCreator* self, const gchar* uri, gchar** sanitized_uri);
void rygel_media_file_item_set_size (RygelMediaFileItem* self, gint64 value);
const gchar* rygel_media_file_item_get_mime_type (RygelMediaFileItem* self);
gint64 rygel_media_file_item_get_size (RygelMediaFileItem* self);
void rygel_media_object_set_date (RygelMediaObject* self, const gchar* value);
static void _vala_SoupDate_free (SoupDate* self);
#define RYGEL_IMAGE_ITEM_UPNP_CLASS "object.item.imageItem"
#define RYGEL_PHOTO_ITEM_UPNP_CLASS "object.item.imageItem.photo"
#define RYGEL_VIDEO_ITEM_UPNP_CLASS "object.item.videoItem"
#define RYGEL_AUDIO_ITEM_UPNP_CLASS "object.item.audioItem"
#define RYGEL_MUSIC_ITEM_UPNP_CLASS "object.item.audioItem.musicTrack"
#define RYGEL_MEDIA_CONTAINER_UPNP_CLASS "object.container"
#define RYGEL_MEDIA_CONTAINER_STORAGE_FOLDER RYGEL_MEDIA_CONTAINER_UPNP_CLASS ".storageFolder"
#define RYGEL_MEDIA_CONTAINER_PLAYLIST RYGEL_MEDIA_CONTAINER_UPNP_CLASS ".playlistContainer"
RygelImageItem* rygel_image_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelImageItem* rygel_image_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelPhotoItem* rygel_photo_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelPhotoItem* rygel_photo_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_photo_item_get_type (void) G_GNUC_CONST;
RygelVideoItem* rygel_video_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelVideoItem* rygel_video_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelAudioItem* rygel_audio_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelAudioItem* rygel_audio_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMusicItem* rygel_music_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelMusicItem* rygel_music_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_music_item_get_type (void) G_GNUC_CONST;
RygelPlaylistItem* rygel_playlist_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelPlaylistItem* rygel_playlist_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
GType rygel_playlist_item_get_type (void) G_GNUC_CONST;
void rygel_media_object_set_upnp_class (RygelMediaObject* self, const gchar* value);
static void _vala_SoupURI_free (SoupURI* self);
static gchar* rygel_object_creator_mangle_title (RygelObjectCreator* self, const gchar* title, GError** error);
static void rygel_object_creator_create_uri_data_free (gpointer _data);
static gboolean rygel_object_creator_create_uri_co (RygelObjectCreatorCreateUriData* _data_);
void rygel_media_object_get_writable (RygelMediaObject* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GFile* rygel_media_object_get_writable_finish (RygelMediaObject* self, GAsyncResult* _res_, GError** error);
static void rygel_object_creator_create_uri_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_object_creator_wait_for_object_data_free (gpointer _data);
static gboolean rygel_object_creator_wait_for_object_co (RygelObjectCreatorWaitForObjectData* _data_);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void rygel_object_creator_wait_for_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void ____lambda13_ (Block9Data* _data9_, RygelMediaContainer* container);
GType rygel_object_event_type_get_type (void) G_GNUC_CONST;
static void _____lambda13__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update, gpointer self);
static gboolean ____lambda14_ (Block9Data* _data9_);
static gboolean _____lambda14__gsource_func (gpointer self);
GType rygel_media_server_plugin_get_type (void) G_GNUC_CONST;
GList* rygel_media_server_plugin_get_upload_profiles (RygelMediaServerPlugin* self);
static gint _rygel_dlna_profile_compare_by_name_gcompare_func (gconstpointer a, gconstpointer b);
static void rygel_object_creator_finalize (GObject* obj);
static void _vala_rygel_object_creator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_object_creator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * Create a media container with the specified details.
     *
     * @param id See the id property of the #RygelMediaObject class.
     * @param parent The parent container, if any.
     * @param title See the title property of the #RygelMediaObject class.
     * @param child_count The initially-known number of child items.
     */
RygelBaseMediaContainer* rygel_base_media_container_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, gint child_count) {
	RygelBaseMediaContainer * self = NULL;
	const gchar* _tmp0_ = NULL;
	RygelMediaContainer* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp0_ = id;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp1_ = parent;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp2_ = title;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp3_ = child_count;
#line 44 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	self = (RygelBaseMediaContainer*) g_object_new (object_type, "id", _tmp0_, "parent", _tmp1_, "title", _tmp2_, "child-count", _tmp3_, NULL);
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	return self;
#line 1180 "rygel-object-creator.c"
}


RygelBaseMediaContainer* rygel_base_media_container_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, gint child_count) {
#line 40 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	return rygel_base_media_container_construct (RYGEL_TYPE_BASE_MEDIA_CONTAINER, id, parent, title, child_count);
#line 1187 "rygel-object-creator.c"
}


static void rygel_base_media_container_real_get_children_data_free (gpointer _data) {
	RygelBaseMediaContainerGetChildrenData* _data_;
	_data_ = _data;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_free0 (_data_->sort_criteria);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (_data_->cancellable);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (_data_->result);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (_data_->self);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_slice_free (RygelBaseMediaContainerGetChildrenData, _data_);
#line 1204 "rygel-object-creator.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	return self ? g_object_ref (self) : NULL;
#line 1211 "rygel-object-creator.c"
}


static void rygel_base_media_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelBaseMediaContainer * self;
	RygelBaseMediaContainerGetChildrenData* _data_;
	RygelBaseMediaContainer* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GCancellable* _tmp5_ = NULL;
	GCancellable* _tmp6_ = NULL;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	self = (RygelBaseMediaContainer*) base;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_ = g_slice_new0 (RygelBaseMediaContainerGetChildrenData);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_base_media_container_real_get_children);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_base_media_container_real_get_children_data_free);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->self = _tmp0_;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp1_ = offset;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->offset = _tmp1_;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp2_ = max_count;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->max_count = _tmp2_;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp3_ = sort_criteria;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_free0 (_data_->sort_criteria);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->sort_criteria = _tmp4_;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp5_ = cancellable;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (_data_->cancellable);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->cancellable = _tmp6_;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	rygel_base_media_container_real_get_children_co (_data_);
#line 1263 "rygel-object-creator.c"
}


static RygelMediaObjects* rygel_base_media_container_real_get_children_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObjects* result;
	RygelBaseMediaContainerGetChildrenData* _data_;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return NULL;
#line 1274 "rygel-object-creator.c"
	}
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	result = _data_->result;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->result = NULL;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	return result;
#line 1284 "rygel-object-creator.c"
}


/**
     * Fetches the list of media objects directly under this container.
     *
     * @param offset zero-based index of the first item to return
     * @param max_count maximum number of objects to return
     * @param sort_criteria sorting order of objects to return
     * @param cancellable optional cancellable for this operation
     *
     * @return A list of media objects.
     */
static gboolean rygel_base_media_container_real_get_children_co (RygelBaseMediaContainerGetChildrenData* _data_) {
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	switch (_data_->_state_) {
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		case 0:
#line 1303 "rygel-object-creator.c"
		goto _state_0;
		default:
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_assert_not_reached ();
#line 1308 "rygel-object-creator.c"
	}
	_state_0:
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->result = NULL;
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_data_->_state_ == 0) {
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1317 "rygel-object-creator.c"
	} else {
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1321 "rygel-object-creator.c"
	}
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_object_unref (_data_->_async_result);
#line 66 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	return FALSE;
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_data_->_state_ == 0) {
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1331 "rygel-object-creator.c"
	} else {
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1335 "rygel-object-creator.c"
	}
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_object_unref (_data_->_async_result);
#line 60 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	return FALSE;
#line 1341 "rygel-object-creator.c"
}


static void rygel_base_media_container_real_find_object_data_free (gpointer _data) {
	RygelBaseMediaContainerFindObjectData* _data_;
	_data_ = _data;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_free0 (_data_->id);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (_data_->cancellable);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (_data_->result);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (_data_->self);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_slice_free (RygelBaseMediaContainerFindObjectData, _data_);
#line 1358 "rygel-object-creator.c"
}


static void rygel_base_media_container_real_find_object (RygelMediaContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelBaseMediaContainer * self;
	RygelBaseMediaContainerFindObjectData* _data_;
	RygelBaseMediaContainer* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	self = (RygelBaseMediaContainer*) base;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_ = g_slice_new0 (RygelBaseMediaContainerFindObjectData);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_base_media_container_real_find_object);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_base_media_container_real_find_object_data_free);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->self = _tmp0_;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp1_ = id;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_free0 (_data_->id);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->id = _tmp2_;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp3_ = cancellable;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (_data_->cancellable);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->cancellable = _tmp4_;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	rygel_base_media_container_real_find_object_co (_data_);
#line 1400 "rygel-object-creator.c"
}


static RygelMediaObject* rygel_base_media_container_real_find_object_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelBaseMediaContainerFindObjectData* _data_;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return NULL;
#line 1411 "rygel-object-creator.c"
	}
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	result = _data_->result;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->result = NULL;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	return result;
#line 1421 "rygel-object-creator.c"
}


/**
     * Recursively searches this container for a media object with the given ID.
     *
     * @param id ID of the media object to search for
     * @param cancellable optional cancellable for this operation
     *
     * @return the found media object.
     */
static gboolean rygel_base_media_container_real_find_object_co (RygelBaseMediaContainerFindObjectData* _data_) {
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	switch (_data_->_state_) {
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		case 0:
#line 1438 "rygel-object-creator.c"
		goto _state_0;
		default:
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_assert_not_reached ();
#line 1443 "rygel-object-creator.c"
	}
	_state_0:
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->result = NULL;
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_data_->_state_ == 0) {
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1452 "rygel-object-creator.c"
	} else {
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1456 "rygel-object-creator.c"
	}
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_object_unref (_data_->_async_result);
#line 80 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	return FALSE;
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_data_->_state_ == 0) {
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1466 "rygel-object-creator.c"
	} else {
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1470 "rygel-object-creator.c"
	}
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_object_unref (_data_->_async_result);
#line 77 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	return FALSE;
#line 1476 "rygel-object-creator.c"
}


static void rygel_base_media_container_class_init (RygelBaseMediaContainerClass * klass) {
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	rygel_base_media_container_parent_class = g_type_class_peek_parent (klass);
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	((RygelMediaContainerClass *) klass)->get_children = rygel_base_media_container_real_get_children;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	((RygelMediaContainerClass *) klass)->get_children_finish = rygel_base_media_container_real_get_children_finish;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	((RygelMediaContainerClass *) klass)->find_object = rygel_base_media_container_real_find_object;
#line 31 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	((RygelMediaContainerClass *) klass)->find_object_finish = rygel_base_media_container_real_find_object_finish;
#line 1491 "rygel-object-creator.c"
}


static void rygel_base_media_container_instance_init (RygelBaseMediaContainer * self) {
}


/**
 * Dummy implementation of Rygel.MediaContainer to pass on to
 * Rygel.WritableContianer for creation.
 */
GType rygel_base_media_container_get_type (void) {
	static volatile gsize rygel_base_media_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_base_media_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelBaseMediaContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_base_media_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelBaseMediaContainer), 0, (GInstanceInitFunc) rygel_base_media_container_instance_init, NULL };
		GType rygel_base_media_container_type_id;
		rygel_base_media_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_CONTAINER, "RygelBaseMediaContainer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_base_media_container_type_id__volatile, rygel_base_media_container_type_id);
	}
	return rygel_base_media_container_type_id__volatile;
}


static void _vala_GUPnPServiceAction_free (GUPnPServiceAction* self) {
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_boxed_free (gupnp_service_action_get_type (), self);
#line 1518 "rygel-object-creator.c"
}


RygelObjectCreator* rygel_object_creator_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
	RygelObjectCreator * self = NULL;
	RygelContentDirectory* _tmp0_ = NULL;
	RygelContentDirectory* _tmp1_ = NULL;
	RygelContentDirectory* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GUPnPServiceAction* _tmp4_ = NULL;
	RygelSerializer* _tmp5_ = NULL;
	GUPnPDIDLLiteParser* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_return_val_if_fail (content_dir != NULL, NULL);
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_return_val_if_fail (action != NULL, NULL);
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	self = (RygelObjectCreator*) g_object_new (object_type, NULL);
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp0_ = content_dir;
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (self->priv->content_dir);
#line 111 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	self->priv->content_dir = _tmp1_;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp2_ = content_dir;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp3_ = _tmp2_->cancellable;
#line 112 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp3_);
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp4_ = action;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	action = NULL;
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	__vala_GUPnPServiceAction_free0 (self->priv->action);
#line 113 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	self->priv->action = _tmp4_;
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp5_ = rygel_serializer_new (RYGEL_SERIALIZER_TYPE_GENERIC_DIDL);
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (self->priv->serializer);
#line 114 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	self->priv->serializer = _tmp5_;
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp6_ = gupnp_didl_lite_parser_new ();
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (self->priv->didl_parser);
#line 115 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	self->priv->didl_parser = _tmp6_;
#line 1572 "rygel-object-creator.c"
	{
		gchar* pattern = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		GRegex* _tmp13_ = NULL;
		GRegex* _tmp14_ = NULL;
		GRegex* _tmp15_ = NULL;
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp7_ = g_regex_escape_string (RYGEL_OBJECT_CREATOR_INVALID_CHARS, -1);
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp8_ = _tmp7_;
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp9_ = g_strconcat ("[", _tmp8_, NULL);
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp10_ = _tmp9_;
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp11_ = g_strconcat (_tmp10_, "]", NULL);
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp12_ = _tmp11_;
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_free0 (_tmp10_);
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_free0 (_tmp8_);
#line 117 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		pattern = _tmp12_;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp14_ = g_regex_new (pattern, G_REGEX_OPTIMIZE, G_REGEX_MATCH_NOTEMPTY, &_inner_error_);
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp13_ = _tmp14_;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_g_free0 (pattern);
#line 1610 "rygel-object-creator.c"
			goto __catch59_g_error;
		}
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp15_ = _tmp13_;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp13_ = NULL;
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_regex_unref0 (self->priv->title_regex);
#line 118 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		self->priv->title_regex = _tmp15_;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_regex_unref0 (_tmp13_);
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_free0 (pattern);
#line 1625 "rygel-object-creator.c"
	}
	goto __finally59;
	__catch59_g_error:
	{
		GError* _error_ = NULL;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_error_ = _inner_error_;
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_inner_error_ = NULL;
#line 121 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_assert_not_reached ();
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_error_free0 (_error_);
#line 1639 "rygel-object-creator.c"
	}
	__finally59:
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		__vala_GUPnPServiceAction_free0 (action);
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_clear_error (&_inner_error_);
#line 116 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return NULL;
#line 1652 "rygel-object-creator.c"
	}
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	__vala_GUPnPServiceAction_free0 (action);
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	return self;
#line 1658 "rygel-object-creator.c"
}


RygelObjectCreator* rygel_object_creator_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
#line 109 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	return rygel_object_creator_construct (RYGEL_TYPE_OBJECT_CREATOR, content_dir, action);
#line 1665 "rygel-object-creator.c"
}


static void rygel_object_creator_real_run_data_free (gpointer _data) {
	RygelObjectCreatorRunData* _data_;
	_data_ = _data;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (_data_->self);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_slice_free (RygelObjectCreatorRunData, _data_);
#line 1676 "rygel-object-creator.c"
}


static void rygel_object_creator_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelObjectCreator * self;
	RygelObjectCreatorRunData* _data_;
	RygelObjectCreator* _tmp0_ = NULL;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	self = (RygelObjectCreator*) base;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_ = g_slice_new0 (RygelObjectCreatorRunData);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_object_creator_real_run);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_object_creator_real_run_data_free);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->self = _tmp0_;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	rygel_object_creator_real_run_co (_data_);
#line 1698 "rygel-object-creator.c"
}


static void rygel_object_creator_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelObjectCreatorRunData* _data_;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1706 "rygel-object-creator.c"
}


static void rygel_object_creator_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelObjectCreatorRunData* _data_;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_ = _user_data_;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_source_object_ = source_object;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_res_ = _res_;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	rygel_object_creator_real_run_co (_data_);
#line 1720 "rygel-object-creator.c"
}


static gboolean rygel_object_creator_real_run_co (RygelObjectCreatorRunData* _data_) {
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	switch (_data_->_state_) {
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		case 0:
#line 1729 "rygel-object-creator.c"
		goto _state_0;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		case 1:
#line 1733 "rygel-object-creator.c"
		goto _state_1;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		case 2:
#line 1737 "rygel-object-creator.c"
		goto _state_2;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		case 3:
#line 1741 "rygel-object-creator.c"
		goto _state_3;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		case 4:
#line 1745 "rygel-object-creator.c"
		goto _state_4;
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		case 5:
#line 1749 "rygel-object-creator.c"
		goto _state_5;
		default:
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_assert_not_reached ();
#line 1754 "rygel-object-creator.c"
	}
	_state_0:
	{
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		rygel_object_creator_parse_args (_data_->self, &_data_->_inner_error_);
#line 126 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 1762 "rygel-object-creator.c"
			goto __catch60_g_error;
		}
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		rygel_object_creator_parse_didl (_data_->self, &_data_->_inner_error_);
#line 127 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 1769 "rygel-object-creator.c"
			goto __catch60_g_error;
		}
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_state_ = 1;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		rygel_object_creator_fetch_container (_data_->self, rygel_object_creator_run_ready, _data_);
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return FALSE;
#line 1778 "rygel-object-creator.c"
		_state_1:
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp0_ = NULL;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp0_ = rygel_object_creator_fetch_container_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->container = _data_->_tmp0_;
#line 129 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 1788 "rygel-object-creator.c"
			goto __catch60_g_error;
		}
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp2_ = NULL;
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp2_ = _data_->container;
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp3_ = NULL;
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp3_ = _data_->self->priv->didl_object;
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp4_ = NULL;
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp4_ = gupnp_didl_lite_object_get_upnp_class (_data_->_tmp3_);
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp5_ = NULL;
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp5_ = _data_->_tmp4_;
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp6_ = FALSE;
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp6_ = rygel_writable_container_can_create (_data_->_tmp2_, _data_->_tmp5_);
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (!_data_->_tmp6_) {
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp7_ = NULL;
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp7_ = _data_->self->priv->container_id;
#line 139 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp1_ = g_strcmp0 (_data_->_tmp7_, RYGEL_MEDIA_CONTAINER_ANY) != 0;
#line 1819 "rygel-object-creator.c"
		} else {
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp1_ = FALSE;
#line 1823 "rygel-object-creator.c"
		}
#line 138 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (_data_->_tmp1_) {
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp8_ = NULL;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp8_ = _data_->self->priv->didl_object;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp9_ = NULL;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp9_ = gupnp_didl_lite_object_get_upnp_class (_data_->_tmp8_);
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp10_ = NULL;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp10_ = _data_->_tmp9_;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp11_ = NULL;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp11_ = _data_->container;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp12_ = NULL;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp12_ = rygel_media_object_get_id ((RygelMediaObject*) _data_->_tmp11_);
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp13_ = NULL;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp13_ = _data_->_tmp12_;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp14_ = NULL;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp14_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "Creating of objects with class %s " "is not supported in %s", _data_->_tmp10_, _data_->_tmp13_);
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_inner_error_ = _data_->_tmp14_;
#line 140 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_g_object_unref0 (_data_->container);
#line 1859 "rygel-object-creator.c"
			goto __catch60_g_error;
		}
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp16_ = NULL;
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp16_ = _data_->self->priv->didl_object;
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp16_, gupnp_didl_lite_container_get_type ())) {
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp17_ = NULL;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp17_ = _data_->container;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp18_ = FALSE;
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp18_ = rygel_object_creator_validate_create_class (_data_->self, _data_->_tmp17_);
#line 148 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp15_ = !_data_->_tmp18_;
#line 1878 "rygel-object-creator.c"
		} else {
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp15_ = FALSE;
#line 1882 "rygel-object-creator.c"
		}
#line 147 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (_data_->_tmp15_) {
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp19_ = NULL;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp19_ = _ ("upnp:createClass value not supported");
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp20_ = NULL;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp20_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _data_->_tmp19_);
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_inner_error_ = _data_->_tmp20_;
#line 149 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_g_object_unref0 (_data_->container);
#line 1898 "rygel-object-creator.c"
			goto __catch60_g_error;
		}
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp21_ = NULL;
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp21_ = _data_->container;
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_state_ = 2;
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		rygel_object_creator_create_object_from_didl (_data_->self, _data_->_tmp21_, rygel_object_creator_run_ready, _data_);
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return FALSE;
#line 1911 "rygel-object-creator.c"
		_state_2:
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		rygel_object_creator_create_object_from_didl_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 153 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_g_object_unref0 (_data_->container);
#line 1919 "rygel-object-creator.c"
			goto __catch60_g_error;
		}
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp22_ = NULL;
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp22_ = _data_->self->priv->object;
#line 154 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp22_, RYGEL_TYPE_MEDIA_FILE_ITEM)) {
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp23_ = NULL;
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp23_ = _data_->container;
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp24_ = NULL;
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp24_ = _data_->self->priv->object;
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp25_ = NULL;
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp25_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp26_ = NULL;
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp26_ = _data_->_tmp25_;
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_state_ = 3;
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			rygel_writable_container_add_item (_data_->_tmp23_, G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp24_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _data_->_tmp24_) : NULL, _data_->_tmp26_, rygel_object_creator_run_ready, _data_);
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			return FALSE;
#line 1950 "rygel-object-creator.c"
			_state_3:
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			rygel_writable_container_add_item_finish (_data_->_tmp23_, _data_->_res_, &_data_->_inner_error_);
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 155 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_g_object_unref0 (_data_->container);
#line 1958 "rygel-object-creator.c"
				goto __catch60_g_error;
			}
		} else {
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp27_ = NULL;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp27_ = _data_->container;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp28_ = NULL;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp28_ = _data_->self->priv->object;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp29_ = NULL;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp29_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp30_ = NULL;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp30_ = _data_->_tmp29_;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_state_ = 4;
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			rygel_writable_container_add_container (_data_->_tmp27_, G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp28_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _data_->_tmp28_) : NULL, _data_->_tmp30_, rygel_object_creator_run_ready, _data_);
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			return FALSE;
#line 1984 "rygel-object-creator.c"
			_state_4:
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			rygel_writable_container_add_container_finish (_data_->_tmp27_, _data_->_res_, &_data_->_inner_error_);
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 158 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_g_object_unref0 (_data_->container);
#line 1992 "rygel-object-creator.c"
				goto __catch60_g_error;
			}
		}
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp31_ = NULL;
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp31_ = _data_->container;
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_state_ = 5;
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		rygel_object_creator_wait_for_object (_data_->self, _data_->_tmp31_, rygel_object_creator_run_ready, _data_);
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return FALSE;
#line 2006 "rygel-object-creator.c"
		_state_5:
#line 162 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		rygel_object_creator_wait_for_object_finish (_data_->self, _data_->_res_);
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp32_ = NULL;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp32_ = _data_->self->priv->object;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp33_ = NULL;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp33_ = _data_->self->priv->serializer;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp34_ = NULL;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp34_ = _data_->self->priv->content_dir;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp35_ = NULL;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp35_ = _data_->_tmp34_->http_server;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp36_ = NULL;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp36_ = rygel_media_object_serialize (_data_->_tmp32_, _data_->_tmp33_, _data_->_tmp35_, &_data_->_inner_error_);
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp37_ = NULL;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp37_ = _data_->_tmp36_;
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_object_unref0 (_data_->_tmp37_);
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 164 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_g_object_unref0 (_data_->container);
#line 2040 "rygel-object-creator.c"
			goto __catch60_g_error;
		}
#line 167 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		rygel_object_creator_conclude (_data_->self);
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp39_ = NULL;
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp39_ = _data_->self->priv->container_id;
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (g_strcmp0 (_data_->_tmp39_, RYGEL_MEDIA_CONTAINER_ANY) == 0) {
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp41_ = NULL;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp41_ = _data_->self->priv->object;
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp41_, RYGEL_TYPE_MEDIA_FILE_ITEM)) {
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_data_->_tmp42_ = NULL;
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_data_->_tmp42_ = _data_->self->priv->object;
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_data_->_tmp43_ = FALSE;
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_data_->_tmp43_ = rygel_media_file_item_get_place_holder (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp42_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _data_->_tmp42_) : NULL);
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_data_->_tmp44_ = FALSE;
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_data_->_tmp44_ = _data_->_tmp43_;
#line 171 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_data_->_tmp40_ = _data_->_tmp44_;
#line 2071 "rygel-object-creator.c"
			} else {
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_data_->_tmp40_ = FALSE;
#line 2075 "rygel-object-creator.c"
			}
#line 170 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp38_ = _data_->_tmp40_;
#line 2079 "rygel-object-creator.c"
		} else {
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp38_ = FALSE;
#line 2083 "rygel-object-creator.c"
		}
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (_data_->_tmp38_) {
#line 172 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp45_ = NULL;
#line 172 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp45_ = rygel_object_removal_queue_get_default ();
#line 172 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->queue = _data_->_tmp45_;
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp46_ = NULL;
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp46_ = _data_->queue;
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp47_ = NULL;
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp47_ = _data_->self->priv->object;
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp48_ = NULL;
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp48_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp49_ = NULL;
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp49_ = _data_->_tmp48_;
#line 174 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			rygel_object_removal_queue_queue (_data_->_tmp46_, _data_->_tmp47_, _data_->_tmp49_);
#line 169 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_g_object_unref0 (_data_->queue);
#line 2113 "rygel-object-creator.c"
		}
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_object_unref0 (_data_->container);
#line 2117 "rygel-object-creator.c"
	}
	goto __finally60;
	__catch60_g_error:
	{
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->err = _data_->_inner_error_;
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_inner_error_ = NULL;
#line 177 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp50_ = NULL;
#line 177 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp50_ = _data_->err;
#line 177 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		rygel_object_creator_handle_error (_data_->self, _data_->_tmp50_);
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_error_free0 (_data_->err);
#line 2134 "rygel-object-creator.c"
	}
	__finally60:
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_clear_error (&_data_->_inner_error_);
#line 125 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return FALSE;
#line 2145 "rygel-object-creator.c"
	}
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_data_->_state_ == 0) {
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2151 "rygel-object-creator.c"
	} else {
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2155 "rygel-object-creator.c"
	}
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_object_unref (_data_->_async_result);
#line 124 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	return FALSE;
#line 2161 "rygel-object-creator.c"
}


/**
     * Check the supplied input parameters.
     */
static void rygel_object_creator_parse_args (RygelObjectCreator* self, GError** error) {
	GUPnPServiceAction* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
#line 184 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_return_if_fail (self != NULL);
#line 186 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp0_ = self->priv->action;
#line 186 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	gupnp_service_action_get (_tmp0_, "ContainerID", G_TYPE_STRING, &self->priv->container_id, "Elements", G_TYPE_STRING, &self->priv->elements, NULL);
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp1_ = self->priv->elements;
#line 189 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_tmp1_ == NULL) {
#line 2183 "rygel-object-creator.c"
		const gchar* _tmp2_ = NULL;
		GError* _tmp3_ = NULL;
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp2_ = _ ("'Elements' argument missing.");
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp3_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _tmp2_);
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_inner_error_ = _tmp3_;
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_propagate_error (error, _inner_error_);
#line 190 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return;
#line 2196 "rygel-object-creator.c"
	} else {
		GPatternSpec* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp4_ = rygel_object_creator_comment_pattern;
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp5_ = self->priv->elements;
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp6_ = g_pattern_match_string (_tmp4_, _tmp5_);
#line 192 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (_tmp6_) {
#line 2209 "rygel-object-creator.c"
			const gchar* _tmp7_ = NULL;
			GError* _tmp8_ = NULL;
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_tmp7_ = _ ("Comments not allowed in XML");
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_tmp8_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _tmp7_);
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_inner_error_ = _tmp8_;
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_propagate_error (error, _inner_error_);
#line 193 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			return;
#line 2222 "rygel-object-creator.c"
		}
	}
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp9_ = self->priv->container_id;
#line 197 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_tmp9_ == NULL) {
#line 2229 "rygel-object-creator.c"
		const gchar* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
#line 199 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp10_ = _ ("Missing ContainerID argument");
#line 199 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp11_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS, _tmp10_);
#line 199 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_inner_error_ = _tmp11_;
#line 199 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_propagate_error (error, _inner_error_);
#line 199 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return;
#line 2242 "rygel-object-creator.c"
	}
}


/**
     * Parse the given DIDL-Lite snippet.
     *
     * Parses the DIDL-Lite and performs checking of the passed meta-data
     * according to UPnP and DLNA guidelines.
     */
static void __lambda12_ (RygelObjectCreator* self, GUPnPDIDLLiteObject* didl_object) {
	GUPnPDIDLLiteObject* _tmp0_ = NULL;
	GUPnPDIDLLiteObject* _tmp1_ = NULL;
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_return_if_fail (didl_object != NULL);
#line 214 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp0_ = didl_object;
#line 214 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 214 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (self->priv->didl_object);
#line 214 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	self->priv->didl_object = _tmp1_;
#line 2266 "rygel-object-creator.c"
}


static void ___lambda12__gupnp_didl_lite_parser_object_available (GUPnPDIDLLiteParser* _sender, GUPnPDIDLLiteObject* object, gpointer self) {
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	__lambda12_ ((RygelObjectCreator*) self, object);
#line 2273 "rygel-object-creator.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 264 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 2280 "rygel-object-creator.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 264 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 264 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_list_free (self);
#line 2289 "rygel-object-creator.c"
}


static void rygel_object_creator_parse_didl (RygelObjectCreator* self, GError** error) {
	GUPnPDIDLLiteParser* _tmp0_ = NULL;
	GUPnPDIDLLiteObject* _tmp4_ = NULL;
	gboolean _tmp10_ = FALSE;
	GUPnPDIDLLiteObject* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	GUPnPDIDLLiteObject* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	gboolean _tmp28_ = FALSE;
	GUPnPDIDLLiteObject* _tmp29_ = NULL;
	gboolean _tmp37_ = FALSE;
	gboolean _tmp38_ = FALSE;
	GUPnPDIDLLiteObject* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	const gchar* _tmp41_ = NULL;
	GUPnPDIDLLiteObject* _tmp51_ = NULL;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_ = FALSE;
	GUPnPDIDLLiteObject* _tmp56_ = NULL;
	const gchar* _tmp57_ = NULL;
	const gchar* _tmp58_ = NULL;
	GError * _inner_error_ = NULL;
#line 210 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_return_if_fail (self != NULL);
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp0_ = self->priv->didl_parser;
#line 213 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_signal_connect_object (_tmp0_, "object-available", (GCallback) ___lambda12__gupnp_didl_lite_parser_object_available, self, 0);
#line 2323 "rygel-object-creator.c"
	{
		GUPnPDIDLLiteParser* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp1_ = self->priv->didl_parser;
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp2_ = self->priv->elements;
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		gupnp_didl_lite_parser_parse_didl (_tmp1_, _tmp2_, &_inner_error_);
#line 218 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2335 "rygel-object-creator.c"
			goto __catch61_g_error;
		}
	}
	goto __finally61;
	__catch61_g_error:
	{
		GError* parse_err = NULL;
		GError* _tmp3_ = NULL;
#line 217 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		parse_err = _inner_error_;
#line 217 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_inner_error_ = NULL;
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp3_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, "Bad metadata");
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_inner_error_ = _tmp3_;
#line 220 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_error_free0 (parse_err);
#line 2354 "rygel-object-creator.c"
		goto __finally61;
	}
	__finally61:
#line 217 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 217 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_propagate_error (error, _inner_error_);
#line 217 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return;
#line 2364 "rygel-object-creator.c"
	}
#line 223 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp4_ = self->priv->didl_object;
#line 223 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_tmp4_ == NULL) {
#line 2370 "rygel-object-creator.c"
		gchar* message = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		GError* _tmp9_ = NULL;
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp5_ = _ ("No objects in DIDL-Lite from client: '%s'");
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp6_ = g_strdup (_tmp5_);
#line 224 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		message = _tmp6_;
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp7_ = message;
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp8_ = self->priv->elements;
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp9_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _tmp7_, _tmp8_);
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_inner_error_ = _tmp9_;
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_propagate_error (error, _inner_error_);
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_free0 (message);
#line 226 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return;
#line 2397 "rygel-object-creator.c"
	}
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp11_ = self->priv->didl_object;
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp12_ = gupnp_didl_lite_object_get_id (_tmp11_);
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp13_ = _tmp12_;
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_tmp13_ == NULL) {
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp10_ = TRUE;
#line 2409 "rygel-object-creator.c"
	} else {
		GUPnPDIDLLiteObject* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp14_ = self->priv->didl_object;
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp15_ = gupnp_didl_lite_object_get_id (_tmp14_);
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp16_ = _tmp15_;
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp10_ = g_strcmp0 (_tmp16_, "") != 0;
#line 2422 "rygel-object-creator.c"
	}
#line 230 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_tmp10_) {
#line 2426 "rygel-object-creator.c"
		gchar* msg = NULL;
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		GError* _tmp20_ = NULL;
#line 231 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp17_ = _ ("@id must be set to \"\" in CreateObject call");
#line 231 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp18_ = g_strdup (_tmp17_);
#line 231 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		msg = _tmp18_;
#line 232 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp19_ = msg;
#line 232 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp20_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _tmp19_);
#line 232 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_inner_error_ = _tmp20_;
#line 232 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_propagate_error (error, _inner_error_);
#line 232 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_free0 (msg);
#line 232 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return;
#line 2450 "rygel-object-creator.c"
	}
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp21_ = self->priv->didl_object;
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp22_ = gupnp_didl_lite_object_get_title (_tmp21_);
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp23_ = _tmp22_;
#line 235 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_tmp23_ == NULL) {
#line 2460 "rygel-object-creator.c"
		gchar* msg = NULL;
		const gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		GError* _tmp27_ = NULL;
#line 236 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp24_ = _ ("dc:title must not be empty in CreateObject call");
#line 236 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp25_ = g_strdup (_tmp24_);
#line 236 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		msg = _tmp25_;
#line 237 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp26_ = msg;
#line 237 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp27_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _tmp26_);
#line 237 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_inner_error_ = _tmp27_;
#line 237 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_propagate_error (error, _inner_error_);
#line 237 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_free0 (msg);
#line 237 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return;
#line 2484 "rygel-object-creator.c"
	}
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp29_ = self->priv->didl_object;
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, gupnp_didl_lite_item_get_type ())) {
#line 2490 "rygel-object-creator.c"
		GUPnPDIDLLiteObject* _tmp30_ = NULL;
		GUPnPOCMFlags _tmp31_ = 0;
		GUPnPOCMFlags _tmp32_ = 0;
#line 243 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp30_ = self->priv->didl_object;
#line 243 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp31_ = gupnp_didl_lite_object_get_dlna_managed (_tmp30_);
#line 243 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp32_ = _tmp31_;
#line 243 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp28_ = (_tmp32_ & ((GUPNP_OCM_FLAGS_UPLOAD | GUPNP_OCM_FLAGS_CREATE_CONTAINER) | GUPNP_OCM_FLAGS_UPLOAD_DESTROYABLE)) != 0;
#line 2502 "rygel-object-creator.c"
	} else {
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp28_ = FALSE;
#line 2506 "rygel-object-creator.c"
	}
#line 242 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_tmp28_) {
#line 2510 "rygel-object-creator.c"
		gchar* msg = NULL;
		const gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		const gchar* _tmp35_ = NULL;
		GError* _tmp36_ = NULL;
#line 247 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp33_ = _ ("Flags that must not be set were found in 'dlnaManaged'");
#line 247 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp34_ = g_strdup (_tmp33_);
#line 247 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		msg = _tmp34_;
#line 248 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp35_ = msg;
#line 248 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp36_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _tmp35_);
#line 248 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_inner_error_ = _tmp36_;
#line 248 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_propagate_error (error, _inner_error_);
#line 248 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_free0 (msg);
#line 248 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return;
#line 2534 "rygel-object-creator.c"
	}
#line 251 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp39_ = self->priv->didl_object;
#line 251 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp40_ = gupnp_didl_lite_object_get_upnp_class (_tmp39_);
#line 251 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp41_ = _tmp40_;
#line 251 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_tmp41_ == NULL) {
#line 251 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp38_ = TRUE;
#line 2546 "rygel-object-creator.c"
	} else {
		GUPnPDIDLLiteObject* _tmp42_ = NULL;
		const gchar* _tmp43_ = NULL;
		const gchar* _tmp44_ = NULL;
#line 252 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp42_ = self->priv->didl_object;
#line 252 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp43_ = gupnp_didl_lite_object_get_upnp_class (_tmp42_);
#line 252 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp44_ = _tmp43_;
#line 252 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp38_ = g_strcmp0 (_tmp44_, "") == 0;
#line 2559 "rygel-object-creator.c"
	}
#line 251 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_tmp38_) {
#line 251 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp37_ = TRUE;
#line 2565 "rygel-object-creator.c"
	} else {
		GUPnPDIDLLiteObject* _tmp45_ = NULL;
		const gchar* _tmp46_ = NULL;
		const gchar* _tmp47_ = NULL;
		gboolean _tmp48_ = FALSE;
#line 253 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp45_ = self->priv->didl_object;
#line 253 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp46_ = gupnp_didl_lite_object_get_upnp_class (_tmp45_);
#line 253 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp47_ = _tmp46_;
#line 253 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp48_ = g_str_has_prefix (_tmp47_, "object");
#line 253 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp37_ = !_tmp48_;
#line 2581 "rygel-object-creator.c"
	}
#line 251 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_tmp37_) {
#line 2585 "rygel-object-creator.c"
		const gchar* _tmp49_ = NULL;
		GError* _tmp50_ = NULL;
#line 254 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp49_ = _ ("Invalid upnp:class given in CreateObject");
#line 254 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp50_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _tmp49_);
#line 254 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_inner_error_ = _tmp50_;
#line 254 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_propagate_error (error, _inner_error_);
#line 254 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return;
#line 2598 "rygel-object-creator.c"
	}
#line 258 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp51_ = self->priv->didl_object;
#line 258 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp52_ = gupnp_didl_lite_object_get_restricted (_tmp51_);
#line 258 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp53_ = _tmp52_;
#line 258 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_tmp53_) {
#line 2608 "rygel-object-creator.c"
		const gchar* _tmp54_ = NULL;
		GError* _tmp55_ = NULL;
#line 259 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp54_ = _ ("Cannot create restricted item");
#line 259 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp55_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _tmp54_);
#line 259 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_inner_error_ = _tmp55_;
#line 259 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_propagate_error (error, _inner_error_);
#line 259 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return;
#line 2621 "rygel-object-creator.c"
	}
#line 264 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp56_ = self->priv->didl_object;
#line 264 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp57_ = gupnp_didl_lite_object_get_upnp_class (_tmp56_);
#line 264 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp58_ = _tmp57_;
#line 264 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (g_strcmp0 (_tmp58_, "object.item") == 0) {
#line 2631 "rygel-object-creator.c"
		GList* resources = NULL;
		GUPnPDIDLLiteObject* _tmp59_ = NULL;
		GList* _tmp60_ = NULL;
		gboolean _tmp61_ = FALSE;
		GList* _tmp62_ = NULL;
#line 265 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp59_ = self->priv->didl_object;
#line 265 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp60_ = gupnp_didl_lite_object_get_resources (_tmp59_);
#line 265 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		resources = _tmp60_;
#line 266 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp62_ = resources;
#line 266 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (_tmp62_ != NULL) {
#line 2647 "rygel-object-creator.c"
			GList* _tmp63_ = NULL;
			gconstpointer _tmp64_ = NULL;
			GUPnPProtocolInfo* _tmp65_ = NULL;
			GUPnPProtocolInfo* _tmp66_ = NULL;
			const gchar* _tmp67_ = NULL;
			const gchar* _tmp68_ = NULL;
#line 267 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_tmp63_ = resources;
#line 267 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_tmp64_ = _tmp63_->data;
#line 267 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_tmp65_ = gupnp_didl_lite_resource_get_protocol_info ((GUPnPDIDLLiteResource*) _tmp64_);
#line 267 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_tmp66_ = _tmp65_;
#line 267 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_tmp67_ = gupnp_protocol_info_get_dlna_profile (_tmp66_);
#line 267 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_tmp68_ = _tmp67_;
#line 267 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_tmp61_ = g_strcmp0 (_tmp68_, "DIDL_S") == 0;
#line 2668 "rygel-object-creator.c"
		} else {
#line 266 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_tmp61_ = FALSE;
#line 2672 "rygel-object-creator.c"
		}
#line 266 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (_tmp61_) {
#line 2676 "rygel-object-creator.c"
			GUPnPDIDLLiteObject* _tmp69_ = NULL;
#line 268 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_tmp69_ = self->priv->didl_object;
#line 268 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			gupnp_didl_lite_object_set_upnp_class (_tmp69_, RYGEL_PLAYLIST_ITEM_UPNP_CLASS);
#line 2682 "rygel-object-creator.c"
		}
#line 264 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		__g_list_free__g_object_unref0_0 (resources);
#line 2686 "rygel-object-creator.c"
	}
}


/**
     * Modify the give UPnP class to be a more general one.
     *
     * Used to simplify the search for a valid container in the
     * DLNA.ORG_AnyContainer use-case.
     * Example: object.item.videoItem.videoBroadcast → object.item.videoItem
     *
     * @param upnp_class the current UPnP class which will be modified in-place.
     */
static void rygel_object_creator_generalize_upnp_class (RygelObjectCreator* self, gchar** upnp_class) {
	gchar* needle = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 282 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_return_if_fail (self != NULL);
#line 282 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_return_if_fail (*upnp_class != NULL);
#line 283 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp0_ = *upnp_class;
#line 283 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp1_ = g_strrstr_len (_tmp0_, (gssize) (-1), ".");
#line 283 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	needle = _tmp1_;
#line 284 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp2_ = needle;
#line 284 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_tmp2_ != NULL) {
#line 2719 "rygel-object-creator.c"
		gchar* _tmp3_ = NULL;
		gchar _tmp4_ = '\0';
#line 285 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp3_ = needle;
#line 285 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		*_tmp3_ = '\0';
#line 285 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp4_ = *_tmp3_;
#line 2728 "rygel-object-creator.c"
	}
}


static void rygel_object_creator_build_create_class_expression_data_free (gpointer _data) {
	RygelObjectCreatorBuildCreateClassExpressionData* _data_;
	_data_ = _data;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_rygel_search_expression_unref0 (_data_->result);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (_data_->self);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_slice_free (RygelObjectCreatorBuildCreateClassExpressionData, _data_);
#line 2744 "rygel-object-creator.c"
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	return self ? rygel_search_expression_ref (self) : NULL;
#line 2751 "rygel-object-creator.c"
}


static void rygel_object_creator_build_create_class_expression (RygelObjectCreator* self, RygelSearchExpression* expression, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelObjectCreatorBuildCreateClassExpressionData* _data_;
	RygelObjectCreator* _tmp0_ = NULL;
	RygelSearchExpression* _tmp1_ = NULL;
	RygelSearchExpression* _tmp2_ = NULL;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_ = g_slice_new0 (RygelObjectCreatorBuildCreateClassExpressionData);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_object_creator_build_create_class_expression);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_object_creator_build_create_class_expression_data_free);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->self = _tmp0_;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp1_ = expression;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp2_ = _rygel_search_expression_ref0 (_tmp1_);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->expression = _tmp2_;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	rygel_object_creator_build_create_class_expression_co (_data_);
#line 2780 "rygel-object-creator.c"
}


static RygelSearchExpression* rygel_object_creator_build_create_class_expression_finish (RygelObjectCreator* self, GAsyncResult* _res_) {
	RygelSearchExpression* result;
	RygelObjectCreatorBuildCreateClassExpressionData* _data_;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	result = _data_->result;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->result = NULL;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	return result;
#line 2795 "rygel-object-creator.c"
}


static void _g_free0_ (gpointer var) {
#line 299 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	var = (g_free (var), NULL);
#line 2802 "rygel-object-creator.c"
}


static void _g_list_free__g_free0_ (GList* self) {
#line 299 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
#line 299 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_list_free (self);
#line 2811 "rygel-object-creator.c"
}


static void rygel_object_creator_build_create_class_expression_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelObjectCreatorBuildCreateClassExpressionData* _data_;
#line 314 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_ = _user_data_;
#line 314 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_source_object_ = source_object;
#line 314 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_res_ = _res_;
#line 314 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	rygel_object_creator_build_create_class_expression_co (_data_);
#line 2825 "rygel-object-creator.c"
}


static gboolean rygel_object_creator_build_create_class_expression_co (RygelObjectCreatorBuildCreateClassExpressionData* _data_) {
#line 289 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	switch (_data_->_state_) {
#line 289 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		case 0:
#line 2834 "rygel-object-creator.c"
		goto _state_0;
#line 289 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		case 1:
#line 2838 "rygel-object-creator.c"
		goto _state_1;
		default:
#line 289 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_assert_not_reached ();
#line 2843 "rygel-object-creator.c"
	}
	_state_0:
#line 292 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp0_ = NULL;
#line 292 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp0_ = _data_->self->priv->didl_object;
#line 292 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp0_, gupnp_didl_lite_container_get_type ())) {
#line 293 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp1_ = NULL;
#line 293 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp1_ = _data_->expression;
#line 293 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp2_ = NULL;
#line 293 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp2_ = _rygel_search_expression_ref0 (_data_->_tmp1_);
#line 293 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->result = _data_->_tmp2_;
#line 293 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (_data_->_state_ == 0) {
#line 293 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2866 "rygel-object-creator.c"
		} else {
#line 293 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2870 "rygel-object-creator.c"
		}
#line 293 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_object_unref (_data_->_async_result);
#line 293 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return FALSE;
#line 2876 "rygel-object-creator.c"
	}
#line 296 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp3_ = NULL;
#line 296 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp3_ = _data_->self->priv->didl_object;
#line 296 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp4_ = NULL;
#line 296 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp3_, gupnp_didl_lite_container_get_type ()) ? ((GUPnPDIDLLiteContainer*) _data_->_tmp3_) : NULL);
#line 296 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->didl_container = _data_->_tmp4_;
#line 297 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp5_ = NULL;
#line 297 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp5_ = _data_->didl_container;
#line 297 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp6_ = NULL;
#line 297 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp6_ = gupnp_didl_lite_container_get_create_classes (_data_->_tmp5_);
#line 297 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->create_classes = _data_->_tmp6_;
#line 298 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp7_ = NULL;
#line 298 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp7_ = _data_->create_classes;
#line 298 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_data_->_tmp7_ == NULL) {
#line 299 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp8_ = NULL;
#line 299 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp8_ = _data_->expression;
#line 299 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp9_ = NULL;
#line 299 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp9_ = _rygel_search_expression_ref0 (_data_->_tmp8_);
#line 299 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->result = _data_->_tmp9_;
#line 299 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		__g_list_free__g_free0_0 (_data_->create_classes);
#line 299 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_object_unref0 (_data_->didl_container);
#line 299 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (_data_->_state_ == 0) {
#line 299 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2922 "rygel-object-creator.c"
		} else {
#line 299 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2926 "rygel-object-creator.c"
		}
#line 299 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_object_unref (_data_->_async_result);
#line 299 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return FALSE;
#line 2932 "rygel-object-creator.c"
	}
#line 302 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp10_ = NULL;
#line 302 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp10_ = g_string_new ("(");
#line 302 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->builder = _data_->_tmp10_;
#line 303 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp11_ = NULL;
#line 303 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp11_ = _data_->create_classes;
#line 2944 "rygel-object-creator.c"
	{
#line 303 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->create_class_collection = _data_->_tmp11_;
#line 303 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		for (_data_->create_class_it = _data_->create_class_collection; _data_->create_class_it != NULL; _data_->create_class_it = _data_->create_class_it->next) {
#line 303 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp12_ = NULL;
#line 303 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp12_ = g_strdup ((const gchar*) _data_->create_class_it->data);
#line 303 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->create_class = _data_->_tmp12_;
#line 2956 "rygel-object-creator.c"
			{
#line 304 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_data_->_tmp13_ = NULL;
#line 304 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_data_->_tmp13_ = _data_->builder;
#line 304 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_data_->_tmp14_ = NULL;
#line 304 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_data_->_tmp14_ = _data_->create_class;
#line 304 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				g_string_append_printf (_data_->_tmp13_, "(upnp:createClass derivedfrom \"%s\") AND", _data_->_tmp14_);
#line 303 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_g_free0 (_data_->create_class);
#line 2970 "rygel-object-creator.c"
			}
		}
	}
#line 309 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp15_ = NULL;
#line 309 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp15_ = _data_->builder;
#line 309 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp16_ = NULL;
#line 309 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp16_ = _data_->builder;
#line 309 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp17_ = 0L;
#line 309 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp17_ = _data_->_tmp16_->len;
#line 309 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_string_truncate (_data_->_tmp15_, (gsize) (_data_->_tmp17_ - 3));
#line 310 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp18_ = NULL;
#line 310 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp18_ = _data_->builder;
#line 310 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_string_append (_data_->_tmp18_, ")");
#line 2994 "rygel-object-creator.c"
	{
#line 313 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp19_ = NULL;
#line 313 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp19_ = _data_->builder;
#line 313 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp20_ = NULL;
#line 313 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp20_ = _data_->_tmp19_->str;
#line 313 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp21_ = NULL;
#line 313 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp21_ = rygel_search_criteria_parser_new (_data_->_tmp20_, &_data_->_inner_error_);
#line 313 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->parser = _data_->_tmp21_;
#line 313 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 3012 "rygel-object-creator.c"
			goto __catch62_g_error;
		}
#line 314 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp22_ = NULL;
#line 314 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp22_ = _data_->parser;
#line 314 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_state_ = 1;
#line 314 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		rygel_state_machine_run ((RygelStateMachine*) _data_->_tmp22_, rygel_object_creator_build_create_class_expression_ready, _data_);
#line 314 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return FALSE;
#line 3025 "rygel-object-creator.c"
		_state_1:
#line 314 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		rygel_state_machine_run_finish ((RygelStateMachine*) _data_->_tmp22_, _data_->_res_);
#line 316 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp23_ = NULL;
#line 316 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp23_ = rygel_logical_expression_new ();
#line 316 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->rel = _data_->_tmp23_;
#line 317 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp24_ = NULL;
#line 317 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp24_ = _data_->rel;
#line 317 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp25_ = NULL;
#line 317 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp25_ = _data_->expression;
#line 317 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp26_ = NULL;
#line 317 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp26_ = _rygel_search_expression_ref0 (_data_->_tmp25_);
#line 317 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_rygel_search_expression_unref0 (((RygelSearchExpression*) _data_->_tmp24_)->operand1);
#line 317 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		((RygelSearchExpression*) _data_->_tmp24_)->operand1 = _data_->_tmp26_;
#line 318 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp27_ = NULL;
#line 318 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp27_ = _data_->rel;
#line 318 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		((RygelSearchExpression*) _data_->_tmp27_)->op = (gpointer) ((gintptr) RYGEL_LOGICAL_OPERATOR_AND);
#line 319 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp28_ = NULL;
#line 319 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp28_ = _data_->rel;
#line 319 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp29_ = NULL;
#line 319 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp29_ = _data_->parser;
#line 319 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp30_ = NULL;
#line 319 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp30_ = _data_->_tmp29_->expression;
#line 319 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp31_ = NULL;
#line 319 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp31_ = _rygel_search_expression_ref0 (_data_->_tmp30_);
#line 319 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_rygel_search_expression_unref0 (((RygelSearchExpression*) _data_->_tmp28_)->operand2);
#line 319 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		((RygelSearchExpression*) _data_->_tmp28_)->operand2 = _data_->_tmp31_;
#line 321 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->result = (RygelSearchExpression*) _data_->rel;
#line 321 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_object_unref0 (_data_->parser);
#line 321 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_string_free0 (_data_->builder);
#line 321 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		__g_list_free__g_free0_0 (_data_->create_classes);
#line 321 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_object_unref0 (_data_->didl_container);
#line 321 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (_data_->_state_ == 0) {
#line 321 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3091 "rygel-object-creator.c"
		} else {
#line 321 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 3095 "rygel-object-creator.c"
		}
#line 321 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_object_unref (_data_->_async_result);
#line 321 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return FALSE;
#line 3101 "rygel-object-creator.c"
	}
	goto __finally62;
	__catch62_g_error:
	{
#line 312 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 312 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_inner_error_ = NULL;
#line 323 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_assert_not_reached ();
#line 312 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_error_free0 (_data_->_error_);
#line 3114 "rygel-object-creator.c"
	}
	__finally62:
#line 312 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_string_free0 (_data_->builder);
#line 312 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	__g_list_free__g_free0_0 (_data_->create_classes);
#line 312 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (_data_->didl_container);
#line 312 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 312 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_clear_error (&_data_->_inner_error_);
#line 312 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	return FALSE;
#line 289 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_string_free0 (_data_->builder);
#line 289 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	__g_list_free__g_free0_0 (_data_->create_classes);
#line 289 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (_data_->didl_container);
#line 289 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_data_->_state_ == 0) {
#line 289 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3139 "rygel-object-creator.c"
	} else {
#line 289 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 3143 "rygel-object-creator.c"
	}
#line 289 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_object_unref (_data_->_async_result);
#line 289 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	return FALSE;
#line 3149 "rygel-object-creator.c"
}


static void rygel_object_creator_find_any_container_data_free (gpointer _data) {
	RygelObjectCreatorFindAnyContainerData* _data_;
	_data_ = _data;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (_data_->result);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (_data_->self);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_slice_free (RygelObjectCreatorFindAnyContainerData, _data_);
#line 3162 "rygel-object-creator.c"
}


static void rygel_object_creator_find_any_container (RygelObjectCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelObjectCreatorFindAnyContainerData* _data_;
	RygelObjectCreator* _tmp0_ = NULL;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_ = g_slice_new0 (RygelObjectCreatorFindAnyContainerData);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_object_creator_find_any_container);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_object_creator_find_any_container_data_free);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->self = _tmp0_;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	rygel_object_creator_find_any_container_co (_data_);
#line 3181 "rygel-object-creator.c"
}


static RygelMediaObject* rygel_object_creator_find_any_container_finish (RygelObjectCreator* self, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelObjectCreatorFindAnyContainerData* _data_;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return NULL;
#line 3192 "rygel-object-creator.c"
	}
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	result = _data_->result;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->result = NULL;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	return result;
#line 3202 "rygel-object-creator.c"
}


/**
     * Find a container that can create items matching the UPnP class of the
     * requested item.
     *
     * If the item's UPnP class cannot be found, generalize the UPnP class until
     * we reach object.item according to DLNA guideline 7.3.120.4.
     *
     * @returns a container able to create the item or null if no such container
     *          can be found.
     */
static void rygel_object_creator_find_any_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelObjectCreatorFindAnyContainerData* _data_;
#line 353 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_ = _user_data_;
#line 353 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_source_object_ = source_object;
#line 353 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_res_ = _res_;
#line 353 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	rygel_object_creator_find_any_container_co (_data_);
#line 3226 "rygel-object-creator.c"
}


static gboolean rygel_object_creator_find_any_container_co (RygelObjectCreatorFindAnyContainerData* _data_) {
#line 337 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	switch (_data_->_state_) {
#line 337 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		case 0:
#line 3235 "rygel-object-creator.c"
		goto _state_0;
#line 337 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		case 1:
#line 3239 "rygel-object-creator.c"
		goto _state_1;
#line 337 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		case 2:
#line 3243 "rygel-object-creator.c"
		goto _state_2;
		default:
#line 337 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_assert_not_reached ();
#line 3248 "rygel-object-creator.c"
	}
	_state_0:
#line 338 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp0_ = NULL;
#line 338 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp0_ = _data_->self->priv->content_dir;
#line 338 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp1_ = NULL;
#line 338 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp1_ = _data_->_tmp0_->root_container;
#line 338 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp2_ = NULL;
#line 338 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp1_, RYGEL_TYPE_SEARCHABLE_CONTAINER) ? ((RygelSearchableContainer*) _data_->_tmp1_) : NULL);
#line 338 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->root_container = _data_->_tmp2_;
#line 341 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp3_ = NULL;
#line 341 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp3_ = _data_->root_container;
#line 341 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_data_->_tmp3_ == NULL) {
#line 342 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->result = NULL;
#line 342 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_object_unref0 (_data_->root_container);
#line 342 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (_data_->_state_ == 0) {
#line 342 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3279 "rygel-object-creator.c"
		} else {
#line 342 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 3283 "rygel-object-creator.c"
		}
#line 342 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_object_unref (_data_->_async_result);
#line 342 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return FALSE;
#line 3289 "rygel-object-creator.c"
	}
#line 345 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp4_ = NULL;
#line 345 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp4_ = _data_->self->priv->didl_object;
#line 345 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp5_ = NULL;
#line 345 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp5_ = gupnp_didl_lite_object_get_upnp_class (_data_->_tmp4_);
#line 345 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp6_ = NULL;
#line 345 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp6_ = _data_->_tmp5_;
#line 345 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp7_ = NULL;
#line 345 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp7_ = g_strdup (_data_->_tmp6_);
#line 345 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->upnp_class = _data_->_tmp7_;
#line 347 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp8_ = NULL;
#line 347 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp8_ = rygel_relational_expression_new ();
#line 347 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->expression = _data_->_tmp8_;
#line 348 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp9_ = NULL;
#line 348 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp9_ = _data_->expression;
#line 348 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	((RygelSearchExpression*) _data_->_tmp9_)->op = (gpointer) ((gintptr) GUPNP_SEARCH_CRITERIA_OP_DERIVED_FROM);
#line 349 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp10_ = NULL;
#line 349 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp10_ = _data_->expression;
#line 349 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp11_ = NULL;
#line 349 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp11_ = g_strdup ("upnp:createClass");
#line 349 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_free0 (((RygelSearchExpression*) _data_->_tmp10_)->operand1);
#line 349 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	((RygelSearchExpression*) _data_->_tmp10_)->operand1 = _data_->_tmp11_;
#line 353 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp12_ = NULL;
#line 353 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp12_ = _data_->expression;
#line 353 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_state_ = 1;
#line 353 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	rygel_object_creator_build_create_class_expression (_data_->self, (RygelSearchExpression*) _data_->_tmp12_, rygel_object_creator_find_any_container_ready, _data_);
#line 353 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	return FALSE;
#line 3343 "rygel-object-creator.c"
	_state_1:
#line 353 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp13_ = NULL;
#line 353 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp13_ = rygel_object_creator_build_create_class_expression_finish (_data_->self, _data_->_res_);
#line 353 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->search_expression = _data_->_tmp13_;
#line 356 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	while (TRUE) {
#line 356 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp14_ = NULL;
#line 356 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp14_ = _data_->upnp_class;
#line 356 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (!(g_strcmp0 (_data_->_tmp14_, "object") != 0)) {
#line 356 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			break;
#line 3361 "rygel-object-creator.c"
		}
#line 357 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp15_ = NULL;
#line 357 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp15_ = _data_->expression;
#line 357 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp16_ = NULL;
#line 357 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp16_ = _data_->upnp_class;
#line 357 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp17_ = NULL;
#line 357 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp17_ = g_strdup (_data_->_tmp16_);
#line 357 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_free0 (((RygelSearchExpression*) _data_->_tmp15_)->operand2);
#line 357 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		((RygelSearchExpression*) _data_->_tmp15_)->operand2 = _data_->_tmp17_;
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp18_ = NULL;
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp18_ = _data_->root_container;
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp19_ = NULL;
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp19_ = _data_->search_expression;
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp20_ = NULL;
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp20_ = _data_->root_container;
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp21_ = NULL;
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp21_ = rygel_media_container_get_sort_criteria ((RygelMediaContainer*) _data_->_tmp20_);
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp22_ = NULL;
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp22_ = _data_->_tmp21_;
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp23_ = NULL;
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp23_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp24_ = NULL;
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp24_ = _data_->_tmp23_;
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp25_ = 0U;
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_state_ = 2;
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		rygel_searchable_container_search (_data_->_tmp18_, _data_->_tmp19_, (guint) 0, (guint) 1, _data_->_tmp22_, _data_->_tmp24_, rygel_object_creator_find_any_container_ready, _data_);
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return FALSE;
#line 3415 "rygel-object-creator.c"
		_state_2:
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp26_ = NULL;
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp26_ = rygel_searchable_container_search_finish (_data_->_tmp18_, _data_->_res_, &_data_->_tmp25_, &_data_->_inner_error_);
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->total_matches = _data_->_tmp25_;
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_result_ = _data_->_tmp26_;
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_error_free (_data_->_inner_error_);
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_rygel_search_expression_unref0 (_data_->search_expression);
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_rygel_search_expression_unref0 (_data_->expression);
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_g_free0 (_data_->upnp_class);
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_g_object_unref0 (_data_->root_container);
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			if (_data_->_state_ == 0) {
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3443 "rygel-object-creator.c"
			} else {
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 3447 "rygel-object-creator.c"
			}
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_object_unref (_data_->_async_result);
#line 360 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			return FALSE;
#line 3453 "rygel-object-creator.c"
		}
#line 366 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp27_ = NULL;
#line 366 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp27_ = _data_->_result_;
#line 366 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp28_ = 0;
#line 366 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp28_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp27_);
#line 366 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp29_ = 0;
#line 366 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp29_ = _data_->_tmp28_;
#line 366 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (_data_->_tmp29_ > 0) {
#line 367 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp30_ = NULL;
#line 367 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp30_ = _data_->self->priv->didl_object;
#line 367 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp31_ = NULL;
#line 367 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp31_ = _data_->upnp_class;
#line 367 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			gupnp_didl_lite_object_set_upnp_class (_data_->_tmp30_, _data_->_tmp31_);
#line 369 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp32_ = NULL;
#line 369 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp32_ = _data_->_result_;
#line 369 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp33_ = NULL;
#line 369 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp33_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp32_, 0);
#line 369 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->result = (RygelMediaObject*) _data_->_tmp33_;
#line 369 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_g_object_unref0 (_data_->_result_);
#line 369 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_rygel_search_expression_unref0 (_data_->search_expression);
#line 369 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_rygel_search_expression_unref0 (_data_->expression);
#line 369 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_g_free0 (_data_->upnp_class);
#line 369 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_g_object_unref0 (_data_->root_container);
#line 369 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			if (_data_->_state_ == 0) {
#line 369 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3503 "rygel-object-creator.c"
			} else {
#line 369 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 3507 "rygel-object-creator.c"
			}
#line 369 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_object_unref (_data_->_async_result);
#line 369 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			return FALSE;
#line 3513 "rygel-object-creator.c"
		} else {
#line 371 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			rygel_object_creator_generalize_upnp_class (_data_->self, &_data_->upnp_class);
#line 3517 "rygel-object-creator.c"
		}
#line 356 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_object_unref0 (_data_->_result_);
#line 3521 "rygel-object-creator.c"
	}
#line 375 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp34_ = NULL;
#line 375 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp34_ = _data_->upnp_class;
#line 375 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (g_strcmp0 (_data_->_tmp34_, "object") == 0) {
#line 376 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp35_ = NULL;
#line 376 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp35_ = _ ("UPnP class '%s' not supported");
#line 376 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp36_ = NULL;
#line 376 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp36_ = _data_->self->priv->didl_object;
#line 376 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp37_ = NULL;
#line 376 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp37_ = gupnp_didl_lite_object_get_upnp_class (_data_->_tmp36_);
#line 376 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp38_ = NULL;
#line 376 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp38_ = _data_->_tmp37_;
#line 376 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp39_ = NULL;
#line 376 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp39_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _data_->_tmp35_, _data_->_tmp38_);
#line 376 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_inner_error_ = _data_->_tmp39_;
#line 376 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 376 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_error_free (_data_->_inner_error_);
#line 376 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_rygel_search_expression_unref0 (_data_->search_expression);
#line 376 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_rygel_search_expression_unref0 (_data_->expression);
#line 376 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_free0 (_data_->upnp_class);
#line 376 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_object_unref0 (_data_->root_container);
#line 376 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (_data_->_state_ == 0) {
#line 376 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3567 "rygel-object-creator.c"
		} else {
#line 376 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 3571 "rygel-object-creator.c"
		}
#line 376 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_object_unref (_data_->_async_result);
#line 376 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return FALSE;
#line 3577 "rygel-object-creator.c"
	}
#line 381 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->result = NULL;
#line 381 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_rygel_search_expression_unref0 (_data_->search_expression);
#line 381 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 381 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_free0 (_data_->upnp_class);
#line 381 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (_data_->root_container);
#line 381 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_data_->_state_ == 0) {
#line 381 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3593 "rygel-object-creator.c"
	} else {
#line 381 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 3597 "rygel-object-creator.c"
	}
#line 381 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_object_unref (_data_->_async_result);
#line 381 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	return FALSE;
#line 337 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_rygel_search_expression_unref0 (_data_->search_expression);
#line 337 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_rygel_search_expression_unref0 (_data_->expression);
#line 337 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_free0 (_data_->upnp_class);
#line 337 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (_data_->root_container);
#line 337 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_data_->_state_ == 0) {
#line 337 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3615 "rygel-object-creator.c"
	} else {
#line 337 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 3619 "rygel-object-creator.c"
	}
#line 337 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_object_unref (_data_->_async_result);
#line 337 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	return FALSE;
#line 3625 "rygel-object-creator.c"
}


static void rygel_object_creator_fetch_container_data_free (gpointer _data) {
	RygelObjectCreatorFetchContainerData* _data_;
	_data_ = _data;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (_data_->result);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (_data_->self);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_slice_free (RygelObjectCreatorFetchContainerData, _data_);
#line 3638 "rygel-object-creator.c"
}


static void rygel_object_creator_fetch_container (RygelObjectCreator* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelObjectCreatorFetchContainerData* _data_;
	RygelObjectCreator* _tmp0_ = NULL;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_ = g_slice_new0 (RygelObjectCreatorFetchContainerData);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_object_creator_fetch_container);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_object_creator_fetch_container_data_free);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->self = _tmp0_;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	rygel_object_creator_fetch_container_co (_data_);
#line 3657 "rygel-object-creator.c"
}


static RygelWritableContainer* rygel_object_creator_fetch_container_finish (RygelObjectCreator* self, GAsyncResult* _res_, GError** error) {
	RygelWritableContainer* result;
	RygelObjectCreatorFetchContainerData* _data_;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return NULL;
#line 3668 "rygel-object-creator.c"
	}
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	result = _data_->result;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->result = NULL;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	return result;
#line 3678 "rygel-object-creator.c"
}


/**
     * Get the container to create the item in.
     *
     * This will either try to fetch the container supplied by the caller or
     * search for a container if the caller supplied the "DLNA.ORG_AnyContainer"
     * id.
     *
     * @return an instance of WritableContainer matching the criteria
     * @throws ContentDirectoryError for various problems
     */
static void rygel_object_creator_fetch_container_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelObjectCreatorFetchContainerData* _data_;
#line 398 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_ = _user_data_;
#line 398 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_source_object_ = source_object;
#line 398 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_res_ = _res_;
#line 398 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	rygel_object_creator_fetch_container_co (_data_);
#line 3702 "rygel-object-creator.c"
}


static gboolean rygel_object_creator_fetch_container_co (RygelObjectCreatorFetchContainerData* _data_) {
#line 394 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	switch (_data_->_state_) {
#line 394 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		case 0:
#line 3711 "rygel-object-creator.c"
		goto _state_0;
#line 394 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		case 1:
#line 3715 "rygel-object-creator.c"
		goto _state_1;
#line 394 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		case 2:
#line 3719 "rygel-object-creator.c"
		goto _state_2;
		default:
#line 394 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_assert_not_reached ();
#line 3724 "rygel-object-creator.c"
	}
	_state_0:
#line 395 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->media_object = NULL;
#line 397 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp0_ = NULL;
#line 397 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp0_ = _data_->self->priv->container_id;
#line 397 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (g_strcmp0 (_data_->_tmp0_, RYGEL_MEDIA_CONTAINER_ANY) == 0) {
#line 398 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_state_ = 1;
#line 398 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		rygel_object_creator_find_any_container (_data_->self, rygel_object_creator_fetch_container_ready, _data_);
#line 398 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return FALSE;
#line 3741 "rygel-object-creator.c"
		_state_1:
#line 398 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp2_ = NULL;
#line 398 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp2_ = rygel_object_creator_find_any_container_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 398 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp1_ = _data_->_tmp2_;
#line 398 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 398 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 398 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_error_free (_data_->_inner_error_);
#line 398 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_g_object_unref0 (_data_->media_object);
#line 398 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			if (_data_->_state_ == 0) {
#line 398 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3761 "rygel-object-creator.c"
			} else {
#line 398 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 3765 "rygel-object-creator.c"
			}
#line 398 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_object_unref (_data_->_async_result);
#line 398 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			return FALSE;
#line 3771 "rygel-object-creator.c"
		}
#line 398 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp3_ = NULL;
#line 398 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp3_ = _data_->_tmp1_;
#line 398 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp1_ = NULL;
#line 398 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_object_unref0 (_data_->media_object);
#line 398 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->media_object = _data_->_tmp3_;
#line 397 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_object_unref0 (_data_->_tmp1_);
#line 3785 "rygel-object-creator.c"
	} else {
#line 400 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp5_ = NULL;
#line 400 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp5_ = _data_->self->priv->content_dir;
#line 400 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp6_ = NULL;
#line 400 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp6_ = _data_->_tmp5_->root_container;
#line 400 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp7_ = NULL;
#line 400 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp7_ = _data_->self->priv->container_id;
#line 400 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp8_ = NULL;
#line 400 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp8_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 400 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp9_ = NULL;
#line 400 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp9_ = _data_->_tmp8_;
#line 400 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_state_ = 2;
#line 400 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		rygel_media_container_find_object (_data_->_tmp6_, _data_->_tmp7_, _data_->_tmp9_, rygel_object_creator_fetch_container_ready, _data_);
#line 400 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return FALSE;
#line 3813 "rygel-object-creator.c"
		_state_2:
#line 400 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp10_ = NULL;
#line 400 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp10_ = rygel_media_container_find_object_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error_);
#line 400 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp4_ = _data_->_tmp10_;
#line 400 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 400 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 400 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_error_free (_data_->_inner_error_);
#line 400 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_g_object_unref0 (_data_->media_object);
#line 400 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			if (_data_->_state_ == 0) {
#line 400 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3833 "rygel-object-creator.c"
			} else {
#line 400 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 3837 "rygel-object-creator.c"
			}
#line 400 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_object_unref (_data_->_async_result);
#line 400 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			return FALSE;
#line 3843 "rygel-object-creator.c"
		}
#line 400 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp11_ = NULL;
#line 400 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp11_ = _data_->_tmp4_;
#line 400 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp4_ = NULL;
#line 400 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_object_unref0 (_data_->media_object);
#line 400 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->media_object = _data_->_tmp11_;
#line 397 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_object_unref0 (_data_->_tmp4_);
#line 3857 "rygel-object-creator.c"
	}
#line 404 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp13_ = NULL;
#line 404 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp13_ = _data_->media_object;
#line 404 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_data_->_tmp13_ == NULL) {
#line 404 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp12_ = TRUE;
#line 3867 "rygel-object-creator.c"
	} else {
#line 404 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp14_ = NULL;
#line 404 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp14_ = _data_->media_object;
#line 404 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp12_ = !G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp14_, RYGEL_TYPE_MEDIA_CONTAINER);
#line 3875 "rygel-object-creator.c"
	}
#line 404 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_data_->_tmp12_) {
#line 405 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp15_ = NULL;
#line 405 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp15_ = _ ("No such container");
#line 405 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp16_ = NULL;
#line 405 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp16_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_CONTAINER, _data_->_tmp15_);
#line 405 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_inner_error_ = _data_->_tmp16_;
#line 405 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 405 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_error_free (_data_->_inner_error_);
#line 405 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_object_unref0 (_data_->media_object);
#line 405 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (_data_->_state_ == 0) {
#line 405 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3899 "rygel-object-creator.c"
		} else {
#line 405 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 3903 "rygel-object-creator.c"
		}
#line 405 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_object_unref (_data_->_async_result);
#line 405 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return FALSE;
#line 3909 "rygel-object-creator.c"
	}
#line 409 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp17_ = NULL;
#line 409 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp17_ = _data_->media_object;
#line 409 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp17_, RYGEL_TYPE_WRITABLE_CONTAINER)) {
#line 410 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp18_ = NULL;
#line 410 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp18_ = _ ("Object creation in %s not allowed");
#line 410 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp19_ = NULL;
#line 410 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp19_ = _data_->media_object;
#line 410 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp20_ = NULL;
#line 410 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp20_ = rygel_media_object_get_id (_data_->_tmp19_);
#line 410 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp21_ = NULL;
#line 410 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp21_ = _data_->_tmp20_;
#line 410 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp22_ = NULL;
#line 410 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp22_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT, _data_->_tmp18_, _data_->_tmp21_);
#line 410 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_inner_error_ = _data_->_tmp22_;
#line 410 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 410 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_error_free (_data_->_inner_error_);
#line 410 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_object_unref0 (_data_->media_object);
#line 410 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (_data_->_state_ == 0) {
#line 410 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3949 "rygel-object-creator.c"
		} else {
#line 410 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 3953 "rygel-object-creator.c"
		}
#line 410 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_object_unref (_data_->_async_result);
#line 410 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return FALSE;
#line 3959 "rygel-object-creator.c"
	}
#line 418 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp25_ = NULL;
#line 418 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp25_ = _data_->self->priv->didl_object;
#line 418 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp25_, gupnp_didl_lite_item_get_type ())) {
#line 419 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp26_ = NULL;
#line 419 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp26_ = _data_->media_object;
#line 419 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp27_ = 0;
#line 419 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp27_ = rygel_media_object_get_ocm_flags (_data_->_tmp26_);
#line 419 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp28_ = 0;
#line 419 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp28_ = _data_->_tmp27_;
#line 419 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp24_ = (_data_->_tmp28_ & GUPNP_OCM_FLAGS_UPLOAD) == GUPNP_OCM_FLAGS_UPLOAD;
#line 3981 "rygel-object-creator.c"
	} else {
#line 418 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp24_ = FALSE;
#line 3985 "rygel-object-creator.c"
	}
#line 418 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_data_->_tmp24_) {
#line 418 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp23_ = TRUE;
#line 3991 "rygel-object-creator.c"
	} else {
#line 420 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp30_ = NULL;
#line 420 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp30_ = _data_->self->priv->didl_object;
#line 420 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp30_, gupnp_didl_lite_container_get_type ())) {
#line 421 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp31_ = NULL;
#line 421 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp31_ = _data_->media_object;
#line 421 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp32_ = 0;
#line 421 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp32_ = rygel_media_object_get_ocm_flags (_data_->_tmp31_);
#line 421 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp33_ = 0;
#line 421 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp33_ = _data_->_tmp32_;
#line 421 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp29_ = (_data_->_tmp33_ & GUPNP_OCM_FLAGS_CREATE_CONTAINER) == GUPNP_OCM_FLAGS_CREATE_CONTAINER;
#line 4013 "rygel-object-creator.c"
		} else {
#line 420 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp29_ = FALSE;
#line 4017 "rygel-object-creator.c"
		}
#line 420 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp23_ = _data_->_tmp29_;
#line 4021 "rygel-object-creator.c"
	}
#line 418 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (!_data_->_tmp23_) {
#line 422 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp34_ = NULL;
#line 422 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp34_ = _ ("Object creation in %s not allowed");
#line 422 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp35_ = NULL;
#line 422 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp35_ = _data_->media_object;
#line 422 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp36_ = NULL;
#line 422 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp36_ = rygel_media_object_get_id (_data_->_tmp35_);
#line 422 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp37_ = NULL;
#line 422 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp37_ = _data_->_tmp36_;
#line 422 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp38_ = NULL;
#line 422 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp38_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT, _data_->_tmp34_, _data_->_tmp37_);
#line 422 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_inner_error_ = _data_->_tmp38_;
#line 422 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 422 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_error_free (_data_->_inner_error_);
#line 422 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_object_unref0 (_data_->media_object);
#line 422 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (_data_->_state_ == 0) {
#line 422 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4057 "rygel-object-creator.c"
		} else {
#line 422 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 4061 "rygel-object-creator.c"
		}
#line 422 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_object_unref (_data_->_async_result);
#line 422 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return FALSE;
#line 4067 "rygel-object-creator.c"
	}
#line 429 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp39_ = NULL;
#line 429 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp39_ = _data_->media_object;
#line 429 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp40_ = NULL;
#line 429 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp40_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp39_, RYGEL_TYPE_WRITABLE_CONTAINER) ? ((RygelWritableContainer*) _data_->_tmp39_) : NULL);
#line 429 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->result = _data_->_tmp40_;
#line 429 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (_data_->media_object);
#line 429 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_data_->_state_ == 0) {
#line 429 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4085 "rygel-object-creator.c"
	} else {
#line 429 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 4089 "rygel-object-creator.c"
	}
#line 429 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_object_unref (_data_->_async_result);
#line 429 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	return FALSE;
#line 394 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (_data_->media_object);
#line 394 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_data_->_state_ == 0) {
#line 394 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4101 "rygel-object-creator.c"
	} else {
#line 394 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 4105 "rygel-object-creator.c"
	}
#line 394 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_object_unref (_data_->_async_result);
#line 394 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	return FALSE;
#line 4111 "rygel-object-creator.c"
}


static void rygel_object_creator_conclude (RygelObjectCreator* self) {
	gchar* didl = NULL;
	RygelSerializer* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GUPnPServiceAction* _tmp2_ = NULL;
	RygelMediaObject* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GUPnPServiceAction* _tmp6_ = NULL;
#line 432 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_return_if_fail (self != NULL);
#line 434 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp0_ = self->priv->serializer;
#line 434 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp1_ = rygel_serializer_get_string (_tmp0_);
#line 434 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	didl = _tmp1_;
#line 437 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp2_ = self->priv->action;
#line 437 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp3_ = self->priv->object;
#line 437 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp4_ = rygel_media_object_get_id (_tmp3_);
#line 437 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp5_ = _tmp4_;
#line 437 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	gupnp_service_action_set (_tmp2_, "ObjectID", G_TYPE_STRING, _tmp5_, "Result", G_TYPE_STRING, didl, NULL);
#line 440 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp6_ = self->priv->action;
#line 440 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	gupnp_service_action_return (_tmp6_);
#line 441 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
#line 432 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_free0 (didl);
#line 4150 "rygel-object-creator.c"
}


static gboolean rygel_object_creator_validate_create_class (RygelObjectCreator* self, RygelWritableContainer* container) {
	gboolean result = FALSE;
	GUPnPDIDLLiteContainer* didl_cont = NULL;
	GUPnPDIDLLiteObject* _tmp0_ = NULL;
	GUPnPDIDLLiteContainer* _tmp1_ = NULL;
	GList* create_classes = NULL;
	GUPnPDIDLLiteContainer* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
#line 444 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 444 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_return_val_if_fail (container != NULL, FALSE);
#line 445 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp0_ = self->priv->didl_object;
#line 445 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gupnp_didl_lite_container_get_type ()) ? ((GUPnPDIDLLiteContainer*) _tmp0_) : NULL);
#line 445 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	didl_cont = _tmp1_;
#line 446 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp2_ = didl_cont;
#line 446 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp3_ = gupnp_didl_lite_container_get_create_classes (_tmp2_);
#line 446 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	create_classes = _tmp3_;
#line 448 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp4_ = create_classes;
#line 448 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_tmp4_ == NULL) {
#line 449 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		result = TRUE;
#line 449 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		__g_list_free__g_free0_0 (create_classes);
#line 449 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_object_unref0 (didl_cont);
#line 449 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return result;
#line 4192 "rygel-object-creator.c"
	}
#line 452 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp5_ = create_classes;
#line 4196 "rygel-object-creator.c"
	{
		GList* create_class_collection = NULL;
		GList* create_class_it = NULL;
#line 452 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		create_class_collection = _tmp5_;
#line 452 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		for (create_class_it = create_class_collection; create_class_it != NULL; create_class_it = create_class_it->next) {
#line 4204 "rygel-object-creator.c"
			gchar* _tmp6_ = NULL;
			gchar* create_class = NULL;
#line 452 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_tmp6_ = g_strdup ((const gchar*) create_class_it->data);
#line 452 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			create_class = _tmp6_;
#line 4211 "rygel-object-creator.c"
			{
				RygelWritableContainer* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
				gboolean _tmp9_ = FALSE;
#line 453 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp7_ = container;
#line 453 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp8_ = create_class;
#line 453 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp9_ = rygel_writable_container_can_create (_tmp7_, _tmp8_);
#line 453 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				if (!_tmp9_) {
#line 454 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
					result = FALSE;
#line 454 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
					_g_free0 (create_class);
#line 454 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
					__g_list_free__g_free0_0 (create_classes);
#line 454 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
					_g_object_unref0 (didl_cont);
#line 454 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
					return result;
#line 4234 "rygel-object-creator.c"
				}
#line 452 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_g_free0 (create_class);
#line 4238 "rygel-object-creator.c"
			}
		}
	}
#line 458 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	result = TRUE;
#line 458 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	__g_list_free__g_free0_0 (create_classes);
#line 458 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (didl_cont);
#line 458 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	return result;
#line 4250 "rygel-object-creator.c"
}


static void rygel_object_creator_handle_error (RygelObjectCreator* self, GError* _error_) {
	GError* _tmp0_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	GError* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
#line 461 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_return_if_fail (self != NULL);
#line 462 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp0_ = _error_;
#line 462 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_tmp0_->domain == RYGEL_CONTENT_DIRECTORY_ERROR) {
#line 4266 "rygel-object-creator.c"
		GUPnPServiceAction* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 463 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp1_ = self->priv->action;
#line 463 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp2_ = _error_;
#line 463 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp3_ = _tmp2_->code;
#line 463 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp4_ = _error_;
#line 463 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp5_ = _tmp4_->message;
#line 463 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		gupnp_service_action_return_error (_tmp1_, (guint) _tmp3_, _tmp5_);
#line 4284 "rygel-object-creator.c"
	} else {
		GUPnPServiceAction* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
#line 465 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp6_ = self->priv->action;
#line 465 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp7_ = _error_;
#line 465 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp8_ = _tmp7_->message;
#line 465 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		gupnp_service_action_return_error (_tmp6_, (guint) 701, _tmp8_);
#line 4297 "rygel-object-creator.c"
	}
#line 468 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp9_ = _ ("Failed to create item under '%s': %s");
#line 468 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp10_ = self->priv->container_id;
#line 468 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp11_ = _error_;
#line 468 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp12_ = _tmp11_->message;
#line 468 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_warning (_tmp9_, _tmp10_, _tmp12_);
#line 472 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
#line 4311 "rygel-object-creator.c"
}


static gchar* rygel_object_creator_get_generic_mime_type (RygelObjectCreator* self) {
	gchar* result = NULL;
	RygelMediaObject* _tmp0_ = NULL;
	RygelMediaFileItem* item = NULL;
	RygelMediaObject* _tmp2_ = NULL;
	RygelMediaFileItem* _tmp3_ = NULL;
	RygelMediaFileItem* _tmp4_ = NULL;
#line 475 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 476 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp0_ = self->priv->object;
#line 476 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_MEDIA_FILE_ITEM)) {
#line 4328 "rygel-object-creator.c"
		gchar* _tmp1_ = NULL;
#line 477 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp1_ = g_strdup ("");
#line 477 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		result = _tmp1_;
#line 477 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return result;
#line 4336 "rygel-object-creator.c"
	}
#line 480 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp2_ = self->priv->object;
#line 480 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _tmp2_) : NULL);
#line 480 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	item = _tmp3_;
#line 482 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp4_ = item;
#line 482 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, RYGEL_TYPE_IMAGE_ITEM)) {
#line 4348 "rygel-object-creator.c"
		gchar* _tmp5_ = NULL;
#line 483 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp5_ = g_strdup ("image");
#line 483 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		result = _tmp5_;
#line 483 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_object_unref0 (item);
#line 483 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return result;
#line 4358 "rygel-object-creator.c"
	} else {
		RygelMediaFileItem* _tmp6_ = NULL;
#line 484 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp6_ = item;
#line 484 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, RYGEL_TYPE_VIDEO_ITEM)) {
#line 4365 "rygel-object-creator.c"
			gchar* _tmp7_ = NULL;
#line 485 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_tmp7_ = g_strdup ("video");
#line 485 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			result = _tmp7_;
#line 485 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_g_object_unref0 (item);
#line 485 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			return result;
#line 4375 "rygel-object-creator.c"
		} else {
			gchar* _tmp8_ = NULL;
#line 487 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_tmp8_ = g_strdup ("audio");
#line 487 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			result = _tmp8_;
#line 487 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_g_object_unref0 (item);
#line 487 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			return result;
#line 4386 "rygel-object-creator.c"
		}
	}
#line 475 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (item);
#line 4391 "rygel-object-creator.c"
}


static void rygel_object_creator_create_object_from_didl_data_free (gpointer _data) {
	RygelObjectCreatorCreateObjectFromDidlData* _data_;
	_data_ = _data;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (_data_->container);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (_data_->self);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_slice_free (RygelObjectCreatorCreateObjectFromDidlData, _data_);
#line 4404 "rygel-object-creator.c"
}


static void rygel_object_creator_create_object_from_didl (RygelObjectCreator* self, RygelWritableContainer* container, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelObjectCreatorCreateObjectFromDidlData* _data_;
	RygelObjectCreator* _tmp0_ = NULL;
	RygelWritableContainer* _tmp1_ = NULL;
	RygelWritableContainer* _tmp2_ = NULL;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_ = g_slice_new0 (RygelObjectCreatorCreateObjectFromDidlData);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_object_creator_create_object_from_didl);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_object_creator_create_object_from_didl_data_free);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->self = _tmp0_;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp1_ = container;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (_data_->container);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->container = _tmp2_;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	rygel_object_creator_create_object_from_didl_co (_data_);
#line 4433 "rygel-object-creator.c"
}


static void rygel_object_creator_create_object_from_didl_finish (RygelObjectCreator* self, GAsyncResult* _res_, GError** error) {
	RygelObjectCreatorCreateObjectFromDidlData* _data_;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return;
#line 4443 "rygel-object-creator.c"
	}
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 4447 "rygel-object-creator.c"
}


/**
     * Transfer information passed by caller to a MediaObject.
     *
     * WritableContainer works on MediaObject so we transfer the supplied data
     * to one. Additionally some checks are performed (e.g. whether the DLNA
     * profile is supported or not) or sanitize the supplied title for use as
     * part of the on-disk filename.
     *
     * This function fills ObjectCreator.object.
     */
static void rygel_object_creator_create_object_from_didl_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelObjectCreatorCreateObjectFromDidlData* _data_;
#line 516 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_ = _user_data_;
#line 516 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_source_object_ = source_object;
#line 516 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_res_ = _res_;
#line 516 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	rygel_object_creator_create_object_from_didl_co (_data_);
#line 4471 "rygel-object-creator.c"
}


static gboolean rygel_object_creator_create_object_from_didl_co (RygelObjectCreatorCreateObjectFromDidlData* _data_) {
#line 501 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	switch (_data_->_state_) {
#line 501 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		case 0:
#line 4480 "rygel-object-creator.c"
		goto _state_0;
#line 501 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		case 1:
#line 4484 "rygel-object-creator.c"
		goto _state_1;
		default:
#line 501 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_assert_not_reached ();
#line 4489 "rygel-object-creator.c"
	}
	_state_0:
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp1_ = NULL;
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp1_ = _data_->self->priv->didl_object;
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp2_ = NULL;
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp2_ = gupnp_didl_lite_object_get_id (_data_->_tmp1_);
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp3_ = NULL;
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp3_ = _data_->_tmp2_;
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp4_ = NULL;
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp4_ = _data_->container;
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp5_ = NULL;
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp5_ = _data_->self->priv->didl_object;
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp6_ = NULL;
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp6_ = gupnp_didl_lite_object_get_title (_data_->_tmp5_);
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp7_ = NULL;
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp7_ = _data_->_tmp6_;
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp8_ = NULL;
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp8_ = _data_->self->priv->didl_object;
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp9_ = NULL;
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp9_ = gupnp_didl_lite_object_get_upnp_class (_data_->_tmp8_);
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp10_ = NULL;
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp10_ = _data_->_tmp9_;
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp11_ = NULL;
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp11_ = rygel_object_creator_create_object (_data_->self, _data_->_tmp3_, _data_->_tmp4_, _data_->_tmp7_, _data_->_tmp10_, &_data_->_inner_error_);
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp0_ = _data_->_tmp11_;
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_error_free (_data_->_inner_error_);
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (_data_->_state_ == 0) {
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4548 "rygel-object-creator.c"
		} else {
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 4552 "rygel-object-creator.c"
		}
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_object_unref (_data_->_async_result);
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return FALSE;
#line 4558 "rygel-object-creator.c"
	}
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp12_ = NULL;
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp12_ = _data_->_tmp0_;
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp0_ = NULL;
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (_data_->self->priv->object);
#line 503 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->self->priv->object = _data_->_tmp12_;
#line 508 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp13_ = NULL;
#line 508 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp13_ = _data_->self->priv->object;
#line 508 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp14_ = NULL;
#line 508 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp14_ = _data_->self->priv->didl_object;
#line 508 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	rygel_media_object_apply_didl_lite (_data_->_tmp13_, _data_->_tmp14_);
#line 510 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp15_ = NULL;
#line 510 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp15_ = _data_->self->priv->object;
#line 510 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp15_, RYGEL_TYPE_MEDIA_ITEM)) {
#line 511 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		rygel_object_creator_extract_item_parameters (_data_->self, &_data_->_inner_error_);
#line 511 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 511 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 511 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_error_free (_data_->_inner_error_);
#line 511 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_g_object_unref0 (_data_->_tmp0_);
#line 511 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			if (_data_->_state_ == 0) {
#line 511 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4600 "rygel-object-creator.c"
			} else {
#line 511 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 4604 "rygel-object-creator.c"
			}
#line 511 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_object_unref (_data_->_async_result);
#line 511 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			return FALSE;
#line 4610 "rygel-object-creator.c"
		}
	}
#line 515 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp16_ = NULL;
#line 515 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp16_ = _data_->self->priv->object;
#line 515 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp17_ = NULL;
#line 515 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp17_ = rygel_media_object_get_uris (_data_->_tmp16_);
#line 515 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp18_ = NULL;
#line 515 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp18_ = _data_->_tmp17_;
#line 515 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp19_ = FALSE;
#line 515 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp19_ = gee_collection_get_is_empty ((GeeCollection*) _data_->_tmp18_);
#line 515 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp20_ = FALSE;
#line 515 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp20_ = _data_->_tmp19_;
#line 515 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp21_ = FALSE;
#line 515 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp21_ = _data_->_tmp20_;
#line 515 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (_data_->_tmp18_);
#line 515 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_data_->_tmp21_) {
#line 516 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp22_ = NULL;
#line 516 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp22_ = _data_->container;
#line 516 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp23_ = NULL;
#line 516 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp23_ = _data_->self->priv->object;
#line 516 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp24_ = NULL;
#line 516 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp24_ = rygel_media_object_get_title (_data_->_tmp23_);
#line 516 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp25_ = NULL;
#line 516 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp25_ = _data_->_tmp24_;
#line 516 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_state_ = 1;
#line 516 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		rygel_object_creator_create_uri (_data_->self, _data_->_tmp22_, _data_->_tmp25_, rygel_object_creator_create_object_from_didl_ready, _data_);
#line 516 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return FALSE;
#line 4663 "rygel-object-creator.c"
		_state_1:
#line 516 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp26_ = NULL;
#line 516 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp26_ = rygel_object_creator_create_uri_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 516 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->uri = _data_->_tmp26_;
#line 516 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 516 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 516 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_error_free (_data_->_inner_error_);
#line 516 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_g_object_unref0 (_data_->_tmp0_);
#line 516 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			if (_data_->_state_ == 0) {
#line 516 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4683 "rygel-object-creator.c"
			} else {
#line 516 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 4687 "rygel-object-creator.c"
			}
#line 516 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_object_unref (_data_->_async_result);
#line 516 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			return FALSE;
#line 4693 "rygel-object-creator.c"
		}
#line 517 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp27_ = NULL;
#line 517 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp27_ = _data_->self->priv->object;
#line 517 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp28_ = NULL;
#line 517 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp28_ = _data_->uri;
#line 517 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		rygel_media_object_add_uri (_data_->_tmp27_, _data_->_tmp28_);
#line 518 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp29_ = NULL;
#line 518 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp29_ = _data_->self->priv->object;
#line 518 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp29_, RYGEL_TYPE_MEDIA_FILE_ITEM)) {
#line 519 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp30_ = NULL;
#line 519 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp30_ = _data_->self->priv->object;
#line 519 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			rygel_media_file_item_set_place_holder (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp30_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _data_->_tmp30_) : NULL, TRUE);
#line 4717 "rygel-object-creator.c"
		}
#line 515 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_free0 (_data_->uri);
#line 4721 "rygel-object-creator.c"
	} else {
#line 522 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp31_ = NULL;
#line 522 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp31_ = _data_->self->priv->object;
#line 522 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp31_, RYGEL_TYPE_MEDIA_FILE_ITEM)) {
#line 523 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp32_ = NULL;
#line 523 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp32_ = _data_->self->priv->object;
#line 523 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp33_ = NULL;
#line 523 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp33_ = rygel_media_object_get_primary_uri (_data_->_tmp32_);
#line 523 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp34_ = NULL;
#line 523 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp34_ = _data_->_tmp33_;
#line 523 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp35_ = NULL;
#line 523 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp35_ = g_file_new_for_uri (_data_->_tmp34_);
#line 523 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp36_ = NULL;
#line 523 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp36_ = _data_->_tmp35_;
#line 523 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_g_free0 (_data_->_tmp34_);
#line 523 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->file = _data_->_tmp36_;
#line 524 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp37_ = NULL;
#line 524 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp37_ = _data_->self->priv->object;
#line 524 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp38_ = NULL;
#line 524 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp38_ = _data_->file;
#line 524 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp39_ = FALSE;
#line 524 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp39_ = g_file_is_native (_data_->_tmp38_);
#line 524 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			rygel_media_file_item_set_place_holder (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp37_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _data_->_tmp37_) : NULL, !_data_->_tmp39_);
#line 522 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_g_object_unref0 (_data_->file);
#line 4769 "rygel-object-creator.c"
		}
	}
#line 528 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp40_ = NULL;
#line 528 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp40_ = _data_->self->priv->object;
#line 528 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp41_ = NULL;
#line 528 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp41_ = _data_->self->priv->object;
#line 528 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp42_ = NULL;
#line 528 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp42_ = rygel_media_object_get_primary_uri (_data_->_tmp41_);
#line 528 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp43_ = NULL;
#line 528 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp43_ = _data_->_tmp42_;
#line 528 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	rygel_media_object_set_id (_data_->_tmp40_, _data_->_tmp43_);
#line 528 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_free0 (_data_->_tmp43_);
#line 530 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	rygel_object_creator_parse_and_verify_didl_date (_data_->self, &_data_->_inner_error_);
#line 530 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 530 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 530 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_error_free (_data_->_inner_error_);
#line 530 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_object_unref0 (_data_->_tmp0_);
#line 530 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (_data_->_state_ == 0) {
#line 530 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4806 "rygel-object-creator.c"
		} else {
#line 530 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 4810 "rygel-object-creator.c"
		}
#line 530 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_object_unref (_data_->_async_result);
#line 530 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return FALSE;
#line 4816 "rygel-object-creator.c"
	}
#line 501 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (_data_->_tmp0_);
#line 501 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_data_->_state_ == 0) {
#line 501 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4824 "rygel-object-creator.c"
	} else {
#line 501 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 4828 "rygel-object-creator.c"
	}
#line 501 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_object_unref (_data_->_async_result);
#line 501 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	return FALSE;
#line 4834 "rygel-object-creator.c"
}


static void rygel_object_creator_extract_item_parameters (RygelObjectCreator* self, GError** error) {
	RygelMediaFileItem* item = NULL;
	RygelMediaObject* _tmp0_ = NULL;
	RygelMediaFileItem* _tmp1_ = NULL;
	GUPnPDIDLLiteObject* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	RygelMediaFileItem* _tmp49_ = NULL;
	const gchar* _tmp50_ = NULL;
	const gchar* _tmp51_ = NULL;
	RygelMediaFileItem* _tmp55_ = NULL;
	gint64 _tmp56_ = 0LL;
	gint64 _tmp57_ = 0LL;
	GError * _inner_error_ = NULL;
#line 533 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_return_if_fail (self != NULL);
#line 534 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp0_ = self->priv->object;
#line 534 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _tmp0_) : NULL);
#line 534 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	item = _tmp1_;
#line 536 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp2_ = self->priv->didl_object;
#line 536 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp3_ = gupnp_didl_lite_object_get_resources (_tmp2_);
#line 4863 "rygel-object-creator.c"
	{
		GList* resource_collection = NULL;
		GList* resource_it = NULL;
#line 536 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		resource_collection = _tmp3_;
#line 536 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		for (resource_it = resource_collection; resource_it != NULL; resource_it = resource_it->next) {
#line 4871 "rygel-object-creator.c"
			GUPnPDIDLLiteResource* _tmp4_ = NULL;
			GUPnPDIDLLiteResource* resource = NULL;
#line 536 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_tmp4_ = _g_object_ref0 ((GUPnPDIDLLiteResource*) resource_it->data);
#line 536 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			resource = _tmp4_;
#line 4878 "rygel-object-creator.c"
			{
				GUPnPProtocolInfo* info = NULL;
				GUPnPDIDLLiteResource* _tmp5_ = NULL;
				GUPnPProtocolInfo* _tmp6_ = NULL;
				GUPnPProtocolInfo* _tmp7_ = NULL;
				GUPnPProtocolInfo* _tmp8_ = NULL;
				GUPnPProtocolInfo* _tmp9_ = NULL;
				gchar* sanitized_uri = NULL;
				GUPnPDIDLLiteResource* _tmp35_ = NULL;
				const gchar* _tmp36_ = NULL;
				const gchar* _tmp37_ = NULL;
				gchar* _tmp38_ = NULL;
				gboolean _tmp39_ = FALSE;
				GUPnPDIDLLiteResource* _tmp42_ = NULL;
				glong _tmp43_ = 0L;
				glong _tmp44_ = 0L;
#line 537 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp5_ = resource;
#line 537 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp6_ = gupnp_didl_lite_resource_get_protocol_info (_tmp5_);
#line 537 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp7_ = _tmp6_;
#line 537 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp8_ = _g_object_ref0 (_tmp7_);
#line 537 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				info = _tmp8_;
#line 539 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp9_ = info;
#line 539 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				if (_tmp9_ != NULL) {
#line 4909 "rygel-object-creator.c"
					GUPnPProtocolInfo* _tmp10_ = NULL;
					const gchar* _tmp11_ = NULL;
					const gchar* _tmp12_ = NULL;
					GUPnPProtocolInfo* _tmp28_ = NULL;
					const gchar* _tmp29_ = NULL;
					const gchar* _tmp30_ = NULL;
#line 540 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
					_tmp10_ = info;
#line 540 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
					_tmp11_ = gupnp_protocol_info_get_dlna_profile (_tmp10_);
#line 540 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
					_tmp12_ = _tmp11_;
#line 540 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
					if (_tmp12_ != NULL) {
#line 4924 "rygel-object-creator.c"
						GUPnPProtocolInfo* _tmp13_ = NULL;
						const gchar* _tmp14_ = NULL;
						const gchar* _tmp15_ = NULL;
						gboolean _tmp16_ = FALSE;
						RygelMediaFileItem* _tmp24_ = NULL;
						GUPnPProtocolInfo* _tmp25_ = NULL;
						const gchar* _tmp26_ = NULL;
						const gchar* _tmp27_ = NULL;
#line 541 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
						_tmp13_ = info;
#line 541 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
						_tmp14_ = gupnp_protocol_info_get_dlna_profile (_tmp13_);
#line 541 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
						_tmp15_ = _tmp14_;
#line 541 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
						_tmp16_ = rygel_object_creator_is_profile_valid (self, _tmp15_);
#line 541 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
						if (!_tmp16_) {
#line 4943 "rygel-object-creator.c"
							gchar* msg = NULL;
							const gchar* _tmp17_ = NULL;
							gchar* _tmp18_ = NULL;
							const gchar* _tmp19_ = NULL;
							GUPnPProtocolInfo* _tmp20_ = NULL;
							const gchar* _tmp21_ = NULL;
							const gchar* _tmp22_ = NULL;
							GError* _tmp23_ = NULL;
#line 542 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
							_tmp17_ = _ ("DLNA profile '%s' not supported");
#line 542 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
							_tmp18_ = g_strdup (_tmp17_);
#line 542 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
							msg = _tmp18_;
#line 543 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
							_tmp19_ = msg;
#line 543 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
							_tmp20_ = info;
#line 543 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
							_tmp21_ = gupnp_protocol_info_get_dlna_profile (_tmp20_);
#line 543 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
							_tmp22_ = _tmp21_;
#line 543 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
							_tmp23_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _tmp19_, _tmp22_);
#line 543 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
							_inner_error_ = _tmp23_;
#line 543 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
							g_propagate_error (error, _inner_error_);
#line 543 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
							_g_free0 (msg);
#line 543 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
							_g_object_unref0 (info);
#line 543 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
							_g_object_unref0 (resource);
#line 543 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
							__g_list_free__g_object_unref0_0 (resource_collection);
#line 543 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
							_g_object_unref0 (item);
#line 543 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
							return;
#line 4984 "rygel-object-creator.c"
						}
#line 548 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
						_tmp24_ = item;
#line 548 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
						_tmp25_ = info;
#line 548 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
						_tmp26_ = gupnp_protocol_info_get_dlna_profile (_tmp25_);
#line 548 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
						_tmp27_ = _tmp26_;
#line 548 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
						rygel_media_file_item_set_dlna_profile (_tmp24_, _tmp27_);
#line 4996 "rygel-object-creator.c"
					}
#line 551 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
					_tmp28_ = info;
#line 551 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
					_tmp29_ = gupnp_protocol_info_get_mime_type (_tmp28_);
#line 551 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
					_tmp30_ = _tmp29_;
#line 551 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
					if (_tmp30_ != NULL) {
#line 5006 "rygel-object-creator.c"
						RygelMediaFileItem* _tmp31_ = NULL;
						GUPnPProtocolInfo* _tmp32_ = NULL;
						const gchar* _tmp33_ = NULL;
						const gchar* _tmp34_ = NULL;
#line 552 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
						_tmp31_ = item;
#line 552 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
						_tmp32_ = info;
#line 552 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
						_tmp33_ = gupnp_protocol_info_get_mime_type (_tmp32_);
#line 552 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
						_tmp34_ = _tmp33_;
#line 552 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
						rygel_media_file_item_set_mime_type (_tmp31_, _tmp34_);
#line 5021 "rygel-object-creator.c"
					}
				}
#line 556 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				sanitized_uri = NULL;
#line 557 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp35_ = resource;
#line 557 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp36_ = gupnp_didl_lite_resource_get_uri (_tmp35_);
#line 557 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp37_ = _tmp36_;
#line 557 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp39_ = rygel_object_creator_is_valid_uri (self, _tmp37_, &_tmp38_);
#line 557 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_g_free0 (sanitized_uri);
#line 557 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				sanitized_uri = _tmp38_;
#line 557 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				if (_tmp39_) {
#line 5040 "rygel-object-creator.c"
					RygelMediaFileItem* _tmp40_ = NULL;
					const gchar* _tmp41_ = NULL;
#line 558 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
					_tmp40_ = item;
#line 558 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
					_tmp41_ = sanitized_uri;
#line 558 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
					rygel_media_object_add_uri ((RygelMediaObject*) _tmp40_, _tmp41_);
#line 5049 "rygel-object-creator.c"
				}
#line 561 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp42_ = resource;
#line 561 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp43_ = gupnp_didl_lite_resource_get_size (_tmp42_);
#line 561 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp44_ = _tmp43_;
#line 561 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				if (_tmp44_ >= ((glong) 0)) {
#line 5059 "rygel-object-creator.c"
					RygelMediaFileItem* _tmp45_ = NULL;
					GUPnPDIDLLiteResource* _tmp46_ = NULL;
					glong _tmp47_ = 0L;
					glong _tmp48_ = 0L;
#line 562 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
					_tmp45_ = item;
#line 562 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
					_tmp46_ = resource;
#line 562 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
					_tmp47_ = gupnp_didl_lite_resource_get_size (_tmp46_);
#line 562 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
					_tmp48_ = _tmp47_;
#line 562 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
					rygel_media_file_item_set_size (_tmp45_, (gint64) _tmp48_);
#line 5074 "rygel-object-creator.c"
				}
#line 536 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_g_free0 (sanitized_uri);
#line 536 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_g_object_unref0 (info);
#line 536 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_g_object_unref0 (resource);
#line 5082 "rygel-object-creator.c"
			}
		}
#line 536 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		__g_list_free__g_object_unref0_0 (resource_collection);
#line 5087 "rygel-object-creator.c"
	}
#line 566 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp49_ = item;
#line 566 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp50_ = rygel_media_file_item_get_mime_type (_tmp49_);
#line 566 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp51_ = _tmp50_;
#line 566 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_tmp51_ == NULL) {
#line 5097 "rygel-object-creator.c"
		RygelMediaFileItem* _tmp52_ = NULL;
		gchar* _tmp53_ = NULL;
		gchar* _tmp54_ = NULL;
#line 567 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp52_ = item;
#line 567 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp53_ = rygel_object_creator_get_generic_mime_type (self);
#line 567 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp54_ = _tmp53_;
#line 567 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		rygel_media_file_item_set_mime_type (_tmp52_, _tmp54_);
#line 567 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_free0 (_tmp54_);
#line 5111 "rygel-object-creator.c"
	}
#line 570 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp55_ = item;
#line 570 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp56_ = rygel_media_file_item_get_size (_tmp55_);
#line 570 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp57_ = _tmp56_;
#line 570 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_tmp57_ < ((gint64) 0)) {
#line 5121 "rygel-object-creator.c"
		RygelMediaFileItem* _tmp58_ = NULL;
#line 571 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp58_ = item;
#line 571 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		rygel_media_file_item_set_size (_tmp58_, (gint64) 0);
#line 5127 "rygel-object-creator.c"
	}
#line 533 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (item);
#line 5131 "rygel-object-creator.c"
}


static void _vala_SoupDate_free (SoupDate* self) {
#line 590 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_boxed_free (soup_date_get_type (), self);
#line 5138 "rygel-object-creator.c"
}


static void rygel_object_creator_parse_and_verify_didl_date (RygelObjectCreator* self, GError** error) {
	GUPnPDIDLLiteObject* _tmp0_ = NULL;
	GUPnPDIDLLiteItem* didl_item = NULL;
	GUPnPDIDLLiteObject* _tmp1_ = NULL;
	GUPnPDIDLLiteItem* _tmp2_ = NULL;
	GUPnPDIDLLiteItem* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	SoupDate* parsed_date = NULL;
	GUPnPDIDLLiteItem* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	SoupDate* _tmp9_ = NULL;
	SoupDate* _tmp10_ = NULL;
	gint year = 0;
	gint month = 0;
	gint day = 0;
	GUPnPDIDLLiteItem* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	GDate date = {0};
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	gboolean _tmp27_ = FALSE;
	RygelMediaObject* _tmp33_ = NULL;
	GUPnPDIDLLiteItem* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	const gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	gchar* _tmp38_ = NULL;
	GError * _inner_error_ = NULL;
#line 575 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_return_if_fail (self != NULL);
#line 576 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp0_ = self->priv->didl_object;
#line 576 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gupnp_didl_lite_item_get_type ())) {
#line 577 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return;
#line 5183 "rygel-object-creator.c"
	}
#line 580 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp1_ = self->priv->didl_object;
#line 580 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gupnp_didl_lite_item_get_type ()) ? ((GUPnPDIDLLiteItem*) _tmp1_) : NULL);
#line 580 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	didl_item = _tmp2_;
#line 581 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp3_ = didl_item;
#line 581 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp4_ = gupnp_didl_lite_object_get_date ((GUPnPDIDLLiteObject*) _tmp3_);
#line 581 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp5_ = _tmp4_;
#line 581 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_tmp5_ == NULL) {
#line 582 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_object_unref0 (didl_item);
#line 582 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return;
#line 5203 "rygel-object-creator.c"
	}
#line 585 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp6_ = didl_item;
#line 585 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp7_ = gupnp_didl_lite_object_get_date ((GUPnPDIDLLiteObject*) _tmp6_);
#line 585 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp8_ = _tmp7_;
#line 585 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp9_ = soup_date_new_from_string (_tmp8_);
#line 585 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	parsed_date = _tmp9_;
#line 586 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp10_ = parsed_date;
#line 586 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_tmp10_ != NULL) {
#line 5219 "rygel-object-creator.c"
		RygelMediaObject* _tmp11_ = NULL;
		SoupDate* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
#line 587 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp11_ = self->priv->object;
#line 587 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp12_ = parsed_date;
#line 587 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp13_ = soup_date_to_string (_tmp12_, SOUP_DATE_ISO8601);
#line 587 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp14_ = _tmp13_;
#line 587 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		rygel_media_object_set_date ((RygelMediaObject*) (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _tmp11_) : NULL), _tmp14_);
#line 587 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_free0 (_tmp14_);
#line 590 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		__vala_SoupDate_free0 (parsed_date);
#line 590 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_object_unref0 (didl_item);
#line 590 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return;
#line 5242 "rygel-object-creator.c"
	}
#line 593 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	year = 0;
#line 593 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	month = 0;
#line 593 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	day = 0;
#line 595 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp15_ = didl_item;
#line 595 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp16_ = gupnp_didl_lite_object_get_date ((GUPnPDIDLLiteObject*) _tmp15_);
#line 595 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp17_ = _tmp16_;
#line 595 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp18_ = sscanf (_tmp17_, "%4d-%02d-%02d", &year, &month, &day);
#line 595 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_tmp18_ != 3) {
#line 5260 "rygel-object-creator.c"
		const gchar* _tmp19_ = NULL;
		GUPnPDIDLLiteItem* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		GError* _tmp23_ = NULL;
#line 599 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp19_ = _ ("Invalid date format: %s");
#line 599 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp20_ = didl_item;
#line 599 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp21_ = gupnp_didl_lite_object_get_date ((GUPnPDIDLLiteObject*) _tmp20_);
#line 599 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp22_ = _tmp21_;
#line 599 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp23_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _tmp19_, _tmp22_);
#line 599 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_inner_error_ = _tmp23_;
#line 599 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_propagate_error (error, _inner_error_);
#line 599 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		__vala_SoupDate_free0 (parsed_date);
#line 599 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_object_unref0 (didl_item);
#line 599 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return;
#line 5286 "rygel-object-creator.c"
	}
#line 604 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	memset (&date, 0, sizeof (GDate));
#line 605 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp24_ = day;
#line 605 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp25_ = month;
#line 605 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp26_ = year;
#line 605 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_date_set_dmy (&date, (GDateDay) _tmp24_, (gint) ((GDateMonth) _tmp25_), (GDateYear) _tmp26_);
#line 607 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp27_ = g_date_valid (&date);
#line 607 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (!_tmp27_) {
#line 5302 "rygel-object-creator.c"
		const gchar* _tmp28_ = NULL;
		GUPnPDIDLLiteItem* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		const gchar* _tmp31_ = NULL;
		GError* _tmp32_ = NULL;
#line 608 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp28_ = _ ("Invalid date: %s");
#line 608 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp29_ = didl_item;
#line 608 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp30_ = gupnp_didl_lite_object_get_date ((GUPnPDIDLLiteObject*) _tmp29_);
#line 608 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp31_ = _tmp30_;
#line 608 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp32_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _tmp28_, _tmp31_);
#line 608 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_inner_error_ = _tmp32_;
#line 608 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_propagate_error (error, _inner_error_);
#line 608 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		__vala_SoupDate_free0 (parsed_date);
#line 608 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_object_unref0 (didl_item);
#line 608 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return;
#line 5328 "rygel-object-creator.c"
	}
#line 613 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp33_ = self->priv->object;
#line 613 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp34_ = didl_item;
#line 613 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp35_ = gupnp_didl_lite_object_get_date ((GUPnPDIDLLiteObject*) _tmp34_);
#line 613 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp36_ = _tmp35_;
#line 613 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp37_ = g_strconcat (_tmp36_, "T00:00:00", NULL);
#line 613 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp38_ = _tmp37_;
#line 613 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	rygel_media_object_set_date ((RygelMediaObject*) (G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _tmp33_) : NULL), _tmp38_);
#line 613 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_free0 (_tmp38_);
#line 575 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	__vala_SoupDate_free0 (parsed_date);
#line 575 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (didl_item);
#line 5350 "rygel-object-creator.c"
}


static RygelMediaObject* rygel_object_creator_create_object (RygelObjectCreator* self, const gchar* id, RygelWritableContainer* parent, const gchar* title, const gchar* upnp_class, GError** error) {
	RygelMediaObject* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
	GError * _inner_error_ = NULL;
#line 616 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 616 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 616 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 616 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 616 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_return_val_if_fail (upnp_class != NULL, NULL);
#line 621 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp0_ = upnp_class;
#line 621 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp1_ = _tmp0_;
#line 621 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 621 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_tmp3_ == g_quark_from_string (RYGEL_IMAGE_ITEM_UPNP_CLASS)) {
#line 621 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		switch (0) {
#line 5380 "rygel-object-creator.c"
			default:
			{
				const gchar* _tmp4_ = NULL;
				RygelWritableContainer* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				RygelImageItem* _tmp7_ = NULL;
#line 623 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp4_ = id;
#line 623 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp5_ = parent;
#line 623 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp6_ = title;
#line 623 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp7_ = rygel_image_item_new (_tmp4_, (RygelMediaContainer*) _tmp5_, _tmp6_, RYGEL_IMAGE_ITEM_UPNP_CLASS);
#line 623 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				result = (RygelMediaObject*) _tmp7_;
#line 623 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				return result;
#line 5399 "rygel-object-creator.c"
			}
		}
	} else if (_tmp3_ == g_quark_from_string (RYGEL_PHOTO_ITEM_UPNP_CLASS)) {
#line 621 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		switch (0) {
#line 5405 "rygel-object-creator.c"
			default:
			{
				const gchar* _tmp8_ = NULL;
				RygelWritableContainer* _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
				RygelPhotoItem* _tmp11_ = NULL;
#line 625 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp8_ = id;
#line 625 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp9_ = parent;
#line 625 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp10_ = title;
#line 625 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp11_ = rygel_photo_item_new (_tmp8_, (RygelMediaContainer*) _tmp9_, _tmp10_, RYGEL_PHOTO_ITEM_UPNP_CLASS);
#line 625 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				result = (RygelMediaObject*) _tmp11_;
#line 625 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				return result;
#line 5424 "rygel-object-creator.c"
			}
		}
	} else if (_tmp3_ == g_quark_from_string (RYGEL_VIDEO_ITEM_UPNP_CLASS)) {
#line 621 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		switch (0) {
#line 5430 "rygel-object-creator.c"
			default:
			{
				const gchar* _tmp12_ = NULL;
				RygelWritableContainer* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				RygelVideoItem* _tmp15_ = NULL;
#line 627 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp12_ = id;
#line 627 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp13_ = parent;
#line 627 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp14_ = title;
#line 627 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp15_ = rygel_video_item_new (_tmp12_, (RygelMediaContainer*) _tmp13_, _tmp14_, RYGEL_VIDEO_ITEM_UPNP_CLASS);
#line 627 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				result = (RygelMediaObject*) _tmp15_;
#line 627 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				return result;
#line 5449 "rygel-object-creator.c"
			}
		}
	} else if (_tmp3_ == g_quark_from_string (RYGEL_AUDIO_ITEM_UPNP_CLASS)) {
#line 621 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		switch (0) {
#line 5455 "rygel-object-creator.c"
			default:
			{
				const gchar* _tmp16_ = NULL;
				RygelWritableContainer* _tmp17_ = NULL;
				const gchar* _tmp18_ = NULL;
				RygelAudioItem* _tmp19_ = NULL;
#line 629 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp16_ = id;
#line 629 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp17_ = parent;
#line 629 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp18_ = title;
#line 629 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp19_ = rygel_audio_item_new (_tmp16_, (RygelMediaContainer*) _tmp17_, _tmp18_, RYGEL_AUDIO_ITEM_UPNP_CLASS);
#line 629 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				result = (RygelMediaObject*) _tmp19_;
#line 629 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				return result;
#line 5474 "rygel-object-creator.c"
			}
		}
	} else if (_tmp3_ == g_quark_from_string (RYGEL_MUSIC_ITEM_UPNP_CLASS)) {
#line 621 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		switch (0) {
#line 5480 "rygel-object-creator.c"
			default:
			{
				const gchar* _tmp20_ = NULL;
				RygelWritableContainer* _tmp21_ = NULL;
				const gchar* _tmp22_ = NULL;
				RygelMusicItem* _tmp23_ = NULL;
#line 631 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp20_ = id;
#line 631 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp21_ = parent;
#line 631 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp22_ = title;
#line 631 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp23_ = rygel_music_item_new (_tmp20_, (RygelMediaContainer*) _tmp21_, _tmp22_, RYGEL_MUSIC_ITEM_UPNP_CLASS);
#line 631 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				result = (RygelMediaObject*) _tmp23_;
#line 631 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				return result;
#line 5499 "rygel-object-creator.c"
			}
		}
	} else if (_tmp3_ == g_quark_from_string (RYGEL_PLAYLIST_ITEM_UPNP_CLASS)) {
#line 621 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		switch (0) {
#line 5505 "rygel-object-creator.c"
			default:
			{
				const gchar* _tmp24_ = NULL;
				RygelWritableContainer* _tmp25_ = NULL;
				const gchar* _tmp26_ = NULL;
				RygelPlaylistItem* _tmp27_ = NULL;
#line 633 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp24_ = id;
#line 633 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp25_ = parent;
#line 633 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp26_ = title;
#line 633 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp27_ = rygel_playlist_item_new (_tmp24_, (RygelMediaContainer*) _tmp25_, _tmp26_, RYGEL_PLAYLIST_ITEM_UPNP_CLASS);
#line 633 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				result = (RygelMediaObject*) _tmp27_;
#line 633 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				return result;
#line 5524 "rygel-object-creator.c"
			}
		}
	} else if ((_tmp3_ == g_quark_from_string (RYGEL_MEDIA_CONTAINER_UPNP_CLASS)) || (_tmp3_ == g_quark_from_string (RYGEL_MEDIA_CONTAINER_STORAGE_FOLDER))) {
#line 621 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		switch (0) {
#line 5530 "rygel-object-creator.c"
			default:
			{
				const gchar* _tmp28_ = NULL;
				RygelWritableContainer* _tmp29_ = NULL;
				const gchar* _tmp30_ = NULL;
				RygelBaseMediaContainer* _tmp31_ = NULL;
#line 636 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp28_ = id;
#line 636 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp29_ = parent;
#line 636 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp30_ = title;
#line 636 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp31_ = rygel_base_media_container_new (_tmp28_, (RygelMediaContainer*) _tmp29_, _tmp30_, 0);
#line 636 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				result = (RygelMediaObject*) _tmp31_;
#line 636 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				return result;
#line 5549 "rygel-object-creator.c"
			}
		}
	} else if (_tmp3_ == g_quark_from_string (RYGEL_MEDIA_CONTAINER_PLAYLIST)) {
#line 621 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		switch (0) {
#line 5555 "rygel-object-creator.c"
			default:
			{
				RygelBaseMediaContainer* container = NULL;
				const gchar* _tmp32_ = NULL;
				RygelWritableContainer* _tmp33_ = NULL;
				const gchar* _tmp34_ = NULL;
				RygelBaseMediaContainer* _tmp35_ = NULL;
				RygelBaseMediaContainer* _tmp36_ = NULL;
				const gchar* _tmp37_ = NULL;
#line 638 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp32_ = id;
#line 638 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp33_ = parent;
#line 638 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp34_ = title;
#line 638 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp35_ = rygel_base_media_container_new (_tmp32_, (RygelMediaContainer*) _tmp33_, _tmp34_, 0);
#line 638 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				container = _tmp35_;
#line 639 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp36_ = container;
#line 639 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp37_ = upnp_class;
#line 639 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				rygel_media_object_set_upnp_class ((RygelMediaObject*) _tmp36_, _tmp37_);
#line 640 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				result = (RygelMediaObject*) container;
#line 640 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				return result;
#line 5585 "rygel-object-creator.c"
			}
		}
	} else {
#line 621 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		switch (0) {
#line 5591 "rygel-object-creator.c"
			default:
			{
				gchar* msg = NULL;
				const gchar* _tmp38_ = NULL;
				gchar* _tmp39_ = NULL;
				const gchar* _tmp40_ = NULL;
				const gchar* _tmp41_ = NULL;
				GError* _tmp42_ = NULL;
#line 642 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp38_ = _ ("Cannot create object of class '%s': Not supported");
#line 642 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp39_ = g_strdup (_tmp38_);
#line 642 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				msg = _tmp39_;
#line 643 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp40_ = msg;
#line 643 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp41_ = upnp_class;
#line 643 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_tmp42_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA, _tmp40_, _tmp41_);
#line 643 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_inner_error_ = _tmp42_;
#line 643 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				g_propagate_error (error, _inner_error_);
#line 643 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_g_free0 (msg);
#line 643 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				return NULL;
#line 5620 "rygel-object-creator.c"
			}
		}
	}
}


/**
     * Simple check for the validity of an URI.
     *
     * Check is done by parsing the URI with soup. Additionaly a cleaned-up
     * version of the URI is returned in sanitized_uri.
     *
     * @param uri the input URI
     * @param sanitized_uri containes a sanitized version of the URI on return
     * @returns true if the URI is valid, false otherwise.
     */
static void _vala_SoupURI_free (SoupURI* self) {
#line 666 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_boxed_free (soup_uri_get_type (), self);
#line 5640 "rygel-object-creator.c"
}


static gboolean rygel_object_creator_is_valid_uri (RygelObjectCreator* self, const gchar* uri, gchar** sanitized_uri) {
	gchar* _vala_sanitized_uri = NULL;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	SoupURI* soup_uri = NULL;
	const gchar* _tmp3_ = NULL;
	SoupURI* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	SoupURI* _tmp6_ = NULL;
	SoupURI* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
#line 657 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 658 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_free0 (_vala_sanitized_uri);
#line 658 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_vala_sanitized_uri = NULL;
#line 659 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp1_ = uri;
#line 659 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_tmp1_ == NULL) {
#line 659 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp0_ = TRUE;
#line 5668 "rygel-object-creator.c"
	} else {
		const gchar* _tmp2_ = NULL;
#line 659 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp2_ = uri;
#line 659 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp0_ = g_strcmp0 (_tmp2_, "") == 0;
#line 5675 "rygel-object-creator.c"
	}
#line 659 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_tmp0_) {
#line 660 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		result = FALSE;
#line 660 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (sanitized_uri) {
#line 660 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			*sanitized_uri = _vala_sanitized_uri;
#line 5685 "rygel-object-creator.c"
		} else {
#line 660 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_g_free0 (_vala_sanitized_uri);
#line 5689 "rygel-object-creator.c"
		}
#line 660 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return result;
#line 5693 "rygel-object-creator.c"
	}
#line 663 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp3_ = uri;
#line 663 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp4_ = soup_uri_new (_tmp3_);
#line 663 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	soup_uri = _tmp4_;
#line 665 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp6_ = soup_uri;
#line 665 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_tmp6_ == NULL) {
#line 665 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp5_ = TRUE;
#line 5707 "rygel-object-creator.c"
	} else {
		SoupURI* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
#line 665 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp7_ = soup_uri;
#line 665 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp8_ = _tmp7_->scheme;
#line 665 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_tmp5_ = _tmp8_ == NULL;
#line 5717 "rygel-object-creator.c"
	}
#line 665 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_tmp5_) {
#line 666 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		result = FALSE;
#line 666 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		__vala_SoupURI_free0 (soup_uri);
#line 666 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (sanitized_uri) {
#line 666 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			*sanitized_uri = _vala_sanitized_uri;
#line 5729 "rygel-object-creator.c"
		} else {
#line 666 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_g_free0 (_vala_sanitized_uri);
#line 5733 "rygel-object-creator.c"
		}
#line 666 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return result;
#line 5737 "rygel-object-creator.c"
	}
#line 669 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp9_ = soup_uri;
#line 669 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp10_ = soup_uri_to_string (_tmp9_, FALSE);
#line 669 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_free0 (_vala_sanitized_uri);
#line 669 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_vala_sanitized_uri = _tmp10_;
#line 671 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	result = TRUE;
#line 671 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	__vala_SoupURI_free0 (soup_uri);
#line 671 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (sanitized_uri) {
#line 671 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		*sanitized_uri = _vala_sanitized_uri;
#line 5755 "rygel-object-creator.c"
	} else {
#line 671 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_free0 (_vala_sanitized_uri);
#line 5759 "rygel-object-creator.c"
	}
#line 671 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	return result;
#line 5763 "rygel-object-creator.c"
}


/**
     * Transform the title to be usable on legacy file-systems such as FAT32.
     *
     * The function trims down the title to 205 chars (leaving room for an UUID)
     * and replaces all special characters.
     *
     * @param title of the the media item
     * @return the cleaned and shortened title
     */
static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1197 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1197 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1197 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1197 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1198 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1198 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 5795 "rygel-object-creator.c"
		glong _tmp4_ = 0L;
#line 1199 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1199 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1199 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 5803 "rygel-object-creator.c"
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 1201 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1201 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1201 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1201 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		return result;
#line 5815 "rygel-object-creator.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
#line 1208 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 5839 "rygel-object-creator.c"
		glong _tmp2_ = 0L;
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 5845 "rygel-object-creator.c"
	} else {
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 5849 "rygel-object-creator.c"
	}
#line 1210 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 5853 "rygel-object-creator.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
#line 1212 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp3_ = offset;
#line 1212 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp4_ = len;
#line 1212 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
#line 1212 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		string_length = _tmp5_;
#line 5865 "rygel-object-creator.c"
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 1214 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp6_ = strlen (self);
#line 1214 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp6_;
#line 1214 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp7_;
#line 5875 "rygel-object-creator.c"
	}
#line 1217 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp8_ = offset;
#line 1217 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp8_ < ((glong) 0)) {
#line 5881 "rygel-object-creator.c"
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1218 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp9_ = string_length;
#line 1218 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp10_ = offset;
#line 1218 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		offset = _tmp9_ + _tmp10_;
#line 1219 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1219 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
#line 5895 "rygel-object-creator.c"
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
#line 1221 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1221 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp13_ = string_length;
#line 1221 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
#line 5905 "rygel-object-creator.c"
	}
#line 1223 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp14_ = len;
#line 1223 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	if (_tmp14_ < ((glong) 0)) {
#line 5911 "rygel-object-creator.c"
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
#line 1224 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1224 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		_tmp16_ = offset;
#line 1224 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
		len = _tmp15_ - _tmp16_;
#line 5920 "rygel-object-creator.c"
	}
#line 1226 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp17_ = offset;
#line 1226 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp18_ = len;
#line 1226 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp19_ = string_length;
#line 1226 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp20_ = offset;
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp21_ = len;
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp22_;
#line 1227 "/home/jens/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 5940 "rygel-object-creator.c"
}


static gchar* uuid_get (void) {
	gchar* result = NULL;
	guchar* id = NULL;
	guchar* _tmp0_ = NULL;
	gint id_length1 = 0;
	gint _id_size_ = 0;
	guchar* unparsed = NULL;
	guchar* _tmp1_ = NULL;
	gint unparsed_length1 = 0;
	gint _unparsed_size_ = 0;
	guchar* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	guchar* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guchar* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	guchar* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	guchar _tmp6_ = '\0';
	guchar* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gchar* _tmp8_ = NULL;
#line 8 "../../src/librygel-core/uuid.vapi"
	_tmp0_ = g_new0 (guchar, 16);
#line 8 "../../src/librygel-core/uuid.vapi"
	id = _tmp0_;
#line 8 "../../src/librygel-core/uuid.vapi"
	id_length1 = 16;
#line 8 "../../src/librygel-core/uuid.vapi"
	_id_size_ = id_length1;
#line 9 "../../src/librygel-core/uuid.vapi"
	_tmp1_ = g_new0 (guchar, 51);
#line 9 "../../src/librygel-core/uuid.vapi"
	unparsed = _tmp1_;
#line 9 "../../src/librygel-core/uuid.vapi"
	unparsed_length1 = 51;
#line 9 "../../src/librygel-core/uuid.vapi"
	_unparsed_size_ = unparsed_length1;
#line 11 "../../src/librygel-core/uuid.vapi"
	_tmp2_ = id;
#line 11 "../../src/librygel-core/uuid.vapi"
	_tmp2__length1 = id_length1;
#line 11 "../../src/librygel-core/uuid.vapi"
	uuid_generate (_tmp2_);
#line 12 "../../src/librygel-core/uuid.vapi"
	_tmp3_ = id;
#line 12 "../../src/librygel-core/uuid.vapi"
	_tmp3__length1 = id_length1;
#line 12 "../../src/librygel-core/uuid.vapi"
	_tmp4_ = unparsed;
#line 12 "../../src/librygel-core/uuid.vapi"
	_tmp4__length1 = unparsed_length1;
#line 12 "../../src/librygel-core/uuid.vapi"
	uuid_unparse (_tmp3_, _tmp4_);
#line 13 "../../src/librygel-core/uuid.vapi"
	_tmp5_ = unparsed;
#line 13 "../../src/librygel-core/uuid.vapi"
	_tmp5__length1 = unparsed_length1;
#line 13 "../../src/librygel-core/uuid.vapi"
	_tmp5_[50] = (guchar) '\0';
#line 13 "../../src/librygel-core/uuid.vapi"
	_tmp6_ = _tmp5_[50];
#line 15 "../../src/librygel-core/uuid.vapi"
	_tmp7_ = unparsed;
#line 15 "../../src/librygel-core/uuid.vapi"
	_tmp7__length1 = unparsed_length1;
#line 15 "../../src/librygel-core/uuid.vapi"
	_tmp8_ = g_strdup ((const gchar*) _tmp7_);
#line 15 "../../src/librygel-core/uuid.vapi"
	result = _tmp8_;
#line 15 "../../src/librygel-core/uuid.vapi"
	unparsed = (g_free (unparsed), NULL);
#line 15 "../../src/librygel-core/uuid.vapi"
	id = (g_free (id), NULL);
#line 15 "../../src/librygel-core/uuid.vapi"
	return result;
#line 6020 "rygel-object-creator.c"
}


static gchar* rygel_object_creator_mangle_title (RygelObjectCreator* self, const gchar* title, GError** error) {
	gchar* result = NULL;
	gchar* mangled = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GRegex* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	GError * _inner_error_ = NULL;
#line 683 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 683 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 684 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp0_ = title;
#line 684 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp1_ = title;
#line 684 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp2_ = strlen (_tmp1_);
#line 684 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp3_ = _tmp2_;
#line 684 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp4_ = MIN (_tmp3_, 205);
#line 684 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp5_ = string_substring (_tmp0_, (glong) 0, (glong) _tmp4_);
#line 684 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	mangled = _tmp5_;
#line 685 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp7_ = self->priv->title_regex;
#line 685 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp8_ = mangled;
#line 685 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp9_ = g_regex_replace_literal (_tmp7_, _tmp8_, (gssize) (-1), 0, "_", G_REGEX_MATCH_NOTEMPTY, &_inner_error_);
#line 685 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp6_ = _tmp9_;
#line 685 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 685 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_propagate_error (error, _inner_error_);
#line 685 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_free0 (mangled);
#line 685 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return NULL;
#line 6080 "rygel-object-creator.c"
	}
#line 685 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp10_ = _tmp6_;
#line 685 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp6_ = NULL;
#line 685 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_free0 (mangled);
#line 685 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	mangled = _tmp10_;
#line 691 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp11_ = uuid_get ();
#line 691 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp12_ = _tmp11_;
#line 691 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp13_ = g_strconcat (_tmp12_, "-", NULL);
#line 691 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp14_ = _tmp13_;
#line 691 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp15_ = mangled;
#line 691 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp16_ = g_strconcat (_tmp14_, _tmp15_, NULL);
#line 691 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp17_ = _tmp16_;
#line 691 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_free0 (_tmp14_);
#line 691 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_free0 (_tmp12_);
#line 691 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	result = _tmp17_;
#line 691 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_free0 (_tmp6_);
#line 691 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_free0 (mangled);
#line 691 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	return result;
#line 6116 "rygel-object-creator.c"
}


static void rygel_object_creator_create_uri_data_free (gpointer _data) {
	RygelObjectCreatorCreateUriData* _data_;
	_data_ = _data;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (_data_->container);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_free0 (_data_->title);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_free0 (_data_->result);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (_data_->self);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_slice_free (RygelObjectCreatorCreateUriData, _data_);
#line 6133 "rygel-object-creator.c"
}


static void rygel_object_creator_create_uri (RygelObjectCreator* self, RygelWritableContainer* container, const gchar* title, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelObjectCreatorCreateUriData* _data_;
	RygelObjectCreator* _tmp0_ = NULL;
	RygelWritableContainer* _tmp1_ = NULL;
	RygelWritableContainer* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_ = g_slice_new0 (RygelObjectCreatorCreateUriData);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_object_creator_create_uri);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_object_creator_create_uri_data_free);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->self = _tmp0_;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp1_ = container;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (_data_->container);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->container = _tmp2_;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp3_ = title;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_free0 (_data_->title);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->title = _tmp4_;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	rygel_object_creator_create_uri_co (_data_);
#line 6172 "rygel-object-creator.c"
}


static gchar* rygel_object_creator_create_uri_finish (RygelObjectCreator* self, GAsyncResult* _res_, GError** error) {
	gchar* result;
	RygelObjectCreatorCreateUriData* _data_;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return NULL;
#line 6183 "rygel-object-creator.c"
	}
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	result = _data_->result;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->result = NULL;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	return result;
#line 6193 "rygel-object-creator.c"
}


/**
     * Create an URI from the item's title.
     *
     * Create an unique URI from the supplied title by cleaning it from
     * unwanted characters, shortening it and adding an UUID.
     *
     * @param container to create the item in
     * @param title of the item to base the name on
     * @returns an URI for the newly created item
     */
static void rygel_object_creator_create_uri_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelObjectCreatorCreateUriData* _data_;
#line 706 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_ = _user_data_;
#line 706 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_source_object_ = source_object;
#line 706 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_res_ = _res_;
#line 706 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	rygel_object_creator_create_uri_co (_data_);
#line 6217 "rygel-object-creator.c"
}


static gboolean rygel_object_creator_create_uri_co (RygelObjectCreatorCreateUriData* _data_) {
#line 704 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	switch (_data_->_state_) {
#line 704 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		case 0:
#line 6226 "rygel-object-creator.c"
		goto _state_0;
#line 704 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		case 1:
#line 6230 "rygel-object-creator.c"
		goto _state_1;
		default:
#line 704 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_assert_not_reached ();
#line 6235 "rygel-object-creator.c"
	}
	_state_0:
#line 706 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp0_ = NULL;
#line 706 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp0_ = _data_->container;
#line 706 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp1_ = NULL;
#line 706 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp1_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 706 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp2_ = NULL;
#line 706 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 706 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_state_ = 1;
#line 706 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	rygel_media_object_get_writable ((RygelMediaObject*) _data_->_tmp0_, _data_->_tmp2_, rygel_object_creator_create_uri_ready, _data_);
#line 706 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	return FALSE;
#line 6256 "rygel-object-creator.c"
	_state_1:
#line 706 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp3_ = NULL;
#line 706 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp3_ = rygel_media_object_get_writable_finish ((RygelMediaObject*) _data_->_tmp0_, _data_->_res_, &_data_->_inner_error_);
#line 706 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->dir = _data_->_tmp3_;
#line 706 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 706 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 706 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_error_free (_data_->_inner_error_);
#line 706 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (_data_->_state_ == 0) {
#line 706 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 6274 "rygel-object-creator.c"
		} else {
#line 706 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 6278 "rygel-object-creator.c"
		}
#line 706 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_object_unref (_data_->_async_result);
#line 706 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return FALSE;
#line 6284 "rygel-object-creator.c"
	}
#line 707 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp4_ = NULL;
#line 707 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp4_ = _data_->dir;
#line 707 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_data_->_tmp4_ == NULL) {
#line 708 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp5_ = NULL;
#line 708 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp5_ = _ ("Object creation in %s not allowed");
#line 708 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp6_ = NULL;
#line 708 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp6_ = _data_->container;
#line 708 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp7_ = NULL;
#line 708 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp7_ = rygel_media_object_get_id ((RygelMediaObject*) _data_->_tmp6_);
#line 708 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp8_ = NULL;
#line 708 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp8_ = _data_->_tmp7_;
#line 708 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp9_ = NULL;
#line 708 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp9_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT, _data_->_tmp5_, _data_->_tmp8_);
#line 708 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_inner_error_ = _data_->_tmp9_;
#line 708 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 708 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_error_free (_data_->_inner_error_);
#line 708 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_object_unref0 (_data_->dir);
#line 708 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (_data_->_state_ == 0) {
#line 708 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 6324 "rygel-object-creator.c"
		} else {
#line 708 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 6328 "rygel-object-creator.c"
		}
#line 708 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_object_unref (_data_->_async_result);
#line 708 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return FALSE;
#line 6334 "rygel-object-creator.c"
	}
#line 713 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp11_ = NULL;
#line 713 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp11_ = _data_->title;
#line 713 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp12_ = NULL;
#line 713 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp12_ = rygel_object_creator_mangle_title (_data_->self, _data_->_tmp11_, &_data_->_inner_error_);
#line 713 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp10_ = _data_->_tmp12_;
#line 713 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 713 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 713 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_error_free (_data_->_inner_error_);
#line 713 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_object_unref0 (_data_->dir);
#line 713 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (_data_->_state_ == 0) {
#line 713 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 6358 "rygel-object-creator.c"
		} else {
#line 713 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 6362 "rygel-object-creator.c"
		}
#line 713 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_object_unref (_data_->_async_result);
#line 713 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return FALSE;
#line 6368 "rygel-object-creator.c"
	}
#line 713 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp13_ = NULL;
#line 713 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp13_ = _data_->dir;
#line 713 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp14_ = NULL;
#line 713 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp14_ = g_file_get_child_for_display_name (_data_->_tmp13_, _data_->_tmp10_, &_data_->_inner_error_);
#line 713 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->file = _data_->_tmp14_;
#line 713 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 713 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 713 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_error_free (_data_->_inner_error_);
#line 713 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_free0 (_data_->_tmp10_);
#line 713 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_object_unref0 (_data_->dir);
#line 713 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (_data_->_state_ == 0) {
#line 713 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 6394 "rygel-object-creator.c"
		} else {
#line 713 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 6398 "rygel-object-creator.c"
		}
#line 713 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_object_unref (_data_->_async_result);
#line 713 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		return FALSE;
#line 6404 "rygel-object-creator.c"
	}
#line 715 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp15_ = NULL;
#line 715 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp15_ = _data_->file;
#line 715 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp16_ = NULL;
#line 715 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp16_ = g_file_get_uri (_data_->_tmp15_);
#line 715 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->result = _data_->_tmp16_;
#line 715 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (_data_->file);
#line 715 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_free0 (_data_->_tmp10_);
#line 715 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (_data_->dir);
#line 715 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_data_->_state_ == 0) {
#line 715 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 6426 "rygel-object-creator.c"
	} else {
#line 715 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 6430 "rygel-object-creator.c"
	}
#line 715 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_object_unref (_data_->_async_result);
#line 715 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	return FALSE;
#line 704 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (_data_->file);
#line 704 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_free0 (_data_->_tmp10_);
#line 704 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (_data_->dir);
#line 704 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_data_->_state_ == 0) {
#line 704 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 6446 "rygel-object-creator.c"
	} else {
#line 704 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 6450 "rygel-object-creator.c"
	}
#line 704 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_object_unref (_data_->_async_result);
#line 704 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	return FALSE;
#line 6456 "rygel-object-creator.c"
}


static void rygel_object_creator_wait_for_object_data_free (gpointer _data) {
	RygelObjectCreatorWaitForObjectData* _data_;
	_data_ = _data;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (_data_->self);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_slice_free (RygelObjectCreatorWaitForObjectData, _data_);
#line 6467 "rygel-object-creator.c"
}


static void rygel_object_creator_wait_for_object (RygelObjectCreator* self, RygelWritableContainer* container, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelObjectCreatorWaitForObjectData* _data_;
	RygelObjectCreator* _tmp0_ = NULL;
	RygelWritableContainer* _tmp1_ = NULL;
	RygelWritableContainer* _tmp2_ = NULL;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_ = g_slice_new0 (RygelObjectCreatorWaitForObjectData);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_object_creator_wait_for_object);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_object_creator_wait_for_object_data_free);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->self = _tmp0_;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp1_ = container;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (_data_->container);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->container = _tmp2_;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	rygel_object_creator_wait_for_object_co (_data_);
#line 6496 "rygel-object-creator.c"
}


static void rygel_object_creator_wait_for_object_finish (RygelObjectCreator* self, GAsyncResult* _res_) {
	RygelObjectCreatorWaitForObjectData* _data_;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 6504 "rygel-object-creator.c"
}


/**
     * Wait for the new object
     *
     * When creating an object in the back-end via WritableContainer.add_item
     * or WritableContainer.add_container there might be a delay between the
     * creation and the back-end having the newly created item available. This
     * function waits for the item to become available by hooking into the
     * container_updated signal. The maximum time to wait is 5 seconds.
     *
     * @param container to watch
     */
static Block8Data* block8_data_ref (Block8Data* _data8_) {
#line 729 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_atomic_int_inc (&_data8_->_ref_count_);
#line 729 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	return _data8_;
#line 6524 "rygel-object-creator.c"
}


static void block8_data_unref (void * _userdata_) {
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
#line 729 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
#line 6533 "rygel-object-creator.c"
		RygelObjectCreator* self;
#line 729 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		self = _data8_->self;
#line 729 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_object_unref0 (_data8_->container);
#line 729 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_g_object_unref0 (self);
#line 729 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_slice_free (Block8Data, _data8_);
#line 6543 "rygel-object-creator.c"
	}
}


static void rygel_object_creator_wait_for_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelObjectCreatorWaitForObjectData* _data_;
#line 737 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_ = _user_data_;
#line 737 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_source_object_ = source_object;
#line 737 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_res_ = _res_;
#line 737 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	rygel_object_creator_wait_for_object_co (_data_);
#line 6558 "rygel-object-creator.c"
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
#line 744 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_atomic_int_inc (&_data9_->_ref_count_);
#line 744 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	return _data9_;
#line 6567 "rygel-object-creator.c"
}


static void block9_data_unref (void * _userdata_) {
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
#line 744 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
#line 6576 "rygel-object-creator.c"
		RygelObjectCreator* self;
#line 744 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		self = _data9_->_data8_->self;
#line 744 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		block8_data_unref (_data9_->_data8_);
#line 744 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data9_->_data8_ = NULL;
#line 744 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_slice_free (Block9Data, _data9_);
#line 6586 "rygel-object-creator.c"
	}
}


static void ____lambda13_ (Block9Data* _data9_, RygelMediaContainer* container) {
	Block8Data* _data8_;
	RygelObjectCreator* self;
#line 745 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data8_ = _data9_->_data8_;
#line 745 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	self = _data8_->self;
#line 745 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_return_if_fail (container != NULL);
#line 746 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	rygel_object_creator_wait_for_object_co (_data8_->_async_data_);
#line 6602 "rygel-object-creator.c"
}


static void _____lambda13__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update, gpointer self) {
#line 745 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	____lambda13_ (self, container);
#line 6609 "rygel-object-creator.c"
}


static gboolean ____lambda14_ (Block9Data* _data9_) {
	Block8Data* _data8_;
	RygelObjectCreator* self;
	gboolean result = FALSE;
	RygelWritableContainer* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
#line 750 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data8_ = _data9_->_data8_;
#line 750 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	self = _data8_->self;
#line 751 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp0_ = _data8_->container;
#line 751 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp1_ = rygel_media_object_get_id ((RygelMediaObject*) _tmp0_);
#line 751 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp2_ = _tmp1_;
#line 751 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_debug ("rygel-object-creator.vala:751: Timeout on waiting for 'updated' signal" \
" on '%s'.", _tmp2_);
#line 753 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data9_->timeout = (guint) 0;
#line 754 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	rygel_object_creator_wait_for_object_co (_data8_->_async_data_);
#line 756 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	result = FALSE;
#line 756 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	return result;
#line 6640 "rygel-object-creator.c"
}


static gboolean _____lambda14__gsource_func (gpointer self) {
	gboolean result;
	result = ____lambda14_ (self);
#line 750 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	return result;
#line 6649 "rygel-object-creator.c"
}


static gboolean rygel_object_creator_wait_for_object_co (RygelObjectCreatorWaitForObjectData* _data_) {
#line 729 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	switch (_data_->_state_) {
#line 729 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		case 0:
#line 6658 "rygel-object-creator.c"
		goto _state_0;
#line 729 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		case 1:
#line 6662 "rygel-object-creator.c"
		goto _state_1;
#line 729 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		case 2:
#line 6666 "rygel-object-creator.c"
		goto _state_2;
		default:
#line 729 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_assert_not_reached ();
#line 6671 "rygel-object-creator.c"
	}
	_state_0:
#line 729 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_data8_ = g_slice_new0 (Block8Data);
#line 729 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_data8_->_ref_count_ = 1;
#line 729 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_data8_->self = g_object_ref (_data_->self);
#line 729 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp0_ = NULL;
#line 729 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp0_ = _data_->container;
#line 729 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (_data_->_data8_->container);
#line 729 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_data8_->container = _data_->_tmp0_;
#line 729 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_data8_->_async_data_ = _data_;
#line 730 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp1_ = NULL;
#line 730 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp1_ = _data_->_data8_->container;
#line 730 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp2_ = NULL;
#line 730 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp2_ = rygel_media_object_get_id ((RygelMediaObject*) _data_->_tmp1_);
#line 730 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp3_ = NULL;
#line 730 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp3_ = _data_->_tmp2_;
#line 730 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_debug ("rygel-object-creator.vala:730: Waiting for new object to appear under " \
"container '%s'…", _data_->_tmp3_);
#line 733 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->object = NULL;
#line 735 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	while (TRUE) {
#line 735 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp4_ = NULL;
#line 735 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp4_ = _data_->object;
#line 735 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (!(_data_->_tmp4_ == NULL)) {
#line 735 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			break;
#line 6716 "rygel-object-creator.c"
		}
		{
#line 737 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp6_ = NULL;
#line 737 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp6_ = _data_->_data8_->container;
#line 737 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp7_ = NULL;
#line 737 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp7_ = _data_->self->priv->object;
#line 737 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp8_ = NULL;
#line 737 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp8_ = rygel_media_object_get_id (_data_->_tmp7_);
#line 737 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp9_ = NULL;
#line 737 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp9_ = _data_->_tmp8_;
#line 737 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp10_ = NULL;
#line 737 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp10_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 737 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp11_ = NULL;
#line 737 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp11_ = _data_->_tmp10_;
#line 737 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_state_ = 1;
#line 737 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			rygel_media_container_find_object ((RygelMediaContainer*) _data_->_tmp6_, _data_->_tmp9_, _data_->_tmp11_, rygel_object_creator_wait_for_object_ready, _data_);
#line 737 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			return FALSE;
#line 6749 "rygel-object-creator.c"
			_state_1:
#line 737 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp12_ = NULL;
#line 737 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp12_ = rygel_media_container_find_object_finish ((RygelMediaContainer*) _data_->_tmp6_, _data_->_res_, &_data_->_inner_error_);
#line 737 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp5_ = _data_->_tmp12_;
#line 737 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 6759 "rygel-object-creator.c"
				goto __catch63_g_error;
			}
#line 737 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp13_ = NULL;
#line 737 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp13_ = _data_->_tmp5_;
#line 737 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp5_ = NULL;
#line 737 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_g_object_unref0 (_data_->object);
#line 737 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->object = _data_->_tmp13_;
#line 736 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_g_object_unref0 (_data_->_tmp5_);
#line 6774 "rygel-object-creator.c"
		}
		goto __finally63;
		__catch63_g_error:
		{
#line 736 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_error_ = _data_->_inner_error_;
#line 736 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_inner_error_ = NULL;
#line 740 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp14_ = NULL;
#line 740 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp14_ = _ ("Error from container '%s' on trying to find the newly added child obje" \
"ct '%s' in it: %s");
#line 740 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp15_ = NULL;
#line 740 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp15_ = g_strdup (_data_->_tmp14_);
#line 740 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->msg = _data_->_tmp15_;
#line 741 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp16_ = NULL;
#line 741 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp16_ = _data_->msg;
#line 741 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp17_ = NULL;
#line 741 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp17_ = _data_->_data8_->container;
#line 741 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp18_ = NULL;
#line 741 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp18_ = rygel_media_object_get_id ((RygelMediaObject*) _data_->_tmp17_);
#line 741 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp19_ = NULL;
#line 741 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp19_ = _data_->_tmp18_;
#line 741 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp20_ = NULL;
#line 741 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp20_ = _data_->self->priv->object;
#line 741 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp21_ = NULL;
#line 741 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp21_ = rygel_media_object_get_id (_data_->_tmp20_);
#line 741 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp22_ = NULL;
#line 741 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp22_ = _data_->_tmp21_;
#line 741 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp23_ = NULL;
#line 741 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp23_ = _data_->_error_;
#line 741 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp24_ = NULL;
#line 741 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp24_ = _data_->_tmp23_->message;
#line 741 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_warning (_data_->_tmp16_, _data_->_tmp19_, _data_->_tmp22_, _data_->_tmp24_);
#line 736 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_g_free0 (_data_->msg);
#line 736 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_g_error_free0 (_data_->_error_);
#line 6835 "rygel-object-creator.c"
		}
		__finally63:
#line 736 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 736 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_g_object_unref0 (_data_->object);
#line 736 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			block8_data_unref (_data_->_data8_);
#line 736 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_data8_ = NULL;
#line 736 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 736 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_clear_error (&_data_->_inner_error_);
#line 736 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			return FALSE;
#line 6852 "rygel-object-creator.c"
		}
#line 744 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp25_ = NULL;
#line 744 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		_data_->_tmp25_ = _data_->object;
#line 744 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		if (_data_->_tmp25_ == NULL) {
#line 744 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_data9_ = g_slice_new0 (Block9Data);
#line 744 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_data9_->_ref_count_ = 1;
#line 744 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_data9_->_data8_ = block8_data_ref (_data_->_data8_);
#line 745 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp26_ = NULL;
#line 745 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp26_ = _data_->_data8_->container;
#line 745 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp27_ = 0UL;
#line 745 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp27_ = g_signal_connect_data ((RygelMediaContainer*) _data_->_tmp26_, "container-updated", (GCallback) _____lambda13__rygel_media_container_container_updated, block9_data_ref (_data_->_data9_), (GClosureNotify) block9_data_unref, 0);
#line 745 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->id = _data_->_tmp27_;
#line 749 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_data9_->timeout = (guint) 0;
#line 750 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp28_ = 0U;
#line 750 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp28_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, _____lambda14__gsource_func, block9_data_ref (_data_->_data9_), block9_data_unref);
#line 750 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_data9_->timeout = _data_->_tmp28_;
#line 759 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_state_ = 2;
#line 759 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			return FALSE;
#line 6888 "rygel-object-creator.c"
			_state_2:
			;
#line 761 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp29_ = NULL;
#line 761 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp29_ = _data_->_data8_->container;
#line 761 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp30_ = 0UL;
#line 761 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp30_ = _data_->id;
#line 761 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			g_signal_handler_disconnect ((GObject*) _data_->_tmp29_, _data_->_tmp30_);
#line 763 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp31_ = 0U;
#line 763 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_tmp31_ = _data_->_data9_->timeout;
#line 763 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			if (_data_->_tmp31_ != ((guint) 0)) {
#line 764 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_data_->_tmp32_ = 0U;
#line 764 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_data_->_tmp32_ = _data_->_data9_->timeout;
#line 764 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				g_source_remove (_data_->_tmp32_);
#line 6913 "rygel-object-creator.c"
			} else {
#line 766 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				block9_data_unref (_data_->_data9_);
#line 766 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				_data_->_data9_ = NULL;
#line 766 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
				break;
#line 6921 "rygel-object-creator.c"
			}
#line 744 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			block9_data_unref (_data_->_data9_);
#line 744 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
			_data_->_data9_ = NULL;
#line 6927 "rygel-object-creator.c"
		}
	}
#line 770 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp33_ = NULL;
#line 770 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp33_ = _data_->_data8_->container;
#line 770 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp34_ = NULL;
#line 770 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp34_ = rygel_media_object_get_id ((RygelMediaObject*) _data_->_tmp33_);
#line 770 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp35_ = NULL;
#line 770 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp35_ = _data_->_tmp34_;
#line 770 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_debug ("rygel-object-creator.vala:770: Finished waiting for new object to appe" \
"ar under container '%s'", _data_->_tmp35_);
#line 773 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp36_ = NULL;
#line 773 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp36_ = _data_->object;
#line 773 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp37_ = NULL;
#line 773 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_tmp37_ = _g_object_ref0 (_data_->_tmp36_);
#line 773 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (_data_->self->priv->object);
#line 773 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->self->priv->object = _data_->_tmp37_;
#line 729 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (_data_->object);
#line 729 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	block8_data_unref (_data_->_data8_);
#line 729 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_data_->_data8_ = NULL;
#line 729 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	if (_data_->_state_ == 0) {
#line 729 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 6966 "rygel-object-creator.c"
	} else {
#line 729 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 6970 "rygel-object-creator.c"
	}
#line 729 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_object_unref (_data_->_async_result);
#line 729 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	return FALSE;
#line 6976 "rygel-object-creator.c"
}


/**
     * Check if the profile is supported.
     *
     * The check is performed against the MediaEngine's database explicitly excluding
     * the transcoders.
     *
     * @param profile to check
     * @returns true if the profile is supported, false otherwise.
     */
static gint _rygel_dlna_profile_compare_by_name_gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = rygel_dlna_profile_compare_by_name ((RygelDLNAProfile*) a, (RygelDLNAProfile*) b);
#line 792 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	return result;
#line 6994 "rygel-object-creator.c"
}


static gboolean rygel_object_creator_is_profile_valid (RygelObjectCreator* self, const gchar* profile) {
	gboolean result = FALSE;
	GList* profiles = NULL;
	GList* _result_ = NULL;
	RygelMediaServerPlugin* plugin = NULL;
	RygelContentDirectory* _tmp0_ = NULL;
	GUPnPRootDevice* _tmp1_ = NULL;
	GUPnPRootDevice* _tmp2_ = NULL;
	GUPnPRootDevice* _tmp3_ = NULL;
	GUPnPResourceFactory* _tmp4_ = NULL;
	GUPnPResourceFactory* _tmp5_ = NULL;
	RygelMediaServerPlugin* _tmp6_ = NULL;
	RygelMediaServerPlugin* _tmp7_ = NULL;
	GList* _tmp8_ = NULL;
	GList* _tmp9_ = NULL;
	RygelDLNAProfile* p = NULL;
	const gchar* _tmp10_ = NULL;
	RygelDLNAProfile* _tmp11_ = NULL;
	GList* _tmp12_ = NULL;
#line 785 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 785 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_return_val_if_fail (profile != NULL, FALSE);
#line 788 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp0_ = self->priv->content_dir;
#line 788 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_object_get ((GUPnPService*) _tmp0_, "root-device", &_tmp1_, NULL);
#line 788 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp2_ = _tmp1_;
#line 788 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp3_ = _tmp2_;
#line 788 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp4_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _tmp3_);
#line 788 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp5_ = _tmp4_;
#line 788 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, RYGEL_TYPE_MEDIA_SERVER_PLUGIN) ? ((RygelMediaServerPlugin*) _tmp5_) : NULL);
#line 788 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp7_ = _tmp6_;
#line 788 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (_tmp3_);
#line 788 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	plugin = _tmp7_;
#line 789 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp8_ = rygel_media_server_plugin_get_upload_profiles (plugin);
#line 789 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp9_ = _tmp8_;
#line 789 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	profiles = _tmp9_;
#line 790 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp10_ = profile;
#line 790 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp11_ = rygel_dlna_profile_new (_tmp10_, "");
#line 790 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	p = _tmp11_;
#line 792 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp12_ = g_list_find_custom (profiles, p, _rygel_dlna_profile_compare_by_name_gcompare_func);
#line 792 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_result_ = _tmp12_;
#line 794 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	result = _result_ != NULL;
#line 794 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_rygel_dlna_profile_unref0 (p);
#line 794 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (plugin);
#line 794 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	return result;
#line 7065 "rygel-object-creator.c"
}


static GCancellable* rygel_object_creator_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelObjectCreator* self;
	GCancellable* _tmp0_ = NULL;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	self = (RygelObjectCreator*) base;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp0_ = self->priv->_cancellable;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	result = _tmp0_;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	return result;
#line 7081 "rygel-object-creator.c"
}


static void rygel_object_creator_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelObjectCreator* self;
	GCancellable* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	self = (RygelObjectCreator*) base;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp0_ = value;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	self->priv->_cancellable = _tmp1_;
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_object_notify ((GObject *) self, "cancellable");
#line 7101 "rygel-object-creator.c"
}


static void rygel_object_creator_class_init (RygelObjectCreatorClass * klass) {
	GPatternSpec* _tmp0_ = NULL;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	rygel_object_creator_parent_class = g_type_class_peek_parent (klass);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_type_class_add_private (klass, sizeof (RygelObjectCreatorPrivate));
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_object_creator_get_property;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_object_creator_set_property;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_object_creator_finalize;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_OBJECT_CREATOR_CANCELLABLE, g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_tmp0_ = g_pattern_spec_new ("*<!--*-->*");
#line 90 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	rygel_object_creator_comment_pattern = _tmp0_;
#line 7123 "rygel-object-creator.c"
}


static void rygel_object_creator_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	rygel_object_creator_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	iface->run = (void (*)(RygelStateMachine*)) rygel_object_creator_real_run;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	iface->run_finish = rygel_object_creator_real_run_finish;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	iface->get_cancellable = rygel_object_creator_real_get_cancellable;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	iface->set_cancellable = rygel_object_creator_real_set_cancellable;
#line 7138 "rygel-object-creator.c"
}


static void rygel_object_creator_instance_init (RygelObjectCreator * self) {
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	self->priv = RYGEL_OBJECT_CREATOR_GET_PRIVATE (self);
#line 7145 "rygel-object-creator.c"
}


static void rygel_object_creator_finalize (GObject* obj) {
	RygelObjectCreator * self;
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_OBJECT_CREATOR, RygelObjectCreator);
#line 95 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_free0 (self->priv->container_id);
#line 96 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_free0 (self->priv->elements);
#line 98 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (self->priv->didl_object);
#line 99 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (self->priv->object);
#line 101 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (self->priv->content_dir);
#line 102 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	__vala_GUPnPServiceAction_free0 (self->priv->action);
#line 103 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (self->priv->serializer);
#line 104 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (self->priv->didl_parser);
#line 105 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_regex_unref0 (self->priv->title_regex);
#line 107 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	G_OBJECT_CLASS (rygel_object_creator_parent_class)->finalize (obj);
#line 7175 "rygel-object-creator.c"
}


/**
 * CreateObject action implementation.
 */
GType rygel_object_creator_get_type (void) {
	static volatile gsize rygel_object_creator_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_object_creator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelObjectCreatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_object_creator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelObjectCreator), 0, (GInstanceInitFunc) rygel_object_creator_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_object_creator_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_object_creator_type_id;
		rygel_object_creator_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelObjectCreator", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_object_creator_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_object_creator_type_id__volatile, rygel_object_creator_type_id);
	}
	return rygel_object_creator_type_id__volatile;
}


static void _vala_rygel_object_creator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelObjectCreator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_OBJECT_CREATOR, RygelObjectCreator);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	switch (property_id) {
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		case RYGEL_OBJECT_CREATOR_CANCELLABLE:
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		break;
#line 7207 "rygel-object-creator.c"
		default:
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		break;
#line 7213 "rygel-object-creator.c"
	}
}


static void _vala_rygel_object_creator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelObjectCreator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_OBJECT_CREATOR, RygelObjectCreator);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
	switch (property_id) {
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		case RYGEL_OBJECT_CREATOR_CANCELLABLE:
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		break;
#line 7229 "rygel-object-creator.c"
		default:
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 89 "/home/jens/Source/rygel/src/librygel-server/rygel-object-creator.vala"
		break;
#line 7235 "rygel-object-creator.c"
	}
}



