/* rygel-simple-data-source.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from rygel-simple-data-source.vala, do not modify */

/*
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-server.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>


#define RYGEL_TYPE_SIMPLE_DATA_SOURCE (rygel_simple_data_source_get_type ())
#define RYGEL_SIMPLE_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SIMPLE_DATA_SOURCE, RygelSimpleDataSource))
#define RYGEL_SIMPLE_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SIMPLE_DATA_SOURCE, RygelSimpleDataSourceClass))
#define RYGEL_IS_SIMPLE_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SIMPLE_DATA_SOURCE))
#define RYGEL_IS_SIMPLE_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SIMPLE_DATA_SOURCE))
#define RYGEL_SIMPLE_DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SIMPLE_DATA_SOURCE, RygelSimpleDataSourceClass))

typedef struct _RygelSimpleDataSource RygelSimpleDataSource;
typedef struct _RygelSimpleDataSourceClass RygelSimpleDataSourceClass;
typedef struct _RygelSimpleDataSourcePrivate RygelSimpleDataSourcePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelSimpleDataSource {
	GObject parent_instance;
	RygelSimpleDataSourcePrivate * priv;
};

struct _RygelSimpleDataSourceClass {
	GObjectClass parent_class;
};

struct _RygelSimpleDataSourcePrivate {
	gchar* uri;
	GThread* thread;
	GMutex mutex;
	GCond cond;
	off_t first_byte;
	off_t last_byte;
	gboolean frozen;
	gboolean stop_thread;
};

struct _Block1Data {
	int _ref_count_;
	RygelSimpleDataSource* self;
	guint8* slice;
	gint slice_length1;
	gint _slice_size_;
};


static gpointer rygel_simple_data_source_parent_class = NULL;
static RygelDataSourceIface* rygel_simple_data_source_rygel_data_source_parent_iface = NULL;

GType rygel_simple_data_source_get_type (void) G_GNUC_CONST;
#define RYGEL_SIMPLE_DATA_SOURCE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_SIMPLE_DATA_SOURCE, RygelSimpleDataSourcePrivate))
enum  {
	RYGEL_SIMPLE_DATA_SOURCE_DUMMY_PROPERTY
};
RygelSimpleDataSource* rygel_simple_data_source_new (const gchar* uri);
RygelSimpleDataSource* rygel_simple_data_source_construct (GType object_type, const gchar* uri);
static GeeList* rygel_simple_data_source_real_preroll (RygelDataSource* base, RygelHTTPSeekRequest* seek_request, RygelPlaySpeedRequest* playspeed_request, GError** error);
static void rygel_simple_data_source_real_start (RygelDataSource* base, GError** error);
static void* rygel_simple_data_source_thread_func (RygelSimpleDataSource* self);
static gpointer _rygel_simple_data_source_thread_func_gthread_func (gpointer self);
static void rygel_simple_data_source_real_freeze (RygelDataSource* base);
static void rygel_simple_data_source_real_thaw (RygelDataSource* base);
static void rygel_simple_data_source_real_stop (RygelDataSource* base);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean ____lambda4_ (Block1Data* _data1_);
static gboolean _____lambda4__gsource_func (gpointer self);
static gboolean __lambda5_ (RygelSimpleDataSource* self);
static gboolean ___lambda5__gsource_func (gpointer self);
static void rygel_simple_data_source_finalize (GObject* obj);
static void _vala_clear_GMutex (GMutex * mutex);
static void _vala_clear_GRecMutex (GRecMutex * mutex);
static void _vala_clear_GRWLock (GRWLock * mutex);
static void _vala_clear_GCond (GCond * mutex);


RygelSimpleDataSource* rygel_simple_data_source_construct (GType object_type, const gchar* uri) {
	RygelSimpleDataSource * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 44 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 44 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	self = (RygelSimpleDataSource*) g_object_new (object_type, NULL);
#line 45 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	_tmp0_ = uri;
#line 45 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	g_debug ("rygel-simple-data-source.vala:45: Creating new data source for %s", _tmp0_);
#line 46 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	_tmp1_ = uri;
#line 46 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 46 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	_g_free0 (self->priv->uri);
#line 46 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	self->priv->uri = _tmp2_;
#line 44 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	return self;
#line 141 "rygel-simple-data-source.c"
}


RygelSimpleDataSource* rygel_simple_data_source_new (const gchar* uri) {
#line 44 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	return rygel_simple_data_source_construct (RYGEL_TYPE_SIMPLE_DATA_SOURCE, uri);
#line 148 "rygel-simple-data-source.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 64 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	return self ? g_object_ref (self) : NULL;
#line 155 "rygel-simple-data-source.c"
}


static GeeList* rygel_simple_data_source_real_preroll (RygelDataSource* base, RygelHTTPSeekRequest* seek_request, RygelPlaySpeedRequest* playspeed_request, GError** error) {
	RygelSimpleDataSource * self;
	GeeList* result = NULL;
	GeeArrayList* response_list = NULL;
	GeeArrayList* _tmp0_ = NULL;
	RygelHTTPSeekRequest* _tmp1_ = NULL;
	RygelPlaySpeedRequest* _tmp24_ = NULL;
	GError * _inner_error_ = NULL;
#line 53 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	self = (RygelSimpleDataSource*) base;
#line 56 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	_tmp0_ = gee_array_list_new (RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 56 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	response_list = _tmp0_;
#line 58 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	_tmp1_ = seek_request;
#line 58 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	if (_tmp1_ != NULL) {
#line 177 "rygel-simple-data-source.c"
		RygelHTTPSeekRequest* _tmp2_ = NULL;
		RygelHTTPByteSeekRequest* byte_seek = NULL;
		RygelHTTPSeekRequest* _tmp5_ = NULL;
		RygelHTTPByteSeekRequest* _tmp6_ = NULL;
		RygelHTTPByteSeekRequest* _tmp7_ = NULL;
		gint64 _tmp8_ = 0LL;
		gint64 _tmp9_ = 0LL;
		RygelHTTPByteSeekRequest* _tmp10_ = NULL;
		gint64 _tmp11_ = 0LL;
		gint64 _tmp12_ = 0LL;
		RygelHTTPByteSeekRequest* _tmp13_ = NULL;
		gint64 _tmp14_ = 0LL;
		gint64 _tmp15_ = 0LL;
		RygelHTTPByteSeekRequest* _tmp16_ = NULL;
		gint64 _tmp17_ = 0LL;
		gint64 _tmp18_ = 0LL;
		const gchar* _tmp19_ = NULL;
		RygelHTTPByteSeekResponse* seek_response = NULL;
		RygelHTTPByteSeekRequest* _tmp20_ = NULL;
		RygelHTTPByteSeekResponse* _tmp21_ = NULL;
		GeeArrayList* _tmp22_ = NULL;
		RygelHTTPByteSeekResponse* _tmp23_ = NULL;
#line 59 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_tmp2_ = seek_request;
#line 59 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST)) {
#line 204 "rygel-simple-data-source.c"
			const gchar* _tmp3_ = NULL;
			GError* _tmp4_ = NULL;
#line 60 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_tmp3_ = _ ("Only byte-based seek supported");
#line 60 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_tmp4_ = g_error_new_literal (RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_SEEK_FAILED, _tmp3_);
#line 60 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_inner_error_ = _tmp4_;
#line 60 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			g_propagate_error (error, _inner_error_);
#line 60 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_g_object_unref0 (response_list);
#line 60 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			return NULL;
#line 219 "rygel-simple-data-source.c"
		}
#line 64 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_tmp5_ = seek_request;
#line 64 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, RYGEL_TYPE_HTTP_BYTE_SEEK_REQUEST) ? ((RygelHTTPByteSeekRequest*) _tmp5_) : NULL);
#line 64 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		byte_seek = _tmp6_;
#line 65 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_tmp7_ = byte_seek;
#line 65 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_tmp8_ = rygel_http_byte_seek_request_get_start_byte (_tmp7_);
#line 65 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_tmp9_ = _tmp8_;
#line 65 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		self->priv->first_byte = (off_t) _tmp9_;
#line 66 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_tmp10_ = byte_seek;
#line 66 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_tmp11_ = rygel_http_byte_seek_request_get_end_byte (_tmp10_);
#line 66 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_tmp12_ = _tmp11_;
#line 66 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		self->priv->last_byte = (off_t) (_tmp12_ + 1);
#line 67 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_tmp13_ = byte_seek;
#line 67 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_tmp14_ = rygel_http_byte_seek_request_get_start_byte (_tmp13_);
#line 67 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_tmp15_ = _tmp14_;
#line 67 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_tmp16_ = byte_seek;
#line 67 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_tmp17_ = rygel_http_byte_seek_request_get_end_byte (_tmp16_);
#line 67 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_tmp18_ = _tmp17_;
#line 67 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_tmp19_ = self->priv->uri;
#line 67 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		g_debug ("rygel-simple-data-source.vala:67: Processing byte seek request for byt" \
"es %lld-%lld of %s", _tmp15_, _tmp18_, _tmp19_);
#line 69 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_tmp20_ = byte_seek;
#line 69 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_tmp21_ = rygel_http_byte_seek_response_new_from_request (_tmp20_);
#line 69 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		seek_response = _tmp21_;
#line 71 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_tmp22_ = response_list;
#line 71 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_tmp23_ = seek_response;
#line 71 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, (RygelHTTPResponseElement*) _tmp23_);
#line 58 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_g_object_unref0 (seek_response);
#line 58 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_g_object_unref0 (byte_seek);
#line 275 "rygel-simple-data-source.c"
	} else {
#line 73 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		self->priv->first_byte = (off_t) 0;
#line 74 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		self->priv->last_byte = (off_t) 0;
#line 281 "rygel-simple-data-source.c"
	}
#line 77 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	_tmp24_ = playspeed_request;
#line 77 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	if (_tmp24_ != NULL) {
#line 287 "rygel-simple-data-source.c"
		const gchar* _tmp25_ = NULL;
		GError* _tmp26_ = NULL;
#line 78 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_tmp25_ = _ ("Playspeed not supported");
#line 78 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_tmp26_ = g_error_new_literal (RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_PLAYSPEED_FAILED, _tmp25_);
#line 78 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_inner_error_ = _tmp26_;
#line 78 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		g_propagate_error (error, _inner_error_);
#line 78 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_g_object_unref0 (response_list);
#line 78 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		return NULL;
#line 302 "rygel-simple-data-source.c"
	}
#line 82 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	result = (GeeList*) response_list;
#line 82 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	return result;
#line 308 "rygel-simple-data-source.c"
}


static gpointer _rygel_simple_data_source_thread_func_gthread_func (gpointer self) {
	gpointer result;
	result = rygel_simple_data_source_thread_func ((RygelSimpleDataSource*) self);
#line 89 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	g_object_unref (self);
#line 89 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	return result;
#line 319 "rygel-simple-data-source.c"
}


static void rygel_simple_data_source_real_start (RygelDataSource* base, GError** error) {
	RygelSimpleDataSource * self;
	const gchar* _tmp0_ = NULL;
	GThread* _tmp1_ = NULL;
#line 85 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	self = (RygelSimpleDataSource*) base;
#line 86 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	_tmp0_ = self->priv->uri;
#line 86 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	g_debug ("rygel-simple-data-source.vala:86: Starting data source for uri %s", _tmp0_);
#line 89 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	_tmp1_ = g_thread_new ("Rygel Serving thread", _rygel_simple_data_source_thread_func_gthread_func, g_object_ref (self));
#line 89 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	_g_thread_unref0 (self->priv->thread);
#line 89 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	self->priv->thread = _tmp1_;
#line 339 "rygel-simple-data-source.c"
}


static void rygel_simple_data_source_real_freeze (RygelDataSource* base) {
	RygelSimpleDataSource * self;
	gboolean _tmp0_ = FALSE;
#line 93 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	self = (RygelSimpleDataSource*) base;
#line 94 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	g_mutex_lock (&self->priv->mutex);
#line 95 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	_tmp0_ = self->priv->frozen;
#line 95 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	if (!_tmp0_) {
#line 96 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		self->priv->frozen = TRUE;
#line 356 "rygel-simple-data-source.c"
	}
#line 99 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	g_mutex_unlock (&self->priv->mutex);
#line 360 "rygel-simple-data-source.c"
}


static void rygel_simple_data_source_real_thaw (RygelDataSource* base) {
	RygelSimpleDataSource * self;
	gboolean _tmp0_ = FALSE;
#line 102 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	self = (RygelSimpleDataSource*) base;
#line 103 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	g_mutex_lock (&self->priv->mutex);
#line 104 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	_tmp0_ = self->priv->frozen;
#line 104 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	if (_tmp0_) {
#line 105 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		self->priv->frozen = FALSE;
#line 106 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		g_cond_broadcast (&self->priv->cond);
#line 379 "rygel-simple-data-source.c"
	}
#line 109 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	g_mutex_unlock (&self->priv->mutex);
#line 383 "rygel-simple-data-source.c"
}


static void rygel_simple_data_source_real_stop (RygelDataSource* base) {
	RygelSimpleDataSource * self;
	gboolean _tmp0_ = FALSE;
#line 112 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	self = (RygelSimpleDataSource*) base;
#line 113 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	g_mutex_lock (&self->priv->mutex);
#line 114 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	_tmp0_ = self->priv->stop_thread;
#line 114 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	if (!_tmp0_) {
#line 115 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		self->priv->frozen = FALSE;
#line 116 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		self->priv->stop_thread = TRUE;
#line 117 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		g_cond_broadcast (&self->priv->cond);
#line 404 "rygel-simple-data-source.c"
	}
#line 120 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	g_mutex_unlock (&self->priv->mutex);
#line 408 "rygel-simple-data-source.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 144 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 144 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	return _data1_;
#line 417 "rygel-simple-data-source.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 144 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 426 "rygel-simple-data-source.c"
		RygelSimpleDataSource* self;
#line 144 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		self = _data1_->self;
#line 144 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_data1_->slice = (g_free (_data1_->slice), NULL);
#line 144 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_g_object_unref0 (self);
#line 144 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		g_slice_free (Block1Data, _data1_);
#line 436 "rygel-simple-data-source.c"
	}
}


static gboolean ____lambda4_ (Block1Data* _data1_) {
	RygelSimpleDataSource* self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 178 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	self = _data1_->self;
#line 179 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	_tmp0_ = self->priv->stop_thread;
#line 179 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	if (!_tmp0_) {
#line 451 "rygel-simple-data-source.c"
		guint8* _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
#line 180 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_tmp1_ = _data1_->slice;
#line 180 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_tmp1__length1 = _data1_->slice_length1;
#line 180 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		g_signal_emit_by_name ((RygelDataSource*) self, "data-available", _tmp1_, _tmp1__length1);
#line 460 "rygel-simple-data-source.c"
	}
#line 183 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	result = FALSE;
#line 183 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	return result;
#line 466 "rygel-simple-data-source.c"
}


static gboolean _____lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = ____lambda4_ (self);
#line 178 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	return result;
#line 475 "rygel-simple-data-source.c"
}


static gboolean __lambda5_ (RygelSimpleDataSource* self) {
	gboolean result = FALSE;
#line 195 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	g_signal_emit_by_name ((RygelDataSource*) self, "done");
#line 195 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	result = FALSE;
#line 195 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	return result;
#line 487 "rygel-simple-data-source.c"
}


static gboolean ___lambda5__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda5_ ((RygelSimpleDataSource*) self);
#line 195 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	return result;
#line 496 "rygel-simple-data-source.c"
}


static void* rygel_simple_data_source_thread_func (RygelSimpleDataSource* self) {
	void* result = NULL;
	GFile* file = NULL;
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gint fd = 0;
	GError * _inner_error_ = NULL;
#line 123 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 124 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	_tmp0_ = self->priv->uri;
#line 124 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	_tmp1_ = g_file_new_for_commandline_arg (_tmp0_);
#line 124 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	file = _tmp1_;
#line 125 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	_tmp2_ = self->priv->uri;
#line 125 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	g_debug ("rygel-simple-data-source.vala:125: Spawning new thread for streaming f" \
"ile %s", _tmp2_);
#line 126 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	fd = -1;
#line 522 "rygel-simple-data-source.c"
	{
		GFile* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		off_t _tmp15_ = {0};
		off_t _tmp19_ = {0};
#line 128 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_tmp3_ = file;
#line 128 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_tmp4_ = g_file_get_path (_tmp3_);
#line 128 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_tmp5_ = _tmp4_;
#line 128 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_tmp6_ = open (_tmp5_, O_RDONLY, (mode_t) 0);
#line 128 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		fd = _tmp6_;
#line 128 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_g_free0 (_tmp5_);
#line 129 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_tmp7_ = fd;
#line 129 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		if (_tmp7_ < 0) {
#line 547 "rygel-simple-data-source.c"
			GFile* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			gint _tmp11_ = 0;
			const gchar* _tmp12_ = NULL;
			GError* _tmp13_ = NULL;
			GError* _tmp14_ = NULL;
#line 130 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_tmp8_ = file;
#line 130 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_tmp9_ = g_file_get_path (_tmp8_);
#line 130 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_tmp10_ = _tmp9_;
#line 130 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_tmp11_ = errno;
#line 130 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_tmp12_ = strerror (_tmp11_);
#line 130 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_tmp13_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "Failed to open file '%s': %s", _tmp10_, _tmp12_);
#line 130 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_tmp14_ = _tmp13_;
#line 130 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_g_free0 (_tmp10_);
#line 130 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_inner_error_ = _tmp14_;
#line 573 "rygel-simple-data-source.c"
			goto __catch0_g_error;
		}
#line 135 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_tmp15_ = self->priv->last_byte;
#line 135 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		if (_tmp15_ == ((off_t) 0)) {
#line 580 "rygel-simple-data-source.c"
			gint _tmp16_ = 0;
			off_t _tmp17_ = {0};
			gint _tmp18_ = 0;
#line 136 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_tmp16_ = fd;
#line 136 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_tmp17_ = lseek (_tmp16_, (off_t) 0, SEEK_END);
#line 136 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			self->priv->last_byte = _tmp17_;
#line 137 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_tmp18_ = fd;
#line 137 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			lseek (_tmp18_, (off_t) 0, SEEK_SET);
#line 594 "rygel-simple-data-source.c"
		}
#line 140 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_tmp19_ = self->priv->first_byte;
#line 140 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		if (_tmp19_ != ((off_t) 0)) {
#line 600 "rygel-simple-data-source.c"
			gint _tmp20_ = 0;
			off_t _tmp21_ = {0};
#line 141 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_tmp20_ = fd;
#line 141 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_tmp21_ = self->priv->first_byte;
#line 141 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			lseek (_tmp20_, _tmp21_, SEEK_SET);
#line 609 "rygel-simple-data-source.c"
		}
#line 144 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		while (TRUE) {
#line 613 "rygel-simple-data-source.c"
			Block1Data* _data1_;
			gboolean exit = FALSE;
			gboolean _tmp23_ = FALSE;
			gboolean _tmp24_ = FALSE;
			gboolean _tmp25_ = FALSE;
			off_t start = {0};
			off_t _tmp28_ = {0};
			off_t stop = {0};
			off_t _tmp29_ = {0};
			off_t _tmp30_ = {0};
			off_t _tmp31_ = {0};
			off_t _tmp33_ = {0};
			off_t _tmp34_ = {0};
			guint8* _tmp35_ = NULL;
			gint len = 0;
			gint _tmp36_ = 0;
			guint8* _tmp37_ = NULL;
			gint _tmp37__length1 = 0;
			guint8* _tmp38_ = NULL;
			gint _tmp38__length1 = 0;
			gssize _tmp39_ = 0L;
			gint _tmp40_ = 0;
			gint _tmp48_ = 0;
			gint _tmp49_ = 0;
			off_t _tmp50_ = {0};
#line 144 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_data1_ = g_slice_new0 (Block1Data);
#line 144 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_data1_->_ref_count_ = 1;
#line 144 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_data1_->self = g_object_ref (self);
#line 146 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			g_mutex_lock (&self->priv->mutex);
#line 147 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			while (TRUE) {
#line 649 "rygel-simple-data-source.c"
				gboolean _tmp22_ = FALSE;
#line 147 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
				_tmp22_ = self->priv->frozen;
#line 147 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
				if (!_tmp22_) {
#line 147 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
					break;
#line 657 "rygel-simple-data-source.c"
				}
#line 148 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
				g_cond_wait (&self->priv->cond, &self->priv->mutex);
#line 661 "rygel-simple-data-source.c"
			}
#line 151 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_tmp23_ = self->priv->stop_thread;
#line 151 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			exit = _tmp23_;
#line 152 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			g_mutex_unlock (&self->priv->mutex);
#line 154 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_tmp25_ = exit;
#line 154 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			if (_tmp25_) {
#line 154 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
				_tmp24_ = TRUE;
#line 675 "rygel-simple-data-source.c"
			} else {
				off_t _tmp26_ = {0};
				off_t _tmp27_ = {0};
#line 154 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
				_tmp26_ = self->priv->first_byte;
#line 154 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
				_tmp27_ = self->priv->last_byte;
#line 154 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
				_tmp24_ = _tmp26_ == _tmp27_;
#line 685 "rygel-simple-data-source.c"
			}
#line 154 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			if (_tmp24_) {
#line 155 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
				g_debug ("rygel-simple-data-source.vala:155: Done streaming!");
#line 157 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
				block1_data_unref (_data1_);
#line 157 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
				_data1_ = NULL;
#line 157 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
				break;
#line 697 "rygel-simple-data-source.c"
			}
#line 160 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_tmp28_ = self->priv->first_byte;
#line 160 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			start = _tmp28_;
#line 161 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_tmp29_ = start;
#line 161 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			stop = _tmp29_ + G_MAXUINT16;
#line 162 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_tmp30_ = stop;
#line 162 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_tmp31_ = self->priv->last_byte;
#line 162 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			if (_tmp30_ > _tmp31_) {
#line 713 "rygel-simple-data-source.c"
				off_t _tmp32_ = {0};
#line 163 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
				_tmp32_ = self->priv->last_byte;
#line 163 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
				stop = _tmp32_;
#line 719 "rygel-simple-data-source.c"
			}
#line 166 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_tmp33_ = stop;
#line 166 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_tmp34_ = start;
#line 166 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_tmp35_ = g_new0 (guint8, _tmp33_ - _tmp34_);
#line 166 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_data1_->slice = _tmp35_;
#line 166 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_data1_->slice_length1 = _tmp33_ - _tmp34_;
#line 166 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_data1_->_slice_size_ = _data1_->slice_length1;
#line 167 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_tmp36_ = fd;
#line 167 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_tmp37_ = _data1_->slice;
#line 167 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_tmp37__length1 = _data1_->slice_length1;
#line 167 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_tmp38_ = _data1_->slice;
#line 167 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_tmp38__length1 = _data1_->slice_length1;
#line 167 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_tmp39_ = read (_tmp36_, _tmp37_, (gsize) _tmp38__length1);
#line 167 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			len = (gint) _tmp39_;
#line 168 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_tmp40_ = len;
#line 168 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			if (_tmp40_ < 0) {
#line 751 "rygel-simple-data-source.c"
				GFile* _tmp41_ = NULL;
				gchar* _tmp42_ = NULL;
				gchar* _tmp43_ = NULL;
				gint _tmp44_ = 0;
				const gchar* _tmp45_ = NULL;
				GError* _tmp46_ = NULL;
				GError* _tmp47_ = NULL;
#line 169 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
				_tmp41_ = file;
#line 169 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
				_tmp42_ = g_file_get_path (_tmp41_);
#line 169 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
				_tmp43_ = _tmp42_;
#line 169 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
				_tmp44_ = errno;
#line 169 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
				_tmp45_ = strerror (_tmp44_);
#line 169 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
				_tmp46_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "Failed to read file '%s': %s", _tmp43_, _tmp45_);
#line 169 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
				_tmp47_ = _tmp46_;
#line 169 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
				_g_free0 (_tmp43_);
#line 169 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
				_inner_error_ = _tmp47_;
#line 169 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
				block1_data_unref (_data1_);
#line 169 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
				_data1_ = NULL;
#line 781 "rygel-simple-data-source.c"
				goto __catch0_g_error;
			}
#line 174 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_tmp48_ = len;
#line 174 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_data1_->slice_length1 = _tmp48_;
#line 174 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_tmp49_ = _data1_->slice_length1;
#line 175 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_tmp50_ = stop;
#line 175 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			self->priv->first_byte = _tmp50_;
#line 178 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _____lambda4__gsource_func, block1_data_ref (_data1_), block1_data_unref);
#line 144 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			block1_data_unref (_data1_);
#line 144 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
			_data1_ = NULL;
#line 800 "rygel-simple-data-source.c"
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GFile* _tmp51_ = NULL;
		gchar* _tmp52_ = NULL;
		gchar* _tmp53_ = NULL;
		GError* _tmp54_ = NULL;
		const gchar* _tmp55_ = NULL;
#line 127 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_error_ = _inner_error_;
#line 127 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_inner_error_ = NULL;
#line 187 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_tmp51_ = file;
#line 187 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_tmp52_ = g_file_get_path (_tmp51_);
#line 187 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_tmp53_ = _tmp52_;
#line 187 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_tmp54_ = _error_;
#line 187 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_tmp55_ = _tmp54_->message;
#line 187 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		g_warning ("rygel-simple-data-source.vala:187: Failed to stream file %s: %s", _tmp53_, _tmp55_);
#line 187 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_g_free0 (_tmp53_);
#line 127 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_g_error_free0 (_error_);
#line 832 "rygel-simple-data-source.c"
	}
	__finally0:
	{
		gint _tmp56_ = 0;
#line 191 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_tmp56_ = fd;
#line 191 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		close (_tmp56_);
#line 841 "rygel-simple-data-source.c"
	}
#line 127 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 127 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		_g_object_unref0 (file);
#line 127 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 127 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		g_clear_error (&_inner_error_);
#line 127 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
		return NULL;
#line 853 "rygel-simple-data-source.c"
	}
#line 195 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda5__gsource_func, g_object_ref (self), g_object_unref);
#line 197 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	result = NULL;
#line 197 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	_g_object_unref0 (file);
#line 197 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	return result;
#line 863 "rygel-simple-data-source.c"
}


static void rygel_simple_data_source_class_init (RygelSimpleDataSourceClass * klass) {
#line 34 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	rygel_simple_data_source_parent_class = g_type_class_peek_parent (klass);
#line 34 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	g_type_class_add_private (klass, sizeof (RygelSimpleDataSourcePrivate));
#line 34 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_simple_data_source_finalize;
#line 874 "rygel-simple-data-source.c"
}


static void rygel_simple_data_source_rygel_data_source_interface_init (RygelDataSourceIface * iface) {
#line 34 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	rygel_simple_data_source_rygel_data_source_parent_iface = g_type_interface_peek_parent (iface);
#line 34 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	iface->preroll = (GeeList* (*)(RygelDataSource*, RygelHTTPSeekRequest*, RygelPlaySpeedRequest*, GError**)) rygel_simple_data_source_real_preroll;
#line 34 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	iface->start = (void (*)(RygelDataSource*, GError**)) rygel_simple_data_source_real_start;
#line 34 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	iface->freeze = (void (*)(RygelDataSource*)) rygel_simple_data_source_real_freeze;
#line 34 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	iface->thaw = (void (*)(RygelDataSource*)) rygel_simple_data_source_real_thaw;
#line 34 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	iface->stop = (void (*)(RygelDataSource*)) rygel_simple_data_source_real_stop;
#line 891 "rygel-simple-data-source.c"
}


static void rygel_simple_data_source_instance_init (RygelSimpleDataSource * self) {
#line 34 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	self->priv = RYGEL_SIMPLE_DATA_SOURCE_GET_PRIVATE (self);
#line 37 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	g_mutex_init (&self->priv->mutex);
#line 38 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	g_cond_init (&self->priv->cond);
#line 39 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	self->priv->first_byte = (off_t) 0;
#line 40 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	self->priv->last_byte = (off_t) 0;
#line 41 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	self->priv->frozen = FALSE;
#line 42 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	self->priv->stop_thread = FALSE;
#line 910 "rygel-simple-data-source.c"
}


static void rygel_simple_data_source_finalize (GObject* obj) {
	RygelSimpleDataSource * self;
#line 34 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_SIMPLE_DATA_SOURCE, RygelSimpleDataSource);
#line 50 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	rygel_data_source_stop ((RygelDataSource*) self);
#line 35 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	_g_free0 (self->priv->uri);
#line 36 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	_g_thread_unref0 (self->priv->thread);
#line 37 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	_vala_clear_GMutex (&self->priv->mutex);
#line 38 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	_vala_clear_GCond (&self->priv->cond);
#line 34 "/home/jens/Source/rygel/src/media-engines/simple/rygel-simple-data-source.vala"
	G_OBJECT_CLASS (rygel_simple_data_source_parent_class)->finalize (obj);
#line 930 "rygel-simple-data-source.c"
}


/**
 * A simple data source for use with the simple media engine (RygelSimpleMediaEngine).
 *
 * This does not support time-base seeking with 
 * rygel_data_source_start() because it does not
 * use any multimedia framework. Therefore, calling start() with
 * RYGEL_HTTP_SEEK_TYPE_TIME will fail with a 
 * RYGEL_DATA_SOURCE_ERROR_SEEK_FAILED GError code,
 */
GType rygel_simple_data_source_get_type (void) {
	static volatile gsize rygel_simple_data_source_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_simple_data_source_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSimpleDataSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_simple_data_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSimpleDataSource), 0, (GInstanceInitFunc) rygel_simple_data_source_instance_init, NULL };
		static const GInterfaceInfo rygel_data_source_info = { (GInterfaceInitFunc) rygel_simple_data_source_rygel_data_source_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_simple_data_source_type_id;
		rygel_simple_data_source_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelSimpleDataSource", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_simple_data_source_type_id, RYGEL_TYPE_DATA_SOURCE, &rygel_data_source_info);
		g_once_init_leave (&rygel_simple_data_source_type_id__volatile, rygel_simple_data_source_type_id);
	}
	return rygel_simple_data_source_type_id__volatile;
}


static void _vala_clear_GMutex (GMutex * mutex) {
	GMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GMutex))) {
		g_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GMutex));
	}
}


static void _vala_clear_GRecMutex (GRecMutex * mutex) {
	GRecMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRecMutex))) {
		g_rec_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GRecMutex));
	}
}


static void _vala_clear_GRWLock (GRWLock * mutex) {
	GRWLock zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRWLock))) {
		g_rw_lock_clear (mutex);
		memset (mutex, 0, sizeof (GRWLock));
	}
}


static void _vala_clear_GCond (GCond * mutex) {
	GCond zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GCond))) {
		g_cond_clear (mutex);
		memset (mutex, 0, sizeof (GCond));
	}
}



