#if !defined(SAPHIRE_INNER_H)
#define SAPHIRE_INNER_H

////////////////////////////////////////////////////////////
/// from saphire_main.c
////////////////////////////////////////////////////////////
extern volatile BOOL gSigUser;

/// ޥɤбʸ
enum eCommandKind { 
    kObject, kRef, kVar, kGlobal, kExport, 
    kAry, kAryAdd, kAryErase, 
    kHash, kHashAdd, kHashErase,  
    kDef, kInherit, kSelf, kStackFrame, kClass,
    kSweep, kShow,
    kSubshell, kMSleep, kTrue, kFalse, kTest,
    kIndex, kRIndex, kLength, kLc, kUc,
    kChomp, kEval, kFg, kBg, 
    kJobs, kRehash, kKanjiCode, kLineField,
    kPrint,  kPuts, kLoad, 
    kCompile, kRaise,
    kWhile, kTry, kBreak, kExit, kIf, kSplit, kX, kJoin, kSelect, kLines, kRows,
    kMatch, kScan, kSub, kGSub, 
    kRead, kClose, 
    kCd, 
    kAdd, kDel, kSelector, kMax, kMin,
    kExtName, kParentName, kNoExtName, 
    kPopd, kPushd,
    kPlusPlus,
    kMinusMinus,
    kPlus,
    kMinus,
    kMult,
    kDiv,
    kMod,
    kPow,
    kSort,
    kRange,
    kPrintf,
    kPomch,
    kPTee,
    kPCat,
    kReturn,
    kMInitScr,
    kMEndWin,
    kMClear,
    kMClearImmediately,
    kMRefresh,
    kMMove ,
    kMMoveImmediately,
    kMPrintw, 
    kYeild,
    kBlock,
    kEach,
    kForeach,
    kAbs,
    kFAbs,
    kP,
    kEnvSpace,
    kQuote,
    kTime,
    kFSelector,
    kUnset,
    kUMask,
    kErrMsg,
    kRunInfo,

    kConditionN,
    kConditionZ,
    kConditionB,
    kConditionC,
    kConditionD,
    kConditionF,
    kConditionH,
    kConditionL,
    kConditionP,
    kConditionS2,
    kConditionT,
    kConditionG,
    kConditionK,
    kConditionU,
    kConditionR,
    kConditionW,
    kConditionX,
    kConditionO,
    kConditionG2,
    kConditionE,
    kConditionS,
    kConditionEq,
    kConditionNEq,
    kConditionSLT,
    kConditionSGT,
    kConditionSLE,
    kConditionSGE,
    kConditionSILT,
    kConditionSIGT,
    kConditionSILE,
    kConditionSIGE,
    kConditionEqI,
    kConditionRE,
    kConditionREI,
    kConditionREIM,
    kConditionREMI,
    kConditionREM,
    kConditionEQ,
    kConditionNE,
    kConditionLT,
    kConditionLE,
    kConditionGT,
    kConditionGE,
    kConditionNT,
    kConditionOT,
    kConditionEF,

    kInnerCommand,
    kCommand 
};

typedef struct
{
    enum eCommandKind mKind;
    vector_obj* mArgs;
        // vector of sArg*
        // ޥɥ饤
    vector_obj* mRedirects;
        // vector of sRedirect* 
        // 쥯Υꥹ

    unsigned int mOptions;

    void* mExtra;
} sCommand;

typedef struct {
    //sStatments* statments;
    //char* title
    //sWFd* pipeout
    //sRFd* pipein
    //int pipeerr
    BOOL* return_;
    BOOL enable_return;
    BOOL* break_;
    BOOL enable_break;
    vector_obj* parent_blocks;
    //BOOL try_;
    vector_obj* envs;
    sObject* object;
    sFunction* running_fun;
    sClass* running_class;
} sRunInfo;

BOOL statment_tree_internal_commands_fselector(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_object(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_ref(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_var(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_global(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_export(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_ary(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_ary_add(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_ary_erase(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_hash(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_hash_add(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_hash_erase(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_def(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_class(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_self(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_inherit(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_stackframe(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_show(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_sweep(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_subshell(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_msleep(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_test(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_index(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_rindex(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_length(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_uc(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_lc(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_chomp(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_eval(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_fg(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_bg(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_jobs(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_rehash(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_kanjicode(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_linefield(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_print(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_compile(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_raise(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_load(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_while(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_break(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_try(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_envspace(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_exit(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_if(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_split(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_add(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_del(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_x(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_join(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_rows(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_select(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_lines(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_scan(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_match(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_sub(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_gsub(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_read(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_close(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_cd(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_selector(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_max(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_min(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_extname(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_parentname(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_noextname(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_popd(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_pushd(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_ssort(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_minusminus(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_plusplus(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_plus(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_minus(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_mult(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_div(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_mod(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_pow(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_range(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_printf(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_pomch(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_ptee(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_pcat(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_return(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_minitscr(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_mendwin(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_mclear(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_mclear_immediately(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_mrefresh(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_mmove(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_mmove_immediately(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_mprintw(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_yeild(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_block(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_each(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_foreach(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_abs(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_fabs(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_p(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_quote(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_time(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_unset(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_umask(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_errmsg(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_runinfo(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_condition_n(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_condition_z(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_condition_b(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_condition_c(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_condition_d(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_condition_f(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_condition_h(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_condition_l(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_condition_p(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_condition_s2(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_condition_t(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_condition_g(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_condition_k(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_condition_u(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_condition_r(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_condition_w(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_condition_x(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_condition_o(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_condition_g2(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_condition_e(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_condition_s(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_condition_eq(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_condition_neq(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_true(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_false(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_condition_slt(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_condition_sgt(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_condition_sle(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_condition_sge(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_condition_silt(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_condition_sigt(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_condition_sile(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_condition_sige(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_condition_eqi(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_condition_re(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_condition_eq2(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_condition_ne(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_condition_lt(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_condition_le(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_condition_gt(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_condition_ge(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_condition_nt(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_condition_ot(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);
BOOL statment_tree_internal_commands_condition_ef(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);

typedef BOOL (*fInternalCommand)(sRunInfo* runinfo, sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, char* sname, int sline, BOOL input, int j);

fInternalCommand kInternalCommands[kCommand];

//extern char* kCommandOptions[kCommand][32];

extern char gTmpDir[PATH_MAX];
    // ե֤

extern char* gStatmentKindStrs[kCommand+1];
extern hash_obj* gFuncs;
    // 桼ؿ sFunction*äƤ
    // ϴؿ̾

extern hash_obj* gClasses;
    // 饹 sClass*äƤ
    // ϥ饹̾

extern vector_obj* gStackFrame;
extern vector_obj* gStackFramePointers;
extern vector_obj* gStackFrameArrays;
extern vector_obj* gStackFrameHashs;
extern vector_obj* gStackFrameObjects;
extern vector_obj* gStackFrameRefs;
    // ѿΥå
    // Ƥhash_obj*
    // Υϥѿ̾
    // Ƥstring_obj*
extern enum eAppType gAppType;
    // ץꥱμ
extern BOOL gJobControl;
    // ֤Υȥ򤹤뤫ɤ
extern vector_obj* gJobs;
    //  sJob*

extern char* gMagicNumber;
    // ֥ȥեΥޥåʥС

extern hash_obj* gReadBuffers;
    //  ե̾
    //  sRFd*
    // readѤΥեΥ꡼ɥХåե

extern string_obj* gGlobalPipe;
    // Хѥפɤ߹ߤǡ

extern string_obj* gGlobalPipeNum[10];
    // ʥСХѥפɤ߹ߤǡ
extern BOOL gSaphireBackground;
    // SaphireХå饦ɤưƤ뤫ɤ

extern hash_obj* gRegexs;
extern hash_obj* gRegexsI;
extern hash_obj* gRegexsM;
extern hash_obj* gRegexsIM;
extern hash_obj* gRegexsSjis;
extern hash_obj* gRegexsISjis;
extern hash_obj* gRegexsMSjis;
extern hash_obj* gRegexsIMSjis;
extern hash_obj* gRegexsEucjp;
extern hash_obj* gRegexsIEucjp;
extern hash_obj* gRegexsMEucjp;
extern hash_obj* gRegexsIMEucjp;
extern hash_obj* gRegexsUtf8;
extern hash_obj* gRegexsIUtf8;
extern hash_obj* gRegexsMUtf8;
extern hash_obj* gRegexsIMUtf8;
    // ɽΥå
    // ɽʸ
    // Ƥregex_t

extern hash_obj* gInnerCommands;
    // Ͽޥ
    // saphireȤ߹ץꥱ
    // 줿ޥɤΥǡ
    // ϥޥ̾
    // ƤsInnerCommand

extern vector_obj* gDirStack;
    // popd, pushdǻȤǥ쥯ȥꥹå
    // Ƥ string_obj*
extern enum eLineField gLineField;
    // saphireʸޥɤǻȤԥ

extern vector_obj* gTmpFiles;
    // ץִǻȤեǾä
    // ¸Ƥ

BOOL is_line_field(char* p);
    // 饤եɤݥȤƤ뤫

BOOL is_line_field2(enum eLineField lf, char* p);
    // 饤եɤݥȤƤ뤫2

BOOL string_chomp(string_obj* str);
    // ԥɤ

BOOL string_chomp2(string_obj* str, enum eLineField lf);
    // ԥɤ

void string_ponch(string_obj* str);
    // ԥɤդ(\n)

void string_pomch(string_obj* str, enum eLineField lf);
    // ԥɤդ(ԥɤΤޤ)

int get_command_kind(char* arg0);
    // ޥ̾饳ޥIDõ

void null_fun();
    // gotoΥ٥򥳥ѥ顼̤δؿ

void get_quoted_linefield(char* str, string_obj* out);

void bash_get_quoted_fname(char* fname, string_obj* quoted_fname);
    // bashΥ
void all_get_quoted_fname(char* fname, string_obj* quoted_fname);
    // Ȥ

typedef struct _sJob {
    string_obj* mName;          // ֤̾
    pid_t mPGroup;              // ץ롼ID
    vector_obj* mPIDs;          // ҥץPIDΥꥹ
    struct termios* mTty;
} sJob;

sJob* sJob_new();
void sJob_delete(sJob* self);

enum eStatmentTerminated { kTNormal, kTOrOr, kTAndAnd };

typedef struct
{
    sStatments* joukensiki;
    sStatments* contents;
} sWhile;

sWhile* sWhile_new(sStatments* joukensiki, sStatments* contents);
sWhile* sWhile_new2(sWhile* while_);

void sWhile_delete(sWhile* self);
void sWhile_save(sWhile* self, int fd);
sWhile* sWhile_load(int fd);

typedef struct
{
    sStatments* contents;
} sSubshell;

sSubshell* sSubshell_new(sStatments* contents);
sSubshell* sSubshell_new2(sSubshell* subshell);
void sSubshell_delete(sSubshell* self);

void sSubshell_delete(sSubshell* self);
void sSubshell_save(sSubshell* self, int fd);
sSubshell* sSubshell_load(int fd);
void sSubshell_view(sSubshell* self);

typedef struct
{
    vector_obj* joukensiki_list;
    vector_obj* contents_list;
} sIf;

sIf* sIf_new(vector_obj* joukensiki_list, vector_obj* contents_list);
sIf* sIf_new2(sIf* if_);

void sIf_delete(sIf* self);
void sIf_save(sIf* self, int fd);
sIf* sIf_load(int fd);

enum eCommandKind2 {
    kCKLocalVar, kCKUserCommand, kCKExternInnerCommand, kCKInnerCommand,
    kCKExternCommand
};

typedef struct
{
    int mKind; // 0:string 2: statments 4: statments2 5: block 6: process substituion 7: here document 8:process substituion2 9 : redirect
    void* mBody;
} sArg; // mArgs


#ifdef MDEBUG

sArg* sArg_new_debug(int kind, MANAGED void* body, const char* fname, int line, const char* func);

#define ARG_NEW(o, o2) sArg_new_debug(o, o2, __FILE__, __LINE__, __FUNCTION__)

sArg* sArg_new2_debug(sArg* arg, const char* fname, int line, const char* func);

#define ARG_NEW2(o) sArg_new2_debug(o, __FILE__, __LINE__, __FUNCTION__)

#else

sArg* sArg_new(int kind, MANAGED void* body);

#define ARG_NEW(o, o2) sArg_new(o, o2)

sArg* sArg_new2(sArg* arg);

#define ARG_NEW2(o) sArg_new2(o)

#endif

void sArg_delete(sArg* self);

void sArg_save(sArg* self, int fd);
sArg* sArg_load(int fd);

enum eRedirect { kRedirectInput, kRedirectOverwrite, kRedirectAppend
          , kRedirectErrAndOutput };

typedef struct {
    enum eRedirect mType;
    int mFd;
    string_obj* mFName;      // ¹Ի˻Ȥ
} sRedirect; // ¹Ի˻Ȥ ֥ȥե¸

sRedirect* sRedirect_new(enum eRedirect type, int fd);
sRedirect* sRedirect_new2(sRedirect* redirect);
void sRedirect_delete(sRedirect* self);
void sRedirect_save(sRedirect* self, int fd);
sRedirect* sRedirect_load(int fd);
void sRedirect_delete(sRedirect* self);

sBlock* sBlock_new(sStatments* statments, vector_obj* args, int count);
sBlock* sBlock_new2(sBlock* block);
void sBlock_delete(sBlock* self);
void sBlock_save(sBlock* self, int fd);
sBlock* sBlock_load(int fd);

typedef struct
{
    string_obj* mFName;
    sStatments* mStatments;
} sPSub;

sPSub* sPSub_new(char* fname, sStatments* statments);
void sPSub_delete(sPSub* self);


#ifndef MDEBUG

sCommand* sCommand_new();
#define COMMAND_NEW() sCommand_new()

void sCommand_view(sCommand* self);

#else

sCommand* sCommand_new_debug(const char* fname, int line, const char* func);

#define COMMAND_NEW() sCommand_new_debug(__FILE__, __LINE__, __FUNCTION__)

#endif

void sCommand_save(sCommand* self, int fd);
sCommand* sCommand_load(int fd);
void sCommand_delete(sCommand* self);

typedef struct
{
    vector_obj* mCommands;   // ޥ

    string_obj* mFName;      // ʸե̾
    int mLine;               // ʸ

    string_obj* mNotEvaled;  // run˥ѡʸ
                             // Ķѿȥޥޤʸ
    string_obj* mTitle;      // ȥ

    enum eStatmentTerminated mTerminated;   
            // ʣʸκǸ夬ǶڤƤ뤫

    BOOL mRCodeReverse;      // ꥿󥳡ɤȿž

    BOOL mBackground;        // Хå饦ɤǼ¹

    int mGlobalPipeIn;       // ХѥפϤ뤫 1:  4: ʥС
    int mGlobalPipeOut;      // ХѥפνϤ뤫 1:  4:ʥС
    int mGlobalPipeInNum;    // ʥСХѥפֹ
    int mGlobalPipeOutNum;   // ʥСХѥפֹ

    int mSTDINPipe;         // STDIN ѥפ뤫ʤ
} sStatment;

#ifdef MDEBUG
sStatment* sStatment_new_debug(const char* fname, int line, const char* func_name);
#define STATMENT_NEW() sStatment_new_debug(__FILE__, __LINE__, __FUNCTION__)
sStatment* sStatment_new2_debug(sStatment* statment, const char* fname, int line, const char* func_name);
#define STATMENT_NEW2(o) sStatment_new2_debug(o, __FILE__, __LINE__, __FUNCTION__)
#else
sStatment* sStatment_new();
#define STATMENT_NEW() sStatment_new()
sStatment* sStatment_new2();
#define STATMENT_NEW2(o) sStatment_new2(o)
#endif

void sStatment_delete(sStatment* self);
void sStatment_save(sStatment* self, int fd);
sStatment* sStatment_load(int fd);

void sStatments_view(sStatments* self);

void sStatments_save(sStatments* self, int fd);
sStatments* sStatments_load(int fd);
void sStatments_delete(sStatments* self);


sFunction* sFunction_new(char* name, sStatments* statments, char* arg_name, sFunction* parent, int ref_count);
  
void sFunction_delete(sFunction* self);
void sFunction_save(sFunction* self, int fd);
sFunction* sFunction_load(int fd);
void sFunction_view(sFunction* self);


typedef struct {
    string_obj* mName;
    fInnerCommand mFun;
} sInnerCommand;

sInnerCommand* sInnerCommand_new(char* name, fInnerCommand fun);
void sInnerCommand_delete(sInnerCommand* self);

void sigchld_block(int block);

extern hash_obj* gObjects;
// ֥ ϥ֥̾ ƤsObject*
//
extern hash_obj* gRefs;
// ֥ ϥ֥̾ ƤsObject*

typedef struct {
    char* mStr;
    int mLen;

    int mMallocLen;

    int mHasMem;
} sVar;

typedef struct {
    char* mStr;
    int mLen;

    int mMallocLen;

    int mRefCount;
    int mHasMem;
} sGlobal;

sVar* sVar_new(char* str, BOOL has_mem);
void sVar_delete(sVar* self);
sGlobal* sGlobal_new(char* str, int ref_count, int has_mem);
void sGlobal_delete(sGlobal* self);
sAry* sAry_new(int first_size, int ref_count);
void sAry_delete(sAry* self);
sHash* sHash_new(int size, int ref_count);
void sHash_delete(sHash* self);

string_obj* saphire_get_hash_item(sHash* hash, char* key);
void saphire_put_hash_item(sHash* hash, char* key, string_obj* item);
void saphire_erase_hash_element(sHash* hash, char* key);

typedef struct {
    sStatments* mStatments;
    enum eLineField mLineField;
} sAtCommand;

sAtCommand* sAtCommand_new(sStatments* statments, enum eLineField lf);
sAtCommand* sAtCommand_new2(sAtCommand* at_command);
void sAtCommand_delete(sAtCommand* self);
sAtCommand* sAtCommand_save(sAtCommand* self, int fd);
sAtCommand* sAtCommand_load(int fd);
void dig_stack_frame(char* sname, int sline, sAry** fun_argv_before, sAry* argv2);
void burry_stack_frame(sAry* fun_argv_before, string_obj** sname_strace, int* line_strace);

////////////////////////////////////////////////////////////
/// from saphire_commands.c
////////////////////////////////////////////////////////////

BOOL vcat_expand_env(string_obj* pipeout, char* env, vector_obj* numbers,char* sname, int line);

////////////////////////////////////////////////////////////
/// from saphire_parser.c
////////////////////////////////////////////////////////////
BOOL expand_env(char* p, string_obj* out, sRFd* rfd, char* sname, int* line, sObject* object);
BOOL parse(char* cmdline, char* sname, int* line, sStatments* statments);
BOOL delete_comments(char* p, string_obj* cmdline2, char* separator, char* sname, int* line);


BOOL read_until_next_cbrace_end(char** p, string_obj* not_evaled, int* read_end_of_statment, BOOL line_inc, char* sname, int* line);

////////////////////////////////////////////////////////////
// from saphire_vm.c
////////////////////////////////////////////////////////////
BOOL forground_job(int num);
void background_job(int num);
void tmpfile_all_sweep();
void tmpfile_sweep();

extern vector_obj* gStackTraceFName;
extern vector_obj* gStackTraceLineNum;
    // åե졼εϿ
 

int run(sRunInfo* runinfo, sStatments* statments, char* title, sWFd* pipeout, sRFd* pipein, int pipeerr, BOOL try_);
    // saphire_compile2ǥѥ뤷ѥ̤¹Ԥ롣

int saphire_shell4(char* command, char* title, sWFd* pipeout, sRFd* pipein, int pipeerr, sObject* object);
    // ʸɤ߹Ǽ¹
int saphire_shell5(sWFd* pipeout, char* command, char* title, sRFd* pipein, sObject* object);
    // ʸɤ߹Ǽ¹ԡޥɤνϤpipeout->mBuffer

typedef struct {
    string_obj* mText;
    BOOL mExpandEnv;
} sHereDoc;

sHereDoc* sHereDoc_new(MANAGED string_obj* text, BOOL expand_env);
sHereDoc* sHereDoc_new2(sHereDoc* hdoc);
void sHereDoc_delete(sHereDoc* self);

BOOL inc_refcount(void* mem);
BOOL dec_refcount(void* mem);





#endif
