#include "config.h"
#include "saphire/saphire_extra.h"
#include <unistd.h>
#include <sys/types.h>
#include <pwd.h>
#include <grp.h>
#include <string.h>
#include <limits.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>

#include <limits.h>

//////////////////////////////////////////////////////////////////////
// ?g???q?????Ԃ?
//////////////////////////////////////////////////////////////////////
void extname(SPACE char* result, int result_size, char* name)
{
    char* p;
    
    for(p = name + strlen(name); p != name; p--) {
        if(*p == '.' && p == name + strlen(name)) {
            xstrncpy(result, "", result_size);
            return;
        }
        else if(*p == '/') {
            xstrncpy(result, "", result_size);
            return;
        }
        else if(*p == '.') {
            xstrncpy(result, p+1, result_size);
            return;
        }
    }

    xstrncpy(result, "", result_size);
}

//////////////////////////////////////////////////////////////////////
// ?g???q???ȊO???Ԃ?
//////////////////////////////////////////////////////////////////////
void noextname(SPACE char* result, int result_size, char* name)
{
    char* max;
    char* p;
    
    max = name + strlen(name);
    for(p = name + strlen(name); p >= name; p--) {
        if(*p == '.' && (p - name + 1) < result_size) {
            memcpy(result, name, p - name);
            result[p - name] = 0;
            return;
        }
    }

    xstrncpy(result, name, result_size);
}

//////////////////////////////////////////////////////////////////////
// ?e?f?B???N?g???????Ԃ?
//////////////////////////////////////////////////////////////////////
void parentname(SPACE char* result, int result_size, char* path)
{
    char* p;

    if(*path == 0) {
        xstrncpy(result, "", result_size);
        return;
    }
    
    if(strcmp(path, "/") == 0) {
        xstrncpy(result, "/", result_size);
        return;
    }

    for(p=path + strlen(path)-2; p != path-1; p--) {
        if(*p == '/' && (p-path + 2) < result_size) {
            memcpy(result, path, p-path);
            result[p-path] = '/';
            result[p-path+1] = 0;
            
            return;
        }
    }

    xstrncpy(result, "", result_size);
}

//////////////////////////////////////////////////////////////////////
// ?J?????g?f?B???N?g?????Ԃ?
//////////////////////////////////////////////////////////////////////
void mygetcwd(SPACE char* result, int result_size)
{
    int l;
    
    l = 50;
    while(!getcwd(result, l)) {
         l += 50;
         if(l+1 >= result_size) {
            break;
         }
    }
}

//////////////////////////////////////////////////////////////////////
// ?????????S?????????ɂ???
//////////////////////////////////////////////////////////////////////
void mystrtolower(char* result)
{
    int i;

    const int len = strlen(result);
    for(i=0; i<len; i++) {
        result[i] = tolower(result[i]);
    }
}

//////////////////////////////////////////////////////////////////////
// パスを絶対パスにする
//////////////////////////////////////////////////////////////////////
int correct_path(char* current_path, char* path, char* path2, int path2_size)
{
    char tmp[PATH_MAX];
    char tmp2[PATH_MAX];
    char tmp3[PATH_MAX];
    char tmp4[PATH_MAX];

    /// 先頭にカレントパスを加える ///
    {
        if(path[0] == '/') {      /// 絶対パスなら必要ない
            xstrncpy(tmp, path, PATH_MAX);
        }
        else {
            if(current_path == NULL) {
                char cwd[PATH_MAX];
                mygetcwd(cwd, PATH_MAX);
                
                xstrncpy(tmp, cwd, PATH_MAX);
                xstrncat(tmp, "/", PATH_MAX);
                xstrncat(tmp, path, PATH_MAX);
            }
            else {
                xstrncpy(tmp, current_path, PATH_MAX);
                if(current_path[strlen(current_path)-1] != '/') {
                    xstrncat(tmp, "/", PATH_MAX);
                }
                xstrncat(tmp, path, PATH_MAX);
            }
        }

    }

    xstrncpy(tmp2, tmp, PATH_MAX);

    /// .を削除する ///
    {
        char* p;
        char* p2;
        int i;

        p = tmp3;
        p2 = tmp2;
        while(*p2) {
            if(*p2 == '/' && *(p2+1) == '.' && *(p2+2) != '.' && ((*p2+3)=='/' || *(p2+3)==0)) {
                p2+=2;
            }
            else {
                *p++ = *p2++;
            }
        }
        *p = 0;

        if(*tmp3 == 0) {
            *tmp3 = '/';
            *(tmp3+1) = 0;
        }

    }

    /// ..を削除する ///
    {
        char* p;
        char* p2;

        p = tmp4;
        p2 = tmp3;

        while(*p2) {
            if(*p2 == '/' && *(p2+1) == '.' && *(p2+2) == '.' 
                && *(p2+3) == '/')
            {
                p2 += 3;

                do {
                    p--;

                    if(p < tmp4) {
                        xstrncpy(path2, "/", path2_size);
                        return FALSE;
                    }
                } while(*p != '/');

                *p = 0;
            }
            else if(*p2 == '/' && *(p2+1) == '.' && *(p2+2) == '.' 
                && *(p2+3) == 0) 
            {
                do {
                    p--;

                    if(p < tmp4) {
                        xstrncpy(path2, "/", path2_size);
                        return FALSE;
                    }
                } while(*p != '/');

                *p = 0;
                break;
            }
            else {
                *p++ = *p2++;
            }
        }
        *p = 0;
    }

    if(*tmp4 == 0) {
        xstrncpy(path2, "/", path2_size);
    }
    else {
        xstrncpy(path2, tmp4, path2_size);
    }

    return TRUE;
}

//////////////////////////////////////////////////////////////////////
// ?????????????Ԃ?
//////////////////////////////////////////////////////////////////////
char* mystrcasestr(const char *haystack, const char *needle)
{
    char* p;
    p = (char*)haystack;

    while(*p) {
        char* p2;
        char* p3;
        BOOL match;

        p2 = p;
        p3 = (char*)needle;
        
        match = TRUE;
        while(*p3) {
            if(*p2 == 0) {
                match = FALSE;
                break;
            }
            
            if(tolower(*p2) != tolower(*p3)) {
                match = FALSE;
                break;
            }
            
            p2++;
            p3++;
        }
        
        if(match) {
            return p;
        }
        
        p++;
    }
    
    return NULL;
}

char* xstrncpy(char* des, char* src, int size)
{
    des[size-1] = 0;
    return strncpy(des, src, size-1);
}

char* xstrncat(char* des, char* str, int size)
{
    des[size-1] = 0;
    return strncat(des, str, size-1);
}
