/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Vector;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.junit.FormatterElement;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;

public class JUnitTestRunner
implements TestListener {
    public static final int SUCCESS = 0;
    public static final int FAILURES = 1;
    public static final int ERRORS = 2;
    private Vector formatters = new Vector();
    private TestResult res;
    private boolean haltOnError = false;
    private boolean haltOnFailure = false;
    private Test suite = null;
    private Exception exception;
    private int retCode = 0;
    private JUnitTest junitTest;
    private static Vector fromCmdLine = new Vector();

    public JUnitTestRunner(JUnitTest jUnitTest, boolean bl, boolean bl2) {
        this(jUnitTest, bl, bl2, null);
    }

    public JUnitTestRunner(JUnitTest jUnitTest, boolean bl, boolean bl2, ClassLoader classLoader) {
        this.junitTest = jUnitTest;
        this.haltOnError = bl;
        this.haltOnFailure = bl2;
        try {
            Class<?> clazz = null;
            clazz = classLoader == null ? Class.forName(jUnitTest.getName()) : classLoader.loadClass(jUnitTest.getName());
            Method method = null;
            try {
                method = clazz.getMethod("suite", new Class[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.suite = method != null ? (Test)method.invoke(null, (Object[])new Class[0]) : new TestSuite(clazz);
        }
        catch (Exception exception) {
            this.retCode = 2;
            this.exception = exception;
        }
    }

    public void run() {
        this.res = new TestResult();
        this.res.addListener((TestListener)this);
        int n = 0;
        while (n < this.formatters.size()) {
            this.res.addListener((TestListener)this.formatters.elementAt(n));
            ++n;
        }
        long l = System.currentTimeMillis();
        this.fireStartTestSuite();
        if (this.exception != null) {
            int n2 = 0;
            while (n2 < this.formatters.size()) {
                ((TestListener)this.formatters.elementAt(n2)).addError(null, (Throwable)this.exception);
                ++n2;
            }
            this.junitTest.setCounts(1L, 0L, 1L);
            this.junitTest.setRunTime(0L);
        } else {
            this.suite.run(this.res);
            this.junitTest.setCounts(this.res.runCount(), this.res.failureCount(), this.res.errorCount());
            this.junitTest.setRunTime(System.currentTimeMillis() - l);
        }
        this.fireEndTestSuite();
        if (this.retCode != 0 || this.res.errorCount() != 0) {
            this.retCode = 2;
        } else if (this.res.failureCount() != 0) {
            this.retCode = 1;
        }
    }

    public int getRetCode() {
        return this.retCode;
    }

    public void startTest(Test test) {
    }

    public void endTest(Test test) {
    }

    public void addFailure(Test test, Throwable throwable) {
        if (this.haltOnFailure) {
            this.res.stop();
        }
    }

    public void addFailure(Test test, AssertionFailedError assertionFailedError) {
        this.addFailure(test, (Throwable)assertionFailedError);
    }

    public void addError(Test test, Throwable throwable) {
        if (this.haltOnError) {
            this.res.stop();
        }
    }

    private void fireStartTestSuite() {
        int n = 0;
        while (n < this.formatters.size()) {
            ((JUnitResultFormatter)this.formatters.elementAt(n)).startTestSuite(this.junitTest);
            ++n;
        }
    }

    private void fireEndTestSuite() {
        int n = 0;
        while (n < this.formatters.size()) {
            ((JUnitResultFormatter)this.formatters.elementAt(n)).endTestSuite(this.junitTest);
            ++n;
        }
    }

    public void addFormatter(JUnitResultFormatter jUnitResultFormatter) {
        this.formatters.addElement(jUnitResultFormatter);
    }

    public static void main(String[] stringArray) throws IOException {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        if (stringArray.length == 0) {
            System.err.println("required argument TestClassName missing");
            System.exit(2);
        }
        int n = 1;
        while (n < stringArray.length) {
            if (stringArray[n].startsWith("haltOnError=")) {
                bl2 = Project.toBoolean((String)stringArray[n].substring(12));
            } else if (stringArray[n].startsWith("haltOnFailure=")) {
                bl3 = Project.toBoolean((String)stringArray[n].substring(14));
            } else if (stringArray[n].startsWith("formatter=")) {
                try {
                    JUnitTestRunner.createAndStoreFormatter(stringArray[n].substring(10));
                }
                catch (BuildException buildException) {
                    System.err.println(buildException.getMessage());
                    System.exit(2);
                }
            }
            ++n;
        }
        JUnitTest jUnitTest = new JUnitTest(stringArray[0]);
        JUnitTestRunner jUnitTestRunner = new JUnitTestRunner(jUnitTest, bl2, bl3);
        JUnitTestRunner.transferFormatters(jUnitTestRunner);
        jUnitTestRunner.run();
        System.exit(jUnitTestRunner.getRetCode());
    }

    private static void transferFormatters(JUnitTestRunner jUnitTestRunner) {
        int n = 0;
        while (n < fromCmdLine.size()) {
            jUnitTestRunner.addFormatter((JUnitResultFormatter)fromCmdLine.elementAt(n));
            ++n;
        }
    }

    private static void createAndStoreFormatter(String string) throws BuildException {
        FormatterElement formatterElement = new FormatterElement();
        int n = string.indexOf(44);
        if (n == -1) {
            formatterElement.setClassname(string);
        } else {
            formatterElement.setClassname(string.substring(0, n));
            formatterElement.setOutfile(new File(string.substring(n + 1)));
        }
        fromCmdLine.addElement(formatterElement.createFormatter());
    }
}

