/*************************************************************************
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Kohei Yoshida.
 *    1039 Kingsway Dr., Apex, NC 27502, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "numeric/exception.hxx"

namespace scsolver { namespace numeric {

Exception::Exception(const char* msg) :
    m_msg(msg)
{
}

Exception::Exception(const ::std::string& msg) :
    m_msg(msg)
{
}

Exception::~Exception() throw()
{
}

const char* Exception::what() const throw()
{
    return m_msg.c_str();
}

const char* ConstraintError::what() const throw()
{
	return "Constraint error";
}

const char* AssertionWrong::what() const throw()
{
	return "Wrong assertion! (tell Kohei immediately)";
}

const char* ModelInfeasible::what() const throw()
{
	return "Model infeasible";
}

const char* MaxIterationReached::what() const throw()
{
	return "Maximum iteration reached";
}

const char* IterationTimedOut::what() const throw()
{
	return "Iteration timed out";
}

const char* UnboundedException::what() const throw()
{
    return "Unbounded exception";
}

}}
