/*************************************************************************
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2008 by Kohei Yoshida.
 *    1039 Kingsway Dr., Apex, NC 27502, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "numeric/rosenbrock.hxx"
#include "numeric/funcobj.hxx"
#include "numeric/type.hxx"
#include "numeric/nlpmodel.hxx"
#include "numeric/exception.hxx"
#include "numeric/testtool.hxx"

using namespace ::scsolver::numeric;
using namespace ::std;
using ::scsolver::numeric::nlp::Rosenbrock;

class TestFunc1 : public SimpleFuncObj
{
public:
    TestFunc1() :
        SimpleFuncObj(2)
    {
        // initial values
        setVar(0, 0);
        setVar(1, 3);
    }

    virtual ~TestFunc1()
    {
    }

    virtual double eval() const
    {
        vector<double> vars;
        getVars(vars);
        double term1 = vars[0] - 2;
        term1 *= term1*term1*term1;

        double term2 = vars[0] - 2.0*vars[1];
        term2 *= term2;

        return term1 + term2;
    }

    /**
     * Return a display-friendly function string.
     */
    virtual const string getFuncString() const
    {
        return string("(x1 - 2)^4 + (x1 - 2*x2)^2");
    }
};

int main()
{
    runNonLinearTest(new Rosenbrock, new TestFunc1);
}
