[manpage_begin ripemd128 n 1.0.3]
[moddesc   {RIPEMD Message-Digest Algorithm}]
[copyright {2004, Pat Thoyts <patthoyts@users.sourceforge.net>}]
[titledesc {RIPEMD-128 Message-Digest Algorithm}]
[require Tcl 8.2]
[require ripemd128 [opt 1.0.3]]
[description]
[para]

This package is an implementation in Tcl of the RIPEMD-128 message-digest
algorithm (1). This algorithm takes an arbitrary quantity of data and
generates a 128-bit message digest from the input. The RIPEMD-128 
algorithm is based upon the MD4 algorithm (2, 4) but has been
cryptographically strengthened against weaknesses that have been found
in MD4 (4). RIPEMD-128 has been designed to be a drop-in replacement
for MD4 and MD5 (5). If security is the major consideration, then
RIPEMD-160 or SHA1 should be considered.

[para]

This package will use [package Trf] to
accelerate the digest computation if available. In
the absence of an accelerator package the pure-Tcl implementation will
be used.

[section {COMMANDS}]

[list_begin definitions]

[call [cmd "::ripemd::ripemd128"] \
        [opt "[arg -hex]"] \
        [lb] [arg "-channel channel"] | \
        [arg "-file filename"] | [arg "string"] [rb]]

Calculate the RIPEMD-128 digest of the data given in string. This is
returned as a binary string by default. Giving the [arg "-hex"] option
will return a hexadecimal encoded version of the digest.

[para]

The data to be hashed can be specified either as a string argument to
the ripemd128 command, or as a filename or a pre-opened channel. If the 
[arg "-filename"] argument is given then the file is opened, the data read
and hashed and the file is closed. If the [arg "-channel"] argument is
given then data is read from the channel until the end of file. The
channel is not closed.

[para]

Only one of [arg "-file"], [arg "-channel"] or [arg "string"] should be given.

[call [cmd "::ripemd::hmac128"] \
        [opt "[arg -hex]"] \
        [arg "-key key"]  \
        [lb] [arg "-channel channel"] | \
        [arg "-file filename"] | [arg "string"] [rb]]

Calculate an Hashed Message Authentication digest (HMAC) using the
RIPEMD-128 digest algorithm. HMACs are described in RFC 2104 (6) and
provide a RIPEMD-128 digest that includes a key. All options other
than [arg -key] are as for the [cmd "::ripemd::ripemd128"] command.

[list_end]

[section {PROGRAMMING INTERFACE}]

For the programmer, hash functions can be viewed as a bucket into which
one pours data. When you have finished, you extract a value that is
uniquely derived from the data that was poured into the bucket. The 
programming interface to the hash operates on a token (equivalent to the
bucket). You call [cmd RIPEMD128Init] to obtain a token and then call 
[cmd RIPEMD128Update] as many times as required to add data to the hash. To
release any resources and obtain the hash value, you then call 
[cmd RIPEMD128Final]. An equivalent set of functions gives you a keyed
digest (HMAC).

[para]

If you have [package critcl] and have built the [package tcllibc]
package then the implementation of the hashing function will be
performed by compiled code. Alternatively if both the Trf and Memchan
extensions are available then these will be used. Finally the package
will revert to a pure-Tcl implementation.  The programming interface
remains the same, however.

[list_begin definitions]

[call [cmd "::ripemd::RIPEMD128Init"]]

Begins a new RIPEMD-128 hash. Returns a token ID that must be used for the
remaining functions.

[call [cmd "::ripemd::RIPEMD128Update"] [arg "token"] [arg "data"]]

Add data to the hash identified by token. Calling 
[emph {RIPEMD128Update $token "abcd"}] is equivalent to calling
[emph {RIPEMD128Update $token "ab"}] followed by 
[emph {RIPEMD128Update $token "cb"}]. See [sectref {EXAMPLES}].


[call [cmd "::ripemd::RIPEMD128Final"] [arg "token"]]

Returns the hash value and releases any resources held by this
token. Once this command completes the token will be invalid. The
result is a binary string of 16 bytes representing the 128 bit
RIPEMD-128 digest value.

[call [cmd "::ripemd::RIPEHMAC128Init"] [arg "key"]]

This is equivalent to the [cmd "::ripemd::RIPEMD128Init"] command
except that it requires the key that will be included in the HMAC.

[call [cmd "::ripemd::RIPEHMAC128Update"] [arg "token"] [arg "data"]]
[call [cmd "::ripemd::RIPEHMAC128Final"] [arg "token"]]

These commands are identical to the RIPEMD128 equivalent commands.

[list_end]

[section {EXAMPLES}]

[example {
% ripemd::ripemd128 -hex "Tcl does RIPEMD-128"
3cab177bae65205d81e7978f63556c63
}]

[example {
% ripemd::hmac128 -hex -key Sekret "Tcl does RIPEMD-128"
b359dc5971a05beea0be7b106b30e389
}]

[example {
% set tok [ripemd::RIPEMD128Init]
::ripemd::1
% ripemd::RIPEMD128Update $tok "Tcl "
% ripemd::RIPEMD128Update $tok "does "
% ripemd::RIPEMD128Update $tok "RIPEMD-128"
% ripemd::Hex [ripemd::RIPEMD128Final $tok]
3cab177bae65205d81e7978f63556c63
}]

[section {REFERENCES}]

[list_begin enumerated]

[enum]
        H. Dobbertin, A. Bosselaers, B. Preneel, 
        "RIPEMD-160, a strengthened version of RIPEMD"
        [uri http://www.esat.kuleuven.ac.be/~cosicart/pdf/AB-9601/AB-9601.pdf]

[enum]
       Rivest, R., "The MD4 Message Digest Algorithm", RFC 1320, MIT,
       April 1992. ([uri http://www.rfc-editor.org/rfc/rfc1320.txt])

[enum]
       Rivest, R., "The MD4 message digest algorithm", in A.J.  Menezes
       and S.A. Vanstone, editors, Advances in Cryptology - CRYPTO '90
       Proceedings, pages 303-311, Springer-Verlag, 1991.

[enum]
        Dobbertin, H., "Cryptanalysis of MD4", Journal of Cryptology
        vol 11 (4), pp. 253-271 (1998)

[enum]
       Rivest, R., "The MD5 Message-Digest Algorithm", RFC 1321, MIT and
       RSA Data Security, Inc, April 1992.
	([uri http://www.rfc-editor.org/rfc/rfc1321.txt])

[enum]
      Krawczyk, H., Bellare, M. and Canetti, R. "HMAC: Keyed-Hashing for 
      Message Authentication", RFC 2104, February 1997.
	([uri http://www.rfc-editor.org/rfc/rfc2104.txt])

[list_end]

[section {BUGS, IDEAS, FEEDBACK}]

This document, and the package it describes, will undoubtedly contain
bugs and other problems.

Please report such in the category [emph ripemd] of the
[uri {http://sourceforge.net/tracker/?group_id=12883} {Tcllib SF Trackers}].

Please also report any ideas for enhancements you may have for either
package and/or documentation.


[see_also md4 md5 sha1 ripemd160]
[keywords RIPEMD md4 hashing message-digest security {rfc 1320} {rfc 1321} {rfc 2104}]
[manpage_end]
