
\input csmac % Makra pro etinu
\pageheight=9.5in \fullpageheight=9.8in  \setpage
%\nocon % omit table of contents
\datethis % print date on listing

\def\begitems{\medskip\bgroup\catcode`\*=13 \narrower\narrower}
\def\enditems{\par\egroup\medskip}
{\catcode`\*=13 \gdef*{\par\noindent\llap{$\bullet$\ }\ignorespaces}}


@* PROGRAM VLNA.
Program te vstupn textov soubor a nahrazuje za specifikovanmi
jednopsmennmi slovy (nap.~v, k, u) mezery symbolem \uv{\.{\char126}}. To
zabrn pi nslednm zpracovn \TeX{}em zlomit dek na nevhodnch
mstech, kter jsou v rozporu s typografickou normou.

Program sestv z tchto hlavnch celk:
@c
@<Hlavikov soubory k naten@>@/
@<Globln deklarace@>@/
@<Pomocn funkce@>@/
@<Vlnkovac funkce |tie|@>@/
@<Hlavn program@>

@ Definujeme |BANNER|, co je text, kter se objevi pi startu
programu a obsahuje slo verze programu. 
Zde je nzorn vidt, e mchn dvou jazyk se nevyhneme. Pi tisku
text na terminl nesmme pedpokldat, e tam budou esk fonty.
V~tto dokumentaci se setkme se temi jazyky: anglitinou (vtinou
v~kdu programu, cestinou v~/* komentch */ a etinou jinde.
Tu cestinu si vynutil fakt, e DOS-ovsk varianta \.{tangle} a
\.{weave} se nesn s~akcentovanmi psmeny v~/* komentch */.
A~nyn u slben (vcejazyn) |BANNER|.
@d BANNER "This is program vlna, version 1.2, (c) 1995, 2002 Petr Olsak\n"

@ V programu jsou pouity knihovn funkce, jejch prototypy jsou
definovny ve tech standardnch hlavikovch souborech.
@<Hlavikov ...@>=
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

@ Definujeme konstanty pro nvratov kd. |OK| pro spn bh,
|WARNING| pi vskytu aspo jedn varovn zprvy, |IO_ERR| pro chybu
v~pstupu ke vtupnm nebo vstupnm souborm, |BAD_OPTIONS| pro
syntaktickou chybu na pkazov dce a |BAD_PROGRAM| pro ppad
havrie programu. Ta by nemla nikdy nastat. Promnn |status| bude
obsahovat nvratov kd a promnn |prog_name| bude ukazovat na text
nultho parametru pkazov dky.
@d OK 0
@d WARNING 1
@d IO_ERR 2
@d BAD_OPTIONS 3
@d BAD_PROGRAM 4
@<Globln deklarace@>=
char *prog_name;
int status;

@ Zkladn rozvren funkce |main|.
@<Hlavn program@>=
int main (int argc, char **argv)
{
  @<Lokln promnn funkce |main|@>;
  prog_name=argv[0]; status = OK;
  @<Naten parametr pkazovho dku@>;
  if (!silent) fprintf (stderr, BANNER);
  @<Inicializace datovch struktur@>;
  @<Zpracovn soubor@>;
  return status;
}

@* Parametry pkazovho dku.
Program te z~pkazovho dku postupn (nepovinn) parametry,
kter zanaj znakem \uv{\.{-}}. Pak nsleduj jmna vstupnch a vstupnch
soubor.
\begitems
* \.{-f} \dots\ program pracuje jako filtr (viz sekce |@<Zpracovn
  soubor@>|). Nen-li tento parametr pouit, program pracuje v tzv.
  standardnm reimu, kdy jednotliv soubory jsou vstupn i vstupn.
* \.{-s} \dots\ program nevype |BANNER|, ani sumarizaci, ani varovn,
  pi nich nen program pedasn ukonen.  Vechny tyto vpisy
  smuj do |stderr|, take pokud program pracuje v reimu \uv{filtr},
  nen nutn tento parametr pout.
* \.{-r} \dots\ program mae pracovn soubor (soubory), kter vytv
  ve standardnm reimu (tj. nen pouit \.{-f}). V reimu filter nem
  tento parametr vliv.
* \.{-v} \dots\ parametr definuje skupinu psmen, kter budou
  interpretovny jako neslabin pedloky.
  Nap. \.{-v KkSsVvZzOoUuAI}. Pokud nen parametr uveden, je pouita
  skupina uveden v tomto pklad.
* \.{-m} \dots\ program neprovd kontrolu math/text md, tj. vlnkuje i
  uvnit matematickho mdu \TeX{}u. (Implicite tam nevlnkuje).
* \.{-n} \dots\ prorgram neprovd kontrolu verbatim mdu, tj. vlnkuje i
  uvnit verbatim mdu definovanm bnmi prostedmi. Imlicite ve
  verbatim prosted nevlnkuje.
* \.{-l} \dots\ La\TeX{} reim. Pi kontrole text-math-verbatim md jsou
  brny v vahu dal sekvence, obvykl v La\TeX{}ovch dokumentech.
* \.{-w} \dots\ WEB reim. Ohranien verbatim mdu je doplnno znaky
  pouvanmi v dokumentech WEB (nap. tento dokument). Dsledek: program
  vlnkuje dokumentan st kad sekce, ale nikoli kd.
\enditems

Definujeme funkci |printusage|, kter tiskne (pi chyb) strun pehled
monch parametr. Nepodailo se mi zjistit, jak se ve WEBu nape
kulturn dlouh string obsahujc \.{\char92n} s formtovacmi
poadavky. Byl jsem nucen to takto nehezky zapsat.
@<Pomocn funkce@>=
static void printusage (void)
{
  fprintf(stderr,
    "usage: vlna [opt] [filenames]\n"
    "  opt -f :  filter mode: file1 file2 ... file1->file2\n"
    "                         file1       ... file1->stdout\n"
    "                                     ... stdin->stdout\n"
    "            nofilter: file1 [file2 file3 ...] all are in/out\n"
    "      -s :  silent: no messages to stderr\n"
    "      -r :  rmbackup: if nofilter, removes temporary files\n"
    "      -v charset :  set of lettres to add tie, default: KkSsVvZzOoUuAI\n" 
    "      -m :  nomath: ignores math modes\n"
    "      -n :  noverb: ignores verbatim modes\n"
    "      -l :  LaTeX mode\n"
    "      -w :  web mode\n");
}

@ Promnn |isfilter|, |silent|, |rmbackup|, |nomath|, |noverb|,
|latex|, resp. |web| kaj, e je nastaven parametr \.{-f}, \.{-s},
\.{-r}, \.{-m}, \.{-n}, \.{-l}, resp. \.{-w}.  Promnn |charset|
ukazuje bu na implicitn skupinu znak |charsetdefault|, nebo (pi
pouit parametru \.{-v}) na text uveden v pkazovm dku. 
@<Globln deklarace@>=
int isfilter=0, silent=0, rmbackup=0, nomath=0, noverb=0, web=0, latex=0;
char charsetdefault[]="KkSsVvZzOoUuAI";
char *charset=charsetdefault;

@ @<Naten parametr ...@>=
while (argc>1 && argv[1][0] == '-') {
  if (argv[1][2] != 0) printusage (), exit (BAD_OPTIONS);
  switch(argv[1][1]) {
  case 'f': isfilter = 1; break;
  case 's': silent = 1; break;
  case 'r': rmbackup = 1; break;
  case 'v': if (argc<2) printusage (), exit (BAD_OPTIONS);
    argv++; argc--; charset = argv[1]; break;
  case 'm': nomath = 1; break;
  case 'n': noverb = 1; break;
  case 'l': latex = 1; break;
  case 'w': web = 1; break;
  default: printusage (), exit (BAD_OPTIONS);
          /* nezn\'am\'y parametr */
  }
  argc--; argv++;
}

@* Zpracovn soubor.  Parametr |MAXLEN| definuje maximln monou
dlku jmna souboru, kter vytvome jako pechodn, nebo zlohov.
Dle deklarujeme promnn typu \uv{stream}.
@d MAXLEN 120
@<Lokln promnn funkce...@>=
FILE *infile, *outfile;
char backup[MAXLEN];
int j;

@ Definujeme funkci pro vpis chybovho hlen pi nespnm oteven
souboru.
@<Pomocn funkce@>=
static void ioerr (char *f)
{
   fprintf(stderr, "%s: cannot open file %s\n", prog_name, f);
}

@ Zpsob zpracovn soubor rozlime podle reimu danm pepnaem \.{-f}.
@<Zpracovn soubor@>=
if (isfilter)  @<Zpracovn v reimu filter@> @/
else   @<Zpracovn vech soubor pkazov dky@>

@ V reimu |isfilter==1| je dal zpracovn zvisl na potu soubor v
pkazov dce:
\begitems
* nula soubor -- vstup je |stdin| a vstup je |stdout|,
* jeden soubor -- je vstupn, vstup je |stdout|,
* dva soubory -- prvn je vstupn, druh vstupn,
* vce soubor -- program skon s chybou.
\enditems
@<Zpracovn v reimu filter@>=
{
  if (argc > 3) printusage (), exit (BAD_OPTIONS) ;
  infile = stdin; outfile = stdout;
  if (argc >= 2) infile = fopen (argv[1], "r");
  if (infile == NULL)  ioerr (argv[1]), exit (IO_ERR);
  if (argc == 3) outfile = fopen(argv[2], "w");
  if (outfile == NULL) ioerr (argv[2]), exit (IO_ERR);
  if (argc >= 2) filename = argv[1];
  else filename = NULL;
  tie (infile, outfile);
  if (outfile != stdout) fclose (outfile);
  if (infile != stdin) fclose (infile);
}

@ V~reimu |isfilter==0| jsou jednotliv soubory v~pkazovm dku
interpretovny jako vstupn i vstupn. Vce soubor v~pkazovm dku m
stejn efekt, jako opakovan voln programu na jednotliv soubory.
V~\UNIX/u lze tedy nap. napsat \.{\jobname\ *.tex} a program dopln vlnky do
vech soubor s~pponou~\.{tex}. Toto neplat v~DOSu, protoe interpretace
masky je v~\UNIX/u starost shellu a nikoli programu samotnho. N program
masku nebude interpretovat. Je-li v~tomto reimu nulov poet soubor,
program se ukon s~chybou. 
@<Zpracovn vech soubor pkazov dky@>=
{
  if (argc==1) printusage (), exit(BAD_OPTIONS);
  while (argc>1) {
     argc--; argv++;
     @<Pejmenuj vstup |argv[0]| na |backup| a otevi jej jako |infile|@>;
     if (infile == NULL) {
       ioerr (argv[0]); continue;
     }
     outfile = fopen (argv[0], "w");
     if (outfile == NULL) {
       ioerr (argv[0]);
       rename (backup, argv[0]); 
       status = WARNING; 
       continue;
     }
     filename = argv[0];
     tie (infile, outfile);
     fclose (outfile), fclose (infile);
     if (rmbackup) remove (backup);
   }
}

@ Pi |isfilter==0| program pejmenuje kad  zpracovvan soubor tak, e
zmn posledn psmeno nzvu souboru na znak \.{\char126}. Tento
pejmenovan soubor bude oteven jako vstupn a vstupem bude pvodn
soubor. Vstupn soubor pi |rmbackup==0| zstane zachovn jako zloha.

Pro vlnku nepidvme na konec nzvu souboru, ale mnme ji za posledn
znak souboru? Protoe chceme, aby program fungoval i v tak nemonch
systmech, jako je DOS.
@<Pejmenuj vstup...@>=
infile = NULL;
j = strlen (argv[0]) - 1;
if (j >= MAXLEN || argv[0][j] == '~') {
   if (!silent) fprintf (stderr, "%s: the conflict of file name %s\n",
      prog_name, argv[0]);
}
else {
  strcpy (backup, argv[0]);
  backup[j] = '~';
  remove (backup);
  j = rename (argv[0], backup);
  if (j == 0) infile = fopen (backup, "r");
}

@* Patterny.  Abychom mohli eln definovat chovn programu
v~rznch situacch, zavedeme datovou strukturu |PATTERN|. Zhruba
eeno, budeme sledovat vstup znak po znaku a pokud bude st vstupu
souhlasit s~definovanm patternem, provedeme nmi poadovanou
akci. Napklad nejastj aktivitu, pidn vlnky uvnit dku,
spustme v~okamiku, kdy vstupn text odpovd patternu \uv{\.{\ (v\
p}}, kde \uv{\.{\ }} znamen jedna nebo vce mezer a tabeltor,
\uv{\.{(}} je nula nebo vce otevracch zvorek veho druhu,
\uv{\.{v}} znamen jedno psmeno z~mnoiny pedloek (viz |charset|) a
\uv{\.{p}} zde znamen libovoln psmeno. Pklad zde nen zcela pesn.
Pesn jsou vechny patterny pro n program definovny v~zvrench
sekcch tohoto povdn.

Pattern bude znamenat konenou sekvenci tzv. pozic patternu (|PATITEM|).
Cykly uvnit pozic pro jednoduchost nepipustme. Kad pozice obsahuje
etzec znak, uvaovan pro danou pozici (v~pkladu pozice~\uv{\.{\ }} by
obsahovala mezeru a tabeltor, zatmco pozice \.{v} odpovd |charset|).
Kad pozice m svj pepna (|flag|), kter obsahuje informaci o~tom,
zda shodu testovanho znaku s~nkterm prvkem v~mnoin znak
budeme povaovat za spch i nespch a zda pozice se ve zkoumanm
etzci me vyskytovat prv jednou nebo opakovan. Jako druh ppad
sta implementovat \uv{nula nebo vce} protoe \uv{jedna nebo vce} lze
popsat pomoc dvou pozic, prvn \uv{prv jednou} a nsledujc \uv{nula
nebo vce}. Jednotliv pozice jsou zetzeny ukazatelem |next|, posledn
pozice m |next==NULL|. Stejn tak jednotliv patterny budeme
sestavovat do seznam a budou rovn zetzeny ukazatelem |next|.

Pattern krom etzu pozic obsahuje ukazatel na funkci (proceduru) |proc|,
kter se m vykonat v~ppad, e testovan etzec vyhovuje patternu. 

@d ONE      1        /* flag: prave jeden vyskyt */
@d ANY      2        /* flag: nula nebo vice */
@d ONE_NOT -1        /* flag: prave jednou, znak nesmi byt v mnozine */
@d ANY_NOT -2        /* flag: nula nebo vice, znak nesmi byt v mnozine */

@<Globln deklarace@>=
typedef struct PATITEM {     /* jedna pozice patternu */
   char *str;                /* seznam znaku na teto pozici */
   int flag;                 /* vyznam seznamu znaku */
   struct PATITEM *next ;    /* nasledujici pozice patternu */
} PATITEM;
typedef struct PATTERN {     /* jeden pattern */
   PATITEM *patt;            /* ukazatel na prvni pozici */
   void (*proc)(void);       /* procedura spustena pri souhlasu patternu */
   struct PATTERN *next ;    /* nasledujici v seznamu vsech patternu */
} PATTERN;

@ Deklarujeme nkter globln promnn pro prci s~patterny. |lapi| je pole
obsahujc ukazatele na aktuln pozice v~otevench patternech. kme,
e \uv{pattern je oteven}, pokud zkouman etzec s~nm {\it zan\/}
souhlasit. Pattern se uzave, pokud nastane jedna ze dvou monost:
zkouman etzec s~mm souhlas a do konce (v~takovm ppad se provede
procedura |proc|), nebo pi vyetovn dalch znak ze zkoumanho
etzce pestane etzec s~patternem souhlasit.

V~dan chvli me bt pattern oteven nkolikrt. Nap. pattern \.{abac}
je pi stringu \.{aba} pi vskytu druhho \.{a} oteven podruh. Proto
pole obsahuje ukazatele na prv aktuln pozici patternu a nikoli na
pattern jako takov.

V~poli |lapi| budou na potku sam |NULL| (to se pi pekladu inicializuje
samo) a pemazn ukazatele na pozici konstantou |NULL| budeme povaovat
za zaven patternu. Vedle pole |lapi| soumrn udrujeme pole |lapt|,
do nho budeme ukldat ukazatele na odpovdajc oteven pattern. Tuto
informaci pouijeme v~ppad, e potebujeme nap, znt |proc|
patternu.

|listpatt| bude ukazovat na zatek aktulnho seznamu pattern. Seznamy
budeme mt dva. Jeden se pouije, nachzme-li se mimo koment a druh
v~ppad, e se nachzme v~prostoru \TeX{}ovskho komente (tj. za
procentem). Starty tchto seznam pattern jsou |normallist| a
|commentlist| a aktivn |listpatt| m vdy jednu z~tchto dvou hodnot.

Promnn |lastpt| a |lastpi| pouijeme pro budovn etzov struktury
pattern.

Promnn |c| obsahuje prv testovan znak ze vstupu (kter se rovn
pepe do bufferu |buff|). Z~bufferu obas ukldme data do vstupnho
proudu. Dlme to ale vdy jen v~okamiku, kdy nen oteven dn
pattern. Tehdy toti \uv{nehroz} situace, e by njak procedura vyvolan
souhlasem patternu poadovala v~tomto bufferu njak zmny se zptnou
platnost. O~vyprzdnn bufferu se zaneme zajmat a v~okamiku, kdy je
zaplnn aspo na hodnotu |BUFI|, abychom proceduru pepisu bufferu do
vstupnho proudu neaktivovali zbyten asto.
@d MAXPATT 200       /* maximalni pocet patternu */
@d MAXBUFF 500      /* velikost bufferu pro operace */
@d BUFI 300         /* velikost stredniho zaplneni */
@<Globln deklarace@>=
PATITEM *lapi[MAXPATT];      /* pole ukazatelu na aktualni pozice */
PATTERN *lapt[MAXPATT];      /* pole odpovidajicich ukazatelu na patterny */
PATTERN *listpatt, *normallist, *commentlist, *pt, *lastpt=NULL;
PATITEM *lastpi=NULL;
char c;             /* zrovna nacetny znak */
char buff[MAXBUFF]; /* prechodny buffer */
int ind;            /* aktualni pozice prechodneho bufferu */

@ Nyn definujeme pomocn funkce |setpattern|, |setpi| a |normalpattern|.
Tyto funkce alokuj pam pomoc standardn funkce |malloc|. Abychom mohli
ohldat ppadnou chybu pi alokaci, budeme allokovat pam zprostedkovan
pomoc funkce |myalloc|.
@<Pomocn funkce@>=
static void *myalloc (int size)
{
  void *p;
  p = malloc (size);
  if (p == NULL)
  {
    fprintf (stderr, "%s, no memory, malloc failed\n", prog_name);
    exit (BAD_PROGRAM) ;
  }
  return p;
}

@ Funkce |setpattern| alokuje pamov msto struktury |PATTERN| a napoj
ji pomoc promnn |lastpt| na u alokovan etz pattern. 
Vrt ukazatel na nov alokovan msto. Jednotliv pozice patternu se mus
nsledovn alokovat pomoc |setpi|.
@<Pomocn funkce@>=
static PATTERN *setpattern (void (*proc)(void))
{
  PATTERN *pp;
  pp = myalloc (sizeof (PATTERN));
  pp->proc = proc;  
  pp->next = NULL;
  pp->patt = NULL;
  if (lastpt != NULL) lastpt->next = pp;
  lastpt = pp;
  lastpi = NULL;
  return pp;
}

@ Funkce |setpi| alokuje pamov msto pro jednu pozici patternu. Provede
zetzen tak, aby prvn pozice etzu pozic byla zaznamenna v poloce
|patt| ve struktue |PATTERN| a dal byly provzny polokou |next| ve
struktue |PATITEM|. Posledn pozice m |next==NULL|.
@<Pomocn funkce@>=
static void setpi (char *str, int flag)
{
  PATITEM* p;
  p = myalloc (sizeof (PATITEM));
  p->str = str; p->flag = flag;
  p->next = NULL;
  if (lastpi == NULL) lastpt->patt = p;
  else lastpi->next = p;
  lastpi = p;
}

@ Pipravme si pdu pro funkci |normalpattern|. Tato funkce alokuje
strukturu pro jeden pattern vetn pozic patternu na zklad vstupnho
stringu. Kad pozice patternu obsahuje v~mnoin znak jedin znak a m
|flag=ONE|. Znaky ve vstupnm stringu odpovdaj po ad jednotlivm
pozicm. Vytvo se vlastn jaksi absolutn pattern, tj. testovan etzec
se mus pesn shodovat s~uvedenm stringem. Vjimku tvo znak |"."|,
kter se interpretuje jako nula nebo vce mezer. Chceme-li teku
vnutit do patternu, napeme dv teky za sebou.

Nejdve deklarujeme pole vech monch jednopsmennch string.
@<Globln deklarace@>=
char strings[512];
int i;

@ Inicializujeme toto pole (znak, nula, znak, nula, atd...).
@<Inicializace datovch struktur@>=
for (i=0; i<256; i++) {
  strings[2*i] = (char) i; strings[2*i+1] = 0;
}

@ Definujme funkci |normalpattern|.
@<Pomocn funkce@>=
static PATTERN *normalpattern (void (*proc)(void), const char *str)
{
  PATTERN *pp;
  int j=0;
  pp = setpattern (proc);
  while (str[j]) {
    if (str[j]=='.') {
      j++;
      if (str[j]!='.') {
        setpi (blankscr, ANY); 
        continue;
      }
    }  
    setpi (&strings[(unsigned char)str[j]*2], ONE);
    j++;
  }
  return pp;
}

@ Funkce |match|. Definujeme funkci, kter na zklad hodnoty znaku |c|
(promnn |c| je definovna jako globln), a pozice patternu |p| (parametr
funkce) vrt informaci o tom, zda znak souhlas s patternem. Zporn sla
|FOUND|, resp. |NOFOUND| znamenaj, e je teba uzavt pattern s tm, e
vzor odpovd, resp. neodpovd patternu. Nezporn slo vrt v ppad,
e zkouman vstup stle souhlas s patternem, ale nen jet
rozhodnuto. Velikost nvratov hodnoty v takovm ppad udv, o kolik
pozic je teba se posunout v patternu, abychom mli ukazatel na pozici
patternu v souhlase s novou situac, zpsobenou znakem |c|.

Pokud je |c| v mnoin znak pro danou pozici |p->str|, bude |m==1|, jinak
je |m==-1|. Pokud tmto slem pronsobme hodnotu |p->flag|, nemusme
vtven podle |p->flag| programovat dvakrt. Hodnoty |flag| jsou toti
symetrick podle nuly, nap. |ANY==-ANY_NOT|.
@d FOUND   -1
@d NOFOUND -2
@<Pomocn funkce@>=
static int match (PATITEM *p)
{
  int m;
  if (strchr (p->str, c) != NULL) m = 1;  /* Znak nalezen */
  else m = -1;                            /* Znak nenalezen */
  switch (m * p->flag) {
  case ANY: return 0;                  /* Souhas, neni nutny posun */
  case ONE: if (p->next == NULL) return FOUND;
            return 1;                    /* Souhas, nutny posun o 1 */
  case ONE_NOT: return NOFOUND;          /* Nesouhlas */
  case ANY_NOT: @<Vra hodnotu podle nsledujc...@>;
  }
  return 0; /* Tady bychom nikdy nemeli byt, return pro potlaceni varovani */
}

@ O kolik pozic je teba se posunout a s jakm vsledkem zjistme
rekurzivnm volnm funkce |match|.
@<Vra hodnotu podle nsledujc pozice patternu@>=
switch (m = match (p->next)) {
case NOFOUND: return NOFOUND;
case FOUND: return FOUND;
default: return 1 + m;
}

@* Vlnkovac funkce.
Nejprve pipravme globln deklarace pro \uv{vlnkovac} funkci |tie|.
Funkce |tie| \uv{ovlnkuje} vstupn soubor |infile| a vytvo soubor
|outfile|.  Pi |silent=0| tiskne zvrenou zprvu o zpracovn. V tto
zprv se objev jmno souboru, kter se funkce \uv{dozv} prostednictvm
globln promnn |filename|. Promnn |numline| pot dky, promnn
|numchanges| st zmny, tj. poet doplnnch vlnek. 
Promnn |mode| nabv nkter z hodnot |TEXTMODE|, |MATHMODE|,
|DISPLAYMODE| a |VERBMODE| podle stavu ve tenm textu.
@d TEXTMODE 0
@d MATHMODE 1
@d DISPLAYMODE 2
@d VERBMODE 3
@<Globln deklarace@>=
char *filename;     /* jmeno zpracovavaneho souboru */
long int numline, numchanges;   /* pro zaverecnou statistiku */
int mode;   

@ Nyn definujeme vlnkovac funkci |tie|. Veker innost se opr o
strukturu pattern. Vhodn je (z dvodu rychlosti) \uv{natvrdo} zde
implementovat jen pepnn mezi stavem ten z oblasti komente
(|listpatt==commentlist|) a mimo koment (|listpatt==normallist|);
@<Vlnkovac funkce |tie|@>=
static void tie (FILE *input, FILE *output)
{
  int ap;  /* ap je pocet otevrenych patternu */
  register int k, m, n;
  int ic;
  PATTERN *pp;
  PATITEM *pi;

  @<Inicializace promnnch pi startu funkce |tie|@>;

  while (!feof(input)) {
    @<Otevi nov patterny@>;
    if (ap == 0  && ind > BUFI && c !='\\') @<Vyprzdni buffer@>;
    if (ind >= MAXBUFF) {
      fprintf (stderr, "Operating buffer overflow, is anything wrong?\n");
      exit (BAD_PROGRAM);
    }
    if ((ic = getc(input)) == EOF)  /* opravil Cejka Rudolf */
      break;
    buff[ind++] = c = ic;
    if (c == '\n') numline++, listpatt = normallist;
    if (c == '%' && mode!=VERBMODE && buff[ind-2] != '\\') listpatt = commentlist;
    @<Projdi oteven patterny@>;
  }
  @<Vyprzdni buffer@>;
  if (!web) checkmode ();   /* zaverecna kontrola modu */
  if (!silent) @<Tiskni zvrenou zprvu@>;
}

@ @<Inicializace promnnch pi ...@>=
for (k=0; k<MAXPATT; k++) lapi[k] = NULL;
c = '\n';
buff[0] = mode = ap = 0;  ind = 1;
numline = 1; numchanges = 0;
mode = TEXTMODE;

@ Pi manipulaci s bufferem byl pouit jeden trik. Veker naten znaky
zanaj a od |buff[1]|, zatmco |buff[0]| je rovno nule. Je to proto, e
nkter algoritmy se vrac o jeden znak zpt za svj pattern, aby zjistily,
zda tam nen symbol \uv{\.{\char92}} (napklad na vskyt sekvence
\.{\char92\char37} je teba reagovat jinak, ne na vskyt obyejnho
procenta). Kdybychm zazaali od |buff[0]|, v nkterch situacch
bychom se ptali, zda |buff[-1]=='\\'|, tj. sahali bychom na neoeten
msto v pamti.
@<Vyprzdni buffer@>=
{
  buff[ind] = 0;
  fputs (&buff[1], output);
  ind = 1;
}

@ Pi prochzen otevenmi patterny posunujeme v poli |lapi| pozice
jednotlivch pattern podle pokyn funkce |match|, ppadn pattern zaveme
a ppadn vyvolme proceduru patternu. 

Nkter patterny v poli |lapi| u mohou bt zaveny, take je nutno s tmto
polem pracovat jako s jakmsi dravm srem.
@<Projdi oteven patterny@>=
n = ap; k = 0;
while (n) {
  while (lapi[k]==NULL) k++;  /* zastav se na prvnim ukazateli na pattern */
  switch (m = match (lapi[k])) {
  case FOUND:   (*lapt[k]->proc)();  /* Pattern nalezen, spustit proceduru */
  case NOFOUND: lapi[k] = NULL;  /* Deaktivace patternu */
                ap--; break;  
  default:  while (m--) lapi[k] = lapi[k]->next;  /* dalsi pozice patternu */
  }
  k++; n--;
}

@ Pi otevrn novch pattern, kter nejsou v tuto chvli zablokovny,
se hned vypodme s takovmi patterny, kter nm dvaj rovnou odpov
typu |FOUND| nebo |NOFOUND|. V takovch ppadech ani nezanme ukazatel
na pozici do pole |lapi|.
@<Otevi nov patterny@>=
pp = listpatt;
while (pp != NULL) {
  switch (m = match (pp->patt)) {
  case FOUND:    (*pp->proc)();   /* spustit proceduru */
  case NOFOUND: break;
  default: @<Vytvo ukazatel na nov pattern a |break|@>;
  }
  pp=pp->next;
}

@ Nen-li hned znma odpov, zda pattern vyhovuje i nikoli,
pekontrolujeme nejdve, zda u nen pattern ve stejn pozici oteven.
Pak najdeme prvn \uv{dru} v tabulce |lapi| a tam uhnzdme nov ukazatel
na pozici v patternu.
@<Vytvo ukazatel na nov pattern...@>=
pi = pp->patt;
while (m--) pi = pi->next;
n = ap;  k = 0;
while (n) {
  if (lapi[k]==pi) break;
  if (lapi[k++] != NULL) n--;
}
if (!n) {
  k = 0;
  while (lapi[k] != NULL) k++;
  if (k >= MAXPATT) {
    fprintf (stderr, "I cannot allocate pp, is anything wrong?\n");
    exit (BAD_PROGRAM);
  }
  lapt[k] = pp;  lapi[k] = pi; ap++;
}

@ Posledn vc ve funci |tie| je tisk zvren statistiky zpracovn.
@<Tiskni zvrenou zprvu@>=
fprintf (stderr, "~~~ file: %s\t  lines: %ld, changes: %ld\n", 
   filename, numline,  numchanges);

@* Inicializace pattern.
Po vytvoen pedchozho kdu oprajcho se o~patterny mme nyn v~ruce
pomrn siln nstroj na definovn rznch innost programu prostm
vytvoenm patternu a pslun jeho procedury. Pokud budeme chtt
v~budoucnu njak rys programu pidat, pravdpodobn to bude snadn.

Nejprve deklarujeme nkter asto pouvan skupiny znak v~patternech.

@<Globln deklarace@>=
char tblanks[] = " ~\t";
char blanks[] =  " \t";
char blankscr[] = " \t\n";
char tblankscr[] = " ~\t\n";
char nochar[] = "%~\n";
char cr[] = "\n";
char prefixes[] = "[({~";
char dolar[] = "$";
char backslash[] = "\\";
char openbrace[] = "{";
char letters[] = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
PATTERN *vlnkalist, *mathlist, *parcheck, *verblist ;

@ Zaneme definic nejastji pouvanho patternu na vlnkovn uvnit
dku. Pipomeme, e opakovan voln funkce |setpattern| vytv intern
seznam pattern, piem o~jejich propojen se nemusme starat. Vyzvedneme
si z~nvratovho kdu funkce pouze ukazatel na prvn poloku seznamu
|normallist|. Stejn tak opakovan voln funkce |setpi| vytv seznam
pozic pro naposledy deklarovan pattern.
@<Inicializace datovch struktur@>=
vlnkalist = setpattern (vlnkain);
setpi (tblankscr, ONE);
setpi (tblanks,   ANY);
setpi (prefixes,  ANY);
setpi (charset,   ONE);
setpi (blanks,    ONE);
setpi (blanks,    ANY);
setpi (nochar,    ONE_NOT);

@ @<Inicializace promnnch pi ...@>=
listpatt = normallist = vlnkalist;

@ @<Pomocn funkce@>=
static void vlnkain(void)
{
  char p;
  ind--;
  p = buff[ind--];
  while (strchr(blanks, buff[ind]) !=NULL) ind--;
  ind++;
  buff[ind++] = '~';
  buff[ind++] = p;
  numchanges++;
}

@ Podobn pro tvorbu vlnky \uv{pes dek} vytvome pattern a kd
procedury.
@<Inicializace dat...@>=
setpattern (vlnkacr);
setpi (tblankscr, ONE);
setpi (tblanks,   ANY);
setpi (prefixes,  ANY);
setpi (charset,   ONE);
setpi (blanks,    ANY);
setpi (cr,        ONE);
setpi (blanks,    ANY);
setpi (nochar,    ONE_NOT);

@ V procedue k tomuto patternu musme oetit ppad typu 
\uv{\.{a\char126v\char92np}},
kdy nelze prost pehodit \uv{\.{\char92n}} za \uv{\.{v}}, protoe 
bychom roztrhli
mezeru svzanou vlnkou u dve. Proto musme vyhledat vhodn msto pro
roztren dku, kter bude a {\it ped\/} znakem \uv{\.{a}}. Pi dslednm
oeten tohoto fenomnu meme dokonce narazit na situaci
\uv{\.{\char92n\ v\char126v\char126v\char92np}},  kde nememe vloit 
\uv{\.{\char92n}} ped prvn vskyt \uv{\.{v}}, protoe bychom dostali 
\uv{\.{\char92n\char92n}}, tedy przdn
dek. Ten je v \TeX{}u interperetovn odlin. V tto vjimen
situaci pouze zrume stvajc (v poad druh) \uv{\.{\char92n}} a
nebudeme vytvet nov. Na vstupu bude soubor o jeden dek krat.
@<Pomocn funkce@>=
static void vlnkacr(void)
{
  char p;
  int i, j;
  ind--;
  p = buff[ind--];
  while (strchr(blankscr, buff[ind]) !=NULL) ind--;
  i = ind;  /* misto predlozky, kterou chceme vazat */
  while (i >= 0 && (strchr(blankscr, buff[i]) == NULL)) i--;
  j = i;
  while (i >= 0 && (strchr(blanks, buff[i]) != NULL)) i--;
  if (i >= 0 && buff[i] == '\n') j = -1;
  if (j >= 0)  buff[j] = '\n';
  else numline--;
  ind++;
  buff[ind++] = '~';
  buff[ind++] = p;
  numchanges++;
}

@ Nyn vytvome patterny pro ppady typu \.{\char92uv\char`\{v lese\char`\}}.
@<Inicializace dat...@>=
setpattern (vlnkain);    /* na radku */
setpi (tblankscr, ONE);
setpi (backslash, ONE);
setpi (letters,   ONE);
setpi (letters,   ANY);
setpi (openbrace, ONE);
setpi (prefixes,  ANY);
setpi (charset,   ONE);
setpi (blanks,    ONE);
setpi (blanks,    ANY);
setpi (nochar,    ONE_NOT);

setpattern (vlnkacr);    /* pres radek */
setpi (tblankscr, ONE);
setpi (backslash, ONE);
setpi (letters,   ONE);
setpi (letters,   ANY);
setpi (openbrace, ONE);
setpi (prefixes,  ANY);
setpi (charset,   ONE);
setpi (blanks,    ANY);
setpi (cr,        ONE);
setpi (blanks,    ANY);
setpi (nochar,    ONE_NOT);



@ Vytvome patterny a proceduru pro potlaten tvorby vlnky u psmen tsn
nsledujcch sekvence \.{\char92TeX} a \.{\char92LaTeX}. Tj. nechceme, aby
nap z textu \uv{\.{Vlastnosti~\char92TeX~u~jsou...}} jsme dostali text
s nesprvn vzanm psmenem
\uv{\.{Vlastnosti~\char92TeX~u\char126jsou...}}.
@<Inicializace dat...@>=
normalpattern (tielock, "\\TeX");
setpi (blankscr, ONE);
normalpattern (tielock, "\\LaTeX");
setpi (blankscr, ONE);

@ Procedura |tielock| obsahuje neist trik. Pi provdn procedury je
prv naten znak z |blankscr| a je uloen do buff. Testy na otevrn
novch pattern pro tento znak teprve budou nsledovat a testuj se na
hodnotu promnn |c|. Sta tedy zmnit hodnotu |c| a vlnkovac patterny se
neotevou.
@<Pomocn funkce@>=
static void tielock (void)
{
  c = 1;
}

@ Oetme nyn pechod do/z matematickho reimu \TeX{}u. Uvnit math
mdu vlnky nedlme. Pi zjitnm nesouladu v pechodech mezi
math-mdy spustme nsledujc proceduru.
@<Pomocn funkce@>=
static void printwarning (void)
{
  if (!silent)
    fprintf (stderr, 
      "~!~ warning: text/math/verb mode mismatch,  file: %s,  line: %ld\n", 
      filename, numline - (c=='\n'?1:0));
  status = WARNING;
}

@ Zaneme patterny pro pechod do/z matematickho reimu, ohranienho
jednm dolarem, nebo v La\TeX{}u pslunmi sekvencemi.  Sekvence
La\TeX{}u \.{\char92(} a \.{\char92)} nejsou zahrnuty, protoe bvaj
asto pedefinovny k jinm uitenjm vcem.
@<Inicializace datovch ...@>=
if (!nomath) {
  mathlist = setpattern (onedollar);
  setpi (dolar, ONE);
  setpi (dolar, ONE_NOT);
  if (latex) {
    normalpattern (mathin, "\\begin.{math}");
    normalpattern (mathout, "\\end.{math}");
  }
}

@ @<Pomocn funkce@>=
static void mathin (void)
{
  if (mode!=TEXTMODE) printwarning ();
  mode = MATHMODE;
  normallist = listpatt = mathlist;
}
static void mathout (void)
{
  if (mode!=MATHMODE) printwarning ();
  mode = TEXTMODE;
  normallist = listpatt = vlnkalist;
}

@ Pi programovn procedury |onedollar| nesmme zapomenout na vskyt
sekvence \.{\char92\$}. V tom ppad akci ignorujeme. Podobn u sekvence
\.{\$\$} souhlas ten druh dolar s nam patternem, ale to u jsme uvnit
display mdu. V takovm ppad tak nic nedlme.
@<Pomocn funkce@>=
static void onedollar (void)
{
  if (buff[ind-3]=='\\' || (buff[ind-3]=='$' && buff[ind-4]!='\\')) return;
  if (mode==DISPLAYMODE) printwarning ();
  else {
    if (mode==TEXTMODE) mathin();
    else mathout();
  }
}

@ Pokud najdeme przdn dek, pekontrolujeme, zda nhodou nejsme v
math-mdu. Pokud ano, vypeme varovn a pejdeme do textovho mdu.
@<Inicializace dat...@>=
parcheck = setpattern (checkmode);
setpi (cr, ONE);
setpi (blanks, ANY);
setpi (cr, ONE);

@ @<Pomocn funkce@>=
static void checkmode (void)
{
  if (mode!=TEXTMODE) {
    printwarning ();
    mode = TEXTMODE;
    normallist = listpatt = vlnkalist;
  }
}

@ Nyn oetme vskyt dvou dolar, tj. vstup do/z display mdu.
Rovn mysleme na La\TeX{}isty a jejich prosted pro display-md. Protoe
je mon alternativa s hvzdikou na konci nzvu prosted, radji u
uzavrac zvorku do patternu nezahrnujeme.

@<Inicializace dat...@>=
if (!nomath) {
  normalpattern (twodollars, "$$");
  if (latex) {
    normalpattern (displayin, "\\begin.{displaymath");
    normalpattern (displayin, "\\begin.{equation");
    normalpattern (displayout, "\\end.{displaymath");
    normalpattern (displayout, "\\end.{equation");
  }
}

@ @<Pomocn funkce@>=
static void displayin (void)
{
  if (mode!=TEXTMODE) printwarning ();
  mode = DISPLAYMODE; normallist = listpatt = parcheck;
}
static void displayout (void)
{
  if (mode!=DISPLAYMODE) printwarning();
  mode = TEXTMODE; normallist =  listpatt = vlnkalist;
}
static void twodollars (void)
{
  if (buff[ind-3]=='\\') return;
  if (mode==DISPLAYMODE) displayout ();
  else displayin ();
}

@ Nsleduje oeten tzv. verbatim mdu. Pro plain i La\TeX{} jsou nejastj
zvorky pro verbatim mod tyto (variantu s \.{\char92begtt} pouvm
s oblibou j).
@<Inicializace dat...@>=
if (!noverb) {
  verblist = normalpattern (verbinchar, "\\verb"); 
  setpi (blankscr, ANY);
  setpi (blankscr, ONE_NOT); 
  normalpattern (verbin, "\\begtt"); 
  if (latex) normalpattern (verbin, "\\begin.{verbatim");
}
if (web) {
  normalpattern (verbin, "@@<");
  normalpattern (verbin, "@@d");
}
if (!noverb) {
  verboutlist[0] = setpattern (verbout);
  setpi (verbchar, ONE);
  verboutlist[1] = normalpattern (verbout, "\\endtt");
  if (latex) verboutlist[2] = normalpattern (verbout, "\\end{verbatim");
}
if (web) {
  verboutlist[3] = normalpattern (verbout, "@@ ");
  normalpattern (verbout, "@@*");
  normalpattern (verbout, "@@>|");
}


@ Procedura |verbinchar| se od \uv{spolen} procedury |verbin| li v
tom, e zavede do stringu |verbchar| momentln hodnotu promnn |c|.
Proto druh vskyt tto hodnoty verbatim reim ukon.
@<Pomocn funkce@>=
int prevmode;
PATTERN *prevlist, *verboutlist[4];
char verbchar[2];
static void verbinchar (void)
{
  prevmode = mode;
  verbchar[0] = c;
  c = 1;
  listpatt = normallist = verboutlist[0];
  prevlist = listpatt->next;
  listpatt->next = NULL;
  mode = VERBMODE;
}

@ Pi programovn \uv{obecn} funkce |verbin| musme dbt na to, aby
zstal aktivn pouze odpovdajc \uv{vstupn} pattern k danmu
vstupnmu. Tak si zapamatujeme md, ze kterho jsme do verbatim
oblasti vstoupili, abychom se k nmu mohli vrtit (nap. uvnit
math. mdu me bt
\.{\char92hbox} a v nm lokln verbatim konstrukce).
@<Pomocn funkce@>=
static void verbin (void)
{ 
  int i;
  i = 0;
  prevmode = mode; 
  switch (c) {
  case 't': i = 1; break;
  case 'm': i = 2; break;
  case '<': ;
  case 'd': i = 3; 
       if (buff[ind-3]=='@@') return;  /* dvojity @@ ignorovat */ 
       break;
  }
  listpatt = normallist = verboutlist[i]; 
  prevlist = listpatt->next;
  if (c != '<' && c != 'd')  listpatt->next = NULL;
  mode = VERBMODE;
}

@ @<Pomocn funkce@>=
static void verbout (void)
{
  if (mode!=VERBMODE) return;
  if (web && buff[ind-2] == '@@' && buff[ind-3] == '@@') return;
  mode = prevmode;
  normallist->next = prevlist;
  switch (mode) {
  case DISPLAYMODE: normallist = listpatt = parcheck; break;
  case MATHMODE: normallist = listpatt = mathlist; break ;
  case TEXTMODE:  normallist = listpatt = vlnkalist; break;
  }
}

@ Nyn implementujeme vlastnost dve pouvanho programu vlnka, tj. e
lze jeho innost vypnout a opt zapnout v komentch. Vytvme druh
nezvisl seznam pattern a proto nejprve pronulujeme |lastpt|.
@<Inicializace dat...@>=
lastpt = 0;
commentlist = normalpattern (tieoff, "%.~.-");
normalpattern (tieon, "%.~.+");

@ @<Pomocn funkce@>=
static void tieoff (void)
{
  normallist = NULL;
}
static void tieon (void)
{
  normallist = vlnkalist;
}

@ Dal plnovan vylepen. Program by mohl st definici svho chovn
nejen z~pkazov dky, ale v~mnohem kompletnj podob, vetn
uivatelsky definovanch pattern, z komentov oblasti ve tenm souboru.
Parametry zde uveden by mohly mt vy prioritu, ne parametry 
z~pkazov dky a mohl by se teba roziovat seznam sekvenc, za nimi
psmena nemaj bt vzana vlnkou (zatm je implemenovno na pevno jen
\.{\char92TeX} a \.{\char92LaTeX}). 

@* Rejstk.


