<?php
 /*
   Tiquit Is Quality User Incident Tracking
   Copyright (C) 2006 Jonathan Ciesla
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
  */
require_once("config.php");
require_once("functionlib.php");
authentication(0, 0);
favicon();
  
$link = dbms_connect($dbhost, $dbuser, $dbpass, $dbname);

echo "<link rel=stylesheet href=css.php>";
echo "<title>$sitetitle</title>";
echo "<h1>$sitetitle</h1>";

$keyword = $_POST['keyword'];

$desc = $_POST['desc'];
$diary = $_POST['diary'];
$resol = $_POST['resol'];

$keyword=dbms_escape_string($keyword);

$words = explode(" ", $keyword);
$count = count($words);

if($desc){
  $field = " description";
  echo "<table border=1 align=center>";
  echo "<CAPTION><b>Incidents with $keyword in Description</b></CAPTION>";
  echo "<tr><th>#</th><th>User</th><th>Severity</th><th>Agent</th><th>Type</th><th>Description</th><th>Date</th><th>Status</th></tr>";
  $query = "SELECT number,usr,agent,type,description,date,status,severity FROM incident WHERE";
  $x=0;
  foreach($words as $word){
    $query .= $field . " LIKE '%$word%' ";
    if($x<$count-1){$query .= " AND";};
    $x++;
  };

  $query .= "ORDER BY status DESC, severity ASC, number DESC";
 
  $result = dbms_query($query);
  while($line = dbms_fetch_array($result, "ASSOC")){
    echo "<tr>";
    
    if($line['status']=="Open"){$stat_color = "#00FF00";};
    if($line['status']=="Hold"){$stat_color = "#FFFF00";};
    if($line['status']=="Closed"){$stat_color = "#C0C0C0";};
  
    echo "<td bgcolor=$stat_color>{$line['number']}</td>";
  
    $query1 = "SELECT lname,fname FROM users WHERE number ='{$line['usr']}'";
    $result1 = dbms_query($query1);
    $line1 = dbms_fetch_array($result1, "ASSOC");
    dbms_free_result($result1);
    $print_name = $line1['lname'] . ", " . $line1['fname'];
    echo "<td bgcolor=$stat_color>$print_name</td>";
    
    if($line['severity']=="1"){$sev_color = "#FF0000";};
    if($line['severity']=="2"){$sev_color = "#FF9900";};
    if($line['severity']=="3"){$sev_color = "#FFFF00";};
    if($line['severity']=="4"){$sev_color = "#00FF00";};
    if($line['severity']=="5"){$sev_color = "#0000FF";};
  
    echo "<td bgcolor=$sev_color>{$line['severity']}</td>";
    
    $print_type = agent_name($line['agent']);
    echo "<td bgcolor=$stat_color>$print_type</td>";

    $print_type = type_name($line['type']);
    echo "<td bgcolor=$stat_color>$print_type</td>";
  
    $desc_parts = explode(" ", $line['description']);
    echo "<td bgcolor=$stat_color>";
    foreach($desc_parts as $part){
      foreach($words as $word){
	if(strncasecmp($part, $word, 255)==0){ echo "<span style=\"color:#FF0000;\">"; };
      };
      echo $part;
      foreach($words as $word){
	if(strncasecmp($part, $word, 255)==0){ echo "</span>"; };
      };
      echo " ";
    };
    echo "</td>";
    
    echo "<td bgcolor=$stat_color>{$line['date']}</td>";
    
    echo "<td bgcolor=$stat_color>";
    echo "<form action=incident_update.php method=post>";
    echo "<input type=hidden name=num value=\"{$line['number']}\">";
    echo "<input type=submit value={$line['status']}>";
    echo "</form>";
    echo "</td>";
  
    echo "</tr>";
  };
  echo "</table>";
  dbms_free_result($result);
};
echo "<br />";
if($diary){
  $field = " diary.text";
  echo "<table border=1 align=center>";
  echo "<CAPTION><b>Incidents with $keyword in Diary Entries</b></CAPTION>";
  echo "<tr><th>#</th><th>User</th><th>Severity</th><th>Agent</th><th>Type</th><th>Description</th><th>Date</th><th>Status</th></tr>";
  $query = "SELECT incident.number,usr,incident.agent,type,description,incident.date,status,severity FROM incident LEFT JOIN diary ON incident.number=diary.incident WHERE";
  
  $x=0;
  foreach($words as $word){
    $query .= $field . " LIKE '%$word%' ";
    if($x<$count-1){$query .= " AND";};
    $x++;
  };
  
  $query .= "ORDER BY status DESC, severity ASC, number DESC";

  $result = dbms_query($query);
  while($line = dbms_fetch_array($result, "ASSOC")){
    echo "<tr>";
    
    if($line['status']=="Open"){$stat_color = "#00FF00";};
    if($line['status']=="Hold"){$stat_color = "#FFFF00";};
    if($line['status']=="Closed"){$stat_color = "#C0C0C0";};
  
    echo "<td bgcolor=$stat_color>{$line['number']}</td>";
  
    $query1 = "SELECT lname,fname FROM users WHERE number ='{$line['usr']}'";
    $result1 = dbms_query($query1);
    $line1 = dbms_fetch_array($result1, "ASSOC");
    dbms_free_result($result1);
    $print_name = $line1['lname'] . ", " . $line1['fname'];
    echo "<td bgcolor=$stat_color>$print_name</td>";
    
    if($line['severity']=="1"){$sev_color = "#FF0000";};
    if($line['severity']=="2"){$sev_color = "#FF9900";};
    if($line['severity']=="3"){$sev_color = "#FFFF00";};
    if($line['severity']=="4"){$sev_color = "#00FF00";};
    if($line['severity']=="5"){$sev_color = "#0000FF";};
  
    echo "<td bgcolor=$sev_color>{$line['severity']}</td>";
    
    $print_type = agent_name($line['agent']);
    echo "<td bgcolor=$stat_color>$print_type</td>";

    $print_type = type_name($line['type']);
    echo "<td bgcolor=$stat_color>$print_type</td>";
  
    echo "<td bgcolor=$stat_color>{$line['description']}</td>";
    
    echo "<td bgcolor=$stat_color>{$line['date']}</td>";
    
    echo "<td bgcolor=$stat_color>";
    echo "<form action=incident_update.php method=post>";
    echo "<input type=hidden name=num value=\"{$line['number']}\">";
    echo "<input type=submit value={$line['status']}>";
    echo "</form>";
    echo "</td>";
  
    echo "</tr>";
  };
  echo "</table>";
  dbms_free_result($result);
};
echo "<br />";
if($resol){
  $field = " resolution";
  echo "<table border=1 align=center>";
  echo "<CAPTION><b>Incidents with $keyword in Resolution</b></CAPTION>";
  echo "<tr><th>#</th><th>User</th><th>Severity</th><th>Agent</th><th>Type</th><th>Description</th><th>Date</th><th>Status</th></tr>";
  $query = "SELECT number,usr,agent,type,description,date,status,severity FROM incident WHERE";
  $x=0;
  foreach($words as $word){
    $query .= $field . " LIKE '%$word%' ";
    if($x<$count-1){$query .= " AND";};
    $x++;
  };

  $query .= "ORDER BY status DESC, severity ASC, number DESC";

  $result = dbms_query($query);
  while($line = dbms_fetch_array($result, "ASSOC")){
    echo "<tr>";
    
    if($line['status']=="Open"){$stat_color = "#00FF00";};
    if($line['status']=="Hold"){$stat_color = "#FFFF00";};
    if($line['status']=="Closed"){$stat_color = "#C0C0C0";};
  
    echo "<td bgcolor=$stat_color>{$line['number']}</td>";
  
    $query1 = "SELECT lname,fname FROM users WHERE number ='{$line['usr']}'";
    $result1 = dbms_query($query1);
    $line1 = dbms_fetch_array($result1, "ASSOC");
    dbms_free_result($result1);
    $print_name = $line1['lname'] . ", " . $line1['fname'];
    echo "<td bgcolor=$stat_color>$print_name</td>";
    
    if($line['severity']=="1"){$sev_color = "#FF0000";};
    if($line['severity']=="2"){$sev_color = "#FF9900";};
    if($line['severity']=="3"){$sev_color = "#FFFF00";};
    if($line['severity']=="4"){$sev_color = "#00FF00";};
    if($line['severity']=="5"){$sev_color = "#0000FF";};
  
    echo "<td bgcolor=$sev_color>{$line['severity']}</td>";
    
    $print_type = agent_name($line['agent']);
    echo "<td bgcolor=$stat_color>$print_type</td>";

    $print_type = type_name($line['type']);
    echo "<td bgcolor=$stat_color>$print_type</td>";
  
    echo "<td bgcolor=$stat_color>{$line['description']}</td>";
    
    echo "<td bgcolor=$stat_color>{$line['date']}</td>";
    
    echo "<td bgcolor=$stat_color>";
    echo "<form action=incident_update.php method=post>";
    echo "<input type=hidden name=num value=\"{$line['number']}\">";
    echo "<input type=submit value={$line['status']}>";
    echo "</form>";
    echo "</td>";
  
    echo "</tr>";
  };
  echo "</table>";
  dbms_free_result($result);
};
echo "<br />";

echo "<form action=main.php method=post>";
echo "<input type=submit value=Back />";
echo "</form>";

?>