<?php
 /*
   Tiquit Is Quality User Incident Tracking
   Copyright (C) 2006 Jonathan Ciesla
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
  */
require_once("config.php");
require_once("functionlib.php");
session_start();
favicon();

$link = dbms_connect($dbhost, $dbuser, $dbpass, $dbname);

echo "<link rel=stylesheet href=css.php>";

echo "<h2>$sitetitle: Unassigned Incidents</h2>";

echo "<table border=1 align=center>";

echo "<tr><th>#</th><th>User</th><th>Severity</th><th>Type</th><th width=300>Description</th><th>Date</th><th>Status</th></tr>";
$query = "SELECT number,usr,type,description,date,status,severity FROM incident WHERE agent IS NULL ORDER BY severity ASC, number DESC";
$result = dbms_query($query);
while($line = dbms_fetch_array($result, "ASSOC")){
  echo "<tr>";
  
  if($line['status']=="Open"){$stat_color = "#00FF00";};
  if($line['status']=="Hold"){$stat_color = "#FFFF00";};
  
  echo "<td bgcolor=$stat_color>{$line['number']}</td>";
  
  $query1 = "SELECT lname,fname FROM users WHERE number ='{$line['usr']}'";
  $result1 = dbms_query($query1);
  $line1 = dbms_fetch_array($result1, "ASSOC");
  dbms_free_result($result1);
  $print_name = $line1['lname'] . ", " . $line1['fname'];
  echo "<td bgcolor=$stat_color>$print_name</td>";
  
  if($line['severity']=="1"){$sev_color = "#FF0000";};
  if($line['severity']=="2"){$sev_color = "#FF9900";};
  if($line['severity']=="3"){$sev_color = "#FFFF00";};
  if($line['severity']=="4"){$sev_color = "#00FF00";};
  if($line['severity']=="5"){$sev_color = "#0000FF";};
  
  echo "<td bgcolor=$sev_color>{$line['severity']}</td>";
  
  $print_type = type_name($line['type']);
  echo "<td bgcolor=$stat_color>$print_type</td>";
  
  $wrapped = wordwrap($line['description'], 45, "<br />\n", 1);
  
  echo "<td bgcolor=$stat_color>$wrapped</td>";
  
  echo "<td bgcolor=$stat_color>{$line['date']}</td>";
  
  echo "<td bgcolor=$stat_color>";
  echo "<form action=incident_update.php method=post>";
  echo "<input type=hidden name=num value=\"{$line['number']}\">";
  echo "<input type=submit value={$line['status']}>";
  echo "</form>";
  echo "</td>";
  
  echo "</tr>";
 };
echo "</table>";
dbms_free_result($result);

echo "<br />";

echo "<form action=main.php method=post>";
echo "<input type=submit value=Back />";
echo "</form>";

?>
