/*
 * cfgfile.h
 * Thomas Nemeth, le 26.03.2005
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef CFGFILE_H
#define CFGFILE_H


enum {
        OPT_INT,  /* int    : any integer value by atoi           */
        OPT_REAL, /* double : any double value by strtod          */
        OPT_BOOL, /* int    : 0, 1, off, on, false, true, no, yes */
        OPT_CHAR, /* char   : any character                       */
        OPT_STR   /* char*  : any character pointer               */
};


/**
 * In configuration file each non comment/empty line is in this format :
 *   option = value
 *
 */
typedef struct
{
        char *name;  /* => option (in option = value)  */
        int   type;  /* type of option                 */
        void *value; /* => variable to store the value */
} options;


void load_config(options *list, const char *filename);


#endif

