/*
 * input.c
 * Thomas Nemeth, le 15.10.2003
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include "defines.h"
#include <ncurses.h>
#include <readline/readline.h>
#include "terminal.h"
#include "control.h"
#include "tmms.h"
#include "xmem.h"
#include "playerwin.h"


static WINDOW     * input_win = NULL;
static const char * prompt = NULL;



/* Commands functions */


char * stripwhite(char * string)
{
        register char *s, *t;

        for (s = string; whitespace(*s); s++)
        {
        }

        if (*s == 0)
        {
                return (s);
        }

        t = s + strlen(s) - 1;
        while ((t > s) && whitespace(*t))
        {
                t--;
        }
        *++t = '\0';

        return s;
}


static void display_rlinput()
{
        int j, x = 0, y = 0, dpos;
        int len = rl_line_buffer ? strlen(rl_line_buffer) : 0;
        char *buffer = NULL;

        getmaxyx(stdscr, y, x);
        if ((int) strlen(prompt) + len > x - 5)
        {
                dpos = len - x + 5 + strlen(prompt);
                buffer = rl_line_buffer + dpos;
                len = strlen(buffer);
        }
        else
        {
                dpos = 0;
                buffer = rl_line_buffer;
        }
        wmove(input_win, 1, 2);
        set_color(input_win, NormalColor, FALSE);
        wprintw(input_win, "%s", prompt);
        wattron(input_win, A_REVERSE);
        wprintw(input_win, "%s", buffer ? buffer : "");
        for (j = len + strlen(prompt) + 2 ; j < x - 2; j++)
        {
                wprintw(input_win, " ");
        }
        wmove(input_win, 1, 2 + strlen(prompt) + rl_point - dpos);
        wattroff(input_win, A_REVERSE);
        wrefresh(input_win);
}


static void multi_matches(char **matches, int num_matches, int max_length)
{
        /*
            rl_delete_text(0, rl_end);
            rl_insert_text(matches[1]);
            display_rlinput();
        */ 
        return ;
}


static void init_readline()
{
        rl_readline_name = PROGRAM;
        rl_redisplay_function = display_rlinput;
        rl_completion_display_matches_hook = multi_matches;
        rl_completion_append_character = '\0';
        rl_basic_word_break_characters = "\t\n\"\\'`@$><=;|&{(";
        rl_filename_quote_characters = " ";
        //rl_catch_signals = 0;
}


/* Display functions */

static void display_editzone()
{
        int j;

        curs_set(1);
        set_color(input_win, BordersColor, FALSE);
        wrefresh(input_win);
        set_color(input_win, NormalColor, FALSE);
        wmove(input_win, 1, 2);
        wprintw(input_win, "%s", prompt);
        wattron(input_win, A_REVERSE);
        for (j = strlen(prompt) + 2 ; j < COLS - 2; j++)
        {
                wprintw(input_win, " ");
        }
        wmove(input_win, 1, 2 + strlen(prompt));
        wattroff(input_win, A_REVERSE);
        wrefresh(input_win);
}


void display_input(const char * title, const char * request)
{
        player_display = FALSE;
        prompt = request;
        if (input_win)
        {
                destroy_win(input_win);
        }
        input_win = create_newwin(title, 4, COLS, 0, 0);
        display_editzone();
        init_readline();
}


void close_input()
{
        curs_set(0);
        destroy_win(input_win);
        input_win = NULL;
        player_display = TRUE;
        display_player();
}



