/*
 * playeractions.c
 * Thomas Nemeth, le 15.10.2003
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include "defines.h"
#include <ncurses.h>
#include "terminal.h"
#include "tmms.h"
#include "xmem.h"
#include "playlist.h"
#include "playerwin.h"
#include "playlistwin.h"
#include "modules.h"
#include "control.h"
#include "printlog.h"


static void wait_status(Status status)
{
        struct timespec ts = {0, 10};
        Status s;

        s = get_status();
        while (s != status)
        {
                s = get_status();
                nanosleep(&ts, NULL);
        }
}


static void send_command(Status command, int wait)
{
        printlog(5, "Requesting : %d\n", command);
        if (playlist_max() != 0)
        {
                set_command(command);
                printlog(5, "Request send...\n");
                if (wait)
                {
                        wait_status(command);
                }
        }
}


int play_pause()
{
        Status s1 = get_status();
        Status s2;

        if (s1 == PLAYING)
        {
                s2 = PAUSED;
        }
        else if ((s1 == PAUSED) || (s1 == STOPPED))
        {
                s2 = PLAYING;
        }
        else
        {
                /* Huh ? How did we got here ? */
                s2 = STOPPED;
        }

        send_command(s2, TRUE);

        return CONT;
}


int stop()
{
        send_command(STOPPED, TRUE);

        return CONT;
}


int fforward()
{
        send_command(FFW, FALSE);
        return CONT;
}


int frewind()
{
        send_command(RWD, FALSE);
        return CONT;
}


int next_file()
{
        send_command(NEXT, FALSE);
        return CONT;
}


int prev_file()
{
        send_command(PREV, FALSE);
        return CONT;
}


int switch_repeat_mode()
{
        switch (repeat_mode)
        {
                case REPEAT_NOT:
                        repeat_mode = REPEAT_ONE;
                        break;
                case REPEAT_ONE:
                        repeat_mode = REPEAT_ALL;
                        break;
                case REPEAT_ALL:
                        repeat_mode = REPEAT_NOT;
                        break;
                default:
                        repeat_mode = REPEAT_NOT;
        }
        display_status();
        return CONT;
}


int time_data()
{
        if (timedata == ELAPSED)
        {
                timedata = REMAINING;
        }
        else
        {
                timedata = ELAPSED;
        }
        return CONT;
}


int toggle_pm()
{
        toggle_playmode();
        display_status();
        return CONT;
}

