/*
 * playerwin.c
 * Thomas Nemeth, le 15.10.2003
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include "defines.h"
#include <ncurses.h>
#include "terminal.h"
#include "tmms.h"
#include "xmem.h"
#include "playlist.h"
#include "playerwin.h"
#include "playlistwin.h"
#include "modules.h"
#include "control.h"

int              player_display = TRUE;
static WINDOW   *player_win = NULL;




/* Display functions for player window */

void display_player()
{
        if (player_win)
        {
                destroy_win(player_win);
        }
        player_win = create_newwin(PACKAGE, 4, COLS, 0, 0);
        display_time(0, 0, 0, 0, 0);
        display_status();
        display_song();
}


void display_time(int mins, int secs, int rms, int rss, int bitrate)
{
        char text[10];

        CHECK_DISPLAY(player_display);
        memset(text, 0, 10);
        pthread_mutex_lock(&mutex_display);
        switch (timedata)
        {
                case ELAPSED:
                        snprintf(text, 9, "%02d:%02d  ", mins, secs);
                        break;
                case REMAINING:
                        snprintf(text, 9, "%02d:%02d  ", rms, rss);
                        break;
                default:
                        snprintf(text, 9, "%02d:%02d  ", mins, secs);
                        break;
        }
        set_color(player_win, BitrateColor, FALSE);
        mvwprintw(player_win, 1, 30, "%3d Kbits/s", bitrate);
        wrefresh(player_win);
        set_color(player_win, TimeColor, FALSE);
        mvwprintw(player_win, 1, 2, text);
        wrefresh(player_win);
        pthread_mutex_unlock(&mutex_display);
}


void display_status()
{
        Status s = get_status();
        char *status_str;
        char *mode_str;
        char *play_str;

        CHECK_DISPLAY(player_display);
        pthread_mutex_lock(&mutex_display);
        switch (s)
        {
                case PLAYING :
                        status_str = "|>";
                        break;
                case PAUSED :
                        status_str = "||";
                        break;
                case STOPPED :
                        status_str = "[]";
                        break;
                case FFW :
                        status_str = ">>";
                        break;
                case RWD :
                        status_str = "<<";
                        break;
                case NEXT :
                        status_str = ">|";
                        break;
                case PREV :
                        status_str = "|<";
                        break;
                default :
                        status_str = "[]";
                        break;
        }

        switch (repeat_mode)
        {
                case REPEAT_ONE :
                        mode_str = "R1";
                        break;
                case REPEAT_ALL :
                        mode_str = "RA";
                        break;
                case REPEAT_NOT :
                        mode_str = "  ";
                        break;
                default :
                        mode_str = "  ";
                        break;
        }

        switch (get_playmode())
        {
                case NRM_PLAY :
                        play_str = "   ";
                        break;
                case RND_PLAY :
                        play_str = "RND";
                        break;
                default :
                        play_str = "   ";
                        break;
        }

        set_color(player_win, StatusColor, FALSE);
        mvwprintw(player_win, 1, 12, status_str);
        mvwprintw(player_win, 1, 18, mode_str);
        mvwprintw(player_win, 1, 24, play_str);
        wrefresh(player_win);
        pthread_mutex_unlock(&mutex_display);
}


void display_song()
{
        char *file_title;
        char *spaces;
        unsigned int j;

        CHECK_DISPLAY(player_display);
        spaces = xmalloc(COLS - 4);
        pthread_mutex_lock(&mutex_display);
        set_color(player_win, PlayedSongColor, FALSE);
        file_title = playlist_current();
        if (file_title)
        {
                if (strrchr(file_title, '/') != NULL)
                {
                        file_title = strrchr(playlist_current(), '/') + 1;
                }
        }
        else
        {
                file_title = "NO FILE...";
        }

        if ((! file_title) || (file_title[0] == 0))
        {
                file_title = playlist_current();
        }

        for (j = 0 ; j < COLS - 4 - strlen(file_title) ; j++)
        {
                spaces[j] = ' ';
        }
        spaces[j] = 0;
        mvwprintw(player_win, 2, 2, "%s%s", file_title, spaces);
        wrefresh(player_win);
        free(spaces);
        pthread_mutex_unlock(&mutex_display);
}

