/*****************************************************************************
 * VLCRendererDialog.h: View controller class for the renderer dialog
 *****************************************************************************
 * Copyright (C) 2016 VLC authors and VideoLAN
 * $Id: 12036105ddce17f572cbac454b83e04103ebcf19 $
 *
 * Authors: Marvin Scholz <epirat07 at gmail dot com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston MA 02110-1301, USA.
 *****************************************************************************/

#import <Cocoa/Cocoa.h>

#import "VLCRendererItem.h"
#import "VLCRendererDiscovery.h"

@interface VLCRendererDialog : NSWindowController <VLCRendererDiscoveryDelegate, NSWindowDelegate>

#ifdef MAC_OS_X_VERSION_10_11
@property NSMutableArray<VLCRendererItem*> *rendererItems;
#else
@property NSMutableArray *rendererItems;
#endif

- (IBAction)selectRenderer:(id)sender;

@end
