class ControlPage < Qt::Widget

  def initialize(parent = nil)
    super(parent)

    set_layout @layout = Qt::VBoxLayout.new {no_margins}
  end

  def add_group(text, icon, line = true)
    group = Group.new(text, icon, line)
    @layout.add_widget group

    yield group if block_given?

    return group
  end

  def add_stretch
    @layout.add_stretch
  end

  def add_widget(widget, factor = 0, alignment = 0)
    @layout.add_widget(widget, factor, alignment)
  end

  def add_spacing(space)
    @layout.add_spacing(space)
  end

  def labeled_widget(text, widget, l_to_r = true, click_label = false)
    label = Qt::Label.new(text) do
      set_buddy widget

      def mousePressEvent(event)
        buddy.click
      end if  click_label
    end

    Qt::Widget.new do
      layout = Qt::HBoxLayout.new do
        no_margins
        no_spaces

        if l_to_r
          add_widget(label, 0, Qt::AlignRight)
          add_widget widget
        else
          add_widget widget
          add_widget(label, 1, Qt::AlignLeft)
        end
      end
      set_layout layout
  end end

end

class Group < Qt::Widget
  def initialize(text, icon, line, parent = nil)
    super(parent)
    #set_frame_shape Qt::Frame::StyledPanel

    @layout = Qt::VBoxLayout.new {set_contents_margins(8, 0, 8, 0)}

    set_layout( Qt::VBoxLayout.new do |l|
      l.set_contents_margins(1, 1, 1, 1)
      l.add_widget headline(text, icon)
      l.add_layout @layout
      l.add_widget Qt::Frame.new{set_frame_shape Qt::Frame::HLine} if line
    end)

  end

  def add_widget(widget, factor = nil, alignment = nil)
    if factor
      @layout.add_widget(widget, factor, alignment)
    else
      @layout.add_widget(widget)
    end
  end

  def add_layout(widget, factor = nil)
    if factor
      @layout.add_layout(widget, factor)
    else
      @layout.add_layout(widget)
    end
  end

  def add_stretch
    @layout.add_stretch
  end

  def add_spacing(space)
    @layout.add_spacing space
  end

  def headline(text, icon)
    Qt::Widget.new do

      layout = Qt::HBoxLayout.new do
        no_margins
        add_widget Qt::Label.new{set_pixmap($webkam_app.pixmap(icon))}
        add_stretch
        add_widget Qt::Label.new('<b>' + text +'</b>')
        add_stretch
      end

      set_layout layout
    end
  end

end

